/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.network;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface Packet
extends CustomPacketPayload {
    public void handle(@Nullable Level var1, @Nullable Player var2);

    default public void write(FriendlyByteBuf buf) {
    }

    private static <T extends Packet> StreamCodec<RegistryFriendlyByteBuf, T> makeCodec(Class<T> clazz) {
        StreamDecoder packetRead = friendlyByteBuf -> {
            try {
                return (Packet)clazz.getConstructor(FriendlyByteBuf.class).newInstance(friendlyByteBuf);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Packet class missing constructor method with single `FriendlyByteBuf` argument.", e);
            }
        };
        return CustomPacketPayload.codec(Packet::write, (StreamDecoder)packetRead);
    }

    private static <T extends Packet> CustomPacketPayload.Type<T> getType(Class<T> clazz) {
        try {
            Field[] fields;
            Field foundTypeField = null;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!CustomPacketPayload.Type.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                if (foundTypeField != null) {
                    throw new RuntimeException("Multiple CustomPacketPayload.Type static fields found for " + clazz.getName() + ". Reference the type field directly with another constructor.");
                }
                foundTypeField = field;
            }
            if (foundTypeField != null) {
                CustomPacketPayload.Type type = (CustomPacketPayload.Type)foundTypeField.get(null);
                return type;
            }
            throw new RuntimeException("No CustomPacketPayload.Type static field found for " + clazz.getName() + ". Reference the type field directly with another constructor.");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to get packet type for " + clazz.getName(), e);
        }
    }

    @FunctionalInterface
    public static interface Handle<T extends Packet> {
        public void handle(T var1, Level var2, Player var3);
    }

    public record Handler<T extends Packet>(Class<T> clazz, CustomPacketPayload.Type<T> type, StreamCodec<RegistryFriendlyByteBuf, T> serializer, Handle<T> handle) {
        public Handler(Class<T> clazz) {
            this(clazz, Packet.getType(clazz), Packet.makeCodec(clazz), Packet::handle);
        }
    }
}

