/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.fabric.network;

import com.google.auto.service.AutoService;
import dev.corgitaco.dataanchor.fabric.DataAnchorFabric;
import dev.corgitaco.dataanchor.fabric.network.FabricPacketBroadcaster;
import dev.corgitaco.dataanchor.network.BiDirectionalNetworkContainer;
import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.BiDirectionalPacketBroadcaster;
import dev.corgitaco.dataanchor.network.register.BidirectionalPacketRegister;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3898;
import net.minecraft.class_5321;
import net.minecraft.class_5629;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

@AutoService(value={BiDirectionalPacketBroadcaster.class, BidirectionalPacketRegister.class})
public class BiDirectionalFabricPacketBroadcaster
extends FabricPacketBroadcaster
implements BiDirectionalPacketBroadcaster,
BidirectionalPacketRegister {
    @Override
    public void registerPackets() {
        BiDirectionalNetworkContainer.BI_NAMESPACED_CONTAINERS.forEach((modId, networkContainer) -> networkContainer.registerMessages(this::register));
    }

    @Override
    protected <T extends Packet> void registerPayload(class_8710.class_9154<T> type, class_9139<class_9129, T> serializer) {
        PayloadTypeRegistry.playC2S().register(type, serializer);
        PayloadTypeRegistry.playS2C().register(type, serializer);
    }

    @Override
    protected <T extends Packet> void registerHandler(Packet.Handler<T> handler) {
        FabricPacketBroadcaster.ServerProxy.registerServerReceiver(handler);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            FabricPacketBroadcaster.ClientProxy.registerClientReceiver(handler);
        }
    }

    @Override
    public <MSG extends Packet> void sendToPlayer(MSG msg, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, msg);
    }

    @Override
    public <MSG extends Packet> void sendToAllPlayers(MSG msg) {
        MinecraftServer server = DataAnchorFabric.server;
        for (class_3222 player : server.method_3760().method_14571()) {
            this.sendToPlayer(msg, player);
        }
    }

    @Override
    public <MSG extends Packet> void sendToAllPlayersInDimension(MSG msg, class_5321<class_1937> dimension) {
        MinecraftServer server = DataAnchorFabric.server;
        for (class_3222 player : server.method_3847(dimension).method_18456()) {
            this.sendToPlayer(msg, player);
        }
    }

    @Override
    public <MSG extends Packet> void sendNearPositionInDimension(MSG msg, class_5321<class_1937> dimension, double x, double y, double z, double radius) {
        MinecraftServer server = DataAnchorFabric.server;
        for (class_3222 player : server.method_3847(dimension).method_18456()) {
            if (!(player.method_5649(x, y, z) <= class_3532.method_33723((double)radius))) continue;
            this.sendToPlayer(msg, player);
        }
    }

    @Override
    public <MSG extends Packet> void trackingEntity(MSG msg, class_1297 entity) {
        class_3218 level = (class_3218)entity.method_37908();
        class_3898.class_3208 trackedEntity = (class_3898.class_3208)level.method_14178().field_17254.field_18242.get(entity.method_5628());
        if (trackedEntity != null) {
            for (class_5629 serverPlayerConnection : trackedEntity.field_18250) {
                class_3222 player = serverPlayerConnection.method_32311();
                this.sendToPlayer(msg, player);
            }
        }
    }

    @Override
    public <MSG extends Packet> void trackingEntityAndSelf(MSG msg, class_1297 entity) {
        class_3218 level = (class_3218)entity.method_37908();
        class_3898.class_3208 trackedEntity = (class_3898.class_3208)level.method_14178().field_17254.field_18242.get(entity.method_5628());
        if (trackedEntity != null) {
            for (class_5629 serverPlayerConnection : trackedEntity.field_18250) {
                class_3222 player = serverPlayerConnection.method_32311();
                this.sendToPlayer(msg, player);
            }
            class_1297 class_12972 = trackedEntity.field_18247;
            if (class_12972 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_12972;
                this.sendToPlayer(msg, serverPlayer);
            }
        }
    }

    @Override
    public <MSG extends Packet> void trackingChunk(MSG msg, class_2818 chunk) {
        class_3218 level = (class_3218)chunk.method_12200();
        class_3898 chunkMap = level.method_14178().field_17254;
        chunkMap.method_17210(chunk.method_12004(), false).forEach(serverPlayer -> this.sendToPlayer(msg, (class_3222)serverPlayer));
    }

    @Override
    public <MSG extends Packet> void sendToServer(MSG msg) {
        ServerPacketSender.sendToServer(msg);
    }

    private static class ServerPacketSender {
        private ServerPacketSender() {
        }

        public static <MSG extends Packet> void sendToServer(MSG packet) {
            ClientPlayNetworking.send(packet);
        }
    }
}

