/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.network;

import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public abstract class NetworkContainer
implements PacketBroadcaster {
    private final Map<class_2960, Packet.Handler<? extends Packet>> packets = new HashMap<class_2960, Packet.Handler<? extends Packet>>();
    private final String nameSpace;
    private boolean locked = false;

    public NetworkContainer(String namespace) {
        this.nameSpace = namespace;
    }

    public <T extends Packet> void registerPacketHandler(Class<T> packet) {
        this.registerPacketHandler(new Packet.Handler<T>(packet));
    }

    public <T extends Packet> void registerPacketHandler(Class<T> clazz, class_8710.class_9154<T> type, class_9139<class_9129, T> serializer, Packet.Handle<T> handle) {
        this.registerPacketHandler(new Packet.Handler<T>(clazz, type, serializer, handle));
    }

    public <T extends Packet> void registerPacketHandler(Packet.Handler<T> packetHandle) {
        class_2960 id;
        if (!this.locked) {
            id = packetHandle.type().comp_2242();
            if (!id.method_12836().equals(this.nameSpace)) {
                throw new IllegalArgumentException("Network Container for namespace \"%s\" cannot register packet with namespace \"%s\", expected namespace \"%s\"".formatted(this.nameSpace, id, this.nameSpace));
            }
        } else {
            throw new IllegalArgumentException("Network Container for namespace \"%s\" is already locked, try registering earlier!".formatted(this.nameSpace));
        }
        this.packets.put(id, packetHandle);
    }

    public void registerMessages(Consumer<Packet.Handler<? extends Packet>> handlerConsumer) {
        this.packets.values().forEach(handlerConsumer);
        this.locked = true;
    }
}

