/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.tpshudneoforge.client;

import com.zivalez.tpshudneoforge.client.hud.TpsOverlay;
import com.zivalez.tpshudneoforge.config.ConfigManager;
import com.zivalez.tpshudneoforge.config.TpsHudConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class TpsHudConfigScreen
extends Screen {
    private final Screen parent;
    private ModelView mv;
    private boolean preview = false;
    private int TITLE_Y;
    private int COL_LEFT_X;
    private int LABEL_W;
    private int CTRL_X;
    private int CTRL_W;
    private int CUR_Y;
    private static final int ROW_H = 22;
    private static final int GAP_Y = 6;
    private final List<Label> labels = new ArrayList<Label>();
    private final List<Tip> tips = new ArrayList<Tip>();

    public TpsHudConfigScreen(Screen parent) {
        super((Component)Component.literal((String)"TPS HUD Config"));
        this.parent = parent;
    }

    private void layoutReset() {
        int pad = 16;
        int usableW = Math.max(320, this.width - pad * 2);
        this.TITLE_Y = 12;
        int formW = Math.min(usableW, 380);
        this.COL_LEFT_X = (this.width - formW) / 2;
        this.LABEL_W = 128;
        this.CTRL_X = this.COL_LEFT_X + this.LABEL_W + 12;
        this.CTRL_W = formW - (this.LABEL_W + 12);
        this.CUR_Y = this.TITLE_Y + 24 + 10;
    }

    private void addLabel(String text) {
        this.labels.add(new Label(this.COL_LEFT_X, this.CUR_Y + 5, (Component)Component.literal((String)text)));
    }

    private void nextRow() {
        this.CUR_Y += 28;
    }

    private void addTip(AbstractWidget w, String text) {
        this.tips.add(new Tip(w, (Component)Component.literal((String)text)));
    }

    private static String trimDouble(double v) {
        if (Math.abs(v - (double)Math.round(v)) < 1.0E-6) {
            return String.valueOf(Math.round(v));
        }
        return String.valueOf(v);
    }

    private static int clampInt(int v, int min, int max) {
        return Math.max(min, Math.min(max, v));
    }

    private static double clamp(double v, double min, double max) {
        return Math.max(min, Math.min(max, v));
    }

    private TpsHudConfig toConfigFromMV() {
        TpsHudConfig c = new TpsHudConfig();
        this.mv.applyTo(c);
        return c;
    }

    private void togglePreview() {
        this.preview = !this.preview;
        this.init();
    }

    protected void init() {
        this.clearWidgets();
        this.labels.clear();
        this.tips.clear();
        if (this.mv == null) {
            this.mv = new ModelView(ConfigManager.get());
        }
        this.layoutReset();
        if (this.preview) {
            int cx = this.width / 2;
            Button exit = Button.builder((Component)Component.literal((String)"Exit Preview"), b -> this.togglePreview()).bounds(cx - 60, this.height - 28, 120, 20).build();
            this.addRenderableWidget((GuiEventListener)exit);
            return;
        }
        this.addLabel("Enabled");
        CycleButton enabledBtn = CycleButton.booleanBuilder((Component)Component.literal((String)"ON"), (Component)Component.literal((String)"OFF")).displayOnlyValue().create(this.CTRL_X, this.CUR_Y, this.CTRL_W, 20, (Component)Component.empty(), (btn, v) -> {
            this.mv.enabled = v;
        });
        enabledBtn.setValue((Object)this.mv.enabled);
        this.addRenderableWidget((GuiEventListener)enabledBtn);
        this.addTip((AbstractWidget)enabledBtn, "Show or hide the TPS HUD overlay.");
        this.nextRow();
        this.addLabel("Anchor");
        CycleButton anchorBtn = CycleButton.builder(a -> Component.literal((String)a.name().replace('_', '-'))).withValues((Object[])TpsHudConfig.Anchor.values()).displayOnlyValue().create(this.CTRL_X, this.CUR_Y, this.CTRL_W, 20, (Component)Component.empty(), (btn, v) -> {
            this.mv.anchor = v;
        });
        anchorBtn.setValue((Object)this.mv.anchor);
        this.addRenderableWidget((GuiEventListener)anchorBtn);
        this.addTip((AbstractWidget)anchorBtn, "Choose which screen corner the HUD attaches to.");
        this.nextRow();
        this.addLabel("Padding (px)");
        EditBox padBox = new EditBox(this.font, this.CTRL_X, this.CUR_Y, this.CTRL_W, 20, (Component)Component.empty());
        padBox.setValue(String.valueOf(this.mv.padding));
        padBox.setResponder(s -> {
            try {
                this.mv.padding = TpsHudConfigScreen.clampInt(Integer.parseInt(s.trim()), 0, 64);
                padBox.setTextColor(0xE0E0E0);
            }
            catch (Exception ex) {
                padBox.setTextColor(0xFF5555);
            }
        });
        this.addRenderableWidget((GuiEventListener)padBox);
        this.addTip((AbstractWidget)padBox, "Margin from the screen edges, in pixels.");
        this.nextRow();
        this.addLabel("Scale (%)");
        int btnW = 22;
        EditBox scaleBox = new EditBox(this.font, this.CTRL_X + 22 + 4, this.CUR_Y, this.CTRL_W - 52, 20, (Component)Component.empty());
        scaleBox.setValue(String.valueOf(Math.round(this.mv.scale * 100.0f)));
        scaleBox.setResponder(s -> {
            try {
                int p = Integer.parseInt(s.trim());
                this.mv.scale = Mth.clamp((float)((float)p / 100.0f), (float)0.5f, (float)2.0f);
                scaleBox.setTextColor(0xE0E0E0);
            }
            catch (Exception ex) {
                scaleBox.setTextColor(0xFF5555);
            }
        });
        Button scaleDec = Button.builder((Component)Component.literal((String)"-"), b -> {
            this.mv.scale = Mth.clamp((float)(this.mv.scale - 0.05f), (float)0.5f, (float)2.0f);
            scaleBox.setValue(String.valueOf(Math.round(this.mv.scale * 100.0f)));
        }).bounds(this.CTRL_X, this.CUR_Y, 22, 20).build();
        Button scaleInc = Button.builder((Component)Component.literal((String)"+"), b -> {
            this.mv.scale = Mth.clamp((float)(this.mv.scale + 0.05f), (float)0.5f, (float)2.0f);
            scaleBox.setValue(String.valueOf(Math.round(this.mv.scale * 100.0f)));
        }).bounds(this.CTRL_X + this.CTRL_W - 22, this.CUR_Y, 22, 20).build();
        this.addRenderableWidget((GuiEventListener)scaleDec);
        this.addRenderableWidget((GuiEventListener)scaleBox);
        this.addRenderableWidget((GuiEventListener)scaleInc);
        this.addTip((AbstractWidget)scaleDec, "Decrease HUD size.");
        this.addTip((AbstractWidget)scaleBox, "HUD size multiplier in percent (50%\u2013200%).");
        this.addTip((AbstractWidget)scaleInc, "Increase HUD size.");
        this.nextRow();
        this.addLabel("Precision (decimals)");
        CycleButton precisionBtn = CycleButton.builder(v -> Component.literal((String)String.valueOf(v))).withValues((Object[])new Integer[]{0, 1, 2, 3}).displayOnlyValue().create(this.CTRL_X, this.CUR_Y, this.CTRL_W, 20, (Component)Component.empty(), (btn, v) -> {
            this.mv.precision = v;
        });
        precisionBtn.setValue((Object)this.mv.precision);
        this.addRenderableWidget((GuiEventListener)precisionBtn);
        this.addTip((AbstractWidget)precisionBtn, "Number of decimal places for TPS/MSPT values.");
        this.nextRow();
        this.addLabel("Format");
        CycleButton formatBtn = CycleButton.builder(v -> Component.literal((String)v.name())).withValues((Object[])TpsHudConfig.Format.values()).displayOnlyValue().create(this.CTRL_X, this.CUR_Y, this.CTRL_W, 20, (Component)Component.empty(), (btn, v) -> {
            this.mv.format = v;
        });
        formatBtn.setValue((Object)this.mv.format);
        this.addRenderableWidget((GuiEventListener)formatBtn);
        this.addTip((AbstractWidget)formatBtn, "Show TPS only, MSPT only, or BOTH (two lines).");
        this.nextRow();
        this.addLabel("Smoothing Window (samples)");
        EditBox smoothBox = new EditBox(this.font, this.CTRL_X, this.CUR_Y, this.CTRL_W, 20, (Component)Component.empty());
        smoothBox.setValue(String.valueOf(this.mv.smoothingWindow));
        smoothBox.setResponder(s -> {
            try {
                this.mv.smoothingWindow = TpsHudConfigScreen.clampInt(Integer.parseInt(s.trim()), 5, 240);
                smoothBox.setTextColor(0xE0E0E0);
            }
            catch (Exception ex) {
                smoothBox.setTextColor(0xFF5555);
            }
        });
        this.addRenderableWidget((GuiEventListener)smoothBox);
        this.addTip((AbstractWidget)smoothBox, "Moving average window size. Larger = smoother but slower to react.");
        this.nextRow();
        this.addLabel("Auto-hide when F3 open");
        CycleButton autoHideBtn = CycleButton.booleanBuilder((Component)Component.literal((String)"ON"), (Component)Component.literal((String)"OFF")).displayOnlyValue().create(this.CTRL_X, this.CUR_Y, this.CTRL_W, 20, (Component)Component.empty(), (btn, v) -> {
            this.mv.autoHideF3 = v;
        });
        autoHideBtn.setValue((Object)this.mv.autoHideF3);
        this.addRenderableWidget((GuiEventListener)autoHideBtn);
        this.addTip((AbstractWidget)autoHideBtn, "Hide overlay while the debug screen (F3) is open.");
        this.nextRow();
        this.CUR_Y += 2;
        this.nextRow();
        this.addLabel("TPS Thresholds");
        this.CUR_Y += 14;
        int halfW = (this.CTRL_W - 8) / 2;
        EditBox tpsWarn = new EditBox(this.font, this.CTRL_X, this.CUR_Y, halfW, 20, (Component)Component.empty());
        tpsWarn.setValue(TpsHudConfigScreen.trimDouble(this.mv.thresh.tpsWarn));
        tpsWarn.setResponder(s -> TpsHudConfigScreen.validateDoubleBox(tpsWarn, s, v -> {
            this.mv.thresh.tpsWarn = TpsHudConfigScreen.clamp(v, 0.0, 20.0);
        }));
        this.addRenderableWidget((GuiEventListener)tpsWarn);
        this.addTip((AbstractWidget)tpsWarn, "Warn if TPS \u2264 this value.");
        EditBox tpsBad = new EditBox(this.font, this.CTRL_X + halfW + 8, this.CUR_Y, halfW, 20, (Component)Component.empty());
        tpsBad.setValue(TpsHudConfigScreen.trimDouble(this.mv.thresh.tpsBad));
        tpsBad.setResponder(s -> TpsHudConfigScreen.validateDoubleBox(tpsBad, s, v -> {
            this.mv.thresh.tpsBad = TpsHudConfigScreen.clamp(v, 0.0, 20.0);
        }));
        this.addRenderableWidget((GuiEventListener)tpsBad);
        this.addTip((AbstractWidget)tpsBad, "Bad if TPS \u2264 this value.");
        this.nextRow();
        EditBox tpsGood = this.hexBox(this.CTRL_X, this.CUR_Y, (this.CTRL_W - 16) / 3, this.mv.thresh.tpsGoodColor, v -> {
            this.mv.thresh.tpsGoodColor = v;
        });
        EditBox tpsWarnC = this.hexBox(this.CTRL_X + (this.CTRL_W - 16) / 3 + 8, this.CUR_Y, (this.CTRL_W - 16) / 3, this.mv.thresh.tpsWarnColor, v -> {
            this.mv.thresh.tpsWarnColor = v;
        });
        EditBox tpsBadC = this.hexBox(this.CTRL_X + 2 * ((this.CTRL_W - 16) / 3) + 16, this.CUR_Y, (this.CTRL_W - 16) / 3, this.mv.thresh.tpsBadColor, v -> {
            this.mv.thresh.tpsBadColor = v;
        });
        this.addRenderableWidget((GuiEventListener)tpsGood);
        this.addRenderableWidget((GuiEventListener)tpsWarnC);
        this.addRenderableWidget((GuiEventListener)tpsBadC);
        this.addTip((AbstractWidget)tpsGood, "TPS good color (#RRGGBB).");
        this.addTip((AbstractWidget)tpsWarnC, "TPS warn color (#RRGGBB).");
        this.addTip((AbstractWidget)tpsBadC, "TPS bad color (#RRGGBB).");
        this.nextRow();
        this.addLabel("MSPT Thresholds");
        this.CUR_Y += 14;
        EditBox msptWarn = new EditBox(this.font, this.CTRL_X, this.CUR_Y, halfW, 20, (Component)Component.empty());
        msptWarn.setValue(TpsHudConfigScreen.trimDouble(this.mv.thresh.msptWarn));
        msptWarn.setResponder(s -> TpsHudConfigScreen.validateDoubleBox(msptWarn, s, v -> {
            this.mv.thresh.msptWarn = TpsHudConfigScreen.clamp(v, 0.0, 200.0);
        }));
        this.addRenderableWidget((GuiEventListener)msptWarn);
        this.addTip((AbstractWidget)msptWarn, "Warn if MSPT \u2265 this value. (Target is 50 ms)");
        EditBox msptBad = new EditBox(this.font, this.CTRL_X + halfW + 8, this.CUR_Y, halfW, 20, (Component)Component.empty());
        msptBad.setValue(TpsHudConfigScreen.trimDouble(this.mv.thresh.msptBad));
        msptBad.setResponder(s -> TpsHudConfigScreen.validateDoubleBox(msptBad, s, v -> {
            this.mv.thresh.msptBad = TpsHudConfigScreen.clamp(v, 0.0, 200.0);
        }));
        this.addRenderableWidget((GuiEventListener)msptBad);
        this.addTip((AbstractWidget)msptBad, "Bad if MSPT \u2265 this value.");
        this.nextRow();
        EditBox msptGood = this.hexBox(this.CTRL_X, this.CUR_Y, (this.CTRL_W - 16) / 3, this.mv.thresh.msptGoodColor, v -> {
            this.mv.thresh.msptGoodColor = v;
        });
        EditBox msptWarnC = this.hexBox(this.CTRL_X + (this.CTRL_W - 16) / 3 + 8, this.CUR_Y, (this.CTRL_W - 16) / 3, this.mv.thresh.msptWarnColor, v -> {
            this.mv.thresh.msptWarnColor = v;
        });
        EditBox msptBadC = this.hexBox(this.CTRL_X + 2 * ((this.CTRL_W - 16) / 3) + 16, this.CUR_Y, (this.CTRL_W - 16) / 3, this.mv.thresh.msptBadColor, v -> {
            this.mv.thresh.msptBadColor = v;
        });
        this.addRenderableWidget((GuiEventListener)msptGood);
        this.addRenderableWidget((GuiEventListener)msptWarnC);
        this.addRenderableWidget((GuiEventListener)msptBadC);
        this.addTip((AbstractWidget)msptGood, "MSPT good color (#RRGGBB).");
        this.addTip((AbstractWidget)msptWarnC, "MSPT warn color (#RRGGBB).");
        this.addTip((AbstractWidget)msptBadC, "MSPT bad color (#RRGGBB).");
        this.nextRow();
        int cx = this.width / 2;
        Button done = Button.builder((Component)Component.literal((String)"Done"), b -> {
            this.mv.applyTo(ConfigManager.get());
            ConfigManager.save();
            this.onClose();
        }).bounds(cx - 205, this.height - 28, 90, 20).build();
        Button apply = Button.builder((Component)Component.literal((String)"Apply"), b -> {
            this.mv.applyTo(ConfigManager.get());
            ConfigManager.save();
        }).bounds(cx - 105, this.height - 28, 90, 20).build();
        Button reset = Button.builder((Component)Component.literal((String)"Reset"), b -> {
            this.mv = new ModelView(new TpsHudConfig());
            this.init();
        }).bounds(cx - 5, this.height - 28, 90, 20).build();
        Button cancel = Button.builder((Component)Component.literal((String)"Cancel"), b -> this.onClose()).bounds(cx + 95, this.height - 28, 90, 20).build();
        Button previewBtn = Button.builder((Component)Component.literal((String)"Preview"), b -> this.togglePreview()).bounds(cx + 195, this.height - 28, 90, 20).build();
        this.addRenderableWidget((GuiEventListener)done);
        this.addRenderableWidget((GuiEventListener)apply);
        this.addRenderableWidget((GuiEventListener)reset);
        this.addRenderableWidget((GuiEventListener)cancel);
        this.addRenderableWidget((GuiEventListener)previewBtn);
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float delta) {
        super.render(gfx, mouseX, mouseY, delta);
        String title = this.preview ? "TPS HUD \u2013 Preview" : "TPS HUD \u2013 Settings";
        int titleW = this.font.width(title);
        gfx.drawString(this.font, title, (this.width - titleW) / 2, this.TITLE_Y, 0xFFFFFF, false);
        if (this.preview) {
            gfx.fill(0, 0, this.width, this.height, 0x66000000);
            TpsHudConfig cfg = this.toConfigFromMV();
            float sampleTps = 20.0f;
            float sampleMspt = 50.0f;
            TpsOverlay.renderPreview(gfx, cfg, sampleTps, sampleMspt, this.width, this.height);
            return;
        }
        for (Label l : this.labels) {
            gfx.drawString(this.font, l.text(), l.x(), l.y(), 0xE0E0E0, false);
        }
        for (Tip tip : this.tips) {
            if (!tip.widget.isMouseOver((double)mouseX, (double)mouseY)) continue;
            gfx.renderTooltip(this.font, tip.text, mouseX, mouseY);
            break;
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    private static void validateDoubleBox(EditBox box, String s, DoubleConsumer onValid) {
        try {
            double v = Double.parseDouble(s.trim());
            box.setTextColor(0xE0E0E0);
            onValid.accept(v);
        }
        catch (Exception ex) {
            box.setTextColor(0xFF5555);
        }
    }

    private EditBox hexBox(int x, int y, int w, String init, Consumer<String> onValid) {
        EditBox box = new EditBox(this.font, x, y, w, 20, (Component)Component.empty());
        box.setValue(init);
        box.setResponder(s -> {
            boolean ok;
            String t;
            String string = t = s == null ? "" : s.trim().toUpperCase(Locale.ROOT);
            if (t.startsWith("#")) {
                t = t.substring(1);
            }
            box.setTextColor((ok = t.matches("[0-9A-F]{6}")) ? 0xE0E0E0 : 0xFF5555);
            if (ok) {
                onValid.accept("#" + t);
            }
        });
        this.addTip((AbstractWidget)box, "Hex color (#RRGGBB).");
        return box;
    }

    private record Label(int x, int y, Component text) {
    }

    private record Tip(AbstractWidget widget, Component text) {
    }

    private static final class ModelView {
        public boolean enabled;
        public TpsHudConfig.Anchor anchor;
        public int padding;
        public float scale;
        public int precision;
        public TpsHudConfig.Format format;
        public int smoothingWindow;
        public boolean autoHideF3;
        public final TpsHudConfig.Thresholds thresh = new TpsHudConfig.Thresholds();

        ModelView(TpsHudConfig src) {
            this.enabled = src.enabled;
            this.anchor = src.anchor;
            this.padding = src.padding;
            this.scale = src.scale;
            this.precision = src.precision;
            this.format = src.format;
            this.smoothingWindow = src.smoothingWindow;
            this.autoHideF3 = src.autoHideF3;
            this.thresh.tpsWarn = src.thresholds.tpsWarn;
            this.thresh.tpsBad = src.thresholds.tpsBad;
            this.thresh.tpsGoodColor = src.thresholds.tpsGoodColor;
            this.thresh.tpsWarnColor = src.thresholds.tpsWarnColor;
            this.thresh.tpsBadColor = src.thresholds.tpsBadColor;
            this.thresh.msptWarn = src.thresholds.msptWarn;
            this.thresh.msptBad = src.thresholds.msptBad;
            this.thresh.msptGoodColor = src.thresholds.msptGoodColor;
            this.thresh.msptWarnColor = src.thresholds.msptWarnColor;
            this.thresh.msptBadColor = src.thresholds.msptBadColor;
        }

        void applyTo(TpsHudConfig dst) {
            dst.enabled = this.enabled;
            dst.anchor = this.anchor;
            dst.padding = this.padding;
            dst.scale = this.scale;
            dst.precision = this.precision;
            dst.format = this.format;
            dst.smoothingWindow = this.smoothingWindow;
            dst.autoHideF3 = this.autoHideF3;
            dst.thresholds.tpsWarn = this.thresh.tpsWarn;
            dst.thresholds.tpsBad = this.thresh.tpsBad;
            dst.thresholds.tpsGoodColor = this.thresh.tpsGoodColor;
            dst.thresholds.tpsWarnColor = this.thresh.tpsWarnColor;
            dst.thresholds.tpsBadColor = this.thresh.tpsBadColor;
            dst.thresholds.msptWarn = this.thresh.msptWarn;
            dst.thresholds.msptBad = this.thresh.msptBad;
            dst.thresholds.msptGoodColor = this.thresh.msptGoodColor;
            dst.thresholds.msptWarnColor = this.thresh.msptWarnColor;
            dst.thresholds.msptBadColor = this.thresh.msptBadColor;
        }
    }
}

