/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.tpshudneoforge.client.hud;

import com.zivalez.tpshudneoforge.config.ConfigManager;
import com.zivalez.tpshudneoforge.config.TpsHudConfig;
import com.zivalez.tpshudneoforge.core.TpsTracker;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;

@EventBusSubscriber(modid="tpshudneoforge", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public final class TpsOverlay {
    private static final ResourceLocation LAYER_ID = ResourceLocation.fromNamespaceAndPath((String)"tpshudneoforge", (String)"tps_hud");
    private static final double TPS_CAP = 20.0;

    private TpsOverlay() {
    }

    @SubscribeEvent
    public static void onRegisterLayers(RegisterGuiLayersEvent event) {
        event.registerAboveAll(LAYER_ID, (gfx, delta) -> TpsOverlay.render(gfx));
    }

    public static void render(GuiGraphics gfx) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.level == null || mc.player == null) {
            return;
        }
        TpsHudConfig cfg = ConfigManager.get();
        if (!cfg.enabled) {
            return;
        }
        if (cfg.autoHideF3 && TpsOverlay.isDebugActive(mc)) {
            return;
        }
        float tpsRaw = TpsTracker.getTps();
        float msptRaw = TpsTracker.getMspt();
        if (Float.isNaN(tpsRaw)) {
            return;
        }
        int sw = mc.getWindow().getGuiScaledWidth();
        int sh = mc.getWindow().getGuiScaledHeight();
        TpsOverlay.drawOverlay(gfx, cfg, tpsRaw, msptRaw, sw, sh);
    }

    public static void renderPreview(GuiGraphics gfx, TpsHudConfig cfg, float tpsRaw, float msptRaw, int sw, int sh) {
        if (!cfg.enabled) {
            return;
        }
        TpsOverlay.drawOverlay(gfx, cfg, tpsRaw, msptRaw, sw, sh);
    }

    private static void drawOverlay(GuiGraphics gfx, TpsHudConfig cfg, float tpsRaw, float msptRaw, int sw, int sh) {
        int n;
        int drawX;
        int pivotY;
        int pivotX;
        Font font = Minecraft.getInstance().font;
        int prec = Mth.clamp((int)cfg.precision, (int)0, (int)3);
        String tpsStr = TpsOverlay.formatCapped(tpsRaw, 20.0, prec);
        String msptStr = TpsOverlay.formatNumber(msptRaw, prec);
        int tpsColor = TpsOverlay.pickTpsColor(cfg, tpsRaw);
        int msptColor = TpsOverlay.pickMsptColor(cfg, msptRaw);
        String line1 = switch (cfg.format) {
            case TpsHudConfig.Format.TPS -> "TPS: " + tpsStr;
            case TpsHudConfig.Format.MSPT -> "MSPT: " + msptStr;
            default -> "TPS: " + tpsStr;
        };
        String line2 = cfg.format == TpsHudConfig.Format.BOTH ? "MSPT: " + msptStr : null;
        int w = font.width(line1);
        Objects.requireNonNull(font);
        int h = 9;
        if (line2 != null) {
            w = Math.max(w, font.width(line2));
            Objects.requireNonNull(font);
            h = 9 * 2 + 2;
        }
        int pad = Math.max(0, cfg.padding);
        float scale = Mth.clamp((float)cfg.scale, (float)0.5f, (float)2.0f);
        int drawY = switch (cfg.anchor) {
            case TpsHudConfig.Anchor.TOP_LEFT -> {
                pivotX = pad;
                pivotY = pad;
                drawX = 0;
                yield 0;
            }
            case TpsHudConfig.Anchor.TOP_RIGHT -> {
                pivotX = sw - pad;
                pivotY = pad;
                drawX = -w;
                yield 0;
            }
            case TpsHudConfig.Anchor.BOTTOM_LEFT -> {
                pivotX = pad;
                pivotY = sh - pad;
                drawX = 0;
                yield -h;
            }
            default -> {
                pivotX = sw - pad;
                pivotY = sh - pad;
                drawX = -w;
                yield -h;
            }
        };
        gfx.pose().pushPose();
        gfx.pose().translate((float)pivotX, (float)pivotY, 0.0f);
        gfx.pose().scale(scale, scale, 1.0f);
        int bgPad = 3;
        int bgLeft = drawX - bgPad;
        int bgTop = drawY - bgPad;
        int bgRight = drawX + w + bgPad;
        if (line2 == null) {
            Objects.requireNonNull(font);
            n = 9;
        } else {
            Objects.requireNonNull(font);
            n = 9 * 2 + 2;
        }
        int bgBottom = drawY + n + bgPad;
        if (cfg.background) {
            gfx.fill(bgLeft, bgTop, bgRight, bgBottom, 0x66000000);
        }
        if (cfg.format == TpsHudConfig.Format.TPS) {
            String label = "TPS: ";
            int labelW = font.width(label);
            gfx.drawString(font, label, drawX, drawY, cfg.textColor, cfg.shadow);
            gfx.drawString(font, TpsOverlay.stripSign(tpsStr), drawX + labelW, drawY, tpsColor, cfg.shadow);
        } else if (cfg.format == TpsHudConfig.Format.MSPT) {
            String label = "MSPT: ";
            int labelW = font.width(label);
            gfx.drawString(font, label, drawX, drawY, cfg.textColor, cfg.shadow);
            gfx.drawString(font, TpsOverlay.stripSign(msptStr), drawX + labelW, drawY, msptColor, cfg.shadow);
        } else {
            String label1 = "TPS: ";
            int l1 = font.width(label1);
            gfx.drawString(font, label1, drawX, drawY, cfg.textColor, cfg.shadow);
            gfx.drawString(font, TpsOverlay.stripSign(tpsStr), drawX + l1, drawY, tpsColor, cfg.shadow);
            Objects.requireNonNull(font);
            int y2 = drawY + 9 + 2;
            String label2 = "MSPT: ";
            int l2 = font.width(label2);
            gfx.drawString(font, label2, drawX, y2, cfg.textColor, cfg.shadow);
            gfx.drawString(font, TpsOverlay.stripSign(msptStr), drawX + l2, y2, msptColor, cfg.shadow);
        }
        gfx.pose().popPose();
    }

    private static String formatCapped(float value, double cap, int precision) {
        BigDecimal capBD;
        double v = Math.min((double)value, cap);
        BigDecimal bd = BigDecimal.valueOf(v).setScale(precision, RoundingMode.HALF_UP);
        if (bd.compareTo(capBD = BigDecimal.valueOf(cap).setScale(precision, RoundingMode.HALF_UP)) > 0) {
            bd = capBD;
        }
        return bd.toPlainString();
    }

    private static String formatNumber(float value, int precision) {
        return BigDecimal.valueOf(value).setScale(precision, RoundingMode.HALF_UP).toPlainString();
    }

    private static String stripSign(String s) {
        if (s != null && s.startsWith("+")) {
            return s.substring(1);
        }
        return s;
    }

    private static boolean isDebugActive(Minecraft mc) {
        block11: {
            block10: {
                try {
                    Method mGetDbg;
                    Object dbg;
                    Gui gui = mc.gui;
                    if (gui == null || (dbg = (mGetDbg = gui.getClass().getMethod("getDebugOverlay", new Class[0])).invoke((Object)gui, new Object[0])) == null) break block10;
                    for (String m : new String[]{"showDebugScreen", "showDebug", "shouldShowDebug", "isDebugEnabled"}) {
                        try {
                            Method mm = dbg.getClass().getMethod(m, new Class[0]);
                            Object r = mm.invoke(dbg, new Object[0]);
                            if (!(r instanceof Boolean)) continue;
                            Boolean b = (Boolean)r;
                            return b;
                        }
                        catch (NoSuchMethodException mm) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable gui) {
                    // empty catch block
                }
            }
            try {
                Options opt = mc.options;
                if (opt == null) break block11;
                for (String f : new String[]{"renderDebug", "renderDebugScreen", "debugEnabled"}) {
                    try {
                        Field ff = opt.getClass().getField(f);
                        ff.setAccessible(true);
                        Object r = ff.get(opt);
                        if (!(r instanceof Boolean)) continue;
                        Boolean b = (Boolean)r;
                        return b;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static int pickTpsColor(TpsHudConfig cfg, float tps) {
        TpsHudConfig.Thresholds th = cfg.thresholds;
        if ((double)tps <= th.tpsBad) {
            return TpsOverlay.parseHex(th.tpsBadColor, cfg.valueTextColor);
        }
        if ((double)tps <= th.tpsWarn) {
            return TpsOverlay.parseHex(th.tpsWarnColor, cfg.valueTextColor);
        }
        return TpsOverlay.parseHex(th.tpsGoodColor, cfg.valueTextColor);
    }

    private static int pickMsptColor(TpsHudConfig cfg, float mspt) {
        TpsHudConfig.Thresholds th = cfg.thresholds;
        if ((double)mspt >= th.msptBad) {
            return TpsOverlay.parseHex(th.msptBadColor, cfg.valueTextColor);
        }
        if ((double)mspt >= th.msptWarn) {
            return TpsOverlay.parseHex(th.msptWarnColor, cfg.valueTextColor);
        }
        return TpsOverlay.parseHex(th.msptGoodColor, cfg.valueTextColor);
    }

    private static int parseHex(String s, int fallback) {
        try {
            String t;
            String string = t = s == null ? "" : s.trim();
            if (t.startsWith("#")) {
                t = t.substring(1);
            }
            int rgb = Integer.parseInt(t, 16) & 0xFFFFFF;
            return 0xFF000000 | rgb;
        }
        catch (Exception e) {
            return fallback;
        }
    }
}

