/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.tpshudneoforge.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.zivalez.tpshudneoforge.config.TpsHudConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.neoforged.fml.loading.FMLPaths;

public final class ConfigManager {
    private static final String FILE_NAME = "tpshud_v3.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static TpsHudConfig INSTANCE = null;

    private ConfigManager() {
    }

    public static synchronized TpsHudConfig get() {
        if (INSTANCE == null) {
            INSTANCE = ConfigManager.loadOrCreate();
        }
        return INSTANCE;
    }

    public static synchronized void save() {
        try {
            File file = FMLPaths.CONFIGDIR.get().resolve(FILE_NAME).toFile();
            file.getParentFile().mkdirs();
            try (FileWriter fw = new FileWriter(file);){
                GSON.toJson((Object)(INSTANCE != null ? INSTANCE : new TpsHudConfig()), (Appendable)fw);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void reload() {
        INSTANCE = ConfigManager.loadOrCreate();
    }

    private static TpsHudConfig loadOrCreate() {
        TpsHudConfig tpsHudConfig;
        File file = FMLPaths.CONFIGDIR.get().resolve(FILE_NAME).toFile();
        if (!file.exists()) {
            TpsHudConfig def = new TpsHudConfig();
            try (FileWriter fw = new FileWriter(file);){
                GSON.toJson((Object)def, (Appendable)fw);
            }
            return def;
        }
        FileReader fr = new FileReader(file);
        try {
            TpsHudConfig cfg = (TpsHudConfig)GSON.fromJson((Reader)fr, TpsHudConfig.class);
            if (cfg == null) {
                cfg = new TpsHudConfig();
            }
            tpsHudConfig = cfg;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new TpsHudConfig();
            }
        }
        fr.close();
        return tpsHudConfig;
    }
}

