/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.tpshudneoforge.core;

import com.zivalez.tpshudneoforge.config.ConfigManager;
import com.zivalez.tpshudneoforge.config.TpsHudConfig;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;

public final class TpsTracker {
    private static int windowSize = 40;
    private static Deque<Double> samples = new ArrayDeque<Double>(windowSize);
    private static long lastGameTime = Long.MIN_VALUE;
    private static long lastWallNanos = 0L;
    private static double cachedTps = Double.NaN;

    private TpsTracker() {
    }

    public static void onWorldTimePacket() {
        TpsTracker.sampleNow(true);
    }

    public static void onClientTickFallback() {
        TpsTracker.sampleNow(false);
    }

    private static void sampleNow(boolean fromPacket) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null) {
            return;
        }
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        TpsHudConfig cfg = ConfigManager.get();
        int desired = Math.max(5, Math.min(240, cfg.smoothingWindow));
        if (desired != windowSize) {
            windowSize = desired;
            samples = new ArrayDeque<Double>(windowSize);
        }
        long gameTime = level.getGameTime();
        long nanos = System.nanoTime();
        if (lastGameTime == Long.MIN_VALUE) {
            lastGameTime = gameTime;
            lastWallNanos = nanos;
            return;
        }
        long dtTicks = gameTime - lastGameTime;
        long dtNanos = nanos - lastWallNanos;
        if (dtTicks <= 0L || dtNanos <= 0L) {
            return;
        }
        double seconds = (double)dtNanos / 1.0E9;
        double tps = (double)dtTicks / seconds;
        if (samples.size() == windowSize) {
            samples.removeFirst();
        }
        samples.addLast(tps);
        double sum = 0.0;
        for (double v : samples) {
            sum += v;
        }
        cachedTps = sum / (double)samples.size();
        lastGameTime = gameTime;
        lastWallNanos = nanos;
    }

    public static float getTps() {
        return Double.isNaN(cachedTps) ? Float.NaN : (float)cachedTps;
    }

    public static float getMspt() {
        if (Double.isNaN(cachedTps)) {
            return Float.NaN;
        }
        if (cachedTps <= 0.0) {
            return Float.POSITIVE_INFINITY;
        }
        return (float)(1000.0 / cachedTps);
    }
}

