/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.pridemoths.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.dakotapride.pridemoths.PrideMothsMod;
import net.dakotapride.pridemoths.block.MothEnclosureBlockEntity;
import net.dakotapride.pridemoths.item.GlassJarItem;
import net.dakotapride.pridemoths.register.BlockEntityTypeRegistrar;
import net.dakotapride.pridemoths.register.DataComponentsRegistrar;
import net.dakotapride.pridemoths.register.ItemsRegistrar;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MothEnclosureBlock
extends BaseEntityBlock
implements EntityBlock {
    public static final MapCodec<MothEnclosureBlock> CODEC = MothEnclosureBlock.simpleCodec(MothEnclosureBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty FUZZ_LEVEL = PrideMothsMod.FUZZ_LEVEL;
    public static final List<BooleanProperty> SLOT_OCCUPIED_PROPERTIES = List.of(BlockStateProperties.SLOT_0_OCCUPIED, BlockStateProperties.SLOT_1_OCCUPIED, BlockStateProperties.SLOT_2_OCCUPIED);

    public MothEnclosureBlock(BlockBehaviour.Properties settings) {
        super(settings);
        BlockState blockState = (BlockState)((BlockState)((Block)this.stateDefinition.getOwner()).defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)FUZZ_LEVEL, (Comparable)Integer.valueOf(0));
        for (BooleanProperty booleanProperty : SLOT_OCCUPIED_PROPERTIES) {
            blockState = (BlockState)blockState.setValue((Property)booleanProperty, (Comparable)Boolean.FALSE);
        }
        this.registerDefaultState(blockState);
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return SLOT_OCCUPIED_PROPERTIES != null;
    }

    protected void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.nextFloat() < 0.8f) {
            int i;
            if (MothEnclosureBlock.checkIfOnlyOneSlotIsFilled(state)) {
                int i2;
                if (state.is(PrideMothsMod.MOTH_ENCLOSURES, statex -> statex.hasProperty((Property)FUZZ_LEVEL)) && (i2 = MothEnclosureBlockEntity.getMothFuzzLevel(state)) < 1) {
                    int j;
                    int n = j = world.random.nextInt(100) == 0 ? 2 : 1;
                    if (i2 + j > 1) {
                        --j;
                    }
                    world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FUZZ_LEVEL, (Comparable)Integer.valueOf(i2 + j)));
                }
            } else if (MothEnclosureBlock.checkIfOnlyTwoSlotsAreFilled(state)) {
                int i3;
                if (state.is(PrideMothsMod.MOTH_ENCLOSURES, statex -> statex.hasProperty((Property)FUZZ_LEVEL)) && (i3 = MothEnclosureBlockEntity.getMothFuzzLevel(state)) < 2) {
                    int j;
                    int n = j = world.random.nextInt(100) == 0 ? 2 : 1;
                    if (i3 + j > 2) {
                        --j;
                    }
                    world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FUZZ_LEVEL, (Comparable)Integer.valueOf(i3 + j)));
                }
            } else if (MothEnclosureBlock.checkIfAllSlotsAreFilled(state) && state.is(PrideMothsMod.MOTH_ENCLOSURES, statex -> statex.hasProperty((Property)FUZZ_LEVEL)) && (i = MothEnclosureBlockEntity.getMothFuzzLevel(state)) < 3) {
                int j;
                int n = j = world.random.nextInt(100) == 0 ? 2 : 1;
                if (i + j > 3) {
                    --j;
                }
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FUZZ_LEVEL, (Comparable)Integer.valueOf(i + j)));
            }
        }
        super.randomTick(state, world, pos, random);
    }

    private static boolean checkIfOnlyOneSlotIsFilled(BlockState state) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
            return true;
        }
        if (!((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
            return true;
        }
        return (Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED) == false && (Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED) == false && (Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED) != false;
    }

    private static boolean checkIfOnlyTwoSlotsAreFilled(BlockState state) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
            return true;
        }
        if (!((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
            return true;
        }
        return (Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED) != false && (Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED) == false && (Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED) != false;
    }

    private static boolean checkIfAllSlotsAreFilled(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED) != false && (Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED) != false && (Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED) != false;
    }

    public static void dropMothFuzz(Level world, BlockPos pos, BlockState state) {
        if ((Integer)state.getValue((Property)FUZZ_LEVEL) == 1) {
            MothEnclosureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistrar.MOTH_FUZZ.get(), 1));
        }
        if ((Integer)state.getValue((Property)FUZZ_LEVEL) == 2) {
            if (((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
                MothEnclosureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistrar.MOTH_FUZZ.get(), 1));
            }
            if (!((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
                MothEnclosureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistrar.MOTH_FUZZ.get(), 1));
            }
            if (!((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
                MothEnclosureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistrar.MOTH_FUZZ.get(), 1));
            }
            if (((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
                MothEnclosureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistrar.MOTH_FUZZ.get(), 2));
            }
            if (!((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
                MothEnclosureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistrar.MOTH_FUZZ.get(), 2));
            }
            if (((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
                MothEnclosureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistrar.MOTH_FUZZ.get(), 2));
            }
            if (((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
                MothEnclosureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistrar.MOTH_FUZZ.get(), 2));
            }
        }
        if ((Integer)state.getValue((Property)FUZZ_LEVEL) == 3) {
            if (((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
                MothEnclosureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistrar.MOTH_FUZZ.get(), 1));
            }
            if (!((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
                MothEnclosureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistrar.MOTH_FUZZ.get(), 1));
            }
            if (!((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
                MothEnclosureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistrar.MOTH_FUZZ.get(), 1));
            }
            if (((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
                MothEnclosureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistrar.MOTH_FUZZ.get(), 2));
            }
            if (!((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
                MothEnclosureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistrar.MOTH_FUZZ.get(), 2));
            }
            if (((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
                MothEnclosureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistrar.MOTH_FUZZ.get(), 2));
            }
            if (((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
                MothEnclosureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemsRegistrar.MOTH_FUZZ.get(), 3));
            }
        }
    }

    public void takeMothFuzz(Level world, BlockState state, BlockPos pos) {
        world.setBlock(pos, (BlockState)state.setValue((Property)FUZZ_LEVEL, (Comparable)Integer.valueOf(0)), 3);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof MothEnclosureBlockEntity) {
            MothEnclosureBlockEntity mothEnclosureBlockEntity = (MothEnclosureBlockEntity)blockEntity;
            if (!stack.is(PrideMothsMod.MOTH_JARS)) {
                int i = (Integer)state.getValue((Property)FUZZ_LEVEL);
                boolean bl = false;
                if (i >= 1 && stack.getItem() instanceof ShearsItem) {
                    world.playSound((Entity)player, player.getX(), player.getY(), player.getZ(), SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
                    MothEnclosureBlock.dropMothFuzz(world, pos, state);
                    stack.hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
                    bl = true;
                    world.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, pos);
                }
                if (bl) {
                    this.takeMothFuzz(world, state, pos);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            OptionalInt optionalInt = this.getSlotForHitPos(hit, state);
            if (optionalInt.isEmpty()) {
                return InteractionResult.PASS;
            }
            if (((Boolean)state.getValue((Property)SLOT_OCCUPIED_PROPERTIES.get(optionalInt.getAsInt()))).booleanValue()) {
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            MothEnclosureBlock.tryAddGlassJarWithMothInside(world, pos, player, mothEnclosureBlockEntity, stack, optionalInt.getAsInt());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof MothEnclosureBlockEntity) {
            MothEnclosureBlockEntity mothEnclosureBlockEntity = (MothEnclosureBlockEntity)blockEntity;
            OptionalInt optionalInt = this.getSlotForHitPos(hit, state);
            if (optionalInt.isEmpty()) {
                return InteractionResult.PASS;
            }
            if (!((Boolean)state.getValue((Property)SLOT_OCCUPIED_PROPERTIES.get(optionalInt.getAsInt()))).booleanValue()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getMainHandItem().is(Items.SHEARS)) {
                MothEnclosureBlock.tryRemoveGlassJarWithMothInside(world, pos, player, mothEnclosureBlockEntity, optionalInt.getAsInt());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private OptionalInt getSlotForHitPos(BlockHitResult hit, BlockState state) {
        return MothEnclosureBlock.getHitPos(hit, (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).map(hitPos -> {
            int j = MothEnclosureBlock.getColumn(hitPos.x);
            return OptionalInt.of(j);
        }).orElseGet(OptionalInt::empty);
    }

    private static Optional<Vec2> getHitPos(BlockHitResult hit, Direction facing) {
        Direction direction = hit.getDirection();
        if (facing != direction) {
            return Optional.empty();
        }
        BlockPos blockpos = hit.getBlockPos().relative(direction);
        Vec3 vec3 = hit.getLocation().subtract((double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ());
        double d = vec3.x();
        double e = vec3.y();
        double f = vec3.z();
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> Optional.of(new Vec2((float)(1.0 - d), (float)e));
            case Direction.SOUTH -> Optional.of(new Vec2((float)d, (float)e));
            case Direction.WEST -> Optional.of(new Vec2((float)f, (float)e));
            case Direction.EAST -> Optional.of(new Vec2((float)(1.0 - f), (float)e));
            case Direction.DOWN, Direction.UP -> Optional.empty();
        };
    }

    private static int getColumn(float x) {
        if (x < 0.375f) {
            return 0;
        }
        return x < 0.6875f ? 1 : 2;
    }

    private static void tryAddGlassJarWithMothInside(Level world, BlockPos pos, Player player, MothEnclosureBlockEntity blockEntity, ItemStack stack, int slot) {
        if (!world.isClientSide()) {
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            SoundEvent soundEvent = SoundEvents.BOTTLE_EMPTY;
            blockEntity.setItem(slot, stack.consumeAndReturn(1, (LivingEntity)player));
            world.playSound(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void tryRemoveGlassJarWithMothInside(Level world, BlockPos pos, Player player, MothEnclosureBlockEntity blockEntity, int slot) {
        if (!world.isClientSide()) {
            ItemStack itemStack = blockEntity.removeItem(slot, 1);
            SoundEvent soundEvent = SoundEvents.BOTTLE_FILL;
            world.playSound(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.getInventory().add(itemStack)) {
                player.drop(itemStack, false);
            }
            world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
        }
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity2;
        ServerLevel serverLevel;
        if (!world.isClientSide() && world instanceof ServerLevel && (serverLevel = (ServerLevel)world).getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (blockEntity2 = world.getBlockEntity(pos)) instanceof MothEnclosureBlockEntity) {
            MothEnclosureBlockEntity mothEnclosureBlockEntity = (MothEnclosureBlockEntity)blockEntity2;
            ItemStack itemStack = new ItemStack((ItemLike)this);
            boolean slot0 = (Boolean)state.getValue((Property)SLOT_OCCUPIED_PROPERTIES.getFirst());
            boolean slot1 = (Boolean)state.getValue((Property)SLOT_OCCUPIED_PROPERTIES.get(1));
            boolean slot2 = (Boolean)state.getValue((Property)SLOT_OCCUPIED_PROPERTIES.get(2));
            if (slot0 || slot1 || slot2) {
                itemStack.applyComponents(mothEnclosureBlockEntity.collectComponents());
                world.getBlockEntity(pos, (BlockEntityType)BlockEntityTypeRegistrar.MOTH_ENCLOSURE.get()).ifPresent(blockEntity -> blockEntity.applyComponentsFromItemStack(itemStack));
                itemStack.set(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY.with((Property)SLOT_OCCUPIED_PROPERTIES.getFirst(), (Comparable)Boolean.valueOf(slot0)).with((Property)SLOT_OCCUPIED_PROPERTIES.get(1), (Comparable)Boolean.valueOf(slot1)).with((Property)SLOT_OCCUPIED_PROPERTIES.get(2), (Comparable)Boolean.valueOf(slot2)));
                if (mothEnclosureBlockEntity.hasCustomName()) {
                    itemStack.set(DataComponents.CUSTOM_NAME, (Object)mothEnclosureBlockEntity.getCustomName());
                }
            }
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemStack);
            itemEntity.setDefaultPickUpDelay();
            world.addFreshEntity((Entity)itemEntity);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    protected void affectNeighborsAfterRemoval(BlockState state, ServerLevel world, BlockPos pos, boolean moved) {
        Containers.updateNeighboursAfterDestroy((BlockState)state, (Level)world, (BlockPos)pos);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
        ItemStack itemStack = super.getCloneItemStack(level, pos, state, includeData, player);
        level.getBlockEntity(pos, (BlockEntityType)BlockEntityTypeRegistrar.MOTH_ENCLOSURE.get()).ifPresent(blockEntity -> blockEntity.applyComponentsFromItemStack(itemStack));
        return itemStack;
    }

    public MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MothEnclosureBlockEntity(pos, state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FUZZ_LEVEL});
        SLOT_OCCUPIED_PROPERTIES.forEach(xva$0 -> builder.add(new Property[]{xva$0}));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public static int getRedstoneAnalogOutput(BlockState state) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
            return 1;
        }
        if (!((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
            return 1;
        }
        if (!((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
            return 1;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
            return 2;
        }
        if (!((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
            return 2;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
            return 2;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.SLOT_0_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_1_OCCUPIED)).booleanValue() && ((Boolean)state.getValue((Property)BlockStateProperties.SLOT_2_OCCUPIED)).booleanValue()) {
            return 3;
        }
        return 0;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos blockPos, Direction direction) {
        return MothEnclosureBlock.getRedstoneAnalogOutput(state);
    }

    public static class MothEnclosureBlockItem
    extends BlockItem {
        public MothEnclosureBlockItem(Block block, Item.Properties settings) {
            super(block, settings.setId(PrideMothsMod.keyOfItem("moth_enclosure")).overrideDescription("block.pridemoths.moth_enclosure"));
        }

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> textConsumer, TooltipFlag flag) {
            for (ItemStack stack : ((ItemContainerContents)itemStack.getOrDefault(DataComponentsRegistrar.MOTH_CONTAINER, (Object)ItemContainerContents.EMPTY)).nonEmptyItems()) {
                Item item;
                if (!stack.is(PrideMothsMod.MOTH_JARS) || !((item = stack.getItem()) instanceof GlassJarItem)) continue;
                GlassJarItem jarItem = (GlassJarItem)item;
                textConsumer.accept((Component)Component.translatable((String)("container.mothEnclosure.itemCount." + GlassJarItem.getMothVariant(jarItem).getVariation())).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
        }
    }
}

