/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.pridemoths.block;

import java.util.Objects;
import java.util.function.Predicate;
import net.dakotapride.pridemoths.PrideMothsMod;
import net.dakotapride.pridemoths.block.MothEnclosureBlock;
import net.dakotapride.pridemoths.register.BlockEntityTypeRegistrar;
import net.dakotapride.pridemoths.register.DataComponentsRegistrar;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class MothEnclosureBlockEntity
extends BlockEntity
implements Container,
Nameable {
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    private int lastInteractedSlot = -1;
    @Nullable
    private Component customName;

    public MothEnclosureBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypeRegistrar.MOTH_ENCLOSURE.get(), pos, state);
    }

    public static int getMothFuzzLevel(BlockState state) {
        return (Integer)state.getValue((Property)MothEnclosureBlock.FUZZ_LEVEL);
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    private void updateState(int interactedSlot) {
        if (interactedSlot >= 0 && interactedSlot < 3) {
            this.lastInteractedSlot = interactedSlot;
            BlockState blockState = this.getBlockState();
            for (int i = 0; i < MothEnclosureBlock.SLOT_OCCUPIED_PROPERTIES.size(); ++i) {
                boolean bl = !this.getItem(i).isEmpty();
                BooleanProperty booleanProperty = MothEnclosureBlock.SLOT_OCCUPIED_PROPERTIES.get(i);
                blockState = (BlockState)blockState.setValue((Property)booleanProperty, (Comparable)Boolean.valueOf(bl));
            }
            Objects.requireNonNull(this.getLevel()).setBlock(this.getBlockPos(), blockState, 3);
            this.getLevel().gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((BlockState)blockState));
        }
    }

    public void addStack(ItemStack stack) {
        this.inventory.add((Object)stack);
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.getInventory().isEmpty()) {
            ContainerHelper.loadAllItems((ValueInput)valueInput, this.inventory);
        }
        this.lastInteractedSlot = valueInput.getIntOr("last_interacted_slot", -1);
        this.customName = MothEnclosureBlockEntity.parseCustomNameSafe((ValueInput)valueInput, (String)"CustomName");
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.inventory, (boolean)false);
        valueOutput.putInt("last_interacted_slot", this.lastInteractedSlot);
        if (this.hasCustomName()) {
            valueOutput.storeNullable("CustomName", ComponentSerialization.CODEC, (Object)this.customName);
        }
    }

    public int getFilledSlotCount() {
        return (int)this.inventory.stream().filter(Predicate.not(ItemStack::isEmpty)).count();
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public boolean isEmpty() {
        return this.inventory.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = Objects.requireNonNullElse((ItemStack)this.inventory.get(slot), ItemStack.EMPTY);
        this.inventory.set(slot, (Object)ItemStack.EMPTY);
        if (!itemStack.isEmpty()) {
            this.updateState(slot);
        }
        return itemStack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.removeItem(slot, 1);
    }

    public void setItem(int slot, ItemStack stack) {
        if (stack.is(PrideMothsMod.MOTH_JARS)) {
            this.inventory.set(slot, (Object)stack);
            this.updateState(slot);
        } else if (stack.isEmpty()) {
            this.removeItem(slot, 1);
        }
    }

    public boolean canTakeItem(Container hopperInventory, int slot, ItemStack stack) {
        return hopperInventory.hasAnyMatching(stack2 -> stack2.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stack2) && stack2.getCount() + stack.getCount() <= hopperInventory.getMaxStackSize(stack2));
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return stack.is(PrideMothsMod.MOTH_JARS) && this.getItem(slot).isEmpty() && stack.getCount() == this.getMaxStackSize();
    }

    public int getLastInteractedSlot() {
        return this.lastInteractedSlot;
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
    }

    protected void applyImplicitComponents(DataComponentGetter components) {
        super.applyImplicitComponents(components);
        this.customName = (Component)components.get(DataComponents.CUSTOM_NAME);
        ((ItemContainerContents)components.getOrDefault(DataComponentsRegistrar.MOTH_CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.inventory);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder componentMapBuilder) {
        super.collectImplicitComponents(componentMapBuilder);
        componentMapBuilder.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
        componentMapBuilder.set(DataComponentsRegistrar.MOTH_CONTAINER, (Object)ItemContainerContents.fromItems(this.inventory));
    }

    public void removeComponentsFromTag(ValueOutput valueOutput) {
        valueOutput.discard("CustomName");
        valueOutput.discard("Items");
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDisplayName();
    }

    public Component getDisplayName() {
        return Component.literal((String)"Moth Enclosure");
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }
}

