/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.pridemoths.client.entity;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.EnumSet;
import java.util.List;
import net.dakotapride.pridemoths.PrideMothsMod;
import net.dakotapride.pridemoths.client.entity.pride.IPrideMoths;
import net.dakotapride.pridemoths.client.entity.pride.MothVariation;
import net.dakotapride.pridemoths.config.PrideMothsCommonConfig;
import net.dakotapride.pridemoths.register.DataComponentsRegistrar;
import net.dakotapride.pridemoths.register.EntityTypeRegistrar;
import net.dakotapride.pridemoths.register.ItemsRegistrar;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MothEntity
extends Animal
implements FlyingAnimal,
IPrideMoths {
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(MothEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FROM_JAR = SynchedEntityData.defineId(MothEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final List<MothVariation> PRIDE_VARIATIONS = List.of(MothVariation.TRANSGENDER, MothVariation.LGBT, MothVariation.NON_BINARY, MothVariation.AGENDER, MothVariation.ASEXUAL, MothVariation.GAY, MothVariation.LESBIAN, MothVariation.BISEXUAL, MothVariation.PANSEXUAL, MothVariation.POLYAMOROUS, MothVariation.POLYSEXUAL, MothVariation.OMNISEXUAL, MothVariation.AROMANTIC, MothVariation.AROACE, MothVariation.DEMIGIRL, MothVariation.DEMISEXUAL, MothVariation.DEMIGENDER, MothVariation.DEMIROMANTIC, MothVariation.GENDERFLUID, MothVariation.INTERSEX, MothVariation.XENOGENDER, MothVariation.GENDER_QUEER, MothVariation.GENDERFAE, MothVariation.GENDERFAUN, MothVariation.BIGENDER, MothVariation.PANGENDER);
    public static final List<MothVariation> ASEXUAL_VISIBILITY_DAY_VARIATIONS = List.of(MothVariation.ASEXUAL, MothVariation.DEMISEXUAL, MothVariation.AROACE);
    public static final List<MothVariation> AROMANTIC_VISIBILITY_DAY_VARIATIONS = List.of(MothVariation.AROMANTIC, MothVariation.DEMIROMANTIC, MothVariation.AROACE);
    public static final List<MothVariation> DEMIGENDER_VISIBILITY_DAY_VARIATIONS = List.of(MothVariation.DEMIBOY, MothVariation.DEMIGIRL, MothVariation.DEMIGENDER);
    public static final List<MothVariation> TRANSGENDER_VISIBILITY_DAY_VARIATIONS = List.of(MothVariation.TRANSGENDER, MothVariation.NON_BINARY, MothVariation.AGENDER, MothVariation.DEMIBOY, MothVariation.DEMIGIRL, MothVariation.DEMIGENDER, MothVariation.GENDERFLUID, MothVariation.GENDER_QUEER, MothVariation.GENDERFAE, MothVariation.GENDERFAUN, MothVariation.BIGENDER, MothVariation.PANGENDER);

    public MothEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, (double)0.4f).add(Attributes.FLYING_SPEED, 0.25).add(Attributes.TEMPT_RANGE, 10.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, stack -> stack.is(PrideMothsMod.CAN_MOTH_EAT), false));
        this.targetSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new MothWanderAroundGoal());
    }

    public static MothVariation getPrideVariation(RandomSource random) {
        return PRIDE_VARIATIONS.get(random.nextInt(PRIDE_VARIATIONS.size()));
    }

    public static MothVariation getAceVariation(RandomSource random) {
        return ASEXUAL_VISIBILITY_DAY_VARIATIONS.get(random.nextInt(ASEXUAL_VISIBILITY_DAY_VARIATIONS.size()));
    }

    public static MothVariation getAroVariation(RandomSource random) {
        return AROMANTIC_VISIBILITY_DAY_VARIATIONS.get(random.nextInt(AROMANTIC_VISIBILITY_DAY_VARIATIONS.size()));
    }

    public static MothVariation getDemigenderVariation(RandomSource random) {
        return DEMIGENDER_VISIBILITY_DAY_VARIATIONS.get(random.nextInt(DEMIGENDER_VISIBILITY_DAY_VARIATIONS.size()));
    }

    public static MothVariation getTransgenderVariation(RandomSource random) {
        return TRANSGENDER_VISIBILITY_DAY_VARIATIONS.get(random.nextInt(TRANSGENDER_VISIBILITY_DAY_VARIATIONS.size()));
    }

    public static MothVariation getOtherVariation(RandomSource random) {
        int rarePatternChance = PrideMothsCommonConfig.BASE_RARE_CHANCE.getAsInt();
        if (IPrideMoths.isWorldMothWeek()) {
            rarePatternChance = PrideMothsCommonConfig.BASE_RARE_CHANCE_MOTH_WEEK.getAsInt();
        }
        if (random.nextInt(rarePatternChance) == 1) {
            return MothVariation.RARE;
        }
        return MothVariation.DEFAULT;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)((EntityType)EntityTypeRegistrar.MOTH.get()).create((Level)world, EntitySpawnReason.BREEDING);
    }

    public boolean isFood(ItemStack stack) {
        return this.isFavouredFoodItem(stack);
    }

    public boolean isFavouredFoodItem(ItemStack stack) {
        return stack.getItem().getDefaultInstance().is(PrideMothsMod.CAN_MOTH_EAT);
    }

    @NotNull
    public EntityDimensions getDefaultDimensions(Pose pose) {
        return EntityDimensions.fixed((float)0.45f, (float)0.45f);
    }

    protected void ageBoundaryReached() {
        ServerLevel level;
        Level level2;
        super.ageBoundaryReached();
        if (!this.isBaby() && (level2 = this.level()) instanceof ServerLevel && (level = (ServerLevel)level2).getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.spawnAtLocation(level, (ItemLike)ItemsRegistrar.MOTH_FUZZ.get());
        }
    }

    public void setFromFinalizeSpawn() {
        LocalDate date = LocalDate.now();
        int getLocalMonthFromUser = date.get(ChronoField.MONTH_OF_YEAR);
        if (IPrideMoths.isAgenderDayOfVisibility()) {
            this.setMothVariant(MothVariation.AGENDER);
        } else if (IPrideMoths.isBisexualDayOfVisibility()) {
            this.setMothVariant(MothVariation.BISEXUAL);
        } else if (IPrideMoths.isGayDayOfVisibility()) {
            this.setMothVariant(MothVariation.GAY);
        } else if (IPrideMoths.isLesbianDayOfVisibility()) {
            this.setMothVariant(MothVariation.LESBIAN);
        } else if (IPrideMoths.isPansexualDayOfVisibility()) {
            this.setMothVariant(MothVariation.PANSEXUAL);
        } else if (IPrideMoths.isOmnisexualDayOfVisibility()) {
            this.setMothVariant(MothVariation.OMNISEXUAL);
        } else if (IPrideMoths.isPolyamorousDayOfVisibility()) {
            this.setMothVariant(MothVariation.POLYAMOROUS);
        } else if (IPrideMoths.isPolysexualDayOfVisibility()) {
            this.setMothVariant(MothVariation.POLYSEXUAL);
        } else if (IPrideMoths.isIntersexDayOfVisibility()) {
            this.setMothVariant(MothVariation.INTERSEX);
        } else if (IPrideMoths.isXenogenderDayOfVisibility()) {
            this.setMothVariant(MothVariation.XENOGENDER);
        } else if (IPrideMoths.isGenderQueerDayOfVisibility()) {
            this.setMothVariant(MothVariation.GENDER_QUEER);
        } else if (IPrideMoths.isGenderfluidWeekOfVisibility()) {
            this.setMothVariant(MothVariation.GENDERFLUID);
        } else if (IPrideMoths.isTransgenderDayOfVisibility()) {
            this.setMothVariant(MothEntity.getTransgenderVariation(this.random));
        } else if (IPrideMoths.isAsexualDayOfVisibility()) {
            this.setMothVariant(MothEntity.getAceVariation(this.random));
        } else if (IPrideMoths.isAromanticDayOfVisibility()) {
            this.setMothVariant(MothEntity.getAroVariation(this.random));
        } else if (IPrideMoths.isDemigenderDayOfVisibility()) {
            this.setMothVariant(MothEntity.getDemigenderVariation(this.random));
        } else if (getLocalMonthFromUser == 6 || ((Boolean)PrideMothsCommonConfig.GENERATE_PRIDE_VARIANTS_OUTSIDE_OF_PRIDE_MONTH.get()).booleanValue()) {
            this.setMothVariant(MothEntity.getPrideVariation(this.random));
        } else {
            this.setMothVariant(MothEntity.getOtherVariation(this.random));
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData entityData) {
        this.setFromFinalizeSpawn();
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.isFood(itemstack) && this.isFavouredFoodItem(itemstack)) {
            int i = this.getAge();
            if (!this.level().isClientSide() && i == 0 && this.canFallInLove()) {
                this.usePlayerItem(player, hand, itemstack);
                this.setInLove(player);
                return InteractionResult.SUCCESS_SERVER;
            }
            if (this.isBaby()) {
                this.usePlayerItem(player, hand, itemstack);
                this.ageUp(MothEntity.getSpeedUpSecondsWhenFeeding((int)(-i)), true);
                return InteractionResult.SUCCESS;
            }
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
        }
        if (player.getItemInHand(hand).getItem() == ItemsRegistrar.GLASS_JAR.get()) {
            ItemStack itemStack = this.getMothJarItemFromVariation();
            if (this.hasCustomName()) {
                itemStack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            }
            if (this.isBaby()) {
                itemStack.set(DataComponentsRegistrar.CONTAINS_BABY, (Object)this.isBaby());
                itemStack.set(DataComponentsRegistrar.SAVED_AGE, (Object)this.age);
            }
            if (!player.getAbilities().instabuild) {
                if (player.getItemInHand(hand).getCount() > 1) {
                    player.getItemInHand(hand).shrink(1);
                    if (!player.getInventory().add(itemStack)) {
                        player.drop(itemStack, true);
                    }
                } else {
                    player.setItemInHand(hand, itemStack);
                }
            } else if (!player.getInventory().add(itemStack)) {
                player.drop(itemStack, true);
            }
            this.level().playSound((Entity)player, player.blockPosition(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.discard();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public ItemStack getPickResult() {
        return this.getMothJarItemFromVariation();
    }

    @NotNull
    private ItemStack getMothJarItemFromVariation() {
        return new ItemStack((ItemLike)(switch (this.getMothVariant()) {
            case MothVariation.RARE -> (Item)ItemsRegistrar.RARE_MOTH_JAR.get();
            case MothVariation.AGENDER -> (Item)ItemsRegistrar.AGENDER_MOTH_JAR.get();
            case MothVariation.AROACE -> (Item)ItemsRegistrar.AROACE_MOTH_JAR.get();
            case MothVariation.AROMANTIC -> (Item)ItemsRegistrar.AROMANTIC_MOTH_JAR.get();
            case MothVariation.ASEXUAL -> (Item)ItemsRegistrar.ASEXUAL_MOTH_JAR.get();
            case MothVariation.BISEXUAL -> (Item)ItemsRegistrar.BISEXUAL_MOTH_JAR.get();
            case MothVariation.DEMIBOY -> (Item)ItemsRegistrar.DEMIBOY_MOTH_JAR.get();
            case MothVariation.DEMIGENDER -> (Item)ItemsRegistrar.DEMIGENDER_MOTH_JAR.get();
            case MothVariation.DEMIGIRL -> (Item)ItemsRegistrar.DEMIGIRL_MOTH_JAR.get();
            case MothVariation.DEMIROMANTIC -> (Item)ItemsRegistrar.DEMIROMANTIC_MOTH_JAR.get();
            case MothVariation.DEMISEXUAL -> (Item)ItemsRegistrar.DEMISEXUAL_MOTH_JAR.get();
            case MothVariation.GAY -> (Item)ItemsRegistrar.GAY_MOTH_JAR.get();
            case MothVariation.LESBIAN -> (Item)ItemsRegistrar.LESBIAN_MOTH_JAR.get();
            case MothVariation.LGBT -> (Item)ItemsRegistrar.LGBT_MOTH_JAR.get();
            case MothVariation.NON_BINARY -> (Item)ItemsRegistrar.NON_BINARY_MOTH_JAR.get();
            case MothVariation.OMNISEXUAL -> (Item)ItemsRegistrar.OMNISEXUAL_MOTH_JAR.get();
            case MothVariation.PANSEXUAL -> (Item)ItemsRegistrar.PANSEXUAL_MOTH_JAR.get();
            case MothVariation.POLYAMOROUS -> (Item)ItemsRegistrar.POLYAMOROUS_MOTH_JAR.get();
            case MothVariation.POLYSEXUAL -> (Item)ItemsRegistrar.POLYSEXUAL_MOTH_JAR.get();
            case MothVariation.TRANSGENDER -> (Item)ItemsRegistrar.TRANSGENDER_MOTH_JAR.get();
            case MothVariation.GENDERFLUID -> (Item)ItemsRegistrar.GENDERFLUID_MOTH_JAR.get();
            case MothVariation.INTERSEX -> (Item)ItemsRegistrar.INTERSEX_MOTH_JAR.get();
            case MothVariation.XENOGENDER -> (Item)ItemsRegistrar.XENOGENDER_MOTH_JAR.get();
            case MothVariation.GENDER_QUEER -> (Item)ItemsRegistrar.GENDER_QUEER_MOTH_JAR.get();
            case MothVariation.GENDERFAE -> (Item)ItemsRegistrar.GENDERFAE_MOTH_JAR.get();
            case MothVariation.GENDERFAUN -> (Item)ItemsRegistrar.GENDERFAUN_MOTH_JAR.get();
            case MothVariation.BIGENDER -> (Item)ItemsRegistrar.BIGENDER_MOTH_JAR.get();
            case MothVariation.PANGENDER -> (Item)ItemsRegistrar.PANGENDER_MOTH_JAR.get();
            default -> (Item)ItemsRegistrar.MOTH_JAR.get();
        }));
    }

    public void setMothVariant(MothVariation type) {
        this.entityData.set(VARIANT, (Object)type.getIndex());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)MothVariation.DEFAULT.getIndex());
        builder.define(FROM_JAR, (Object)false);
    }

    public boolean isFromGlassJar() {
        return (Boolean)this.entityData.get(FROM_JAR);
    }

    public void setFromGlassJar(boolean b) {
        this.entityData.set(FROM_JAR, (Object)b);
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setFromGlassJar(valueInput.getBooleanOr("FromGlassJar", false));
        this.setMothVariant(valueInput.read("MothVariant", MothVariation.INDEX_CODEC).orElse(MothVariation.DEFAULT));
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putBoolean("FromGlassJar", this.isFromGlassJar());
        valueOutput.store("MothVariant", MothVariation.INDEX_CODEC, (Object)this.getMothVariant());
    }

    public MothVariation getMothVariant() {
        return MothVariation.byIndex((Integer)this.entityData.get(VARIANT));
    }

    public boolean causeFallDamage(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    private boolean queerNames() {
        String name = this.getName().getString();
        return name.equalsIgnoreCase("lgbt") || name.equalsIgnoreCase("lgbtq") || name.equalsIgnoreCase("lgbtqia") || name.equalsIgnoreCase("lgbtqia+");
    }

    private boolean nonBinaryNames() {
        String name = this.getName().getString();
        return name.equalsIgnoreCase("non-binary") || name.equalsIgnoreCase("non binary") || name.equalsIgnoreCase("non_binary") || name.equalsIgnoreCase("nonbinary") || name.equalsIgnoreCase("nyan-binary");
    }

    private boolean twoNames(String i0, String i1) {
        String name = this.getName().getString();
        return name.equalsIgnoreCase(i0) || name.equalsIgnoreCase(i1);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.hasCustomName()) {
            if (this.getMothVariant() != MothVariation.NON_BINARY && this.nonBinaryNames()) {
                this.setMothVariant(MothVariation.NON_BINARY);
            } else if (this.getMothVariant() != MothVariation.TRANSGENDER && this.twoNames("trans", "transgender")) {
                this.setMothVariant(MothVariation.TRANSGENDER);
            } else if (this.getMothVariant() != MothVariation.LGBT && this.queerNames()) {
                this.setMothVariant(MothVariation.LGBT);
            } else if (this.getMothVariant() != MothVariation.GAY && this.twoNames("gay", "mlm")) {
                this.setMothVariant(MothVariation.GAY);
            } else if (this.getMothVariant() != MothVariation.LESBIAN && this.twoNames("lesbian", "wlw")) {
                this.setMothVariant(MothVariation.LESBIAN);
            } else if (this.getMothVariant() != MothVariation.AGENDER && this.getName().getString().equalsIgnoreCase("agender")) {
                this.setMothVariant(MothVariation.AGENDER);
            } else if (this.getMothVariant() != MothVariation.ASEXUAL && this.twoNames("asexual", "ace")) {
                this.setMothVariant(MothVariation.ASEXUAL);
            } else if (this.getMothVariant() != MothVariation.BISEXUAL && this.twoNames("bisexual", "bi")) {
                this.setMothVariant(MothVariation.BISEXUAL);
            } else if (this.getMothVariant() != MothVariation.PANSEXUAL && this.twoNames("pansexual", "pan")) {
                this.setMothVariant(MothVariation.PANSEXUAL);
            } else if (this.getMothVariant() != MothVariation.POLYAMOROUS && this.twoNames("polyamorous", "polygamous")) {
                this.setMothVariant(MothVariation.POLYAMOROUS);
            } else if (this.getMothVariant() != MothVariation.POLYSEXUAL && this.twoNames("polysexual", "poly")) {
                this.setMothVariant(MothVariation.POLYSEXUAL);
            } else if (this.getMothVariant() != MothVariation.OMNISEXUAL && this.twoNames("omnisexual", "omni")) {
                this.setMothVariant(MothVariation.OMNISEXUAL);
            } else if (this.getMothVariant() != MothVariation.DEMISEXUAL && this.twoNames("demisexual", "demi")) {
                this.setMothVariant(MothVariation.DEMISEXUAL);
            } else if (this.getMothVariant() != MothVariation.DEMIROMANTIC && this.twoNames("demiromantic", "demiro")) {
                this.setMothVariant(MothVariation.DEMIROMANTIC);
            } else if (this.getMothVariant() != MothVariation.DEMIBOY && this.getName().getString().equalsIgnoreCase("demiboy")) {
                this.setMothVariant(MothVariation.DEMIBOY);
            } else if (this.getMothVariant() != MothVariation.DEMIGIRL && this.getName().getString().equalsIgnoreCase("demigirl")) {
                this.setMothVariant(MothVariation.DEMIGIRL);
            } else if (this.getMothVariant() != MothVariation.DEMIGENDER && this.getName().getString().equalsIgnoreCase("demigender")) {
                this.setMothVariant(MothVariation.DEMIGENDER);
            } else if (this.getMothVariant() != MothVariation.AROACE && this.getName().getString().equalsIgnoreCase("aroace")) {
                this.setMothVariant(MothVariation.AROACE);
            } else if (this.getMothVariant() != MothVariation.GENDERFLUID && this.getName().getString().equalsIgnoreCase("genderfluid")) {
                this.setMothVariant(MothVariation.GENDERFLUID);
            } else if (this.getMothVariant() != MothVariation.INTERSEX && this.getName().getString().equalsIgnoreCase("intersex")) {
                this.setMothVariant(MothVariation.INTERSEX);
            } else if (this.getMothVariant() != MothVariation.XENOGENDER && this.getName().getString().equalsIgnoreCase("xenogender")) {
                this.setMothVariant(MothVariation.XENOGENDER);
            } else if (this.getMothVariant() != MothVariation.GENDER_QUEER && this.twoNames("gender_queer", "genderqueer")) {
                this.setMothVariant(MothVariation.GENDER_QUEER);
            } else if (this.getMothVariant() != MothVariation.GENDERFAE && this.getName().getString().equalsIgnoreCase("genderfae")) {
                this.setMothVariant(MothVariation.GENDERFAE);
            } else if (this.getMothVariant() != MothVariation.GENDERFAUN && this.getName().getString().equalsIgnoreCase("genderfaun")) {
                this.setMothVariant(MothVariation.GENDERFAUN);
            } else if (this.getMothVariant() != MothVariation.BIGENDER && this.getName().getString().equalsIgnoreCase("bigender")) {
                this.setMothVariant(MothVariation.BIGENDER);
            } else if (this.getMothVariant() != MothVariation.PANGENDER && this.getName().getString().equalsIgnoreCase("pangender")) {
                this.setMothVariant(MothVariation.PANGENDER);
            }
            if (this.getMothVariant() != MothVariation.ALLY && this.twoNames("ally", "straight")) {
                this.setMothVariant(MothVariation.ALLY);
            }
            if (this.getCustomName().getString().equalsIgnoreCase("super straight")) {
                this.kill((ServerLevel)this.level());
            } else if (this.getCustomName().getString().equalsIgnoreCase("super_straight")) {
                this.kill((ServerLevel)this.level());
            } else if (this.getCustomName().getString().equalsIgnoreCase("superstraight")) {
                this.kill((ServerLevel)this.level());
            } else if (this.getCustomName().getString().equalsIgnoreCase("super-straight")) {
                this.kill((ServerLevel)this.level());
            }
        }
    }

    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, world);
        birdNavigation.setCanOpenDoors(false);
        birdNavigation.setCanFloat(false);
        return birdNavigation;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.AXOLOTL_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.AXOLOTL_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    public boolean canAttackType(EntityType<?> type) {
        return type == EntityType.PLAYER;
    }

    class MothWanderAroundGoal
    extends Goal {
        MothWanderAroundGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return MothEntity.this.navigation.isDone() && MothEntity.this.random.nextInt(10) == 0;
        }

        public boolean canContinueToUse() {
            return MothEntity.this.navigation.isInProgress();
        }

        public void start() {
            Vec3 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                MothEntity.this.navigation.moveTo(MothEntity.this.navigation.createPath(BlockPos.containing((Position)vec3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vec3d2 = MothEntity.this.getViewVector(0.35f);
            Vec3 vec3d3 = HoverRandomPos.getPos((PathfinderMob)MothEntity.this, (int)8, (int)7, (double)vec3d2.x, (double)vec3d2.z, (float)1.5707964f, (int)3, (int)1);
            return vec3d3 != null ? vec3d3 : AirAndWaterRandomPos.getPos((PathfinderMob)MothEntity.this, (int)8, (int)4, (int)-2, (double)vec3d2.x, (double)vec3d2.z, (double)1.5707963705062866);
        }
    }
}

