/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.pridemoths.client.model;

import net.dakotapride.pridemoths.client.model.MothRenderState;
import net.dakotapride.pridemoths.client.renderer.MothAnimations;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class BabyMothModel
extends EntityModel<MothRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"baby_moth"), "main");
    private final ModelPart body;
    private final ModelPart antennae;
    private final ModelPart wings;
    private final ModelPart fur;
    private final KeyframeAnimation idlingAnimation;

    public BabyMothModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.antennae = this.body.getChild("antennae");
        this.wings = this.body.getChild("wings");
        this.fur = this.body.getChild("fur");
        this.idlingAnimation = MothAnimations.ANIM_IDLE.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.0f, (float)0.25f));
        PartDefinition antennae = body.addOrReplaceChild("antennae", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)-2.5f));
        PartDefinition right2 = antennae.addOrReplaceChild("right2", CubeListBuilder.create().texOffs(11, 2).addBox(0.0f, -3.0f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.75f, (float)0.75f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.1309f));
        PartDefinition left2 = antennae.addOrReplaceChild("left2", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.75f, (float)0.75f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)-0.1309f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -1.5f, -2.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)-0.5f));
        PartDefinition wings = body.addOrReplaceChild("wings", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)-0.5f));
        PartDefinition left = wings.addOrReplaceChild("left", CubeListBuilder.create(), PartPose.offset((float)-0.5f, (float)0.0f, (float)-0.75f));
        PartDefinition left_r1 = left.addOrReplaceChild("left_r1", CubeListBuilder.create().texOffs(0, 8).addBox(-3.0f, 0.0f, 0.0f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)-0.1309f, (float)0.0f));
        PartDefinition right = wings.addOrReplaceChild("right", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)0.0f, (float)-0.75f));
        PartDefinition right_r1 = right.addOrReplaceChild("right_r1", CubeListBuilder.create().texOffs(6, 8).addBox(0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.1309f, (float)0.0f));
        PartDefinition legs = body.addOrReplaceChild("legs", CubeListBuilder.create().texOffs(11, 1).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 11).addBox(-1.5f, 0.0f, -0.5f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(7, 10).addBox(-1.5f, 0.0f, 1.5f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition fur = body.addOrReplaceChild("fur", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)4.0f, (float)2.5f));
        PartDefinition top = fur.addOrReplaceChild("top", CubeListBuilder.create(), PartPose.offset((float)-0.5f, (float)-5.0f, (float)-4.0f));
        PartDefinition top_r1 = top.addOrReplaceChild("top_r1", CubeListBuilder.create().texOffs(0, 10).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)2.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition top_r2 = top.addOrReplaceChild("top_r2", CubeListBuilder.create().texOffs(10, 0).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition right3 = fur.addOrReplaceChild("right3", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-3.5f, (float)-2.5f));
        PartDefinition right3_r1 = right3.addOrReplaceChild("right3_r1", CubeListBuilder.create().texOffs(10, 11).addBox(0.0f, -1.5f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.5f, (float)0.0f, (float)-1.2217f, (float)0.0f));
        PartDefinition right3_r2 = right3.addOrReplaceChild("right3_r2", CubeListBuilder.create().texOffs(0, 12).addBox(0.0f, -1.5f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.5f, (float)0.0f, (float)-1.2217f, (float)0.0f));
        PartDefinition left3 = fur.addOrReplaceChild("left3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.0f, (float)-3.5f, (float)-2.4167f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition left3_r1 = left3.addOrReplaceChild("left3_r1", CubeListBuilder.create().texOffs(6, 11).addBox(0.0f, -1.5f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.4167f, (float)0.0f, (float)-1.2217f, (float)0.0f));
        PartDefinition left3_r2 = left3.addOrReplaceChild("left3_r2", CubeListBuilder.create().texOffs(8, 11).addBox(0.0f, -1.5f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.5833f, (float)0.0f, (float)-1.2217f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(MothRenderState state) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.idlingAnimation.apply(state.idleAnimationState, state.ageInTicks, 1.0f);
    }
}

