/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.pridemoths.client.model;

import net.dakotapride.pridemoths.client.model.MothRenderState;
import net.dakotapride.pridemoths.client.renderer.MothAnimations;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class MothModel
extends EntityModel<MothRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"moth"), "main");
    private final ModelPart body;
    private final ModelPart antennae;
    private final ModelPart wings;
    private final ModelPart fur;
    private final KeyframeAnimation idlingAnimation;

    public MothModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.antennae = this.body.getChild("antennae");
        this.wings = this.body.getChild("wings");
        this.fur = this.body.getChild("fur");
        this.idlingAnimation = MothAnimations.ANIM_IDLE.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)20.0f, (float)-1.0f));
        PartDefinition antennae = body.addOrReplaceChild("antennae", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)1.0f, (float)2.0f));
        PartDefinition right2 = antennae.addOrReplaceChild("right2", CubeListBuilder.create().texOffs(0, 5).addBox(0.0f, -5.0f, 0.0f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-3.0f, (float)-6.0f, (float)0.0873f, (float)0.0f, (float)0.1309f));
        PartDefinition left2 = antennae.addOrReplaceChild("left2", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -5.0f, 0.0f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-3.0f, (float)-6.0f, (float)0.0873f, (float)0.0f, (float)-0.1309f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 14).addBox(-2.5f, -4.0f, -6.0f, 5.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)1.0f, (float)2.0f));
        PartDefinition wings = body.addOrReplaceChild("wings", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)-3.0f, (float)-2.0f));
        PartDefinition left = wings.addOrReplaceChild("left", CubeListBuilder.create(), PartPose.offset((float)-0.5f, (float)0.0f, (float)0.0f));
        PartDefinition left_r1 = left.addOrReplaceChild("left_r1", CubeListBuilder.create().texOffs(3, 4).addBox(-8.0f, 0.0f, 0.0f, 8.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)-0.1309f, (float)0.0f));
        PartDefinition right = wings.addOrReplaceChild("right", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)0.0f, (float)0.0f));
        PartDefinition right_r1 = right.addOrReplaceChild("right_r1", CubeListBuilder.create().texOffs(3, 9).addBox(0.0f, 0.0f, 0.0f, 8.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.1309f, (float)0.0f));
        PartDefinition legs = body.addOrReplaceChild("legs", CubeListBuilder.create().texOffs(18, 18).addBox(-2.5f, 0.0f, -1.5f, 5.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(18, 16).addBox(-2.5f, 0.0f, -0.5f, 5.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(18, 14).addBox(-2.5f, 0.0f, 1.5f, 5.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)2.0f, (float)-1.5f));
        PartDefinition fur = body.addOrReplaceChild("fur", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)1.0f));
        PartDefinition top = fur.addOrReplaceChild("top", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition top_r1 = top.addOrReplaceChild("top_r1", CubeListBuilder.create().texOffs(2, 27).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-7.0f, (float)1.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition top_r2 = top.addOrReplaceChild("top_r2", CubeListBuilder.create().texOffs(7, 2).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-7.0f, (float)-4.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition top_r3 = top.addOrReplaceChild("top_r3", CubeListBuilder.create().texOffs(7, 0).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-7.0f, (float)-2.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition right3 = fur.addOrReplaceChild("right3", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition right3_r1 = right3.addOrReplaceChild("right3_r1", CubeListBuilder.create().texOffs(0, 10).addBox(0.0f, -2.5f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-1.5f, (float)-4.0f, (float)0.0f, (float)-1.2217f, (float)0.0f));
        PartDefinition right3_r2 = right3.addOrReplaceChild("right3_r2", CubeListBuilder.create().texOffs(0, 27).addBox(0.0f, -2.5f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-1.5f, (float)1.0f, (float)0.0f, (float)-1.2217f, (float)0.0f));
        PartDefinition right3_r3 = right3.addOrReplaceChild("right3_r3", CubeListBuilder.create().texOffs(0, 15).addBox(0.0f, -2.5f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-1.5f, (float)-2.0f, (float)0.0f, (float)-1.2217f, (float)0.0f));
        PartDefinition left3 = fur.addOrReplaceChild("left3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-3.0f, (float)-4.5f, (float)-1.6667f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition left3_r1 = left3.addOrReplaceChild("left3_r1", CubeListBuilder.create().texOffs(0, 10).addBox(0.0f, -2.5f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)-2.3333f, (float)0.0f, (float)-1.2217f, (float)0.0f));
        PartDefinition left3_r2 = left3.addOrReplaceChild("left3_r2", CubeListBuilder.create().texOffs(0, 27).addBox(0.0f, -2.5f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)2.6667f, (float)0.0f, (float)-1.2217f, (float)0.0f));
        PartDefinition left3_r3 = left3.addOrReplaceChild("left3_r3", CubeListBuilder.create().texOffs(0, 15).addBox(0.0f, -2.5f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)-0.3333f, (float)0.0f, (float)-1.2217f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(MothRenderState state) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.idlingAnimation.apply(state.idleAnimationState, state.ageInTicks, 1.0f);
    }
}

