/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.pridemoths.client.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.dakotapride.pridemoths.client.entity.MothEntity;
import net.dakotapride.pridemoths.client.entity.pride.MothVariation;
import net.dakotapride.pridemoths.client.model.MothModel;
import net.dakotapride.pridemoths.client.model.MothRenderState;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class MothRenderer
extends MobRenderer<MothEntity, MothRenderState, MothModel> {
    public static final Map<MothVariation, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(MothVariation.class), map -> {
        map.put(MothVariation.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/moth.png"));
        map.put(MothVariation.RARE, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/rare.png"));
        map.put(MothVariation.AGENDER, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/agender.png"));
        map.put(MothVariation.AROACE, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/aroace.png"));
        map.put(MothVariation.AROMANTIC, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/aromantic.png"));
        map.put(MothVariation.ASEXUAL, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/asexual.png"));
        map.put(MothVariation.BISEXUAL, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/bisexual.png"));
        map.put(MothVariation.DEMIBOY, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/demiboy.png"));
        map.put(MothVariation.DEMIGENDER, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/demigender.png"));
        map.put(MothVariation.DEMIGIRL, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/demigirl.png"));
        map.put(MothVariation.DEMIROMANTIC, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/demiromantic.png"));
        map.put(MothVariation.DEMISEXUAL, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/demisexual.png"));
        map.put(MothVariation.GAY, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/gay.png"));
        map.put(MothVariation.LESBIAN, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/lesbian.png"));
        map.put(MothVariation.LGBT, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/lgbt.png"));
        map.put(MothVariation.NON_BINARY, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/non_binary.png"));
        map.put(MothVariation.OMNISEXUAL, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/omnisexual.png"));
        map.put(MothVariation.PANSEXUAL, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/pansexual.png"));
        map.put(MothVariation.POLYAMOROUS, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/polyamorous.png"));
        map.put(MothVariation.POLYSEXUAL, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/polysexual.png"));
        map.put(MothVariation.TRANSGENDER, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/transgender.png"));
        map.put(MothVariation.GENDERFLUID, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/genderfluid.png"));
        map.put(MothVariation.INTERSEX, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/intersex.png"));
        map.put(MothVariation.XENOGENDER, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/xenogender.png"));
        map.put(MothVariation.GENDER_QUEER, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/gender_queer.png"));
        map.put(MothVariation.GENDERFAE, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/genderfae.png"));
        map.put(MothVariation.GENDERFAUN, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/genderfaun.png"));
        map.put(MothVariation.BIGENDER, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/bigender.png"));
        map.put(MothVariation.PANGENDER, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/pangender.png"));
        map.put(MothVariation.ALLY, ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/pride/ally.png"));
    });

    public MothRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MothModel(context.bakeLayer(MothModel.LAYER_LOCATION)), 0.25f);
    }

    public ResourceLocation getTextureLocation(MothRenderState entity) {
        if (entity.variant == MothVariation.RARE) {
            return ResourceLocation.fromNamespaceAndPath((String)"pridemoths", (String)"textures/model/rare.png");
        }
        return LOCATION_BY_VARIANT.get((Object)entity.variant);
    }

    public void submit(MothRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.isBaby) {
            poseStack.scale(0.45f, 0.45f, 0.45f);
        } else {
            poseStack.scale(1.0f, 1.0f, 1.0f);
        }
        super.submit((LivingEntityRenderState)renderState, poseStack, nodeCollector, cameraRenderState);
    }

    public MothRenderState createRenderState() {
        return new MothRenderState();
    }

    public void extractRenderState(MothEntity entity, MothRenderState reusedState, float partialTick) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)reusedState, partialTick);
        reusedState.idleAnimationState.copyFrom(entity.idleAnimationState);
        reusedState.variant = entity.getMothVariant();
    }
}

