/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.pridemoths.client.entity;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.EnumSet;
import java.util.List;
import net.dakotapride.pridemoths.PrideMothsInitialize;
import net.dakotapride.pridemoths.client.entity.pride.IPrideMoths;
import net.dakotapride.pridemoths.client.entity.pride.MothVariation;
import net.dakotapride.pridemoths.config.PrideMothsConfigs;
import net.dakotapride.pridemoths.register.DataComponentsRegistrar;
import net.dakotapride.pridemoths.register.EntityTypeRegistrar;
import net.dakotapride.pridemoths.register.ItemsRegistrar;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1391;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5530;
import net.minecraft.class_5533;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MothEntity
extends class_1429
implements class_1432,
IPrideMoths {
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(MothEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> FROM_JAR = class_2945.method_12791(MothEntity.class, (class_2941)class_2943.field_13323);
    public static final List<MothVariation> PRIDE_VARIATIONS = List.of(MothVariation.TRANSGENDER, MothVariation.LGBT, MothVariation.NON_BINARY, MothVariation.AGENDER, MothVariation.ASEXUAL, MothVariation.GAY, MothVariation.LESBIAN, MothVariation.BISEXUAL, MothVariation.PANSEXUAL, MothVariation.POLYAMOROUS, MothVariation.POLYSEXUAL, MothVariation.OMNISEXUAL, MothVariation.AROMANTIC, MothVariation.AROACE, MothVariation.DEMIGIRL, MothVariation.DEMISEXUAL, MothVariation.DEMIGENDER, MothVariation.DEMIROMANTIC, MothVariation.GENDERFLUID, MothVariation.INTERSEX, MothVariation.XENOGENDER, MothVariation.GENDER_QUEER, MothVariation.GENDERFAE, MothVariation.GENDERFAUN, MothVariation.BIGENDER, MothVariation.PANGENDER);
    public final class_7094 idleAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    public static final List<MothVariation> ASEXUAL_VISIBILITY_DAY_VARIATIONS = List.of(MothVariation.ASEXUAL, MothVariation.DEMISEXUAL, MothVariation.AROACE);
    public static final List<MothVariation> AROMANTIC_VISIBILITY_DAY_VARIATIONS = List.of(MothVariation.AROMANTIC, MothVariation.DEMIROMANTIC, MothVariation.AROACE);
    public static final List<MothVariation> DEMIGENDER_VISIBILITY_DAY_VARIATIONS = List.of(MothVariation.DEMIBOY, MothVariation.DEMIGIRL, MothVariation.DEMIGENDER);
    public static final List<MothVariation> TRANSGENDER_VISIBILITY_DAY_VARIATIONS = List.of(MothVariation.TRANSGENDER, MothVariation.NON_BINARY, MothVariation.AGENDER, MothVariation.DEMIBOY, MothVariation.DEMIGIRL, MothVariation.DEMIGENDER, MothVariation.GENDERFLUID, MothVariation.GENDER_QUEER, MothVariation.GENDERFAE, MothVariation.GENDERFAUN, MothVariation.BIGENDER, MothVariation.PANGENDER);

    public MothEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, (double)0.4f).method_26868(class_5134.field_23720, 0.25).method_26868(class_5134.field_52450, 10.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(5, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.25, stack -> stack.method_31573(PrideMothsInitialize.CAN_MOTH_EAT), false));
        this.field_6185.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new MothWanderAroundGoal());
    }

    public static MothVariation getPrideVariation(class_5819 random) {
        return PRIDE_VARIATIONS.get(random.method_43048(PRIDE_VARIATIONS.size()));
    }

    public static MothVariation getAceVariation(class_5819 random) {
        return ASEXUAL_VISIBILITY_DAY_VARIATIONS.get(random.method_43048(ASEXUAL_VISIBILITY_DAY_VARIATIONS.size()));
    }

    public static MothVariation getAroVariation(class_5819 random) {
        return AROMANTIC_VISIBILITY_DAY_VARIATIONS.get(random.method_43048(AROMANTIC_VISIBILITY_DAY_VARIATIONS.size()));
    }

    public static MothVariation getDemigenderVariation(class_5819 random) {
        return DEMIGENDER_VISIBILITY_DAY_VARIATIONS.get(random.method_43048(DEMIGENDER_VISIBILITY_DAY_VARIATIONS.size()));
    }

    public static MothVariation getTransgenderVariation(class_5819 random) {
        return TRANSGENDER_VISIBILITY_DAY_VARIATIONS.get(random.method_43048(TRANSGENDER_VISIBILITY_DAY_VARIATIONS.size()));
    }

    public static MothVariation getOtherVariation(class_5819 random) {
        int rarePatternChance = PrideMothsConfigs.BASE_RARE_CHANCE;
        if (IPrideMoths.isWorldMothWeek()) {
            rarePatternChance = PrideMothsConfigs.BASE_RARE_CHANCE_MOTH_WEEK;
        }
        if (random.method_43048(rarePatternChance) == 1) {
            return MothVariation.RARE;
        }
        return MothVariation.DEFAULT;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)EntityTypeRegistrar.MOTH.method_5883((class_1937)world, class_3730.field_16466);
    }

    public boolean method_6481(class_1799 stack) {
        return this.isFavouredFoodItem(stack);
    }

    public boolean isFavouredFoodItem(class_1799 stack) {
        return stack.method_7909().method_7854().method_31573(PrideMothsInitialize.CAN_MOTH_EAT);
    }

    protected class_4048 method_55694(class_4050 pose) {
        return class_4048.method_18385((float)0.45f, (float)0.45f);
    }

    protected void method_5619() {
        class_3218 serverWorld;
        class_1937 class_19372;
        super.method_5619();
        if (!this.method_6109() && (class_19372 = this.method_73183()) instanceof class_3218 && (serverWorld = (class_3218)class_19372).method_64395().method_8355(class_1928.field_19391)) {
            this.method_5706(serverWorld, (class_1935)ItemsRegistrar.MOTH_FUZZ);
        }
    }

    public void setFromInitialize() {
        LocalDate date = LocalDate.now();
        int getLocalMonthFromUser = date.get(ChronoField.MONTH_OF_YEAR);
        if (IPrideMoths.isAgenderDayOfVisibility()) {
            this.setMothVariant(MothVariation.AGENDER);
        } else if (IPrideMoths.isBisexualDayOfVisibility()) {
            this.setMothVariant(MothVariation.BISEXUAL);
        } else if (IPrideMoths.isGayDayOfVisibility()) {
            this.setMothVariant(MothVariation.GAY);
        } else if (IPrideMoths.isLesbianDayOfVisibility()) {
            this.setMothVariant(MothVariation.LESBIAN);
        } else if (IPrideMoths.isPansexualDayOfVisibility()) {
            this.setMothVariant(MothVariation.PANSEXUAL);
        } else if (IPrideMoths.isOmnisexualDayOfVisibility()) {
            this.setMothVariant(MothVariation.OMNISEXUAL);
        } else if (IPrideMoths.isPolyamorousDayOfVisibility()) {
            this.setMothVariant(MothVariation.POLYAMOROUS);
        } else if (IPrideMoths.isPolysexualDayOfVisibility()) {
            this.setMothVariant(MothVariation.POLYSEXUAL);
        } else if (IPrideMoths.isIntersexDayOfVisibility()) {
            this.setMothVariant(MothVariation.INTERSEX);
        } else if (IPrideMoths.isXenogenderDayOfVisibility()) {
            this.setMothVariant(MothVariation.XENOGENDER);
        } else if (IPrideMoths.isGenderQueerDayOfVisibility()) {
            this.setMothVariant(MothVariation.GENDER_QUEER);
        } else if (IPrideMoths.isGenderfluidWeekOfVisibility()) {
            this.setMothVariant(MothVariation.GENDERFLUID);
        } else if (IPrideMoths.isTransgenderDayOfVisibility()) {
            this.setMothVariant(MothEntity.getTransgenderVariation(this.field_5974));
        } else if (IPrideMoths.isAsexualDayOfVisibility()) {
            this.setMothVariant(MothEntity.getAceVariation(this.field_5974));
        } else if (IPrideMoths.isAromanticDayOfVisibility()) {
            this.setMothVariant(MothEntity.getAroVariation(this.field_5974));
        } else if (IPrideMoths.isDemigenderDayOfVisibility()) {
            this.setMothVariant(MothEntity.getDemigenderVariation(this.field_5974));
        } else if (getLocalMonthFromUser == 6 || PrideMothsConfigs.GENERATE_PRIDE_VARIANTS_OUTSIDE_OF_PRIDE_MONTH) {
            this.setMothVariant(MothEntity.getPrideVariation(this.field_5974));
        } else {
            this.setMothVariant(MothEntity.getOtherVariation(this.field_5974));
        }
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.setFromInitialize();
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (this.method_6481(itemstack) && this.isFavouredFoodItem(itemstack)) {
            int i = this.method_5618();
            if (!this.method_73183().method_8608() && i == 0 && this.method_6482()) {
                this.method_6475(player, hand, itemstack);
                this.method_6480(player);
                return class_1269.field_52422;
            }
            if (this.method_6109()) {
                this.method_6475(player, hand, itemstack);
                this.method_5620(MothEntity.method_41321((int)(-i)), true);
            }
            if (this.method_73183().method_8608()) {
                return class_1269.field_21466;
            }
        }
        if (player.method_5998(hand).method_7909() == ItemsRegistrar.GLASS_JAR) {
            class_1799 itemStack = this.getMothJarItemFromVariation();
            if (this.method_16914()) {
                itemStack.method_57379(class_9334.field_49631, (Object)this.method_5797());
            }
            if (this.method_6109()) {
                itemStack.method_57379(DataComponentsRegistrar.CONTAINS_BABY, (Object)this.method_6109());
                itemStack.method_57379(DataComponentsRegistrar.SAVED_AGE, (Object)this.field_5950);
            }
            if (!player.method_31549().field_7477) {
                if (player.method_5998(hand).method_7947() > 1) {
                    player.method_5998(hand).method_7934(1);
                    if (!player.method_31548().method_7394(itemStack)) {
                        player.method_7328(itemStack, true);
                    }
                } else {
                    player.method_6122(hand, itemStack);
                }
            } else if (!player.method_31548().method_7394(itemStack)) {
                player.method_7328(itemStack, true);
            }
            this.method_73183().method_8396((class_1297)player, player.method_24515(), class_3417.field_14779, class_3419.field_15254, 1.0f, 1.0f);
            this.method_31472();
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Nullable
    public class_1799 method_31480() {
        return this.getMothJarItemFromVariation();
    }

    @NotNull
    private class_1799 getMothJarItemFromVariation() {
        return new class_1799((class_1935)(switch (this.getMothVariant()) {
            case MothVariation.RARE -> ItemsRegistrar.RARE_MOTH_JAR;
            case MothVariation.AGENDER -> ItemsRegistrar.AGENDER_MOTH_JAR;
            case MothVariation.AROACE -> ItemsRegistrar.AROACE_MOTH_JAR;
            case MothVariation.AROMANTIC -> ItemsRegistrar.AROMANTIC_MOTH_JAR;
            case MothVariation.ASEXUAL -> ItemsRegistrar.ASEXUAL_MOTH_JAR;
            case MothVariation.BISEXUAL -> ItemsRegistrar.BISEXUAL_MOTH_JAR;
            case MothVariation.DEMIBOY -> ItemsRegistrar.DEMIBOY_MOTH_JAR;
            case MothVariation.DEMIGENDER -> ItemsRegistrar.DEMIGENDER_MOTH_JAR;
            case MothVariation.DEMIGIRL -> ItemsRegistrar.DEMIGIRL_MOTH_JAR;
            case MothVariation.DEMIROMANTIC -> ItemsRegistrar.DEMIROMANTIC_MOTH_JAR;
            case MothVariation.DEMISEXUAL -> ItemsRegistrar.DEMISEXUAL_MOTH_JAR;
            case MothVariation.GAY -> ItemsRegistrar.GAY_MOTH_JAR;
            case MothVariation.LESBIAN -> ItemsRegistrar.LESBIAN_MOTH_JAR;
            case MothVariation.LGBT -> ItemsRegistrar.LGBT_MOTH_JAR;
            case MothVariation.NON_BINARY -> ItemsRegistrar.NON_BINARY_MOTH_JAR;
            case MothVariation.OMNISEXUAL -> ItemsRegistrar.OMNISEXUAL_MOTH_JAR;
            case MothVariation.PANSEXUAL -> ItemsRegistrar.PANSEXUAL_MOTH_JAR;
            case MothVariation.POLYAMOROUS -> ItemsRegistrar.POLYAMOROUS_MOTH_JAR;
            case MothVariation.POLYSEXUAL -> ItemsRegistrar.POLYSEXUAL_MOTH_JAR;
            case MothVariation.TRANSGENDER -> ItemsRegistrar.TRANSGENDER_MOTH_JAR;
            case MothVariation.GENDERFLUID -> ItemsRegistrar.GENDERFLUID_MOTH_JAR;
            case MothVariation.INTERSEX -> ItemsRegistrar.INTERSEX_MOTH_JAR;
            case MothVariation.XENOGENDER -> ItemsRegistrar.XENOGENDER_MOTH_JAR;
            case MothVariation.GENDER_QUEER -> ItemsRegistrar.GENDER_QUEER_MOTH_JAR;
            case MothVariation.GENDERFAE -> ItemsRegistrar.GENDERFAE_MOTH_JAR;
            case MothVariation.GENDERFAUN -> ItemsRegistrar.GENDERFAUN_MOTH_JAR;
            case MothVariation.BIGENDER -> ItemsRegistrar.BIGENDER_MOTH_JAR;
            case MothVariation.PANGENDER -> ItemsRegistrar.PANGENDER_MOTH_JAR;
            default -> ItemsRegistrar.MOTH_JAR;
        }));
    }

    public void setMothVariant(MothVariation type) {
        this.field_6011.method_12778(VARIANT, (Object)type.getIndex());
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)MothVariation.DEFAULT.getIndex());
        builder.method_56912(FROM_JAR, (Object)false);
    }

    public boolean isFromGlassJar() {
        return (Boolean)this.field_6011.method_12789(FROM_JAR);
    }

    public void setFromGlassJar(boolean b) {
        this.field_6011.method_12778(FROM_JAR, (Object)b);
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.setFromGlassJar(view.method_71433("FromGlassJar", false));
        this.setMothVariant(view.method_71426("MothVariant", MothVariation.INDEX_CODEC).orElse(MothVariation.DEFAULT));
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71472("FromGlassJar", this.isFromGlassJar());
        view.method_71468("MothVariant", MothVariation.INDEX_CODEC, (Object)this.getMothVariant());
    }

    public MothVariation getMothVariant() {
        return MothVariation.byIndex((Integer)this.field_6011.method_12789(VARIANT));
    }

    public boolean method_5747(double fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    private boolean queerNames() {
        String name = this.method_5477().getString();
        return name.equalsIgnoreCase("lgbt") || name.equalsIgnoreCase("lgbtq") || name.equalsIgnoreCase("lgbtqia") || name.equalsIgnoreCase("lgbtqia+");
    }

    private boolean nonBinaryNames() {
        String name = this.method_5477().getString();
        return name.equalsIgnoreCase("non-binary") || name.equalsIgnoreCase("non_binary") || name.equalsIgnoreCase("nonbinary") || name.equalsIgnoreCase("nyan-binary");
    }

    private boolean twoNames(String i0, String i1) {
        String name = this.method_5477().getString();
        return name.equalsIgnoreCase(i0) || name.equalsIgnoreCase(i1);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 60;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_73183().method_8608()) {
            this.setupAnimationStates();
        }
        if (this.method_16914()) {
            class_1937 class_19372;
            if (this.getMothVariant() != MothVariation.NON_BINARY && this.nonBinaryNames()) {
                this.setMothVariant(MothVariation.NON_BINARY);
            } else if (this.getMothVariant() != MothVariation.TRANSGENDER && this.twoNames("trans", "transgender")) {
                this.setMothVariant(MothVariation.TRANSGENDER);
            } else if (this.getMothVariant() != MothVariation.LGBT && this.queerNames()) {
                this.setMothVariant(MothVariation.LGBT);
            } else if (this.getMothVariant() != MothVariation.GAY && this.twoNames("gay", "mlm")) {
                this.setMothVariant(MothVariation.GAY);
            } else if (this.getMothVariant() != MothVariation.LESBIAN && this.twoNames("lesbian", "wlw")) {
                this.setMothVariant(MothVariation.LESBIAN);
            } else if (this.getMothVariant() != MothVariation.AGENDER && this.method_5477().getString().equalsIgnoreCase("agender")) {
                this.setMothVariant(MothVariation.AGENDER);
            } else if (this.getMothVariant() != MothVariation.ASEXUAL && this.twoNames("asexual", "ace")) {
                this.setMothVariant(MothVariation.ASEXUAL);
            } else if (this.getMothVariant() != MothVariation.BISEXUAL && this.twoNames("bisexual", "bi")) {
                this.setMothVariant(MothVariation.BISEXUAL);
            } else if (this.getMothVariant() != MothVariation.PANSEXUAL && this.twoNames("pansexual", "pan")) {
                this.setMothVariant(MothVariation.PANSEXUAL);
            } else if (this.getMothVariant() != MothVariation.POLYAMOROUS && this.twoNames("polyamorous", "polygamous")) {
                this.setMothVariant(MothVariation.POLYAMOROUS);
            } else if (this.getMothVariant() != MothVariation.POLYSEXUAL && this.twoNames("polysexual", "poly")) {
                this.setMothVariant(MothVariation.POLYSEXUAL);
            } else if (this.getMothVariant() != MothVariation.OMNISEXUAL && this.twoNames("omnisexual", "omni")) {
                this.setMothVariant(MothVariation.OMNISEXUAL);
            } else if (this.getMothVariant() != MothVariation.AROMANTIC && this.twoNames("aromantic", "aro")) {
                this.setMothVariant(MothVariation.AROMANTIC);
            } else if (this.getMothVariant() != MothVariation.DEMISEXUAL && this.twoNames("demisexual", "demi")) {
                this.setMothVariant(MothVariation.DEMISEXUAL);
            } else if (this.getMothVariant() != MothVariation.DEMIROMANTIC && this.twoNames("demiromantic", "demiro")) {
                this.setMothVariant(MothVariation.DEMIROMANTIC);
            } else if (this.getMothVariant() != MothVariation.DEMIBOY && this.method_5477().getString().equalsIgnoreCase("demiboy")) {
                this.setMothVariant(MothVariation.DEMIBOY);
            } else if (this.getMothVariant() != MothVariation.DEMIGIRL && this.method_5477().getString().equalsIgnoreCase("demigirl")) {
                this.setMothVariant(MothVariation.DEMIGIRL);
            } else if (this.getMothVariant() != MothVariation.DEMIGENDER && this.method_5477().getString().equalsIgnoreCase("demigender")) {
                this.setMothVariant(MothVariation.DEMIGENDER);
            } else if (this.getMothVariant() != MothVariation.AROACE && this.method_5477().getString().equalsIgnoreCase("aroace")) {
                this.setMothVariant(MothVariation.AROACE);
            } else if (this.getMothVariant() != MothVariation.GENDERFLUID && this.twoNames("gender_fluid", "genderfluid")) {
                this.setMothVariant(MothVariation.GENDERFLUID);
            } else if (this.getMothVariant() != MothVariation.INTERSEX && this.method_5477().getString().equalsIgnoreCase("intersex")) {
                this.setMothVariant(MothVariation.INTERSEX);
            } else if (this.getMothVariant() != MothVariation.XENOGENDER && this.method_5477().getString().equalsIgnoreCase("xenogender")) {
                this.setMothVariant(MothVariation.XENOGENDER);
            } else if (this.getMothVariant() != MothVariation.GENDER_QUEER && this.twoNames("gender_queer", "genderqueer")) {
                this.setMothVariant(MothVariation.GENDER_QUEER);
            } else if (this.getMothVariant() != MothVariation.GENDERFAE && this.method_5477().getString().equalsIgnoreCase("genderfae")) {
                this.setMothVariant(MothVariation.GENDERFAE);
            } else if (this.getMothVariant() != MothVariation.GENDERFAUN && this.method_5477().getString().equalsIgnoreCase("genderfaun")) {
                this.setMothVariant(MothVariation.GENDERFAUN);
            } else if (this.getMothVariant() != MothVariation.BIGENDER && this.method_5477().getString().equalsIgnoreCase("bigender")) {
                this.setMothVariant(MothVariation.BIGENDER);
            } else if (this.getMothVariant() != MothVariation.PANGENDER && this.method_5477().getString().equalsIgnoreCase("pangender")) {
                this.setMothVariant(MothVariation.PANGENDER);
            }
            if (this.getMothVariant() != MothVariation.ALLY && this.twoNames("ally", "straight")) {
                this.setMothVariant(MothVariation.ALLY);
            }
            if ((class_19372 = this.method_73183()) instanceof class_3218) {
                class_3218 world = (class_3218)class_19372;
                if (this.method_5797().getString().equalsIgnoreCase("super straight")) {
                    this.method_5768(world);
                } else if (this.method_5797().getString().equalsIgnoreCase("super_straight")) {
                    this.method_5768(world);
                } else if (this.method_5797().getString().equalsIgnoreCase("superstraight")) {
                    this.method_5768(world);
                } else if (this.method_5797().getString().equalsIgnoreCase("super-straight")) {
                    this.method_5768(world);
                }
            }
        }
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407((class_1308)this, world);
        birdNavigation.method_70687(false);
        birdNavigation.method_6354(false);
        return birdNavigation;
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_28289;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_28288;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    public boolean method_5973(class_1299<?> type) {
        return type == class_1299.field_6097;
    }

    class MothWanderAroundGoal
    extends class_1352 {
        MothWanderAroundGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return MothEntity.this.field_6189.method_6357() && MothEntity.this.field_5974.method_43048(10) == 0;
        }

        public boolean method_6266() {
            return MothEntity.this.field_6189.method_23966();
        }

        public void method_6269() {
            class_243 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                MothEntity.this.field_6189.method_6334(MothEntity.this.field_6189.method_6348(class_2338.method_49638((class_2374)vec3d), 1), 1.0);
            }
        }

        @Nullable
        private class_243 getRandomLocation() {
            class_243 vec3d2 = MothEntity.this.method_5828(0.35f);
            class_243 vec3d3 = class_5533.method_31524((class_1314)MothEntity.this, (int)8, (int)7, (double)vec3d2.field_1352, (double)vec3d2.field_1350, (float)1.5707964f, (int)3, (int)1);
            return vec3d3 != null ? vec3d3 : class_5530.method_31504((class_1314)MothEntity.this, (int)8, (int)4, (int)-2, (double)vec3d2.field_1352, (double)vec3d2.field_1350, (double)1.5707963705062866);
        }
    }
}

