/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.adapter;

import com.fastasyncworldedit.bukkit.FaweBukkitWorld;
import com.fastasyncworldedit.bukkit.adapter.AbstractBukkitGetBlocks;
import com.fastasyncworldedit.bukkit.adapter.CachedBukkitAdapter;
import com.fastasyncworldedit.core.FAWEPlatformAdapterImpl;
import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.math.IntPair;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.util.MathMan;
import com.fastasyncworldedit.core.util.ReflectionUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.StampedLock;
import java.util.function.IntFunction;

public class NMSAdapter
implements FAWEPlatformAdapterImpl {
    public static int createPalette(int[] blockToPalette, int[] paletteToBlock, int[] blocksCopy, char[] set, CachedBukkitAdapter adapter) {
        int numPaletteEntries = 0;
        for (int i = 0; i < 4096; ++i) {
            int ordinal = set[i];
            int palette = blockToPalette[ordinal = Math.max(ordinal, 1)];
            if (palette != Integer.MAX_VALUE) continue;
            blockToPalette[ordinal] = numPaletteEntries;
            paletteToBlock[numPaletteEntries] = ordinal;
            ++numPaletteEntries;
        }
        NMSAdapter.mapPalette(blockToPalette, paletteToBlock, blocksCopy, set, adapter, numPaletteEntries);
        return numPaletteEntries;
    }

    public static int createPalette(int layer, int[] blockToPalette, int[] paletteToBlock, int[] blocksCopy, IntFunction<char[]> get, char[] set, CachedBukkitAdapter adapter) {
        int numPaletteEntries = 0;
        char[] getArr = null;
        for (int i = 0; i < 4096; ++i) {
            int palette;
            int ordinal = set[i];
            if (ordinal == 0) {
                if (getArr == null) {
                    getArr = get.apply(layer);
                }
                ordinal = getArr[i];
                set[i] = (char)Math.max(ordinal, 1);
            }
            if ((palette = blockToPalette[ordinal]) != Integer.MAX_VALUE) continue;
            blockToPalette[ordinal] = numPaletteEntries;
            paletteToBlock[numPaletteEntries] = ordinal;
            ++numPaletteEntries;
        }
        NMSAdapter.mapPalette(blockToPalette, paletteToBlock, blocksCopy, set, adapter, numPaletteEntries);
        return numPaletteEntries;
    }

    private static void mapPalette(int[] blockToPalette, int[] paletteToBlock, int[] blocksCopy, char[] set, CachedBukkitAdapter adapter, int numPaletteEntries) {
        int bitsPerEntry = MathMan.log2nlz(numPaletteEntries - 1);
        if (bitsPerEntry > 8 && adapter != null) {
            System.arraycopy(adapter.getIbdToOrdinal(), 0, paletteToBlock, 0, adapter.getIbdToOrdinal().length);
            System.arraycopy(adapter.getOrdinalToIbdID(), 0, blockToPalette, 0, adapter.getOrdinalToIbdID().length);
        }
        for (int i = 0; i < 4096; ++i) {
            int palette;
            int ordinal = set[i];
            ordinal = Math.max(ordinal, 1);
            blocksCopy[i] = palette = blockToPalette[ordinal];
        }
    }

    @Override
    public void sendChunk(IChunkGet chunk, int mask, boolean lighting) {
        if (!(chunk instanceof AbstractBukkitGetBlocks)) {
            throw new IllegalArgumentException("(IChunkGet) chunk not of type BukkitGetBlocks");
        }
        ((AbstractBukkitGetBlocks)chunk).send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <LevelChunkSection> boolean setSectionAtomic(String worldName, IntPair pair, LevelChunkSection[] sections, LevelChunkSection expected, LevelChunkSection value, int layer) {
        if (layer < 0 || layer >= sections.length) {
            return false;
        }
        if (Fawe.isMainThread()) {
            return ReflectionUtils.compareAndSet(sections, expected, value, layer);
        }
        StampLockHolder holder = new StampLockHolder();
        ConcurrentHashMap<IntPair, ChunkSendLock> chunks = FaweBukkitWorld.getWorldSendingChunksMap(worldName);
        chunks.compute(pair, (k, lock) -> {
            if (lock == null) {
                lock = new ChunkSendLock();
            } else if (lock.writeWaiting) {
                throw new IllegalStateException("Attempting to write chunk section when write is already ongoing?!");
            }
            holder.stamp = lock.lock.tryWriteLock();
            holder.chunkLock = lock;
            lock.writeWaiting = true;
            return lock;
        });
        try {
            if (holder.stamp == 0L) {
                holder.stamp = holder.chunkLock.lock.writeLock();
            }
            boolean bl = ReflectionUtils.compareAndSet(sections, expected, value, layer);
            return bl;
        }
        finally {
            chunks = FaweBukkitWorld.getWorldSendingChunksMap(worldName);
            chunks.computeIfPresent(pair, (k, lock) -> {
                if (lock != holder.chunkLock) {
                    throw new IllegalStateException("SENDING_CHUNKS stored lock does not equal lock attempted to be unlocked?!");
                }
                lock.lock.unlockWrite(holder.stamp);
                lock.writeWaiting = false;
                return lock;
            });
        }
    }

    protected static void beginChunkPacketSend(String worldName, IntPair pair, StampLockHolder stampedLock) {
        ConcurrentHashMap<IntPair, ChunkSendLock> chunks = FaweBukkitWorld.getWorldSendingChunksMap(worldName);
        chunks.compute(pair, (k, lock) -> {
            if (lock == null) {
                lock = new ChunkSendLock();
            }
            if (lock.writeWaiting || lock.lock.getReadLockCount() >= 1 || lock.lock.isWriteLocked()) {
                return lock;
            }
            stampedLock.stamp = lock.lock.readLock();
            stampedLock.chunkLock = lock;
            return lock;
        });
    }

    protected static void endChunkPacketSend(String worldName, IntPair pair, StampLockHolder lockHolder) {
        ConcurrentHashMap<IntPair, ChunkSendLock> chunks = FaweBukkitWorld.getWorldSendingChunksMap(worldName);
        chunks.computeIfPresent(pair, (k, lock) -> {
            if (lock.lock != lockHolder.chunkLock.lock) {
                throw new IllegalStateException("SENDING_CHUNKS stored lock does not equal lock attempted to be unlocked?!");
            }
            lock.lock.unlockRead(lockHolder.stamp);
            return null;
        });
    }

    public static final class StampLockHolder {
        public long stamp;
        public ChunkSendLock chunkLock = null;
    }

    public static final class ChunkSendLock {
        public final StampedLock lock = new StampedLock();
        public boolean writeWaiting = false;
    }
}

