/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.regions.plotsquared;

import com.fastasyncworldedit.core.FaweAPI;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.processor.lighting.RelightMode;
import com.fastasyncworldedit.core.util.TaskManager;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.generator.HybridPlotManager;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.function.biome.BiomeReplace;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.FlatRegionVisitor;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FaweDelegateRegionManager {
    public boolean setCuboids(@NonNull PlotArea area, @NonNull Set<CuboidRegion> regions, @NonNull Pattern blocks, int minY, int maxY, Runnable whenDone) {
        TaskManager.taskManager().async(() -> {
            Class<FaweDelegateRegionManager> clazz = FaweDelegateRegionManager.class;
            synchronized (FaweDelegateRegionManager.class) {
                World world = BukkitAdapter.adapt(Bukkit.getWorld((String)area.getWorldName()));
                EditSession session = WorldEdit.getInstance().newEditSessionBuilder().world(world).checkMemory(false).fastMode(true).limitUnlimited().changeSetNull().build();
                for (CuboidRegion region : regions) {
                    region.setPos1(region.getPos1().withY(minY));
                    region.setPos2(region.getPos2().withY(maxY));
                    session.setBlocks((Region)region, blocks);
                }
                try {
                    session.flushQueue();
                    for (CuboidRegion region : regions) {
                        FaweAPI.fixLighting(world, region, null, RelightMode.valueOf(Settings.settings().LIGHTING.MODE));
                    }
                }
                catch (MaxChangedBlocksException e) {
                    e.printStackTrace();
                }
                finally {
                    if (whenDone != null) {
                        TaskManager.taskManager().task(whenDone);
                    }
                }
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
        });
        return true;
    }

    public boolean notifyClear(PlotManager manager) {
        HybridPlotWorld hpw = ((HybridPlotManager)manager).getHybridPlotWorld();
        return hpw.getType() != PlotAreaType.AUGMENTED || hpw.getTerrain() == PlotAreaTerrainType.NONE;
    }

    public boolean handleClear(@Nonnull Plot plot, @Nullable Runnable whenDone, @Nonnull PlotManager manager) {
        TaskManager.taskManager().async(() -> {
            Class<FaweDelegateRegionManager> clazz = FaweDelegateRegionManager.class;
            synchronized (FaweDelegateRegionManager.class) {
                HybridPlotWorld hybridPlotWorld = ((HybridPlotManager)manager).getHybridPlotWorld();
                World world = BukkitAdapter.adapt(Bukkit.getWorld((String)hybridPlotWorld.getWorldName()));
                EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world(world).checkMemory(false).fastMode(true).limitUnlimited().changeSetNull().build();
                if (!hybridPlotWorld.PLOT_SCHEMATIC || !Settings.Schematics.PASTE_ON_TOP) {
                    BlockType air = BlockTypes.AIR;
                    BlockType bedrock = hybridPlotWorld.PLOT_BEDROCK ? BlockTypes.BEDROCK : air;
                    Pattern filling = hybridPlotWorld.MAIN_BLOCK.toPattern();
                    Pattern plotfloor = hybridPlotWorld.TOP_BLOCK.toPattern();
                    BiomeType biome = hybridPlotWorld.getPlotBiome();
                    BlockVector3 pos1 = plot.getBottomAbs().getBlockVector3();
                    BlockVector3 pos2 = pos1.add(BlockVector3.at(hybridPlotWorld.PLOT_WIDTH - 1, hybridPlotWorld.getMaxGenHeight(), hybridPlotWorld.PLOT_WIDTH - 1));
                    if (hybridPlotWorld.PLOT_BEDROCK) {
                        CuboidRegion bedrockRegion = new CuboidRegion(pos1, pos2.withY(hybridPlotWorld.getMinGenHeight()));
                        editSession.setBlocks((Region)bedrockRegion, (Pattern)bedrock);
                    }
                    CuboidRegion fillingRegion = new CuboidRegion(pos1.withY(hybridPlotWorld.getMinGenHeight() + 1), pos2.withY(hybridPlotWorld.PLOT_HEIGHT - 1));
                    CuboidRegion floorRegion = new CuboidRegion(pos1.withY(hybridPlotWorld.PLOT_HEIGHT), pos2.withY(hybridPlotWorld.PLOT_HEIGHT));
                    CuboidRegion airRegion = new CuboidRegion(pos1.withY(hybridPlotWorld.PLOT_HEIGHT + 1), pos2.withY(hybridPlotWorld.getMaxGenHeight()));
                    editSession.setBlocks((Region)fillingRegion, filling);
                    editSession.setBlocks((Region)floorRegion, plotfloor);
                    editSession.setBlocks((Region)airRegion, (Pattern)air);
                    if (hybridPlotWorld.getMinBuildHeight() < hybridPlotWorld.getMinGenHeight()) {
                        CuboidRegion underneath = new CuboidRegion(pos1.withY(hybridPlotWorld.getMinBuildHeight()), pos2.withY(hybridPlotWorld.getMinGenHeight()));
                        editSession.setBlocks((Region)underneath, (Pattern)air);
                    }
                    if (hybridPlotWorld.getMaxGenHeight() < hybridPlotWorld.getMaxBuildHeight() - 1) {
                        CuboidRegion onTop = new CuboidRegion(pos1.withY(hybridPlotWorld.getMaxGenHeight()), pos2.withY(hybridPlotWorld.getMaxBuildHeight() - 1));
                        editSession.setBlocks((Region)onTop, (Pattern)air);
                    }
                    BiomeReplace replace = new BiomeReplace((Extent)editSession, biome);
                    FlatRegionVisitor visitor = new FlatRegionVisitor(floorRegion, replace, editSession);
                    Operations.completeLegacy(visitor);
                }
                if (hybridPlotWorld.PLOT_SCHEMATIC) {
                    EditSession scheditsession = !Settings.Schematics.PASTE_ON_TOP ? editSession : WorldEdit.getInstance().newEditSessionBuilder().world(world).checkMemory(false).fastMode(true).limitUnlimited().changeSetNull().build();
                    File schematicFile = new File(hybridPlotWorld.getSchematicRoot(), "plot.schem");
                    if (!schematicFile.exists()) {
                        schematicFile = new File(hybridPlotWorld.getSchematicRoot(), "plot.schematic");
                    }
                    BlockVector3 to = plot.getBottomAbs().getBlockVector3().withY(hybridPlotWorld.getPlotYStart());
                    try {
                        Clipboard clip = ClipboardFormats.findByFile(schematicFile).getReader(new FileInputStream(schematicFile)).read();
                        clip.setOrigin(clip.getRegion().getMinimumPoint());
                        clip.paste(scheditsession, to, true, true, true);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    scheditsession.flushQueue();
                }
                editSession.flushQueue();
                FaweAPI.fixLighting(world, new CuboidRegion(plot.getBottomAbs().getBlockVector3(), plot.getTopAbs().getBlockVector3()), null, RelightMode.valueOf(Settings.settings().LIGHTING.MODE));
                if (whenDone != null) {
                    TaskManager.taskManager().task(whenDone);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        });
        return true;
    }

    public void swap(Location pos1, Location pos2, Location swapPos, Runnable whenDone) {
        TaskManager.taskManager().async(() -> {
            Class<FaweDelegateRegionManager> clazz = FaweDelegateRegionManager.class;
            synchronized (FaweDelegateRegionManager.class) {
                World pos1World = BukkitAdapter.adapt(Bukkit.getWorld((String)pos1.getWorldName()));
                World pos3World = BukkitAdapter.adapt(Bukkit.getWorld((String)swapPos.getWorldName()));
                EditSession sessionA = WorldEdit.getInstance().newEditSessionBuilder().world(pos1World).checkMemory(false).fastMode(true).limitUnlimited().changeSetNull().build();
                EditSession sessionB = WorldEdit.getInstance().newEditSessionBuilder().world(pos3World).checkMemory(false).fastMode(true).limitUnlimited().changeSetNull().build();
                CuboidRegion regionA = new CuboidRegion(pos1World, pos1.getBlockVector3(), pos2.getBlockVector3());
                CuboidRegion regionB = new CuboidRegion(pos3World, swapPos.getBlockVector3(), swapPos.getBlockVector3().add(pos2.getBlockVector3().subtract(pos1.getBlockVector3())).withY(pos2.getY()));
                BlockArrayClipboard clipA = new BlockArrayClipboard((Region)regionA, UUID.randomUUID());
                BlockArrayClipboard clipB = new BlockArrayClipboard((Region)regionB, UUID.randomUUID());
                ForwardExtentCopy copyA = new ForwardExtentCopy(sessionA, regionA, clipA, clipA.getMinimumPoint());
                ForwardExtentCopy copyB = new ForwardExtentCopy(sessionB, regionB, clipB, clipB.getMinimumPoint());
                copyA.setCopyingBiomes(true);
                copyB.setCopyingBiomes(true);
                copyA.setCopyingEntities(true);
                copyB.setCopyingEntities(true);
                try {
                    Operations.completeLegacy(copyA);
                    Operations.completeLegacy(copyB);
                    clipA.flush();
                    clipB.flush();
                    clipA.paste(sessionB, swapPos.getBlockVector3(), true, true, true);
                    clipB.paste(sessionA, pos1.getBlockVector3(), true, true, true);
                }
                catch (MaxChangedBlocksException e) {
                    e.printStackTrace();
                }
                finally {
                    sessionA.close();
                    sessionB.close();
                }
                FaweAPI.fixLighting(pos1World, regionA, null, RelightMode.valueOf(Settings.settings().LIGHTING.MODE));
                FaweAPI.fixLighting(pos1World, regionB, null, RelightMode.valueOf(Settings.settings().LIGHTING.MODE));
                if (whenDone != null) {
                    TaskManager.taskManager().task(whenDone);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        });
    }

    public void setBiome(CuboidRegion region, int extendBiome, BiomeType biome, String world, Runnable whenDone) {
        region.expand(BlockVector3.at(extendBiome, 0, extendBiome));
        region.expand(BlockVector3.at(-extendBiome, 0, -extendBiome));
        TaskManager.taskManager().async(() -> {
            Class<FaweDelegateRegionManager> clazz = FaweDelegateRegionManager.class;
            synchronized (FaweDelegateRegionManager.class) {
                EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world(BukkitAdapter.adapt(Bukkit.getWorld((String)world))).checkMemory(false).fastMode(true).limitUnlimited().changeSetNull().build();
                BiomeReplace replace = new BiomeReplace((Extent)editSession, biome);
                FlatRegionVisitor visitor = new FlatRegionVisitor(region, replace, editSession);
                try {
                    Operations.completeLegacy(visitor);
                    editSession.flushQueue();
                }
                catch (MaxChangedBlocksException e) {
                    e.printStackTrace();
                }
                if (whenDone != null) {
                    TaskManager.taskManager().task(whenDone);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        });
    }

    public boolean copyRegion(@NonNull Location pos1, @NonNull Location pos2, @NonNull Location pos3, @NonNull Runnable whenDone) {
        TaskManager.taskManager().async(() -> {
            Class<FaweDelegateRegionManager> clazz = FaweDelegateRegionManager.class;
            synchronized (FaweDelegateRegionManager.class) {
                World pos1World = BukkitAdapter.adapt(Bukkit.getWorld((String)pos1.getWorldName()));
                World pos3World = BukkitAdapter.adapt(Bukkit.getWorld((String)pos3.getWorldName()));
                EditSession from = WorldEdit.getInstance().newEditSessionBuilder().world(pos1World).checkMemory(false).fastMode(true).limitUnlimited().changeSetNull().build();
                EditSession to = WorldEdit.getInstance().newEditSessionBuilder().world(pos3World).checkMemory(false).fastMode(true).limitUnlimited().changeSetNull().build();
                CuboidRegion region = new CuboidRegion(BlockVector3.at(pos1.getX(), pos1.getY(), pos1.getZ()), BlockVector3.at(pos2.getX(), pos2.getY(), pos2.getZ()));
                ForwardExtentCopy copy = new ForwardExtentCopy(from, region, to, BlockVector3.at(pos3.getX(), pos3.getY(), pos3.getZ()));
                try {
                    Operations.completeLegacy(copy);
                    to.flushQueue();
                    FaweAPI.fixLighting(pos1World, new CuboidRegion(pos3.getBlockVector3(), pos3.getBlockVector3().add(pos2.getBlockVector3().subtract(pos1.getBlockVector3()))), null, RelightMode.valueOf(Settings.settings().LIGHTING.MODE));
                }
                catch (MaxChangedBlocksException e) {
                    e.printStackTrace();
                }
                if (whenDone != null) {
                    TaskManager.taskManager().task(whenDone);
                }
                return;
            }
        });
        return true;
    }

    public boolean regenerateRegion(Location pos1, Location pos2, boolean ignore, Runnable whenDone) {
        TaskManager.taskManager().async(() -> {
            Class<FaweDelegateRegionManager> clazz = FaweDelegateRegionManager.class;
            synchronized (FaweDelegateRegionManager.class) {
                World pos1World = BukkitAdapter.adapt(Bukkit.getWorld((String)pos1.getWorldName()));
                try (EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world(pos1World).checkMemory(false).fastMode(true).limitUnlimited().changeSetNull().build();){
                    CuboidRegion region = new CuboidRegion(BlockVector3.at(pos1.getX(), pos1.getY(), pos1.getZ()), BlockVector3.at(pos2.getX(), pos2.getY(), pos2.getZ()));
                    editSession.regenerate(region);
                    editSession.flushQueue();
                }
                if (whenDone != null) {
                    TaskManager.taskManager().task(whenDone);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        });
        return true;
    }
}

