/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.command.tool;

import com.fastasyncworldedit.core.configuration.Caption;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.command.tool.BlockTool;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.world.generation.ConfiguredFeatureType;
import javax.annotation.Nullable;

public class FeaturePlacer
implements BlockTool {
    private final ConfiguredFeatureType feature;

    public FeaturePlacer(ConfiguredFeatureType feature) {
        this.feature = feature;
    }

    @Override
    public boolean canUse(Actor player) {
        return player.hasPermission("worldedit.tool.feature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean actPrimary(Platform server, LocalConfiguration config, Player player, LocalSession session, Location clicked, @Nullable Direction face) {
        try (EditSession editSession = session.createEditSession(player);){
            try {
                int affected = 0;
                BlockVector3 pos = clicked.toBlockPoint();
                for (int i = 0; i < 10 && (affected = editSession.generateFeature(this.feature, this.feature.place_on_face() && face != null ? pos.add(face.toBlockVector()) : pos)) <= 0; ++i) {
                }
                if (affected == 0) {
                    player.print(Caption.of("worldedit.generate.feature.failed", new Object[0]));
                } else {
                    player.print(Caption.of("worldedit.feature.created", TextComponent.of(affected)));
                }
            }
            catch (MaxChangedBlocksException e) {
                player.print(Caption.of("worldedit.tool.max-block-changes", new Object[0]));
            }
            finally {
                session.remember(editSession);
            }
        }
        return true;
    }
}

