/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent.clipboard.io;

import com.fastasyncworldedit.core.extent.clipboard.LinearClipboard;
import com.fastasyncworldedit.core.extent.clipboard.SimpleClipboard;
import com.fastasyncworldedit.core.internal.io.ResettableFileInputStream;
import com.fastasyncworldedit.core.internal.io.VarIntStreamIterator;
import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.fastasyncworldedit.core.nbt.FaweCompoundTag;
import com.fastasyncworldedit.core.util.IOUtil;
import com.fastasyncworldedit.core.util.MathMan;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.sponge.ReaderUtil;
import com.sk89q.worldedit.extent.clipboard.io.sponge.VersionedDataFixer;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import com.sk89q.worldedit.world.entity.EntityType;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinIntArrayTag;
import org.enginehub.linbus.tree.LinTagType;
import org.jetbrains.annotations.ApiStatus;

public class FastSchematicReaderV3
implements ClipboardReader {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private static final byte CACHE_IDENTIFIER_END = 0;
    private static final byte CACHE_IDENTIFIER_BLOCK = 1;
    private static final byte CACHE_IDENTIFIER_BIOMES = 2;
    private static final byte CACHE_IDENTIFIER_ENTITIES = 3;
    private static final byte CACHE_IDENTIFIER_BLOCK_TILE_ENTITIES = 4;
    private final InputStream parentStream;
    private final MutableBlockVector3 dimensions = MutableBlockVector3.at(0, 0, 0);
    private final Set<Byte> remainingTags;
    private DataInputStream dataInputStream;
    private NBTInputStream nbtInputStream;
    private VersionedDataFixer dataFixer;
    private BlockVector3 offset;
    private BlockVector3 origin = BlockVector3.ZERO;
    private BlockState[] blockPalette;
    private BiomeType[] biomePalette;
    private int dataVersion = -1;
    private byte[] dataCache;
    private byte[] paletteCache;
    private OutputStream dataCacheWriter;
    private OutputStream paletteCacheWriter;

    public FastSchematicReaderV3(@NonNull InputStream stream) {
        Objects.requireNonNull(stream, "stream");
        if (stream instanceof ResettableFileInputStream) {
            stream.mark(Integer.MAX_VALUE);
            this.remainingTags = new HashSet<Byte>();
        } else if (stream instanceof FileInputStream) {
            FileInputStream fileInputStream = (FileInputStream)stream;
            stream = new ResettableFileInputStream(fileInputStream);
            stream.mark(Integer.MAX_VALUE);
            this.remainingTags = new HashSet<Byte>();
        } else if (stream instanceof FastBufferedInputStream || stream instanceof BufferedInputStream) {
            this.remainingTags = null;
        } else {
            stream = new FastBufferedInputStream(stream);
            this.remainingTags = null;
        }
        this.parentStream = stream;
    }

    @Override
    public Clipboard read(UUID uuid, Function<BlockVector3, Clipboard> createOutput) throws IOException {
        byte type;
        Clipboard clipboard = null;
        this.setSubStreams();
        FastSchematicReaderV3.skipHeader(this.dataInputStream);
        while ((type = this.dataInputStream.readByte()) != 0) {
            String tag;
            switch (tag = this.dataInputStream.readUTF()) {
                case "DataVersion": {
                    Platform platform = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING);
                    this.dataVersion = this.dataInputStream.readInt();
                    this.dataFixer = ReaderUtil.getVersionedDataFixer(this.dataVersion, platform, platform.getDataVersion());
                    break;
                }
                case "Metadata": {
                    LinIntArrayTag originTag;
                    LinCompoundTag metadataCompoundTag = (LinCompoundTag)this.nbtInputStream.readTagPayload(10, 0).toLinTag();
                    LinCompoundTag worldEditTag = metadataCompoundTag.findTag("WorldEdit", LinTagType.compoundTag());
                    if (worldEditTag == null || (originTag = worldEditTag.findTag("Origin", LinTagType.intArrayTag())) == null) break;
                    int[] parts = originTag.value();
                    if (parts.length != 3) {
                        throw new IOException("`Metadata > WorldEdit > Origin` int array length is invalid.");
                    }
                    this.origin = BlockVector3.at(parts[0], parts[1], parts[2]);
                    break;
                }
                case "Offset": {
                    this.dataInputStream.skipNBytes(4L);
                    this.offset = BlockVector3.at(this.dataInputStream.readInt(), this.dataInputStream.readInt(), this.dataInputStream.readInt());
                    break;
                }
                case "Width": {
                    this.dimensions.mutX(this.dataInputStream.readShort() & 0xFFFF);
                    break;
                }
                case "Height": {
                    this.dimensions.mutY(this.dataInputStream.readShort() & 0xFFFF);
                    break;
                }
                case "Length": {
                    this.dimensions.mutZ(this.dataInputStream.readShort() & 0xFFFF);
                    break;
                }
                case "Blocks": {
                    this.readBlocks(clipboard);
                    break;
                }
                case "Biomes": {
                    this.readBiomes(clipboard);
                    break;
                }
                case "Entities": {
                    this.readEntities(clipboard);
                    break;
                }
                default: {
                    this.nbtInputStream.readTagPayloadLazy(type, 0);
                }
            }
            if (clipboard != null || !this.areDimensionsAvailable()) continue;
            clipboard = createOutput.apply(this.dimensions.toImmutable());
        }
        if (clipboard == null) {
            throw new IOException("Invalid schematic - missing dimensions");
        }
        if (this.dataFixer == null) {
            throw new IOException("Invalid schematic - missing DataVersion");
        }
        if (this.supportsReset() && !this.remainingTags.isEmpty()) {
            this.readRemainingDataReset(clipboard);
        } else if (this.dataCacheWriter != null || this.paletteCacheWriter != null) {
            this.readRemainingDataCache(clipboard);
        }
        clipboard.setOrigin(this.offset.multiply(-1));
        if (clipboard instanceof SimpleClipboard) {
            SimpleClipboard simpleClipboard = (SimpleClipboard)clipboard;
            if (!this.offset.equals(BlockVector3.ZERO)) {
                clipboard = new BlockArrayClipboard(simpleClipboard, this.offset.add(this.origin));
            }
        }
        return clipboard;
    }

    private void readRemainingDataCache(Clipboard clipboard) throws IOException {
        byte identifier;
        DataInputStream cacheStream;
        if (this.paletteCacheWriter != null) {
            this.paletteCacheWriter.close();
        }
        if (this.dataCacheWriter != null) {
            this.dataCacheWriter.close();
        }
        if (this.paletteCache != null) {
            cacheStream = new DataInputStream((InputStream)new FastBufferedInputStream((InputStream)new LZ4BlockInputStream((InputStream)new FastBufferedInputStream((InputStream)new ByteArrayInputStream(this.paletteCache)))));
            try {
                while ((identifier = cacheStream.readByte()) != 0) {
                    if (identifier == 1) {
                        this.readPaletteMap(cacheStream, this.provideBlockPaletteInitializer());
                        continue;
                    }
                    if (identifier == 2) {
                        this.readPaletteMap(cacheStream, this.provideBiomePaletteInitializer());
                        continue;
                    }
                    throw new IOException("invalid cache state - got identifier: 0x" + identifier);
                }
            }
            finally {
                cacheStream.close();
            }
        }
        cacheStream = new DataInputStream((InputStream)new FastBufferedInputStream((InputStream)new LZ4BlockInputStream((InputStream)new FastBufferedInputStream((InputStream)new ByteArrayInputStream(this.dataCache)))));
        try (NBTInputStream cacheNbtIn = new NBTInputStream(cacheStream);){
            block22: while ((identifier = cacheStream.readByte()) != 0) {
                switch (identifier) {
                    case 1: {
                        this.readPaletteData(cacheStream, this.getBlockWriter(clipboard));
                        continue block22;
                    }
                    case 2: {
                        this.readPaletteData(cacheStream, this.getBiomeWriter(clipboard));
                        continue block22;
                    }
                    case 3: {
                        cacheStream.skipNBytes(1L);
                        this.readEntityContainers(cacheStream, cacheNbtIn, DataFixer.FixTypes.ENTITY, this.provideEntityTransformer(clipboard));
                        continue block22;
                    }
                    case 4: {
                        cacheStream.skipNBytes(1L);
                        this.readEntityContainers(cacheStream, cacheNbtIn, DataFixer.FixTypes.BLOCK_ENTITY, this.provideTileEntityTransformer(clipboard));
                        continue block22;
                    }
                }
                throw new IOException("invalid cache state - got identifier: 0x" + identifier);
            }
        }
        finally {
            cacheStream.close();
        }
    }

    private void readRemainingDataReset(Clipboard clipboard) throws IOException {
        block10: while (!this.remainingTags.isEmpty()) {
            byte type;
            this.reset();
            FastSchematicReaderV3.skipHeader(this.dataInputStream);
            while ((type = this.dataInputStream.readByte()) != 0) {
                int b;
                String tag = this.dataInputStream.readUTF();
                int n = tag.equals("Blocks") ? 1 : (tag.equals("Biomes") ? 2 : (b = tag.equals("Entities") ? 3 : 0));
                if (!this.remainingTags.remove((byte)b)) {
                    this.nbtInputStream.readTagPayloadLazy(type, 0);
                    continue;
                }
                switch (tag) {
                    case "Blocks": {
                        this.readBlocks(clipboard);
                        break;
                    }
                    case "Biomes": {
                        this.readBiomes(clipboard);
                        break;
                    }
                    case "Entities": {
                        this.readEntities(clipboard);
                        break;
                    }
                    default: {
                        this.nbtInputStream.readTagPayloadLazy(type, 0);
                    }
                }
                if (!this.remainingTags.isEmpty()) continue;
                break block10;
            }
        }
    }

    @Override
    public OptionalInt getDataVersion() {
        return this.dataVersion > -1 ? OptionalInt.of(this.dataVersion) : OptionalInt.empty();
    }

    private void readBlocks(Clipboard target) throws IOException {
        this.blockPalette = new BlockState[BlockTypesCache.states.length];
        this.readPalette(target != null, (byte)1, () -> this.blockPalette[0] != null, this.provideBlockPaletteInitializer(), this.getBlockWriter(target), (type, tag) -> {
            if (!tag.equals("BlockEntities")) {
                try {
                    this.nbtInputStream.readTagPayloadLazy(9, 0);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to skip additional tag", (Throwable)e);
                }
                return;
            }
            try {
                this.readTileEntities(target);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to read tile entities", (Throwable)e);
            }
        });
    }

    private void readBiomes(Clipboard target) throws IOException {
        this.biomePalette = new BiomeType[BiomeType.REGISTRY.size()];
        this.readPalette(target != null, (byte)2, () -> this.biomePalette[0] != null, this.provideBiomePaletteInitializer(), this.getBiomeWriter(target), (type, tag) -> {
            try {
                this.nbtInputStream.readTagPayloadLazy(type, 0);
            }
            catch (IOException e) {
                LOGGER.error("Failed to skip additional tag in biome container: {}", (Object)tag, (Object)e);
            }
        });
    }

    private void readEntities(@Nullable Clipboard target) throws IOException {
        if (target == null || this.dataFixer == null) {
            if (this.supportsReset()) {
                this.remainingTags.add((byte)3);
                this.nbtInputStream.readTagPayloadLazy(9, 0);
                return;
            }
            NBTOutputStream cacheStream = new NBTOutputStream(this.getDataCacheWriter());
            cacheStream.writeByte(3);
            cacheStream.writeTagPayload(this.nbtInputStream.readTagPayload(9, 0));
            return;
        }
        if (this.dataInputStream.read() != 10) {
            throw new IOException("Expected a compound block for entity");
        }
        this.readEntityContainers(this.dataInputStream, this.nbtInputStream, DataFixer.FixTypes.ENTITY, this.provideEntityTransformer(target));
    }

    private void readTileEntities(Clipboard target) throws IOException {
        if (target == null || this.dataFixer == null) {
            if (this.supportsReset()) {
                this.remainingTags.add((byte)1);
                this.nbtInputStream.readTagPayloadLazy(9, 0);
                return;
            }
            NBTOutputStream cacheStream = new NBTOutputStream(this.getDataCacheWriter());
            cacheStream.writeByte(4);
            cacheStream.writeTagPayload(this.nbtInputStream.readTagPayload(9, 0));
            return;
        }
        if (this.dataInputStream.read() != 10) {
            throw new IOException("Expected a compound block for tile entity");
        }
        this.readEntityContainers(this.dataInputStream, this.nbtInputStream, DataFixer.FixTypes.BLOCK_ENTITY, this.provideTileEntityTransformer(target));
    }

    private void readEntityContainers(DataInputStream stream, NBTInputStream nbtStream, DataFixer.FixType<LinCompoundTag> fixType, EntityTransformer transformer) throws IOException {
        int count = stream.readInt();
        while (count-- > 0) {
            byte type;
            double x = -1.0;
            double y = -1.0;
            double z = -1.0;
            LinCompoundTag tag = null;
            String id = null;
            block7: while ((type = stream.readByte()) != 0) {
                switch (type) {
                    case 11: {
                        if (!stream.readUTF().equals("Pos")) {
                            throw new IOException("Expected INT_ARRAY tag to be Pos");
                        }
                        stream.skipNBytes(4L);
                        x = stream.readInt();
                        y = stream.readInt();
                        z = stream.readInt();
                        continue block7;
                    }
                    case 9: {
                        if (!stream.readUTF().equals("Pos")) {
                            throw new IOException("Expected LIST tag to be Pos");
                        }
                        if (stream.readByte() != 6) {
                            throw new IOException("Expected LIST Pos tag to contain DOUBLE");
                        }
                        stream.skipNBytes(4L);
                        x = stream.readDouble();
                        y = stream.readDouble();
                        z = stream.readDouble();
                        continue block7;
                    }
                    case 8: {
                        if (!stream.readUTF().equals("Id")) {
                            throw new IOException("Expected STRING tag to be Id");
                        }
                        id = stream.readUTF();
                        continue block7;
                    }
                    case 10: {
                        if (!stream.readUTF().equals("Data")) {
                            throw new IOException("Expected COMPOUND tag to be Data");
                        }
                        Object LT = nbtStream.readTagPayload(10, 0).toLinTag();
                        if (!(LT instanceof LinCompoundTag)) {
                            throw new IOException("Data tag could not be read into LinCompoundTag");
                        }
                        LinCompoundTag lin = (LinCompoundTag)LT;
                        tag = lin;
                        continue block7;
                    }
                }
                throw new IOException("Unexpected tag in compound: " + type);
            }
            if (id == null) {
                throw new IOException("Missing Id tag in compound");
            }
            if (x < 0.0 || y < 0.0 || z < 0.0) {
                throw new IOException("Missing position for entity " + id);
            }
            if (tag == null) {
                transformer.transform(x, y, z, id, LinCompoundTag.of(Map.of()));
                continue;
            }
            tag = tag.toBuilder().putString("id", id).remove("Id").build();
            if ((tag = this.dataFixer.fixUp(fixType, tag)) == null) {
                LOGGER.warn("Failed to fix-up entity for {} @ {},{},{} - skipping", (Object)id, (Object)x, (Object)y, (Object)z);
                continue;
            }
            transformer.transform(x, y, z, id, tag);
        }
    }

    private void readPalette(boolean hasClipboard, byte paletteType, BooleanSupplier paletteAlreadyInitialized, PaletteInitializer paletteInitializer, PaletteDataApplier paletteDataApplier, AdditionalTagConsumer additionalTag) throws IOException {
        byte type;
        boolean hasPalette = paletteAlreadyInitialized.getAsBoolean();
        while ((type = this.dataInputStream.readByte()) != 0) {
            String tag = this.dataInputStream.readUTF();
            if (tag.equals("Palette")) {
                if (hasPalette) {
                    this.nbtInputStream.readTagPayloadLazy(10, 0);
                    continue;
                }
                if (!this.readPaletteMap(this.dataInputStream, paletteInitializer)) {
                    if (this.supportsReset()) {
                        this.remainingTags.add(paletteType);
                        this.nbtInputStream.readTagPayloadLazy(10, 0);
                        continue;
                    }
                    NBTOutputStream cacheWriter = new NBTOutputStream(this.getPaletteCacheWriter());
                    cacheWriter.write(paletteType);
                    cacheWriter.writeTagPayload(this.nbtInputStream.readTagPayload(10, 0));
                    continue;
                }
                hasPalette = true;
                continue;
            }
            if (tag.equals("Data")) {
                if (!hasPalette || this.dataFixer == null || !hasClipboard) {
                    if (this.supportsReset()) {
                        this.remainingTags.add(paletteType);
                        this.nbtInputStream.readTagPayloadLazy(7, 0);
                        continue;
                    }
                    int byteLen = this.dataInputStream.readInt();
                    DataOutputStream cacheWriter = new DataOutputStream(this.getDataCacheWriter());
                    cacheWriter.write(paletteType);
                    cacheWriter.writeInt(byteLen);
                    IOUtil.copy(this.dataInputStream, cacheWriter, byteLen);
                    continue;
                }
                this.readPaletteData(this.dataInputStream, paletteDataApplier);
                continue;
            }
            additionalTag.accept(type, tag);
        }
    }

    private void readPaletteData(DataInputStream stream, PaletteDataApplier applier) throws IOException {
        int length = stream.readInt();
        int i = 0;
        if (this.needsVarIntReading(length)) {
            VarIntStreamIterator iter = new VarIntStreamIterator(stream, length);
            while (iter.hasNext()) {
                applier.apply(i, (char)iter.nextInt());
                ++i;
            }
            return;
        }
        while (i < length) {
            applier.apply(i++, (char)stream.readUnsignedByte());
        }
    }

    private boolean readPaletteMap(DataInputStream stream, PaletteInitializer initializer) throws IOException {
        if (this.dataFixer == null) {
            return false;
        }
        while (stream.readByte() != 0) {
            String value = stream.readUTF();
            char index = (char)stream.readInt();
            initializer.initialize(index, value);
        }
        return true;
    }

    private void indexToPosition(int index, PositionConsumer supplier) {
        int y = index / (this.dimensions.x() * this.dimensions.z());
        int remainder = index - y * this.dimensions.x() * this.dimensions.z();
        int z = remainder / this.dimensions.x();
        int x = remainder - z * this.dimensions.x();
        supplier.accept(x, y, z);
    }

    private PaletteDataApplier getBlockWriter(Clipboard target) {
        if (target instanceof LinearClipboard) {
            LinearClipboard linearClipboard = (LinearClipboard)target;
            return (index, ordinal) -> linearClipboard.setBlock(index, this.blockPalette[ordinal]);
        }
        return (index, ordinal) -> this.indexToPosition(index, (x, y, z) -> target.setBlock(x, y, z, this.blockPalette[ordinal]));
    }

    private PaletteDataApplier getBiomeWriter(Clipboard target) {
        return (index, ordinal) -> this.indexToPosition(index, (x, y, z) -> target.setBiome(x, y, z, this.biomePalette[ordinal]));
    }

    private PaletteInitializer provideBlockPaletteInitializer() {
        return (index, value) -> {
            if (this.dataFixer == null) {
                throw new IllegalStateException("Can't read block palette map if DataFixer is not yet available");
            }
            value = this.dataFixer.fixUp(DataFixer.FixTypes.BLOCK_STATE, value);
            try {
                this.blockPalette[index] = BlockState.get(value);
            }
            catch (InputParseException e) {
                LOGGER.warn("Invalid BlockState in palette: {}. Block will be replaced with air.", (Object)value);
                this.blockPalette[index] = BlockTypes.AIR.getDefaultState();
            }
        };
    }

    private PaletteInitializer provideBiomePaletteInitializer() {
        return (index, value) -> {
            if (this.dataFixer == null) {
                throw new IllegalStateException("Can't read biome palette map if DataFixer is not yet available");
            }
            BiomeType biomeType = BiomeTypes.get(value = this.dataFixer.fixUp(DataFixer.FixTypes.BIOME, value));
            if (biomeType == null) {
                biomeType = BiomeTypes.PLAINS;
                LOGGER.warn("Invalid biome type in palette: {}. Biome will be replaced with plains.", (Object)value);
            }
            this.biomePalette[index] = biomeType;
        };
    }

    private EntityTransformer provideEntityTransformer(Clipboard clipboard) {
        return (x, y, z, id, tag) -> {
            EntityType type = EntityType.REGISTRY.get(id);
            if (type == null) {
                LOGGER.warn("Invalid entity id: {} - skipping", (Object)id);
                return;
            }
            clipboard.createEntity(new Location(clipboard, Location.at(x, y, z).add(clipboard.getMinimumPoint().toVector3())), new BaseEntity(type, LazyReference.computed(tag)));
        };
    }

    private EntityTransformer provideTileEntityTransformer(Clipboard clipboard) {
        return (x, y, z, id, tag) -> clipboard.tile(MathMan.roundInt(x + (double)clipboard.getMinimumPoint().x()), MathMan.roundInt(y + (double)clipboard.getMinimumPoint().y()), MathMan.roundInt(z + (double)clipboard.getMinimumPoint().z()), FaweCompoundTag.of(tag));
    }

    private boolean areDimensionsAvailable() {
        return this.dimensions.x() != 0 && this.dimensions.y() != 0 && this.dimensions.z() != 0;
    }

    @Override
    public void close() throws IOException {
        this.parentStream.close();
    }

    private void reset() throws IOException {
        if (this.supportsReset()) {
            this.parentStream.reset();
            this.parentStream.mark(Integer.MAX_VALUE);
            this.setSubStreams();
        }
    }

    private boolean supportsReset() {
        return this.remainingTags != null;
    }

    private void setSubStreams() throws IOException {
        FastBufferedInputStream buffer = new FastBufferedInputStream((InputStream)new GZIPInputStream(this.parentStream));
        this.dataInputStream = new DataInputStream((InputStream)buffer);
        this.nbtInputStream = new NBTInputStream((InputStream)buffer);
    }

    private OutputStream getDataCacheWriter() {
        if (this.dataCacheWriter == null) {
            final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            this.dataCacheWriter = new FastBufferedOutputStream(new LZ4BlockOutputStream(byteArrayOutputStream)){

                public void close() throws IOException {
                    this.write(0);
                    super.close();
                    FastSchematicReaderV3.this.dataCache = byteArrayOutputStream.toByteArray();
                }
            };
        }
        return this.dataCacheWriter;
    }

    private OutputStream getPaletteCacheWriter() {
        if (this.paletteCacheWriter == null) {
            final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
            this.paletteCacheWriter = new FastBufferedOutputStream(new LZ4BlockOutputStream(byteArrayOutputStream)){

                public void close() throws IOException {
                    this.write(0);
                    super.close();
                    FastSchematicReaderV3.this.paletteCache = byteArrayOutputStream.toByteArray();
                }
            };
        }
        return this.paletteCacheWriter;
    }

    private boolean needsVarIntReading(int byteArrayLength) {
        return byteArrayLength > this.dimensions.x() * this.dimensions.y() * this.dimensions.z();
    }

    private static void skipHeader(DataInputStream dataInputStream) throws IOException {
        dataInputStream.skipNBytes(3L);
        dataInputStream.skipNBytes(12L);
    }

    @FunctionalInterface
    @ApiStatus.Internal
    private static interface PaletteInitializer {
        public void initialize(char var1, String var2);
    }

    @FunctionalInterface
    @ApiStatus.Internal
    private static interface PaletteDataApplier {
        public void apply(int var1, char var2);
    }

    @FunctionalInterface
    @ApiStatus.Internal
    private static interface EntityTransformer {
        public void transform(double var1, double var3, double var5, String var7, LinCompoundTag var8);
    }

    @FunctionalInterface
    @ApiStatus.Internal
    private static interface AdditionalTagConsumer {
        public void accept(byte var1, String var2);
    }

    @FunctionalInterface
    @ApiStatus.Internal
    private static interface PositionConsumer {
        public void accept(int var1, int var2, int var3);
    }
}

