/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.function.mask;

import com.fastasyncworldedit.core.function.mask.ResettableMask;
import com.sk89q.worldedit.function.mask.AbstractMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.math.BlockVector3;

public class RadiusMask
extends AbstractMask
implements ResettableMask {
    private final int minSqr;
    private final int maxSqr;
    private transient BlockVector3 pos;

    public RadiusMask(int min, int max) {
        this.minSqr = min * min;
        this.maxSqr = max * max;
    }

    private RadiusMask(Integer minSqr, Integer maxSqr) {
        this.minSqr = minSqr;
        this.maxSqr = maxSqr;
    }

    @Override
    public void reset() {
        this.pos = null;
    }

    @Override
    public boolean test(BlockVector3 to) {
        int dx;
        int d;
        if (this.pos == null) {
            this.pos = to.toImmutable();
        }
        if ((d = (dx = this.pos.x() - to.x()) * dx) > this.maxSqr) {
            return false;
        }
        int dz = this.pos.z() - to.z();
        if ((d += dz * dz) > this.maxSqr) {
            return false;
        }
        int dy = this.pos.y() - to.y();
        return (d += dy * dy) >= this.minSqr && d <= this.maxSqr;
    }

    @Override
    public Mask copy() {
        return new RadiusMask((Integer)this.minSqr, (Integer)this.maxSqr);
    }
}

