/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.internal.simd;

import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.filter.block.DelegateFilter;
import com.fastasyncworldedit.core.function.mask.InverseMask;
import com.fastasyncworldedit.core.function.mask.SingleBlockStateMask;
import com.fastasyncworldedit.core.internal.simd.VectorFacade;
import com.fastasyncworldedit.core.internal.simd.VectorizedFilter;
import com.fastasyncworldedit.core.internal.simd.VectorizedMask;
import com.fastasyncworldedit.core.queue.Filter;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.InverseSingleBlockStateMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javax.annotation.Nullable;
import jdk.incubator.vector.ShortVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorMask;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;
import org.apache.logging.log4j.Logger;

public class SimdSupport {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private static final boolean VECTOR_API_PRESENT;

    public static boolean useVectorApi() {
        return VECTOR_API_PRESENT && Settings.settings().EXPERIMENTAL.USE_VECTOR_API;
    }

    @Nullable
    public static VectorizedMask vectorizedTargetMask(Mask mask) {
        if (!SimdSupport.useVectorApi()) {
            return null;
        }
        Mask mask2 = mask;
        Objects.requireNonNull(mask2);
        Mask mask3 = mask2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SingleBlockStateMask.class, InverseSingleBlockStateMask.class, ExistingBlockMask.class, InverseMask.class}, (Object)mask3, n)) {
            case 0 -> {
                SingleBlockStateMask single = (SingleBlockStateMask)mask3;
                yield SimdSupport.vectorizedTargetMask(single.getBlockState().getOrdinalChar());
            }
            case 1 -> {
                InverseSingleBlockStateMask inverse = (InverseSingleBlockStateMask)mask3;
                yield SimdSupport.vectorizedTargetMaskInverse(inverse.getBlockState().getOrdinalChar());
            }
            case 2 -> {
                ExistingBlockMask ignored = (ExistingBlockMask)mask3;
                yield SimdSupport.vectorizedTargetMaskNonAir();
            }
            case 3 -> {
                InverseMask inverse = (InverseMask)mask3;
                VectorizedMask base = SimdSupport.vectorizedTargetMask(inverse.inverse());
                if (base == null) {
                    yield null;
                }
                yield (set, get, species) -> base.compareVector(set, get, (VectorSpecies<Short>)species).not();
            }
            default -> null;
        };
    }

    private static VectorizedMask vectorizedTargetMaskNonAir() {
        return (set, get, species) -> get.get((VectorSpecies<Short>)species).compare(VectorOperators.UNSIGNED_GT, 3L);
    }

    private static VectorizedMask vectorizedTargetMask(char ordinal) {
        return (set, get, species) -> get.get((VectorSpecies<Short>)species).compare(VectorOperators.EQ, (short)ordinal);
    }

    private static VectorizedMask vectorizedTargetMaskInverse(char ordinal) {
        return (set, get, species) -> get.get((VectorSpecies<Short>)species).compare(VectorOperators.NE, (short)ordinal);
    }

    @Nullable
    public static VectorizedFilter vectorizedPattern(Pattern pattern) {
        if (!SimdSupport.useVectorApi()) {
            return null;
        }
        Pattern pattern2 = pattern;
        Objects.requireNonNull(pattern2);
        Pattern pattern3 = pattern2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BaseBlock.class, BlockStateHolder.class}, (Object)pattern3, n)) {
            case 0 -> {
                BaseBlock block = (BaseBlock)pattern3;
                if (block.getNbtReference() == null) {
                    yield new VectorizedPattern<BaseBlock>(block, block.getOrdinalChar());
                }
                yield null;
            }
            case 1 -> {
                BlockStateHolder blockStateHolder = (BlockStateHolder)pattern3;
                yield new VectorizedPattern<BlockStateHolder>(blockStateHolder, blockStateHolder.getOrdinalChar());
            }
            default -> null;
        };
    }

    static {
        boolean vectorApiPresent = false;
        try {
            Class.forName("jdk.incubator.vector.Vector");
            vectorApiPresent = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        VECTOR_API_PRESENT = vectorApiPresent;
        if (!VECTOR_API_PRESENT && Settings.settings().EXPERIMENTAL.USE_VECTOR_API) {
            LOGGER.warn("FAWE use-vector-api is enabled but --add-modules=jdk.incubator.vector is not set.\nVector instructions will not be used.\n");
        } else if (VECTOR_API_PRESENT && !Settings.settings().EXPERIMENTAL.USE_VECTOR_API) {
            LOGGER.warn("The server is running with the --add-modules=jdk.incubator.vector option.\nFAWE can use vector instructions, but it is disabled in the config.\nEnable use-vector-api to benefit from vector instructions with FAWE.");
        }
    }

    private static final class VectorizedPattern<T extends Filter>
    extends DelegateFilter<T>
    implements VectorizedFilter {
        private final char ordinal;

        public VectorizedPattern(T parent, char ordinal) {
            super(parent);
            this.ordinal = ordinal;
        }

        @Override
        public Filter newInstance(Filter other) {
            return new VectorizedPattern<Filter>(other, this.ordinal);
        }

        @Override
        public void applyVector(VectorFacade get, VectorFacade set, VectorMask<Short> mask) {
            ShortVector s = set.getOrZero((VectorSpecies<Short>)mask.vectorSpecies());
            s = s.blend((Vector)ShortVector.broadcast((VectorSpecies)ShortVector.SPECIES_PREFERRED, (long)this.ordinal), mask);
            set.setOrIgnore(s);
        }
    }
}

