/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.jnbt.streamer;

import com.fastasyncworldedit.core.jnbt.streamer.InfoReader;
import com.fastasyncworldedit.core.jnbt.streamer.IntValueReader;
import com.fastasyncworldedit.core.jnbt.streamer.LazyReader;
import com.fastasyncworldedit.core.jnbt.streamer.LongValueReader;
import com.fastasyncworldedit.core.jnbt.streamer.ValueReader;
import com.sk89q.jnbt.NBTConstants;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public class StreamDelegate {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private static final byte[][] ZERO_KEYS = new byte[0][];
    private static final StreamDelegate[] ZERO_VALUES = new StreamDelegate[0];
    private byte[] buffer;
    private byte[][] keys = ZERO_KEYS;
    private StreamDelegate[] values = ZERO_VALUES;
    private LazyReader lazyReader;
    private ValueReader elemReader;
    private InfoReader infoReader;
    private ValueReader valueReader;

    public StreamDelegate addAndGetParent(String name) {
        this.add(name);
        return this;
    }

    public StreamDelegate add() {
        return this.add("");
    }

    public StreamDelegate add(String name) {
        return this.add(name, new StreamDelegate());
    }

    private StreamDelegate add(String name, StreamDelegate scope) {
        byte[] key;
        int i;
        if (this.valueReader != null) {
            LOGGER.warn("Scope {} | {} may not run, as the stream is only read once, and a value reader is already set", (Object)name, (Object)scope);
        }
        byte[] bytes = name.getBytes(NBTConstants.CHARSET);
        int maxSize = bytes.length;
        byte[][] tmpKeys = new byte[this.keys.length + 1][];
        StreamDelegate[] tmpValues = new StreamDelegate[this.keys.length + 1];
        tmpKeys[this.keys.length] = bytes;
        tmpValues[this.keys.length] = scope;
        for (i = 0; i < this.keys.length; ++i) {
            key = this.keys[i];
            if (key.length >= bytes.length) {
                tmpKeys[i] = bytes;
                tmpValues[i] = scope;
                break;
            }
            tmpKeys[i] = key;
            tmpValues[i] = this.values[i];
            maxSize = Math.max(maxSize, key.length);
        }
        while (i < this.keys.length) {
            key = this.keys[i];
            tmpKeys[i + 1] = key;
            tmpValues[i + 1] = this.values[i];
            maxSize = Math.max(maxSize, key.length);
            ++i;
        }
        this.keys = tmpKeys;
        this.values = tmpValues;
        if (this.buffer == null || this.buffer.length < maxSize) {
            this.buffer = new byte[maxSize];
        }
        return scope;
    }

    public StreamDelegate get0() {
        if (this.keys.length > 0 && this.keys[0].length == 0) {
            return this.values[0];
        }
        return null;
    }

    public StreamDelegate get(DataInputStream is) throws IOException {
        int nameLength = is.readShort() & 0xFFFF;
        if (nameLength == 0 && this.keys.length > 0 && this.keys[0].length == 0) {
            return this.values[0];
        }
        if (nameLength > this.buffer.length) {
            is.skipBytes(nameLength);
            return null;
        }
        block0 : switch (this.keys.length) {
            case 0: {
                break;
            }
            default: {
                byte[] key;
                int index;
                for (index = 0; index < this.keys.length; ++index) {
                    key = this.keys[index];
                    if (key.length < nameLength) continue;
                    if (key.length != nameLength) break block0;
                    break;
                }
                if (index != this.keys.length - 1) {
                    byte[] key2;
                    int max;
                    for (max = index + 1; max < this.keys.length && (key2 = this.keys[max]).length == nameLength; ++max) {
                    }
                    if (index != max) {
                        is.readFully(this.buffer, 0, nameLength);
                        block6: for (int i = index; i < max; ++i) {
                            byte[] key3 = this.keys[i];
                            for (int j = 0; j < nameLength; ++j) {
                                if (this.buffer[j] != key3[j]) continue block6;
                            }
                            return this.values[i];
                        }
                        return null;
                    }
                }
            }
            case 1: {
                int index;
                byte[] key = this.keys[index];
                if (key.length != nameLength) break;
                int i = 0;
                while (nameLength > 0) {
                    byte b;
                    this.buffer[i] = b = is.readByte();
                    if (b != key[i]) {
                        --nameLength;
                        break block0;
                    }
                    --nameLength;
                    ++i;
                }
                return this.values[index];
            }
        }
        is.skipBytes(nameLength);
        return null;
    }

    public StreamDelegate withLong(LongValueReader valueReader) {
        return this.withElem(valueReader);
    }

    public StreamDelegate withInt(IntValueReader valueReader) {
        return this.withElem(valueReader);
    }

    public StreamDelegate withValue(ValueReader valueReader) {
        if (this.keys.length != 0) {
            LOGGER.warn("Reader {} may not run, as the stream is only read once, and a value reader is already set", (Object)valueReader);
        }
        this.valueReader = valueReader;
        return this;
    }

    public StreamDelegate withStream(LazyReader lazyReader) {
        this.lazyReader = lazyReader;
        return this;
    }

    public StreamDelegate withElem(ValueReader elemReader) {
        this.elemReader = elemReader;
        return this;
    }

    public StreamDelegate withInfo(InfoReader infoReader) {
        this.infoReader = infoReader;
        return this;
    }

    public void acceptRoot(NBTInputStream is, int type, int depth) throws IOException {
        if (this.lazyReader != null) {
            this.lazyReader.apply(0, is);
        } else if (this.elemReader != null) {
            Object raw = is.readTagPayloadRaw(type, depth);
            this.elemReader.apply(0, raw);
        } else if (this.valueReader != null) {
            Object raw = is.readTagPayloadRaw(type, depth);
            this.valueReader.apply(0, raw);
        } else {
            is.readTagPayloadLazy(type, depth + 1, this);
        }
    }

    public ValueReader getValueReader() {
        return this.valueReader;
    }

    public ValueReader getElemReader() {
        return this.elemReader;
    }

    public void acceptInfo(int length, int type) throws IOException {
        if (this.infoReader != null) {
            this.infoReader.apply(length, type);
        }
    }

    public boolean acceptLazy(int length, NBTInputStream is) throws IOException {
        if (this.lazyReader != null) {
            this.lazyReader.apply(length, is);
            return true;
        }
        return false;
    }
}

