/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.queue.implementation.blocks;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.queue.IBlocks;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public abstract class CharBlocks
implements IBlocks {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    protected static final Section FULL = new Section(){

        @Override
        public char[] get(CharBlocks blocks, int layer, char[] arr) {
            return arr;
        }

        @Override
        public char[] get(CharBlocks blocks, int layer, char[] arr, boolean aggressive) {
            return arr;
        }
    };
    protected static final Section EMPTY = new Section(){

        @Override
        public char[] get(CharBlocks blocks, int layer, char[] arr) {
            return this.get(blocks, layer, arr, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char[] get(CharBlocks blocks, int layer, char[] arr, boolean aggressive) {
            Object object = blocks.sectionLocks[layer];
            synchronized (object) {
                return 2.update(blocks, layer, aggressive);
            }
        }
    };
    public char[][] blocks;
    public Object[] sectionLocks;
    protected int minSectionPosition;
    protected int maxSectionPosition;
    protected int sectionCount;
    private int chunkX;
    private int chunkZ;

    public CharBlocks(int minSectionPosition, int maxSectionPosition) {
        this.minSectionPosition = minSectionPosition;
        this.maxSectionPosition = maxSectionPosition;
        this.sectionCount = maxSectionPosition - minSectionPosition + 1;
        this.blocks = new char[this.sectionCount][];
        this.sectionLocks = new Object[this.sectionCount];
        for (int i = 0; i < this.sectionCount; ++i) {
            this.sectionLocks[i] = new Object();
        }
    }

    public void init(int chunkX, int chunkZ) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trim(boolean aggressive) {
        for (int i = 0; i < this.sectionCount; ++i) {
            Object object = this.sectionLocks[i];
            synchronized (object) {
                if (this.blocks[i] != null) {
                    return false;
                }
                continue;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trim(boolean aggressive, int layer) {
        Object object = this.sectionLocks[layer];
        synchronized (object) {
            return this.blocks[layer] == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IChunkSet reset() {
        for (int i = 0; i < this.sectionCount; ++i) {
            Object object = this.sectionLocks[i];
            synchronized (object) {
                this.blocks[i] = null;
                continue;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(int layer) {
        Object object = this.sectionLocks[layer -= this.minSectionPosition];
        synchronized (object) {
            this.blocks[layer] = null;
        }
    }

    public char[] update(int layer, char[] data, boolean aggressive) {
        if (data == null) {
            return new char[4096];
        }
        Arrays.fill(data, this.defaultOrdinal());
        return data;
    }

    @Override
    public boolean hasSection(int layer) {
        return (layer -= this.minSectionPosition) >= 0 && layer < this.blocks.length && this.blocks[layer] != null;
    }

    @Override
    public char[] load(int layer) {
        char[] data = this.blocks[layer -= this.minSectionPosition];
        return (data == null ? EMPTY : FULL).get(this, layer, data);
    }

    @Override
    @Nullable
    public char[] loadIfPresent(int layer) {
        if (layer < this.minSectionPosition || layer > this.maxSectionPosition) {
            return null;
        }
        return this.blocks[layer -= this.minSectionPosition];
    }

    @Override
    public int getSectionCount() {
        return this.sectionCount;
    }

    @Override
    public int getMaxSectionPosition() {
        return this.maxSectionPosition;
    }

    @Override
    public int getMinSectionPosition() {
        return this.minSectionPosition;
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return BlockTypesCache.states[this.get(x, y, z)];
    }

    public char get(int x, int y, int z) {
        int layer = y >> 4;
        int index = (y & 0xF) << 8 | z << 4 | x;
        if (layer > this.maxSectionPosition || layer < this.minSectionPosition) {
            return this.defaultOrdinal();
        }
        return this.get(layer, index);
    }

    @Override
    public int getX() {
        return this.chunkX;
    }

    @Override
    public int getZ() {
        return this.chunkZ;
    }

    protected abstract char defaultOrdinal();

    public void set(int x, int y, int z, char value) {
        int layer = y >> 4;
        int index = (y & 0xF) << 8 | z << 4 | x;
        try {
            this.set(layer, index, value);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            LOGGER.error("Tried setting block at coordinates (" + x + "," + y + "," + z + ")");
            assert (Fawe.platform() != null);
            LOGGER.error("Layer variable was = {}", (Object)layer, (Object)exception);
        }
    }

    public final char get(int layer, int index) {
        char[] data = this.blocks[layer - this.minSectionPosition];
        return (data == null ? EMPTY : FULL).get(this, layer, index, data);
    }

    public final void set(int layer, int index, char value) throws ArrayIndexOutOfBoundsException {
        char[] data = this.blocks[layer - this.minSectionPosition];
        (data == null ? EMPTY : FULL).set(this, layer, index, value, data);
    }

    public static abstract class Section {
        static char[] update(CharBlocks blocks, int layer, boolean aggressive) {
            char[] arr = blocks.blocks[layer];
            if (arr == null) {
                blocks.blocks[layer] = blocks.update(layer, null, aggressive);
                arr = blocks.blocks[layer];
                if (arr == null) {
                    throw new IllegalStateException("Array cannot be null: " + String.valueOf(blocks.getClass()));
                }
            } else {
                blocks.blocks[layer] = blocks.update(layer, arr, aggressive);
                if (blocks.blocks[layer] == null) {
                    throw new IllegalStateException("Array cannot be null (update): " + String.valueOf(blocks.getClass()));
                }
            }
            return arr;
        }

        abstract char[] get(CharBlocks var1, int var2, char[] var3);

        abstract char[] get(CharBlocks var1, int var2, char[] var3, boolean var4);

        public final char get(CharBlocks blocks, int layer, int index, char[] data) {
            int normalized = layer - blocks.minSectionPosition;
            char[] section = this.get(blocks, normalized, data);
            return section[index];
        }

        public final void set(CharBlocks blocks, int layer, int index, char value, char[] data) {
            this.get((CharBlocks)blocks, (int)(layer -= blocks.minSectionPosition), (char[])data)[index] = value;
        }
    }
}

