/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.queue.implementation.blocks;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.extent.processor.heightmap.HeightMapType;
import com.fastasyncworldedit.core.math.BlockVector3ChunkMap;
import com.fastasyncworldedit.core.nbt.FaweCompoundTag;
import com.fastasyncworldedit.core.queue.IBlocks;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.queue.implementation.blocks.CharSetBlocks;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ThreadUnsafeCharBlocks
implements IChunkSet,
IBlocks {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final char defaultOrdinal;
    private final int chunkX;
    private final int chunkZ;
    private char[][] blocks;
    private int minSectionPosition;
    private int maxSectionPosition;
    private int sectionCount;
    private BiomeType[][] biomes;
    private char[][] light;
    private char[][] skyLight;
    private BlockVector3ChunkMap<FaweCompoundTag> tiles;
    private HashSet<FaweCompoundTag> entities;
    private HashSet<UUID> entityRemoves;
    private Map<HeightMapType, int[]> heightMaps;
    private boolean fastMode;
    private int bitMask;
    private SideEffectSet sideEffectSet;

    ThreadUnsafeCharBlocks(char[][] blocks, int minSectionPosition, int maxSectionPosition, BiomeType[][] biomes, int sectionCount, char[][] light, char[][] skyLight, BlockVector3ChunkMap<FaweCompoundTag> tiles, HashSet<FaweCompoundTag> entities, HashSet<UUID> entityRemoves, Map<HeightMapType, int[]> heightMaps, char defaultOrdinal, boolean fastMode, int bitMask, SideEffectSet sideEffectSet, int chunkX, int chunkZ) {
        this.blocks = blocks;
        this.minSectionPosition = minSectionPosition;
        this.maxSectionPosition = maxSectionPosition;
        this.biomes = biomes;
        this.sectionCount = sectionCount;
        this.light = light;
        this.skyLight = skyLight;
        this.tiles = tiles;
        this.entities = entities;
        this.entityRemoves = entityRemoves;
        this.heightMaps = heightMaps;
        this.defaultOrdinal = defaultOrdinal;
        this.fastMode = fastMode;
        this.bitMask = bitMask;
        this.sideEffectSet = sideEffectSet;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    @Override
    public boolean hasSection(int layer) {
        return (layer -= this.minSectionPosition) >= 0 && layer < this.blocks.length && this.blocks[layer] != null && this.blocks[layer].length == FaweCache.INSTANCE.BLOCKS_PER_LAYER;
    }

    @Override
    public char[] load(int layer) {
        this.updateSectionIndexRange(layer);
        char[] arr = this.blocks[layer -= this.minSectionPosition];
        if (arr == null) {
            this.blocks[layer] = new char[FaweCache.INSTANCE.BLOCKS_PER_LAYER];
            arr = this.blocks[layer];
        }
        return arr;
    }

    @Override
    @Nullable
    public char[] loadIfPresent(int layer) {
        if (layer < this.minSectionPosition || layer > this.maxSectionPosition) {
            return null;
        }
        return this.blocks[layer -= this.minSectionPosition];
    }

    @Override
    public Map<BlockVector3, FaweCompoundTag> tiles() {
        return this.tiles == null ? Collections.emptyMap() : this.tiles;
    }

    @Override
    @Nullable
    public FaweCompoundTag tile(int x, int y, int z) {
        return this.tiles == null ? null : this.tiles.get(x, y, z);
    }

    @Override
    public Collection<FaweCompoundTag> entities() {
        return this.entities == null ? Collections.emptyList() : this.entities;
    }

    @Override
    public Map<HeightMapType, int[]> getHeightMaps() {
        return this.heightMaps == null ? new HashMap() : this.heightMaps;
    }

    @Override
    public void removeSectionLighting(int layer, boolean sky) {
        this.updateSectionIndexRange(layer);
        layer -= this.minSectionPosition;
        if (this.light == null) {
            this.light = new char[this.sectionCount][];
        }
        if (this.light[layer] == null) {
            this.light[layer] = new char[4096];
        }
        Arrays.fill(this.light[layer], '\u0000');
        if (sky) {
            if (this.skyLight == null) {
                this.skyLight = new char[this.sectionCount][];
            }
            if (this.skyLight[layer] == null) {
                this.skyLight[layer] = new char[4096];
            }
            Arrays.fill(this.skyLight[layer], '\u0000');
        }
    }

    @Override
    public boolean trim(boolean aggressive, int layer) {
        return false;
    }

    @Override
    public int getSectionCount() {
        return this.sectionCount;
    }

    @Override
    public int getMaxSectionPosition() {
        return this.maxSectionPosition;
    }

    @Override
    public int getMinSectionPosition() {
        return this.minSectionPosition;
    }

    @Override
    public int getX() {
        return this.chunkX;
    }

    @Override
    public int getZ() {
        return this.chunkZ;
    }

    public char get(int x, int y, int z) {
        int layer = y >> 4;
        if (!this.hasSection(layer)) {
            return this.defaultOrdinal;
        }
        int index = (y & 0xF) << 8 | z << 4 | x;
        return this.blocks[layer - this.minSectionPosition][index];
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        if (this.biomes == null || y >> 4 < this.minSectionPosition || y >> 4 > this.maxSectionPosition) {
            return null;
        }
        int layer = (y >> 4) - this.minSectionPosition;
        if (this.biomes[layer] == null) {
            return null;
        }
        return this.biomes[layer][(y & 0xF) >> 2 | z >> 2 << 2 | x >> 2];
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return BlockTypesCache.states[this.get(x, y, z)];
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        this.updateSectionIndexRange(y >> 4);
        int layer = (y >> 4) - this.minSectionPosition;
        if (this.biomes == null) {
            this.biomes = new BiomeType[this.sectionCount][];
            this.biomes[layer] = new BiomeType[64];
        } else if (this.biomes[layer] == null) {
            this.biomes[layer] = new BiomeType[64];
        }
        this.biomes[layer][(y & 0xC) << 2 | z & 0xC | (x & 0xC) >> 2] = biome;
        return true;
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        return this.setBiome(position.x(), position.y(), position.z(), biome);
    }

    public void set(int x, int y, int z, char value) {
        int layer = (y >> 4) - this.minSectionPosition;
        int index = (y & 0xF) << 8 | z << 4 | x;
        try {
            this.blocks[layer][index] = value;
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            LOGGER.error("Tried setting block at coordinates (" + x + "," + y + "," + z + ")");
            assert (Fawe.platform() != null);
            LOGGER.error("Layer variable was = {}", (Object)layer, (Object)exception);
        }
    }

    @Override
    public <T extends BlockStateHolder<T>> boolean setBlock(int x, int y, int z, T holder) {
        this.updateSectionIndexRange(y >> 4);
        this.set(x, y, z, holder.getOrdinalChar());
        holder.applyTileEntity(this, x, y, z);
        return true;
    }

    @Override
    public void setBlocks(int layer, char[] data) {
        this.updateSectionIndexRange(layer);
        this.blocks[layer -= this.minSectionPosition] = data;
    }

    @Override
    public boolean isEmpty() {
        if (this.biomes != null || this.light != null || this.skyLight != null || this.entities != null && !this.entities.isEmpty() || this.tiles != null && !this.tiles.isEmpty() || this.entityRemoves != null && !this.entityRemoves.isEmpty() || this.heightMaps != null && !this.heightMaps.isEmpty()) {
            return false;
        }
        for (int i = this.minSectionPosition; i <= this.maxSectionPosition; ++i) {
            if (!this.hasSection(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean tile(int x, int y, int z, FaweCompoundTag tag) {
        this.updateSectionIndexRange(y >> 4);
        if (this.tiles == null) {
            this.tiles = new BlockVector3ChunkMap();
        }
        this.tiles.put(x, y, z, tag);
        return true;
    }

    @Override
    public void setBlockLight(int x, int y, int z, int value) {
        int layer;
        this.updateSectionIndexRange(y >> 4);
        if (this.light == null) {
            this.light = new char[this.sectionCount][];
        }
        if (this.light[layer = (y >> 4) - this.minSectionPosition] == null) {
            char[] c = new char[4096];
            Arrays.fill(c, '\u0010');
            this.light[layer] = c;
        }
        int index = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
        this.light[layer][index] = (char)value;
    }

    @Override
    public void setSkyLight(int x, int y, int z, int value) {
        int layer;
        this.updateSectionIndexRange(y >> 4);
        if (this.skyLight == null) {
            this.skyLight = new char[this.sectionCount][];
        }
        if (this.skyLight[layer = (y >> 4) - this.minSectionPosition] == null) {
            char[] c = new char[4096];
            Arrays.fill(c, '\u0010');
            this.skyLight[layer] = c;
        }
        int index = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
        this.skyLight[layer][index] = (char)value;
    }

    @Override
    public void setHeightMap(HeightMapType type, int[] heightMap) {
        if (this.heightMaps == null) {
            this.heightMaps = new EnumMap<HeightMapType, int[]>(HeightMapType.class);
        }
        this.heightMaps.put(type, heightMap);
    }

    @Override
    public void setLightLayer(int layer, char[] toSet) {
        this.updateSectionIndexRange(layer);
        if (this.light == null) {
            this.light = new char[this.sectionCount][];
        }
        this.light[layer -= this.minSectionPosition] = toSet;
    }

    @Override
    public void setSkyLightLayer(int layer, char[] toSet) {
        this.updateSectionIndexRange(layer);
        if (this.skyLight == null) {
            this.skyLight = new char[this.sectionCount][];
        }
        this.skyLight[layer -= this.minSectionPosition] = toSet;
    }

    @Override
    public void setFullBright(int layer) {
        this.updateSectionIndexRange(layer);
        layer -= this.minSectionPosition;
        if (this.light == null) {
            this.light = new char[this.sectionCount][];
        }
        if (this.light[layer] == null) {
            this.light[layer] = new char[4096];
        }
        if (this.skyLight == null) {
            this.skyLight = new char[this.sectionCount][];
        }
        if (this.skyLight[layer] == null) {
            this.skyLight[layer] = new char[4096];
        }
        Arrays.fill(this.light[layer], '\u000f');
        Arrays.fill(this.skyLight[layer], '\u000f');
    }

    @Override
    public void entity(FaweCompoundTag tag) {
        if (this.entities == null) {
            this.entities = new HashSet();
        }
        this.entities.add(tag);
    }

    @Override
    public void removeEntity(UUID uuid) {
        if (this.entityRemoves == null) {
            this.entityRemoves = new HashSet();
        }
        this.entityRemoves.add(uuid);
    }

    @Override
    public void setFastMode(boolean fastMode) {
        this.fastMode = fastMode;
    }

    @Override
    public boolean isFastMode() {
        return this.fastMode;
    }

    @Override
    public void setBitMask(int bitMask) {
        this.bitMask = bitMask;
    }

    @Override
    public int getBitMask() {
        return this.bitMask;
    }

    @Override
    public Set<UUID> getEntityRemoves() {
        return this.entityRemoves == null ? Collections.emptySet() : this.entityRemoves;
    }

    @Override
    public BiomeType[][] getBiomes() {
        return this.biomes;
    }

    @Override
    public boolean hasBiomes() {
        return IChunkSet.super.hasBiomes();
    }

    @Override
    public char[][] getLight() {
        return this.light;
    }

    @Override
    public char[][] getSkyLight() {
        return this.skyLight;
    }

    @Override
    public boolean hasLight() {
        return IChunkSet.super.hasLight();
    }

    @Override
    public IChunkSet reset() {
        this.blocks = new char[this.sectionCount][];
        this.biomes = new BiomeType[this.sectionCount][];
        this.light = new char[this.sectionCount][];
        this.skyLight = new char[this.sectionCount][];
        this.tiles.clear();
        this.entities.clear();
        this.entityRemoves.clear();
        this.heightMaps.clear();
        return this;
    }

    @Override
    public boolean hasBiomes(int layer) {
        return (layer -= this.minSectionPosition) >= 0 && layer < this.biomes.length && this.biomes[layer] != null && this.biomes[layer].length > 0;
    }

    @Override
    public IChunkSet createCopy() {
        BiomeType[][] biomesCopy;
        char[][] blocksCopy = new char[this.sectionCount][];
        for (int i = 0; i < this.sectionCount; ++i) {
            blocksCopy[i] = new char[FaweCache.INSTANCE.BLOCKS_PER_LAYER];
            if (this.blocks[i] == null) continue;
            System.arraycopy(this.blocks[i], 0, blocksCopy[i], 0, FaweCache.INSTANCE.BLOCKS_PER_LAYER);
        }
        if (this.biomes == null) {
            biomesCopy = null;
        } else {
            biomesCopy = new BiomeType[this.sectionCount][];
            for (int i = 0; i < this.sectionCount; ++i) {
                if (this.biomes[i] == null) continue;
                biomesCopy[i] = new BiomeType[this.biomes[i].length];
                System.arraycopy(this.biomes[i], 0, biomesCopy[i], 0, this.biomes[i].length);
            }
        }
        char[][] lightCopy = CharSetBlocks.createLightCopy(this.light, this.sectionCount);
        char[][] skyLightCopy = CharSetBlocks.createLightCopy(this.skyLight, this.sectionCount);
        return new ThreadUnsafeCharBlocks(blocksCopy, this.minSectionPosition, this.maxSectionPosition, biomesCopy, this.sectionCount, lightCopy, skyLightCopy, this.tiles != null ? new BlockVector3ChunkMap<FaweCompoundTag>(this.tiles) : null, this.entities != null ? new HashSet<FaweCompoundTag>(this.entities) : null, this.entityRemoves != null ? new HashSet<UUID>(this.entityRemoves) : null, this.heightMaps != null ? new HashMap<HeightMapType, int[]>(this.heightMaps) : null, this.defaultOrdinal, this.fastMode, this.bitMask, this.sideEffectSet, this.chunkX, this.chunkZ);
    }

    @Override
    public void setSideEffectSet(SideEffectSet sideEffectSet) {
        this.sideEffectSet = sideEffectSet;
    }

    @Override
    public SideEffectSet getSideEffectSet() {
        return this.sideEffectSet;
    }

    @Override
    public boolean trim(boolean aggressive) {
        return false;
    }

    private void updateSectionIndexRange(int layer) {
        if (layer >= this.minSectionPosition && layer <= this.maxSectionPosition) {
            return;
        }
        if (layer < this.minSectionPosition) {
            int diff = this.minSectionPosition - layer;
            this.sectionCount += diff;
            this.minSectionPosition = layer;
            this.resizeSectionsArrays(layer, diff, false);
        } else {
            int diff = layer - this.maxSectionPosition;
            this.sectionCount += diff;
            this.maxSectionPosition = layer;
            this.resizeSectionsArrays(layer, diff, true);
        }
    }

    private void resizeSectionsArrays(int layer, int diff, boolean appendNew) {
        char[][] tmplight;
        char[][] tmpBlocks = new char[this.sectionCount][];
        int destPos = appendNew ? 0 : diff;
        System.arraycopy(this.blocks, 0, tmpBlocks, destPos, this.blocks.length);
        this.blocks = tmpBlocks;
        if (this.biomes != null) {
            BiomeType[][] tmpBiomes = new BiomeType[this.sectionCount][64];
            System.arraycopy(this.biomes, 0, tmpBiomes, destPos, this.biomes.length);
            this.biomes = tmpBiomes;
        }
        if (this.light != null) {
            tmplight = new char[this.sectionCount][];
            System.arraycopy(this.light, 0, tmplight, destPos, this.light.length);
            this.light = tmplight;
        }
        if (this.skyLight != null) {
            tmplight = new char[this.sectionCount][];
            System.arraycopy(this.skyLight, 0, tmplight, destPos, this.skyLight.length);
            this.skyLight = tmplight;
        }
    }
}

