/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util.task;

import com.fastasyncworldedit.core.util.task.FaweForkJoinThread;
import com.fastasyncworldedit.core.util.task.FaweThread;
import com.sk89q.worldedit.extent.Extent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class FaweThreadUtil {
    private static final ThreadLocal<Extent> EXTENTS = new ThreadLocal();

    private FaweThreadUtil() {
    }

    public static void clearCurrentExtent() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FaweThread) {
            FaweThread ft = (FaweThread)((Object)thread);
            ft.clearCurrentExtent();
        } else {
            EXTENTS.remove();
        }
    }

    public static void setCurrentExtent(Extent extent) {
        Thread thread = Thread.currentThread();
        if (thread instanceof FaweForkJoinThread) {
            FaweForkJoinThread ft = (FaweForkJoinThread)thread;
            ft.setCurrentExtent(extent);
        } else {
            EXTENTS.set(extent);
        }
    }

    public static Extent getCurrentExtent() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FaweForkJoinThread) {
            FaweForkJoinThread ft = (FaweForkJoinThread)thread;
            return ft.getCurrentExtent();
        }
        return EXTENTS.get();
    }
}

