/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.ext.fawe.v1_21_6;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.ext.fawe.v1_21_6.PaperweightDataConverters;
import com.sk89q.worldedit.bukkit.adapter.ext.fawe.v1_21_6.PaperweightFakePlayer;
import com.sk89q.worldedit.bukkit.adapter.ext.fawe.v1_21_6.PaperweightServerLevelDelegateProxy;
import com.sk89q.worldedit.bukkit.adapter.ext.fawe.v1_21_6.PaperweightWorldNativeAccess;
import com.sk89q.worldedit.bukkit.adapter.ext.fawe.v1_21_6.StaticRefraction;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_6.PaperweightFaweAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_6.PaperweightPlatformAdapter;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.Watchdog;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.internal.wna.WorldNativeAccess;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.serializer.gson.GsonComponentSerializer;
import com.sk89q.worldedit.util.io.file.SafeFiles;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.biome.BiomeCategory;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.entity.EntityTypes;
import com.sk89q.worldedit.world.generation.ConfiguredFeatureType;
import com.sk89q.worldedit.world.generation.StructureType;
import com.sk89q.worldedit.world.item.ItemType;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.Clearable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.generator.ChunkGenerator;
import org.enginehub.linbus.common.LinTagId;
import org.enginehub.linbus.tree.LinByteArrayTag;
import org.enginehub.linbus.tree.LinByteTag;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinDoubleTag;
import org.enginehub.linbus.tree.LinEndTag;
import org.enginehub.linbus.tree.LinFloatTag;
import org.enginehub.linbus.tree.LinIntArrayTag;
import org.enginehub.linbus.tree.LinIntTag;
import org.enginehub.linbus.tree.LinListTag;
import org.enginehub.linbus.tree.LinLongArrayTag;
import org.enginehub.linbus.tree.LinLongTag;
import org.enginehub.linbus.tree.LinShortTag;
import org.enginehub.linbus.tree.LinStringTag;
import org.enginehub.linbus.tree.LinTag;
import org.enginehub.linbus.tree.LinTagType;
import org.jetbrains.annotations.Nullable;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public final class PaperweightAdapter
implements BukkitImplAdapter<Tag> {
    private final Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private final Field serverWorldsField;
    private final Method getChunkFutureMethod;
    private final Field chunkProviderExecutorField;
    private final PaperweightDataConverters dataFixer;
    private final Watchdog watchdog;
    private static final RandomSource random = RandomSource.create();
    private static final HashMap<BiomeType, Holder<Biome>> biomeTypeToNMSCache = new HashMap();
    private static final HashMap<Holder<Biome>, BiomeType> biomeTypeFromNMSCache = new HashMap();
    private static final LoadingCache<net.minecraft.world.level.block.state.properties.Property<?>, Property<?>> PROPERTY_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(PaperweightFaweAdapter::adaptProperty));
    private static final Codec<DataComponentPatch> COMPONENTS_CODEC = DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).codec();
    private final LoadingCache<ServerLevel, PaperweightFakePlayer> fakePlayers = CacheBuilder.newBuilder().weakKeys().softValues().build(CacheLoader.from(PaperweightFakePlayer::new));
    private static final Set<SideEffect> SUPPORTED_SIDE_EFFECTS = Sets.immutableEnumSet((Enum)SideEffect.NEIGHBORS, (Enum[])new SideEffect[]{SideEffect.LIGHTING, SideEffect.VALIDATION, SideEffect.ENTITY_AI, SideEffect.EVENTS, SideEffect.UPDATE});

    public PaperweightAdapter() throws NoSuchFieldException, NoSuchMethodException {
        Watchdog watchdog;
        CraftServer.class.cast(Bukkit.getServer());
        int dataVersion = SharedConstants.getCurrentVersion().dataVersion().version();
        if (dataVersion != 4435 && dataVersion != 4438 && dataVersion != 4440) {
            throw new UnsupportedClassVersionError("Not 1.21.(6/7/8)!");
        }
        this.serverWorldsField = CraftServer.class.getDeclaredField("worlds");
        this.serverWorldsField.setAccessible(true);
        this.getChunkFutureMethod = ServerChunkCache.class.getDeclaredMethod(StaticRefraction.GET_CHUNK_FUTURE_MAIN_THREAD, Integer.TYPE, Integer.TYPE, ChunkStatus.class, Boolean.TYPE);
        this.getChunkFutureMethod.setAccessible(true);
        this.chunkProviderExecutorField = ServerChunkCache.class.getDeclaredField(StaticRefraction.MAIN_THREAD_PROCESSOR);
        this.chunkProviderExecutorField.setAccessible(true);
        this.dataFixer = new PaperweightDataConverters(dataVersion, this);
        try {
            Class.forName("org.spigotmc.WatchdogThread");
            watchdog = new SpigotWatchdog();
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            try {
                watchdog = new MojangWatchdog(((CraftServer)Bukkit.getServer()).getServer());
            }
            catch (NoSuchFieldException ex) {
                watchdog = null;
            }
        }
        this.watchdog = watchdog;
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            SpigotConfig.config.set("world-settings.worldeditregentempworld.verbose", (Object)false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public DataFixer getDataFixer() {
        return this.dataFixer;
    }

    static void readTagIntoTileEntity(CompoundTag tag, BlockEntity tileEntity) {
        ValueInput input = PaperweightPlatformAdapter.createInput(tag);
        tileEntity.loadWithComponents(input);
        tileEntity.setChanged();
    }

    private static String getEntityId(net.minecraft.world.entity.Entity entity) {
        return EntityType.getKey((EntityType)entity.getType()).toString();
    }

    private static boolean readEntityIntoTag(net.minecraft.world.entity.Entity entity, CompoundTag tag) {
        TagValueOutput output = PaperweightPlatformAdapter.createOutput(tag);
        return entity.save((ValueOutput)output);
    }

    private static Block getBlockFromType(BlockType blockType) {
        return (Block)DedicatedServer.getServer().registryAccess().lookupOrThrow(Registries.BLOCK).getValue(ResourceLocation.tryParse((String)blockType.id()));
    }

    private static Item getItemFromType(ItemType itemType) {
        return (Item)DedicatedServer.getServer().registryAccess().lookupOrThrow(Registries.ITEM).getValue(ResourceLocation.tryParse((String)itemType.id()));
    }

    @Override
    public OptionalInt getInternalBlockStateId(BlockData data) {
        net.minecraft.world.level.block.state.BlockState state = ((CraftBlockData)data).getState();
        int combinedId = Block.getId((net.minecraft.world.level.block.state.BlockState)state);
        return combinedId == 0 && state.getBlock() != Blocks.AIR ? OptionalInt.empty() : OptionalInt.of(combinedId);
    }

    @Override
    public OptionalInt getInternalBlockStateId(BlockState state) {
        Block mcBlock = PaperweightAdapter.getBlockFromType(state.getBlockType());
        net.minecraft.world.level.block.state.BlockState newState = mcBlock.defaultBlockState();
        Map<Property<?>, Object> states = state.getStates();
        newState = this.applyProperties((StateDefinition<Block, net.minecraft.world.level.block.state.BlockState>)mcBlock.getStateDefinition(), newState, states);
        int combinedId = Block.getId((net.minecraft.world.level.block.state.BlockState)newState);
        return combinedId == 0 && state.getBlockType() != BlockTypes.AIR ? OptionalInt.empty() : OptionalInt.of(combinedId);
    }

    public BlockState adapt(net.minecraft.world.level.block.state.BlockState blockState) {
        int internalId = Block.getId((net.minecraft.world.level.block.state.BlockState)blockState);
        BlockState state = BlockStateIdAccess.getBlockStateById(internalId);
        if (state == null) {
            state = BukkitAdapter.adapt((BlockData)CraftBlockData.createData((net.minecraft.world.level.block.state.BlockState)blockState));
        }
        return state;
    }

    public BiomeType adapt(Biome biome) {
        ResourceLocation mcBiome = ((CraftServer)Bukkit.getServer()).getServer().registryAccess().lookupOrThrow(Registries.BIOME).getKey((Object)biome);
        if (mcBiome == null) {
            return null;
        }
        return BiomeType.REGISTRY.get(mcBiome.toString());
    }

    public net.minecraft.world.level.block.state.BlockState adapt(BlockState blockState) {
        int internalId = BlockStateIdAccess.getBlockStateId(blockState);
        return Block.stateById((int)internalId);
    }

    @Override
    public BlockState getBlock(Location location) {
        Preconditions.checkNotNull((Object)location);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        ServerLevel handle = craftWorld.getHandle();
        LevelChunk chunk = handle.getChunk(x >> 4, z >> 4);
        BlockPos blockPos = new BlockPos(x, y, z);
        net.minecraft.world.level.block.state.BlockState blockData = chunk.getBlockState(blockPos);
        return this.adapt(blockData);
    }

    @Override
    public BaseBlock getFullBlock(Location location) {
        BlockPos blockPos;
        BlockState state = this.getBlock(location);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        ServerLevel handle = craftWorld.getHandle();
        LevelChunk chunk = handle.getChunk(x >> 4, z >> 4);
        BlockEntity te = chunk.getBlockEntity(blockPos = new BlockPos(x, y, z));
        if (te != null) {
            TagValueOutput output = PaperweightPlatformAdapter.createOutput();
            te.saveWithId((ValueOutput)output);
            return state.toBaseBlock(LazyReference.from(() -> (LinCompoundTag)this.toNativeLin((Tag)output.buildResult())));
        }
        return state.toBaseBlock();
    }

    @Override
    public BiomeType getBiome(Location location) {
        Preconditions.checkNotNull((Object)location);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        ServerLevel handle = craftWorld.getHandle();
        LevelChunk chunk = handle.getChunk(x >> 4, z >> 4);
        return biomeTypeFromNMSCache.computeIfAbsent((Holder<Biome>)chunk.getNoiseBiome(x >> 2, y >> 2, z >> 2), b -> BiomeType.REGISTRY.get(((ResourceKey)b.unwrapKey().orElseThrow()).location().toString()));
    }

    @Override
    public void setBiome(Location location, BiomeType biome) {
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull((Object)biome);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        ServerLevel handle = craftWorld.getHandle();
        LevelChunk chunk = handle.getChunk(x >> 4, z >> 4);
        chunk.setBiome(x >> 2, y >> 2, z >> 2, biomeTypeToNMSCache.computeIfAbsent(biome, b -> ((CraftServer)Bukkit.getServer()).getServer().registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)b.id())))));
        chunk.markUnsaved();
    }

    @Override
    public WorldNativeAccess<?, ?, ?> createWorldNativeAccess(World world) {
        return new PaperweightWorldNativeAccess(this, new WeakReference<ServerLevel>(((CraftWorld)world).getHandle()));
    }

    private static net.minecraft.core.Direction adapt(Direction face) {
        return switch (face) {
            case Direction.NORTH -> net.minecraft.core.Direction.NORTH;
            case Direction.SOUTH -> net.minecraft.core.Direction.SOUTH;
            case Direction.WEST -> net.minecraft.core.Direction.WEST;
            case Direction.EAST -> net.minecraft.core.Direction.EAST;
            case Direction.DOWN -> net.minecraft.core.Direction.DOWN;
            default -> net.minecraft.core.Direction.UP;
        };
    }

    private net.minecraft.world.level.block.state.BlockState applyProperties(StateDefinition<Block, net.minecraft.world.level.block.state.BlockState> stateContainer, net.minecraft.world.level.block.state.BlockState newState, Map<Property<?>, Object> states) {
        for (Map.Entry<Property<?>, Object> state : states.entrySet()) {
            net.minecraft.world.level.block.state.properties.Property property = stateContainer.getProperty(state.getKey().getName());
            Comparable value = (Comparable)state.getValue();
            if (property instanceof EnumProperty) {
                if (property.getValueClass() == net.minecraft.core.Direction.class) {
                    value = PaperweightAdapter.adapt((Direction)((Object)value));
                } else {
                    String enumName = (String)((Object)value);
                    value = (Comparable)((EnumProperty)property).getValue(enumName).orElseThrow(() -> new IllegalStateException("Enum property " + property.getName() + " does not contain " + enumName));
                }
            }
            newState = (net.minecraft.world.level.block.state.BlockState)newState.setValue(property, value);
        }
        return newState;
    }

    @Override
    public BaseEntity getEntity(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        CraftEntity craftEntity = (CraftEntity)entity;
        net.minecraft.world.entity.Entity mcEntity = craftEntity.getHandle();
        String id = PaperweightAdapter.getEntityId(mcEntity);
        CompoundTag tag = new CompoundTag();
        if (!PaperweightAdapter.readEntityIntoTag(mcEntity, tag)) {
            return null;
        }
        return new BaseEntity(EntityTypes.get(id), LazyReference.from(() -> (LinCompoundTag)this.toNativeLin((Tag)tag)));
    }

    @Override
    @javax.annotation.Nullable
    public Entity createEntity(Location location, BaseEntity state) {
        CompoundTag tag;
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull((Object)state);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        ServerLevel worldServer = craftWorld.getHandle();
        String entityId = state.getType().id();
        LinCompoundTag nativeTag = state.getNbt();
        if (nativeTag != null) {
            tag = (CompoundTag)this.fromNative(nativeTag);
            this.removeUnwantedEntityTagsRecursively(tag);
        } else {
            tag = new CompoundTag();
        }
        tag.putString("id", entityId);
        net.minecraft.world.entity.Entity createdEntity = EntityType.loadEntityRecursive((CompoundTag)tag, (net.minecraft.world.level.Level)craftWorld.getHandle(), (EntitySpawnReason)EntitySpawnReason.COMMAND, loadedEntity -> {
            loadedEntity.absSnapTo(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            return loadedEntity;
        });
        if (createdEntity != null) {
            worldServer.addFreshEntityWithPassengers(createdEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
            return createdEntity.getBukkitEntity();
        }
        return null;
    }

    private void removeUnwantedEntityTagsRecursively(CompoundTag tag) {
        for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
            tag.remove(name);
        }
        tag.getList("Passengers").ifPresent(nbttaglist -> {
            for (int i = 0; i < nbttaglist.size(); ++i) {
                this.removeUnwantedEntityTagsRecursively(nbttaglist.getCompoundOrEmpty(i));
            }
        });
    }

    @Override
    public com.sk89q.worldedit.util.formatting.text.Component getRichBlockName(BlockType blockType) {
        return TranslatableComponent.of(PaperweightAdapter.getBlockFromType(blockType).getDescriptionId());
    }

    @Override
    public com.sk89q.worldedit.util.formatting.text.Component getRichItemName(ItemType itemType) {
        return TranslatableComponent.of(PaperweightAdapter.getItemFromType(itemType).getDescriptionId());
    }

    @Override
    public com.sk89q.worldedit.util.formatting.text.Component getRichItemName(BaseItemStack itemStack) {
        Component itemName = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)BukkitAdapter.adapt(itemStack)).getItemName();
        DataResult result = ComponentSerialization.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)itemName);
        return GsonComponentSerializer.INSTANCE.deserialize(((JsonElement)result.getOrThrow()).toString());
    }

    @Override
    public Map<String, ? extends Property<?>> getProperties(BlockType blockType) {
        TreeMap<String, Property> properties = new TreeMap<String, Property>();
        Block block = PaperweightAdapter.getBlockFromType(blockType);
        StateDefinition blockStateList = block.getStateDefinition();
        for (net.minecraft.world.level.block.state.properties.Property state : blockStateList.getProperties()) {
            Property property = (Property)PROPERTY_CACHE.getUnchecked((Object)state);
            properties.put(property.getName(), property);
        }
        return properties;
    }

    @Override
    public void sendFakeNBT(org.bukkit.entity.Player player, BlockVector3 pos, LinCompoundTag nbtData) {
        StructureBlockEntity structureBlock = new StructureBlockEntity(new BlockPos(pos.x(), pos.y(), pos.z()), Blocks.STRUCTURE_BLOCK.defaultBlockState());
        structureBlock.setLevel((net.minecraft.world.level.Level)((CraftPlayer)player).getHandle().level());
        ((CraftPlayer)player).getHandle().connection.send((Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)structureBlock, (blockEntity, registryAccess) -> (CompoundTag)this.fromNative(nbtData)));
    }

    @Override
    public void sendFakeOP(org.bukkit.entity.Player player) {
        ((CraftPlayer)player).getHandle().connection.send((Packet)new ClientboundEntityEventPacket((net.minecraft.world.entity.Entity)((CraftPlayer)player).getHandle(), 28));
    }

    @Override
    public org.bukkit.inventory.ItemStack adapt(BaseItemStack baseItemStack) {
        RegistryAccess.Frozen registryAccess = DedicatedServer.getServer().registryAccess();
        ItemStack stack = new ItemStack((Holder)registryAccess.lookupOrThrow(Registries.ITEM).getOrThrow(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.tryParse((String)baseItemStack.getType().id()))), baseItemStack.getAmount());
        LinCompoundTag nbt = baseItemStack.getNbt();
        if (nbt != null) {
            DataComponentPatch componentPatch = (DataComponentPatch)COMPONENTS_CODEC.parse((DynamicOps)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.fromNative(nbt)).getOrThrow();
            stack.applyComponents(componentPatch);
        }
        return CraftItemStack.asCraftMirror((ItemStack)stack);
    }

    @Override
    public BaseItemStack adapt(org.bukkit.inventory.ItemStack itemStack) {
        RegistryAccess.Frozen registryAccess = DedicatedServer.getServer().registryAccess();
        ItemStack nmsStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack);
        CompoundTag tag = (CompoundTag)COMPONENTS_CODEC.encodeStart((DynamicOps)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nmsStack.getComponentsPatch()).getOrThrow();
        return new BaseItemStack(BukkitAdapter.asItemType(itemStack.getType()), LazyReference.from(() -> (LinCompoundTag)this.toNativeLin((Tag)tag)), itemStack.getAmount());
    }

    @Override
    public boolean simulateItemUse(World world, BlockVector3 position, BaseItem item, Direction face) {
        PaperweightFakePlayer fakePlayer;
        CraftWorld craftWorld = (CraftWorld)world;
        ServerLevel worldServer = craftWorld.getHandle();
        ItemStack stack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)this.adapt(item instanceof BaseItemStack ? (BaseItemStack)item : new BaseItemStack(item.getType(), item.getNbtReference(), 1)));
        try {
            fakePlayer = (PaperweightFakePlayer)((Object)this.fakePlayers.get((Object)worldServer));
        }
        catch (ExecutionException ignored) {
            return false;
        }
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, stack);
        fakePlayer.absSnapTo(position.x(), position.y(), position.z(), (float)face.toVector().toYaw(), (float)face.toVector().toPitch());
        BlockPos blockPos = new BlockPos(position.x(), position.y(), position.z());
        Vec3 blockVec = Vec3.atLowerCornerOf((Vec3i)blockPos);
        net.minecraft.core.Direction enumFacing = PaperweightAdapter.adapt(face);
        BlockHitResult rayTrace = new BlockHitResult(blockVec, enumFacing, blockPos, false);
        UseOnContext context = new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, rayTrace);
        Object result = stack.useOn(context);
        if (result != InteractionResult.SUCCESS) {
            result = worldServer.getBlockState(blockPos).useItemOn(stack, (net.minecraft.world.level.Level)worldServer, (Player)fakePlayer, InteractionHand.MAIN_HAND, rayTrace).consumesAction() ? InteractionResult.SUCCESS : stack.getItem().use((net.minecraft.world.level.Level)worldServer, (Player)fakePlayer, InteractionHand.MAIN_HAND);
        }
        return result == InteractionResult.SUCCESS;
    }

    @Override
    public boolean canPlaceAt(World world, BlockVector3 position, BlockState blockState) {
        int internalId = BlockStateIdAccess.getBlockStateId(blockState);
        net.minecraft.world.level.block.state.BlockState blockData = Block.stateById((int)internalId);
        return blockData.canSurvive((LevelReader)((CraftWorld)world).getHandle(), new BlockPos(position.x(), position.y(), position.z()));
    }

    @Override
    public boolean regenerate(World bukkitWorld, Region region, Extent extent, RegenOptions options) {
        try {
            this.doRegen(bukkitWorld, region, extent, options);
        }
        catch (Exception e) {
            throw new IllegalStateException("Regen failed.", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegen(World bukkitWorld, Region region, Extent extent, RegenOptions options) throws Exception {
        World.Environment env = bukkitWorld.getEnvironment();
        ChunkGenerator gen = bukkitWorld.getGenerator();
        Path tempDir = Files.createTempDirectory("WorldEditWorldGen", new FileAttribute[0]);
        LevelStorageSource levelStorage = LevelStorageSource.createDefault((Path)tempDir);
        ResourceKey<LevelStem> worldDimKey = this.getWorldDimKey(env);
        try (LevelStorageSource.LevelStorageAccess session = levelStorage.createAccess("worldeditregentempworld", worldDimKey);){
            ServerLevel originalWorld = ((CraftWorld)bukkitWorld).getHandle();
            PrimaryLevelData levelProperties = (PrimaryLevelData)originalWorld.getServer().getWorldData().overworldData();
            WorldOptions originalOpts = levelProperties.worldGenOptions();
            long seed = options.getSeed().orElse(originalWorld.getSeed());
            WorldOptions newOpts = options.getSeed().isPresent() ? originalOpts.withSeed(OptionalLong.of(seed)) : originalOpts;
            LevelSettings newWorldSettings = new LevelSettings("worldeditregentempworld", levelProperties.settings.gameType(), levelProperties.settings.hardcore(), levelProperties.settings.difficulty(), levelProperties.settings.allowCommands(), levelProperties.settings.gameRules(), levelProperties.settings.getDataConfiguration());
            PrimaryLevelData.SpecialWorldProperty specialWorldProperty = levelProperties.isFlatWorld() ? PrimaryLevelData.SpecialWorldProperty.FLAT : (levelProperties.isDebugWorld() ? PrimaryLevelData.SpecialWorldProperty.DEBUG : PrimaryLevelData.SpecialWorldProperty.NONE);
            PrimaryLevelData newWorldData = new PrimaryLevelData(newWorldSettings, newOpts, specialWorldProperty, Lifecycle.stable());
            ServerLevel freshWorld = new ServerLevel(originalWorld.getServer(), originalWorld.getServer().executor, session, newWorldData, originalWorld.dimension(), new LevelStem(originalWorld.dimensionTypeRegistration(), originalWorld.getChunkSource().getGenerator()), (ChunkProgressListener)new NoOpWorldLoadListener(), originalWorld.isDebug(), seed, (List)ImmutableList.of(), false, originalWorld.getRandomSequences(), env, gen, bukkitWorld.getBiomeProvider());
            try {
                this.regenForWorld(region, extent, freshWorld, options);
            }
            finally {
                freshWorld.getChunkSource().close(false);
            }
        }
        finally {
            try {
                Map map = (Map)this.serverWorldsField.get(Bukkit.getServer());
                map.remove("worldeditregentempworld");
            }
            catch (IllegalAccessException illegalAccessException) {}
            SafeFiles.tryHardToDeleteDir(tempDir);
        }
    }

    private BiomeType adapt(ServerLevel serverWorld, Biome origBiome) {
        ResourceLocation key = serverWorld.registryAccess().lookupOrThrow(Registries.BIOME).getKey((Object)origBiome);
        if (key == null) {
            return null;
        }
        return BiomeTypes.get(key.toString());
    }

    private void regenForWorld(Region region, Extent extent, ServerLevel serverWorld, RegenOptions options) throws WorldEditException {
        BlockableEventLoop executor;
        List<CompletableFuture<ChunkAccess>> chunkLoadings = this.submitChunkLoadTasks(region, serverWorld);
        try {
            executor = (BlockableEventLoop)this.chunkProviderExecutorField.get(serverWorld.getChunkSource());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Couldn't get executor for chunk loading.", e);
        }
        executor.managedBlock(() -> {
            if (chunkLoadings.stream().anyMatch(ftr -> ftr.isDone() && Futures.getUnchecked((Future)ftr) == null)) {
                return false;
            }
            return chunkLoadings.stream().allMatch(CompletableFuture::isDone);
        });
        HashMap<ChunkPos, ChunkAccess> chunks = new HashMap<ChunkPos, ChunkAccess>();
        for (CompletableFuture<ChunkAccess> future : chunkLoadings) {
            ChunkAccess chunk = future.getNow(null);
            Preconditions.checkState((chunk != null ? 1 : 0) != 0, (Object)"Failed to generate a chunk, regen failed.");
            chunks.put(chunk.getPos(), chunk);
        }
        for (BlockVector3 vec : region) {
            Biome origBiome;
            BiomeType adaptedBiome;
            BlockPos pos = new BlockPos(vec.x(), vec.y(), vec.z());
            ChunkAccess chunk = (ChunkAccess)chunks.get(new ChunkPos(pos));
            net.minecraft.world.level.block.state.BlockState blockData = chunk.getBlockState(pos);
            int internalId = Block.getId((net.minecraft.world.level.block.state.BlockState)blockData);
            BlockStateHolder<BlockState> state = BlockStateIdAccess.getBlockStateById(internalId);
            Objects.requireNonNull(state);
            BlockEntity blockEntity = chunk.getBlockEntity(pos);
            if (blockEntity != null) {
                TagValueOutput output = PaperweightPlatformAdapter.createOutput();
                blockEntity.saveWithId((ValueOutput)output);
                state = state.toBaseBlock(LazyReference.from(() -> (LinCompoundTag)this.toNativeLin((Tag)output.buildResult())));
            }
            extent.setBlock(vec, state.toBaseBlock());
            if (!options.shouldRegenBiomes() || (adaptedBiome = this.adapt(serverWorld, origBiome = (Biome)chunk.getNoiseBiome(vec.x(), vec.y(), vec.z()).value())) == null) continue;
            extent.setBiome(vec, adaptedBiome);
        }
    }

    private List<CompletableFuture<ChunkAccess>> submitChunkLoadTasks(Region region, ServerLevel serverWorld) {
        ServerChunkCache chunkManager = serverWorld.getChunkSource();
        ArrayList<CompletableFuture<ChunkAccess>> chunkLoadings = new ArrayList<CompletableFuture<ChunkAccess>>();
        for (BlockVector2 chunk : region.getChunks()) {
            try {
                chunkLoadings.add((CompletableFuture<ChunkAccess>)((CompletableFuture)this.getChunkFutureMethod.invoke((Object)chunkManager, chunk.x(), chunk.z(), ChunkStatus.FEATURES, true)).thenApply(either -> (ChunkAccess)either.orElse(null)));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Couldn't load chunk for regen.", e);
            }
        }
        return chunkLoadings;
    }

    private ResourceKey<LevelStem> getWorldDimKey(World.Environment env) {
        return switch (env) {
            case World.Environment.NETHER -> LevelStem.NETHER;
            case World.Environment.THE_END -> LevelStem.END;
            default -> LevelStem.OVERWORLD;
        };
    }

    @Override
    public Set<SideEffect> getSupportedSideEffects() {
        return SUPPORTED_SIDE_EFFECTS;
    }

    @Override
    public boolean clearContainerBlockContents(World world, BlockVector3 pt) {
        ServerLevel originalWorld = ((CraftWorld)world).getHandle();
        BlockEntity entity = originalWorld.getBlockEntity(new BlockPos(pt.x(), pt.y(), pt.z()));
        if (entity instanceof Clearable) {
            ((Clearable)entity).clearContent();
            return true;
        }
        return false;
    }

    @Override
    public void initializeRegistries() {
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        for (ResourceLocation name : server.registryAccess().lookupOrThrow(Registries.BIOME).keySet()) {
            if (BiomeType.REGISTRY.get(name.toString()) != null) continue;
            BiomeType.REGISTRY.register(name.toString(), new BiomeType(name.toString()));
        }
        for (ResourceLocation name : server.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE).keySet()) {
            if (ConfiguredFeatureType.REGISTRY.get(name.toString()) != null) continue;
            ConfiguredFeatureType.REGISTRY.register(name.toString(), new ConfiguredFeatureType(name.toString()));
        }
        for (ResourceLocation name : server.registryAccess().lookupOrThrow(Registries.STRUCTURE).keySet()) {
            if (StructureType.REGISTRY.get(name.toString()) != null) continue;
            StructureType.REGISTRY.register(name.toString(), new StructureType(name.toString()));
        }
        Registry biomeRegistry = server.registryAccess().lookupOrThrow(Registries.BIOME);
        biomeRegistry.getTags().forEach(tag -> {
            String key = tag.key().location().toString();
            if (BiomeCategory.REGISTRY.get(key) == null) {
                BiomeCategory.REGISTRY.register(key, new BiomeCategory(key, () -> biomeRegistry.get(tag.key()).stream().flatMap(HolderSet.ListBacked::stream).map(Holder::value).map(this::adapt).collect(Collectors.toSet())));
            }
        });
    }

    @Override
    public boolean generateFeature(ConfiguredFeatureType type, World world, EditSession session, BlockVector3 pt) {
        boolean bl;
        block8: {
            ServerLevel originalWorld = ((CraftWorld)world).getHandle();
            ConfiguredFeature feature = (ConfiguredFeature)originalWorld.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE).getValue(ResourceLocation.tryParse((String)type.id()));
            ServerChunkCache chunkManager = originalWorld.getChunkSource();
            PaperweightServerLevelDelegateProxy.LevelAndProxy proxyLevel = PaperweightServerLevelDelegateProxy.newInstance(session, originalWorld, this);
            try {
                boolean bl2 = bl = feature != null && feature.place(proxyLevel.level(), chunkManager.getGenerator(), random, new BlockPos(pt.x(), pt.y(), pt.z()));
                if (proxyLevel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (proxyLevel != null) {
                        try {
                            proxyLevel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MaxChangedBlocksException e) {
                    throw new RuntimeException(e);
                }
            }
            proxyLevel.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean generateStructure(StructureType type, World world, EditSession session, BlockVector3 pt) {
        ServerLevel originalWorld = ((CraftWorld)world).getHandle();
        Registry structureRegistry = originalWorld.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        Structure structure = (Structure)structureRegistry.getValue(ResourceLocation.tryParse((String)type.id()));
        if (structure == null) {
            return false;
        }
        ServerChunkCache chunkManager = originalWorld.getChunkSource();
        try (PaperweightServerLevelDelegateProxy.LevelAndProxy proxyLevel = PaperweightServerLevelDelegateProxy.newInstance(session, originalWorld, this);){
            ChunkPos chunkPos = new ChunkPos(new BlockPos(pt.x(), pt.y(), pt.z()));
            StructureStart structureStart = structure.generate(structureRegistry.wrapAsHolder((Object)structure), originalWorld.dimension(), originalWorld.registryAccess(), chunkManager.getGenerator(), chunkManager.getGenerator().getBiomeSource(), chunkManager.randomState(), originalWorld.getStructureManager(), originalWorld.getSeed(), chunkPos, 0, (LevelHeightAccessor)proxyLevel.level(), biome -> true);
            if (!structureStart.isValid()) {
                boolean bl2 = false;
                return bl2;
            }
            BoundingBox boundingBox = structureStart.getBoundingBox();
            ChunkPos min = new ChunkPos(SectionPos.blockToSectionCoord((int)boundingBox.minX()), SectionPos.blockToSectionCoord((int)boundingBox.minZ()));
            ChunkPos max = new ChunkPos(SectionPos.blockToSectionCoord((int)boundingBox.maxX()), SectionPos.blockToSectionCoord((int)boundingBox.maxZ()));
            ChunkPos.rangeClosed((ChunkPos)min, (ChunkPos)max).forEach(chunkPosx -> structureStart.placeInChunk(proxyLevel.level(), originalWorld.structureManager(), chunkManager.getGenerator(), originalWorld.getRandom(), new BoundingBox(chunkPosx.getMinBlockX(), originalWorld.getMinY(), chunkPosx.getMinBlockZ(), chunkPosx.getMaxBlockX(), originalWorld.getMaxY(), chunkPosx.getMaxBlockZ()), chunkPosx));
            boolean bl = true;
            return bl;
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendBiomeUpdates(World world, Iterable<BlockVector2> chunks) {
        ArrayList arrayList;
        ServerLevel originalWorld = ((CraftWorld)world).getHandle();
        if (chunks instanceof Collection) {
            Collection chunkCollection = (Collection)chunks;
            arrayList = Lists.newArrayListWithCapacity((int)chunkCollection.size());
        } else {
            arrayList = Lists.newArrayList();
        }
        ArrayList nativeChunks = arrayList;
        for (BlockVector2 chunk : chunks) {
            nativeChunks.add(originalWorld.getChunk(chunk.x(), chunk.z(), ChunkStatus.BIOMES, false));
        }
        originalWorld.getChunkSource().chunkMap.resendBiomesForChunks((List)nativeChunks);
    }

    @Override
    public LinTag<?> toNativeLin(Tag foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)foreign;
            LinCompoundTag.Builder builder = LinCompoundTag.builder();
            for (String entry : compoundTag.keySet()) {
                builder.put(entry, this.toNativeLin(compoundTag.get(entry)));
            }
            return builder.build();
        }
        if (foreign instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)foreign;
            return LinByteTag.of(byteTag.byteValue());
        }
        if (foreign instanceof ByteArrayTag) {
            ByteArrayTag byteArrayTag = (ByteArrayTag)foreign;
            return LinByteArrayTag.of(byteArrayTag.getAsByteArray());
        }
        if (foreign instanceof DoubleTag) {
            DoubleTag doubleTag = (DoubleTag)foreign;
            return LinDoubleTag.of(doubleTag.doubleValue());
        }
        if (foreign instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)foreign;
            return LinFloatTag.of(floatTag.floatValue());
        }
        if (foreign instanceof IntTag) {
            IntTag intTag = (IntTag)foreign;
            return LinIntTag.of(intTag.intValue());
        }
        if (foreign instanceof IntArrayTag) {
            IntArrayTag intArrayTag = (IntArrayTag)foreign;
            return LinIntArrayTag.of(intArrayTag.getAsIntArray());
        }
        if (foreign instanceof LongArrayTag) {
            LongArrayTag longArrayTag = (LongArrayTag)foreign;
            return LinLongArrayTag.of(longArrayTag.getAsLongArray());
        }
        if (foreign instanceof ListTag) {
            ListTag listTag = (ListTag)foreign;
            try {
                return this.toNativeList(listTag);
            }
            catch (Throwable e) {
                this.logger.log(Level.WARNING, "Failed to convert net.minecraft.nbt.ListTag", e);
                return LinListTag.empty(LinTagType.endTag());
            }
        }
        if (foreign instanceof LongTag) {
            LongTag longTag = (LongTag)foreign;
            return LinLongTag.of(longTag.longValue());
        }
        if (foreign instanceof ShortTag) {
            ShortTag shortTag = (ShortTag)foreign;
            return LinShortTag.of(shortTag.shortValue());
        }
        if (foreign instanceof StringTag) {
            StringTag stringTag = (StringTag)foreign;
            return LinStringTag.of(stringTag.value());
        }
        if (foreign instanceof EndTag) {
            return LinEndTag.instance();
        }
        throw new IllegalArgumentException("Don't know how to make native " + foreign.getClass().getCanonicalName());
    }

    @Override
    public Tag fromNativeLin(LinTag<?> foreign) {
        return this.fromNative(foreign);
    }

    private static byte identifyRawElementType(ListTag list) {
        byte b = 0;
        for (Tag tag : list) {
            byte c = tag.getId();
            if (b == 0) {
                b = c;
                continue;
            }
            if (b == c) continue;
            return 10;
        }
        return b;
    }

    private static CompoundTag wrapTag(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return compoundTag;
        }
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("", tag);
        return compoundTag;
    }

    private LinListTag<?> toNativeList(ListTag foreign) throws SecurityException, IllegalArgumentException {
        byte rawType = PaperweightAdapter.identifyRawElementType(foreign);
        LinListTag.Builder<LinTag<?>> builder = LinListTag.builder(LinTagType.fromId(LinTagId.fromId(rawType)));
        for (Tag tag : foreign) {
            if (rawType == LinTagId.COMPOUND.id() && !(tag instanceof CompoundTag)) {
                builder.add(this.toNativeLin((Tag)PaperweightAdapter.wrapTag(tag)));
                continue;
            }
            builder.add(this.toNativeLin(tag));
        }
        return builder.build();
    }

    Tag fromNative(LinTag<?> foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof LinCompoundTag) {
            LinCompoundTag compoundTag = (LinCompoundTag)foreign;
            CompoundTag tag = new CompoundTag();
            for (Map.Entry entry : compoundTag.value().entrySet()) {
                tag.put((String)entry.getKey(), this.fromNative((LinTag)entry.getValue()));
            }
            return tag;
        }
        if (foreign instanceof LinByteTag) {
            LinByteTag byteTag = (LinByteTag)foreign;
            return ByteTag.valueOf((byte)byteTag.valueAsByte());
        }
        if (foreign instanceof LinByteArrayTag) {
            LinByteArrayTag byteArrayTag = (LinByteArrayTag)foreign;
            return new ByteArrayTag(byteArrayTag.value());
        }
        if (foreign instanceof LinDoubleTag) {
            LinDoubleTag doubleTag = (LinDoubleTag)foreign;
            return DoubleTag.valueOf((double)doubleTag.valueAsDouble());
        }
        if (foreign instanceof LinFloatTag) {
            LinFloatTag floatTag = (LinFloatTag)foreign;
            return FloatTag.valueOf((float)floatTag.valueAsFloat());
        }
        if (foreign instanceof LinIntTag) {
            LinIntTag intTag = (LinIntTag)foreign;
            return IntTag.valueOf((int)intTag.valueAsInt());
        }
        if (foreign instanceof LinIntArrayTag) {
            LinIntArrayTag intArrayTag = (LinIntArrayTag)foreign;
            return new IntArrayTag(intArrayTag.value());
        }
        if (foreign instanceof LinLongArrayTag) {
            LinLongArrayTag longArrayTag = (LinLongArrayTag)foreign;
            return new LongArrayTag(longArrayTag.value());
        }
        if (foreign instanceof LinListTag) {
            LinListTag listTag = (LinListTag)foreign;
            ListTag tag = new ListTag();
            Iterator iterator = listTag.value().iterator();
            while (iterator.hasNext()) {
                LinTag t = (LinTag)iterator.next();
                tag.addAndUnwrap(this.fromNative(t));
            }
            return tag;
        }
        if (foreign instanceof LinLongTag) {
            LinLongTag longTag = (LinLongTag)foreign;
            return LongTag.valueOf((long)longTag.valueAsLong());
        }
        if (foreign instanceof LinShortTag) {
            LinShortTag shortTag = (LinShortTag)foreign;
            return ShortTag.valueOf((short)shortTag.valueAsShort());
        }
        if (foreign instanceof LinStringTag) {
            LinStringTag stringTag = (LinStringTag)foreign;
            return StringTag.valueOf((String)stringTag.value());
        }
        if (foreign instanceof LinEndTag) {
            return EndTag.INSTANCE;
        }
        throw new IllegalArgumentException("Don't know how to make NMS " + foreign.getClass().getCanonicalName());
    }

    @Override
    public boolean supportsWatchdog() {
        return this.watchdog != null;
    }

    @Override
    public void tickWatchdog() {
        this.watchdog.tick();
    }

    private class SpigotWatchdog
    implements Watchdog {
        private final Field instanceField;
        private final Field lastTickField;

        SpigotWatchdog() throws NoSuchFieldException {
            Field instanceField = WatchdogThread.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            this.instanceField = instanceField;
            Field lastTickField = WatchdogThread.class.getDeclaredField("lastTick");
            lastTickField.setAccessible(true);
            this.lastTickField = lastTickField;
        }

        @Override
        public void tick() {
            try {
                WatchdogThread instance = (WatchdogThread)this.instanceField.get(null);
                if ((Long)this.lastTickField.get(instance) != 0L) {
                    WatchdogThread.tick();
                }
            }
            catch (IllegalAccessException e) {
                PaperweightAdapter.this.logger.log(Level.WARNING, "Failed to tick watchdog", e);
            }
        }
    }

    private static class MojangWatchdog
    implements Watchdog {
        private final DedicatedServer server;
        private final Field tickField;

        MojangWatchdog(DedicatedServer server) throws NoSuchFieldException {
            this.server = server;
            Field tickField = MinecraftServer.class.getDeclaredField(StaticRefraction.NEXT_TICK_TIME);
            if (tickField.getType() != Long.TYPE) {
                throw new IllegalStateException("nextTickTime is not a long field, mapping is likely incorrect");
            }
            tickField.setAccessible(true);
            this.tickField = tickField;
        }

        @Override
        public void tick() {
            try {
                this.tickField.set(this.server, Util.getMillis());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static class NoOpWorldLoadListener
    implements ChunkProgressListener {
        private NoOpWorldLoadListener() {
        }

        public void updateSpawnPos(ChunkPos spawnPos) {
        }

        public void onStatusChange(ChunkPos pos, @Nullable ChunkStatus status) {
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

