/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R2;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.math.IntPair;
import com.fastasyncworldedit.core.util.TaskManager;
import com.fastasyncworldedit.core.util.task.RunnableVal;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R2.PaperweightFaweAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R2.PaperweightPlatformAdapter;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.internal.wna.WorldNativeAccess;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.block.BlockState;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.block.data.CraftBlockData;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinTag;

public class PaperweightFaweWorldNativeAccess
implements WorldNativeAccess<LevelChunk, net.minecraft.world.level.block.state.BlockState, BlockPos> {
    private static final int UPDATE = 1;
    private static final int NOTIFY = 2;
    private static final Direction[] NEIGHBOUR_ORDER = new Direction[]{Direction.EAST, Direction.WEST, Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH};
    private final PaperweightFaweAdapter paperweightFaweAdapter;
    private final WeakReference<Level> level;
    private final AtomicInteger lastTick;
    private final Set<CachedChange> cachedChanges = new HashSet<CachedChange>();
    private final Set<IntPair> cachedChunksToSend = new HashSet<IntPair>();
    private SideEffectSet sideEffectSet;

    public PaperweightFaweWorldNativeAccess(PaperweightFaweAdapter paperweightFaweAdapter, WeakReference<Level> level) {
        this.paperweightFaweAdapter = paperweightFaweAdapter;
        this.level = level;
        this.lastTick = new AtomicInteger(MinecraftServer.currentTick);
    }

    private Level getLevel() {
        return Objects.requireNonNull((Level)this.level.get(), "The reference to the world was lost");
    }

    @Override
    public void setCurrentSideEffectSet(SideEffectSet sideEffectSet) {
        this.sideEffectSet = sideEffectSet;
    }

    @Override
    public LevelChunk getChunk(int x, int z) {
        return this.getLevel().getChunk(x, z);
    }

    @Override
    public net.minecraft.world.level.block.state.BlockState toNative(BlockState blockState) {
        int stateId = this.paperweightFaweAdapter.ordinalToIbdID(blockState.getOrdinalChar());
        return BlockStateIdAccess.isValidInternalId(stateId) ? Block.stateById((int)stateId) : ((CraftBlockData)BukkitAdapter.adapt(blockState)).getState();
    }

    @Override
    public net.minecraft.world.level.block.state.BlockState getBlockState(LevelChunk levelChunk, BlockPos blockPos) {
        return levelChunk.getBlockState(blockPos);
    }

    @Override
    @Nullable
    public synchronized net.minecraft.world.level.block.state.BlockState setBlockState(LevelChunk levelChunk, BlockPos blockPos, net.minecraft.world.level.block.state.BlockState blockState) {
        boolean nextTick;
        int currentTick = MinecraftServer.currentTick;
        if (Fawe.isMainThread()) {
            return levelChunk.setBlockState(blockPos, blockState, this.sideEffectSet != null && this.sideEffectSet.shouldApply(SideEffect.UPDATE));
        }
        this.cachedChanges.add(new CachedChange(levelChunk, blockPos, blockState));
        this.cachedChunksToSend.add(new IntPair(levelChunk.locX, levelChunk.locZ));
        boolean bl = nextTick = this.lastTick.get() > currentTick;
        if (nextTick || this.cachedChanges.size() >= 1024) {
            if (nextTick) {
                this.lastTick.set(currentTick);
            }
            this.flushAsync(nextTick);
        }
        return blockState;
    }

    @Override
    public net.minecraft.world.level.block.state.BlockState getValidBlockForPosition(net.minecraft.world.level.block.state.BlockState blockState, BlockPos blockPos) {
        return Block.updateFromNeighbourShapes((net.minecraft.world.level.block.state.BlockState)blockState, (LevelAccessor)this.getLevel(), (BlockPos)blockPos);
    }

    @Override
    public BlockPos getPosition(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    @Override
    public void updateLightingForBlock(BlockPos blockPos) {
        this.getLevel().getChunkSource().getLightEngine().checkBlock(blockPos);
    }

    @Override
    public boolean updateTileEntity(BlockPos blockPos, LinCompoundTag tag) {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(blockPos);
        if (blockEntity == null) {
            return false;
        }
        Tag nativeTag = (Tag)this.paperweightFaweAdapter.fromNativeLin((LinTag)tag);
        blockEntity.load((CompoundTag)nativeTag);
        return true;
    }

    @Override
    public void notifyBlockUpdate(LevelChunk levelChunk, BlockPos blockPos, net.minecraft.world.level.block.state.BlockState oldState, net.minecraft.world.level.block.state.BlockState newState) {
        if (levelChunk.getSections()[((Level)this.level.get()).getSectionIndex(blockPos.getY())] != null) {
            this.getLevel().sendBlockUpdated(blockPos, oldState, newState, 3);
        }
    }

    @Override
    public boolean isChunkTicking(LevelChunk levelChunk) {
        return levelChunk.getFullStatus().isOrAfter(FullChunkStatus.BLOCK_TICKING);
    }

    @Override
    public void markBlockChanged(LevelChunk levelChunk, BlockPos blockPos) {
        if (levelChunk.getSections()[((Level)this.level.get()).getSectionIndex(blockPos.getY())] != null) {
            ((ServerChunkCache)this.getLevel().getChunkSource()).blockChanged(blockPos);
        }
    }

    @Override
    public void notifyNeighbors(BlockPos blockPos, net.minecraft.world.level.block.state.BlockState oldState, net.minecraft.world.level.block.state.BlockState newState) {
        Level level = this.getLevel();
        if (this.sideEffectSet.shouldApply(SideEffect.EVENTS)) {
            level.blockUpdated(blockPos, oldState.getBlock());
        } else {
            for (Direction direction : NEIGHBOUR_ORDER) {
                BlockPos shifted = blockPos.relative(direction);
                level.getBlockState(shifted).neighborChanged(level, shifted, oldState.getBlock(), blockPos, false);
            }
        }
        if (newState.hasAnalogOutputSignal()) {
            level.updateNeighbourForOutputSignal(blockPos, newState.getBlock());
        }
    }

    @Override
    public void updateNeighbors(BlockPos blockPos, net.minecraft.world.level.block.state.BlockState oldState, net.minecraft.world.level.block.state.BlockState newState, int recursionLimit) {
        CraftWorld craftWorld;
        Level level = this.getLevel();
        oldState.updateIndirectNeighbourShapes((LevelAccessor)level, blockPos, 2, recursionLimit);
        if (this.sideEffectSet.shouldApply(SideEffect.EVENTS) && (craftWorld = level.getWorld()) != null) {
            BlockPhysicsEvent event = new BlockPhysicsEvent(craftWorld.getBlockAt(blockPos.getX(), blockPos.getY(), blockPos.getZ()), (BlockData)CraftBlockData.fromData((net.minecraft.world.level.block.state.BlockState)newState));
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        newState.triggerEvent(level, blockPos, 2, recursionLimit);
        newState.updateIndirectNeighbourShapes((LevelAccessor)level, blockPos, 2, recursionLimit);
    }

    @Override
    public void updateBlock(BlockPos pos, net.minecraft.world.level.block.state.BlockState oldState, net.minecraft.world.level.block.state.BlockState newState) {
        Level world = this.getLevel();
        newState.onPlace(world, pos, oldState, false);
    }

    @Override
    public void onBlockStateChange(BlockPos blockPos, net.minecraft.world.level.block.state.BlockState oldState, net.minecraft.world.level.block.state.BlockState newState) {
        this.getLevel().onBlockStateChange(blockPos, oldState, newState);
    }

    private synchronized void flushAsync(final boolean sendChunks) {
        Set<Object> toSend;
        final Set<CachedChange> changes = Set.copyOf(this.cachedChanges);
        this.cachedChanges.clear();
        if (sendChunks) {
            toSend = Set.copyOf(this.cachedChunksToSend);
            this.cachedChunksToSend.clear();
        } else {
            toSend = Collections.emptySet();
        }
        RunnableVal<Object> runnableVal = new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                changes.forEach(cc -> cc.levelChunk.setBlockState(cc.blockPos, cc.blockState, PaperweightFaweWorldNativeAccess.this.sideEffectSet != null && PaperweightFaweWorldNativeAccess.this.sideEffectSet.shouldApply(SideEffect.UPDATE)));
                if (!sendChunks) {
                    return;
                }
                for (IntPair chunk : toSend) {
                    PaperweightPlatformAdapter.sendChunk(chunk, PaperweightFaweWorldNativeAccess.this.getLevel().getWorld().getHandle(), chunk.x(), chunk.z());
                }
            }
        };
        TaskManager.taskManager().async(() -> TaskManager.taskManager().sync(runnableVal));
    }

    @Override
    public synchronized void flush() {
        RunnableVal<Object> runnableVal = new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                PaperweightFaweWorldNativeAccess.this.cachedChanges.forEach(cc -> cc.levelChunk.setBlockState(cc.blockPos, cc.blockState, PaperweightFaweWorldNativeAccess.this.sideEffectSet != null && PaperweightFaweWorldNativeAccess.this.sideEffectSet.shouldApply(SideEffect.UPDATE)));
                for (IntPair chunk : PaperweightFaweWorldNativeAccess.this.cachedChunksToSend) {
                    PaperweightPlatformAdapter.sendChunk(chunk, PaperweightFaweWorldNativeAccess.this.getLevel().getWorld().getHandle(), chunk.x(), chunk.z());
                }
            }
        };
        if (Fawe.isMainThread()) {
            runnableVal.run();
        } else {
            TaskManager.taskManager().sync(runnableVal);
        }
        this.cachedChanges.clear();
        this.cachedChunksToSend.clear();
    }

    private record CachedChange(LevelChunk levelChunk, BlockPos blockPos, net.minecraft.world.level.block.state.BlockState blockState) {
    }
}

