/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R2;

import com.fastasyncworldedit.bukkit.adapter.StarlightRelighter;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.math.IntPair;
import com.fastasyncworldedit.core.queue.IQueueExtent;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R2.PaperweightPlatformAdapter;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkStatus;

public class PaperweightStarlightRelighter
extends StarlightRelighter<ServerLevel, ChunkPos> {
    private static final TicketType<Unit> FAWE_TICKET = TicketType.create((String)"fawe_ticket", (a, b) -> 0);
    private static final int LIGHT_LEVEL = 32 + ChunkStatus.getDistance((ChunkStatus)ChunkStatus.LIGHT);

    public PaperweightStarlightRelighter(ServerLevel serverLevel, IQueueExtent<?> queue) {
        super(serverLevel, queue);
    }

    @Override
    protected ChunkPos createChunkPos(long chunkKey) {
        return new ChunkPos(chunkKey);
    }

    @Override
    protected long asLong(int chunkX, int chunkZ) {
        return ChunkPos.asLong((int)chunkX, (int)chunkZ);
    }

    @Override
    protected CompletableFuture<?> chunkLoadFuture(ChunkPos chunkPos) {
        return ((ServerLevel)this.serverLevel).getWorld().getChunkAtAsync(chunkPos.x, chunkPos.z).thenAccept(c -> ((ServerLevel)this.serverLevel).getChunkSource().addTicketAtLevel(FAWE_TICKET, chunkPos, LIGHT_LEVEL, (Object)Unit.INSTANCE));
    }

    @Override
    protected void invokeRelight(Set<ChunkPos> coords, Consumer<ChunkPos> chunkCallback, IntConsumer processCallback) {
        try {
            ((ServerLevel)this.serverLevel).getChunkSource().getLightEngine().relight(coords, chunkCallback, processCallback);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred on relighting", (Throwable)e);
        }
    }

    @Override
    protected void postProcessChunks(Set<ChunkPos> coords) {
        boolean delay = Settings.settings().LIGHTING.DELAY_PACKET_SENDING;
        for (ChunkPos pos : coords) {
            int x = pos.x;
            int z = pos.z;
            if (delay) {
                PaperweightPlatformAdapter.sendChunk(new IntPair(x, z), (ServerLevel)this.serverLevel, x, z);
            }
            ((ServerLevel)this.serverLevel).getChunkSource().removeTicketAtLevel(FAWE_TICKET, pos, LIGHT_LEVEL, (Object)Unit.INSTANCE);
        }
    }
}

