/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3;

import com.fastasyncworldedit.bukkit.adapter.BukkitBlockMaterial;
import com.fastasyncworldedit.core.nbt.FaweCompoundTag;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3.PaperweightGetBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;

public class PaperweightBlockMaterial
extends BukkitBlockMaterial<Block, BlockState> {
    private final int opacity;

    public PaperweightBlockMaterial(Block block) {
        this(block, block.defaultBlockState());
    }

    public PaperweightBlockMaterial(Block block, BlockState blockState) {
        super(block, blockState, (BlockData)CraftBlockData.fromData((BlockState)blockState));
        this.opacity = blockState.getLightBlock((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
    }

    @Override
    protected FaweCompoundTag tileForBlock(Block block) {
        BlockEntity blockEntity;
        if (!(block instanceof EntityBlock)) {
            blockEntity = null;
        } else {
            EntityBlock eb = (EntityBlock)block;
            blockEntity = eb.newBlockEntity(BlockPos.ZERO, (BlockState)this.blockState);
        }
        BlockEntity tileEntity = blockEntity;
        return tileEntity == null ? null : PaperweightGetBlocks.NMS_TO_TILE.apply(tileEntity);
    }

    @Override
    public boolean isAir() {
        return ((BlockState)this.blockState).isAir();
    }

    @Override
    public boolean isFullCube() {
        return Block.isShapeFullBlock((VoxelShape)((BlockState)this.blockState).getShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO));
    }

    @Override
    public boolean isOpaque() {
        return ((BlockState)this.blockState).canOcclude();
    }

    @Override
    public boolean isPowerSource() {
        return ((BlockState)this.blockState).isSignalSource();
    }

    @Override
    public boolean isLiquid() {
        return !((BlockState)this.blockState).getFluidState().is(Fluids.EMPTY);
    }

    @Override
    public boolean isSolid() {
        return ((BlockState)this.blockState).isSolidRender((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
    }

    @Override
    public float getHardness() {
        return ((BlockState)this.blockState).destroySpeed;
    }

    @Override
    public float getResistance() {
        return ((Block)this.block).getExplosionResistance();
    }

    @Override
    public float getSlipperiness() {
        return ((Block)this.block).getFriction();
    }

    @Override
    public int getLightValue() {
        return ((BlockState)this.blockState).getLightEmission();
    }

    @Override
    public int getLightOpacity() {
        return this.opacity;
    }

    @Override
    public boolean isFragileWhenPushed() {
        return ((BlockState)this.blockState).getPistonPushReaction() == PushReaction.DESTROY;
    }

    @Override
    public boolean isUnpushable() {
        return ((BlockState)this.blockState).getPistonPushReaction() == PushReaction.BLOCK;
    }

    @Override
    public boolean isTicksRandomly() {
        return ((BlockState)this.blockState).isRandomlyTicking();
    }

    @Override
    public boolean isMovementBlocker() {
        return ((BlockState)this.blockState).blocksMotion();
    }

    @Override
    public boolean isReplacedDuringPlacement() {
        return ((BlockState)this.blockState).canBeReplaced();
    }

    @Override
    public boolean isTranslucent() {
        return !((BlockState)this.blockState).canOcclude();
    }

    @Override
    public int getMapColor() {
        return ((Block)this.block).defaultMapColor().col;
    }
}

