/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3;

import com.fastasyncworldedit.core.extent.processor.PlacementStateProcessor;
import com.fastasyncworldedit.core.util.ExtentTraverser;
import com.fastasyncworldedit.core.wrappers.WorldWrapper;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3.PaperweightBlockMaterial;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3.PaperweightFaweAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3.PaperweightFaweMutableBlockPlaceContext;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R3.PaperweightLevelProxy;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;

public class PaperweightPlacementStateProcessor
extends PlacementStateProcessor {
    private final PaperweightFaweAdapter adapter = (PaperweightFaweAdapter)WorldEditPlugin.getInstance().getBukkitImplAdapter();
    private final PaperweightFaweMutableBlockPlaceContext mutableBlockPlaceContext;
    private final PaperweightLevelProxy proxyLevel;

    public PaperweightPlacementStateProcessor(Extent extent, BlockTypeMask mask, Region region) {
        super(extent, mask, region);
        BukkitWorld bukkitWorld;
        World world = ExtentTraverser.getWorldFromExtent(extent);
        if (world == null) {
            throw new UnsupportedOperationException("World is required for PlacementStateProcessor but none found in given extent.");
        }
        if (world instanceof WorldWrapper) {
            WorldWrapper wrapper = (WorldWrapper)world;
            bukkitWorld = (BukkitWorld)wrapper.getParent();
        } else {
            bukkitWorld = (BukkitWorld)world;
        }
        this.proxyLevel = PaperweightLevelProxy.getInstance(((CraftWorld)bukkitWorld.getWorld()).getHandle(), this);
        this.mutableBlockPlaceContext = new PaperweightFaweMutableBlockPlaceContext(this.proxyLevel);
    }

    private PaperweightPlacementStateProcessor(Extent extent, BlockTypeMask mask, Map<PlacementStateProcessor.SecondPass, Character> crossChunkSecondPasses, ThreadLocal<PlacementStateProcessor> threadProcessors, Region region, AtomicBoolean finished) {
        super(extent, mask, crossChunkSecondPasses, threadProcessors, region, finished);
        BukkitWorld bukkitWorld;
        World world = ExtentTraverser.getWorldFromExtent(extent);
        if (world == null) {
            throw new UnsupportedOperationException("World is required for PlacementStateProcessor but none found in given extent.");
        }
        if (world instanceof WorldWrapper) {
            WorldWrapper wrapper = (WorldWrapper)world;
            bukkitWorld = (BukkitWorld)wrapper.getParent();
        } else {
            bukkitWorld = (BukkitWorld)world;
        }
        this.proxyLevel = PaperweightLevelProxy.getInstance(((CraftWorld)bukkitWorld.getWorld()).getHandle(), this);
        this.mutableBlockPlaceContext = new PaperweightFaweMutableBlockPlaceContext(this.proxyLevel);
    }

    @Override
    protected char getStateAtFor(int x, int y, int z, BlockState state, Vector3 clickPos, com.sk89q.worldedit.util.Direction clickedFaceDirection, BlockVector3 clickedBlock) {
        BlockPos blockPos;
        Direction side;
        Vec3 pos;
        Block block = (Block)((PaperweightBlockMaterial)state.getMaterial()).getBlock();
        net.minecraft.world.level.block.state.BlockState newState = block.getStateForPlacement((BlockPlaceContext)this.mutableBlockPlaceContext.withSetting(new BlockHitResult(pos = new Vec3(clickPos.x(), clickPos.y(), clickPos.z()), side = Direction.valueOf((String)clickedFaceDirection.toString()), blockPos = new BlockPos(clickedBlock.x(), clickedBlock.y(), clickedBlock.z()), false), side.getOpposite()));
        return newState == null ? (char)'\u0001' : this.adapter.ibdIDToOrdinal(Block.BLOCK_STATE_REGISTRY.getId((Object)newState));
    }

    @Override
    @Nullable
    public Extent construct(Extent child) {
        if (child == this.getExtent()) {
            return this;
        }
        return new PaperweightPlacementStateProcessor(child, this.mask, this.region);
    }

    @Override
    public PlacementStateProcessor fork() {
        return new PaperweightPlacementStateProcessor(this.extent, this.mask, this.postCompleteSecondPasses, this.threadProcessors, this.region, this.finished);
    }
}

