/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_4.regen;

import com.fastasyncworldedit.bukkit.adapter.Regenerator;
import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.queue.IChunkCache;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.implementation.chunk.ChunkCache;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Lifecycle;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.Refraction;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.io.file.SafeFiles;
import com.sk89q.worldedit.world.RegenOptions;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.ProgressListener;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.jetbrains.annotations.Nullable;

public class PaperweightRegen
extends Regenerator {
    private static final Field serverWorldsField;
    private static final Field paperConfigField;
    private static final Field generatorSettingBaseSupplierField;
    private ServerLevel originalServerWorld;
    private ServerLevel freshWorld;
    private LevelStorageSource.LevelStorageAccess session;
    private Path tempDir;

    public PaperweightRegen(World originalBukkitWorld, Region region, Extent target, RegenOptions options) {
        super(originalBukkitWorld, region, target, options);
    }

    @Override
    protected void runTasks(BooleanSupplier shouldKeepTicking) {
        while (shouldKeepTicking.getAsBoolean()) {
            if (this.freshWorld.getChunkSource().pollTask()) continue;
            return;
        }
    }

    @Override
    protected boolean prepare() {
        this.originalServerWorld = ((CraftWorld)this.originalBukkitWorld).getHandle();
        this.seed = this.options.getSeed().orElse(this.originalServerWorld.getSeed());
        return true;
    }

    @Override
    protected boolean initNewWorld() throws Exception {
        this.tempDir = Files.createTempDirectory("FastAsyncWorldEditWorldGen", new FileAttribute[0]);
        World.Environment environment = this.originalBukkitWorld.getEnvironment();
        ChunkGenerator generator = this.originalBukkitWorld.getGenerator();
        LevelStorageSource levelStorageSource = LevelStorageSource.createDefault((Path)this.tempDir);
        ResourceKey<LevelStem> levelStemResourceKey = this.getWorldDimKey(environment);
        this.session = levelStorageSource.createAccess("faweregentempworld", levelStemResourceKey);
        PrimaryLevelData originalWorldData = this.originalServerWorld.serverLevelData;
        DedicatedServer server = this.originalServerWorld.getCraftServer().getServer();
        WorldOptions originalOpts = originalWorldData.worldGenOptions();
        WorldOptions newOpts = this.options.getSeed().isPresent() ? originalOpts.withSeed(OptionalLong.of(this.seed)) : originalOpts;
        LevelSettings newWorldSettings = new LevelSettings("faweregentempworld", originalWorldData.settings.gameType(), originalWorldData.settings.hardcore(), originalWorldData.settings.difficulty(), originalWorldData.settings.allowCommands(), originalWorldData.settings.gameRules(), originalWorldData.settings.getDataConfiguration());
        PrimaryLevelData.SpecialWorldProperty specialWorldProperty = originalWorldData.isFlatWorld() ? PrimaryLevelData.SpecialWorldProperty.FLAT : (originalWorldData.isDebugWorld() ? PrimaryLevelData.SpecialWorldProperty.DEBUG : PrimaryLevelData.SpecialWorldProperty.NONE);
        PrimaryLevelData newWorldData = new PrimaryLevelData(newWorldSettings, newOpts, specialWorldProperty, Lifecycle.stable());
        BiomeProvider biomeProvider = this.getBiomeProvider();
        this.freshWorld = Fawe.instance().getQueueHandler().sync(() -> this.lambda$initNewWorld$0((MinecraftServer)server, newWorldData, environment, generator, biomeProvider)).get();
        this.freshWorld.noSave = true;
        this.removeWorldFromWorldsMap();
        newWorldData.checkName(this.originalServerWorld.serverLevelData.getLevelName());
        if (paperConfigField != null) {
            paperConfigField.set(this.freshWorld, this.originalServerWorld.paperConfig());
        }
        return true;
    }

    @Override
    protected void cleanup() {
        try {
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Fawe.instance().getQueueHandler().sync(() -> {
                try {
                    this.freshWorld.getChunkSource().getDataStorage().cache.clear();
                    this.freshWorld.getChunkSource().close(false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Fawe.instance().getQueueHandler().sync(this::removeWorldFromWorldsMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SafeFiles.tryHardToDeleteDir(this.tempDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected IChunkCache<IChunkGet> initSourceQueueCache() {
        return new ChunkCache<IChunkGet>(BukkitAdapter.adapt((World)this.freshWorld.getWorld()));
    }

    private void removeWorldFromWorldsMap() {
        try {
            Map map = (Map)serverWorldsField.get(Bukkit.getServer());
            map.remove("faweregentempworld");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private ResourceKey<LevelStem> getWorldDimKey(World.Environment env) {
        return switch (env) {
            case World.Environment.NETHER -> LevelStem.NETHER;
            case World.Environment.THE_END -> LevelStem.END;
            default -> LevelStem.OVERWORLD;
        };
    }

    private /* synthetic */ ServerLevel lambda$initNewWorld$0(MinecraftServer server, PrimaryLevelData newWorldData, World.Environment environment, ChunkGenerator generator, BiomeProvider biomeProvider) {
        return new ServerLevel(server, server.executor, this.session, newWorldData, this.originalServerWorld.dimension(), new LevelStem(this.originalServerWorld.dimensionTypeRegistration(), this.originalServerWorld.getChunkSource().getGenerator()), new RegenNoOpWorldLoadListener(), this.originalServerWorld.isDebug(), this.seed, (List)ImmutableList.of(), false, this.originalServerWorld.getRandomSequences(), environment, generator, biomeProvider){
            private final Holder<Biome> singleBiome;
            {
                this.singleBiome = PaperweightRegen.this.options.hasBiomeType() ? (Holder)DedicatedServer.getServer().registryAccess().lookupOrThrow(Registries.BIOME).asHolderIdMap().byIdOrThrow(WorldEditPlugin.getInstance().getBukkitImplAdapter().getInternalBiomeId(PaperweightRegen.this.options.getBiomeType())) : null;
            }

            @Nonnull
            public Holder<Biome> getUncachedNoiseBiome(int biomeX, int biomeY, int biomeZ) {
                if (PaperweightRegen.this.options.hasBiomeType()) {
                    return this.singleBiome;
                }
                return super.getUncachedNoiseBiome(biomeX, biomeY, biomeZ);
            }

            public void save(ProgressListener progressListener, boolean flush, boolean savingDisabled) {
            }

            public void save(ProgressListener progressListener, boolean flush, boolean savingDisabled, boolean close) {
            }
        };
    }

    static {
        try {
            Field tmpPaperConfigField;
            serverWorldsField = CraftServer.class.getDeclaredField("worlds");
            serverWorldsField.setAccessible(true);
            try {
                tmpPaperConfigField = Level.class.getDeclaredField("paperConfig");
                tmpPaperConfigField.setAccessible(true);
            }
            catch (Exception e) {
                tmpPaperConfigField = null;
            }
            paperConfigField = tmpPaperConfigField;
            generatorSettingBaseSupplierField = NoiseBasedChunkGenerator.class.getDeclaredField(Refraction.pickName("settings", "e"));
            generatorSettingBaseSupplierField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class RegenNoOpWorldLoadListener
    implements ChunkProgressListener {
        private RegenNoOpWorldLoadListener() {
        }

        public void updateSpawnPos(@Nonnull ChunkPos spawnPos) {
        }

        public void onStatusChange(@Nonnull ChunkPos pos, @Nullable ChunkStatus status) {
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

