/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_6;

import com.fastasyncworldedit.core.util.MathMan;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_6.PaperweightChunkAccessProxy;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import org.bukkit.craftbukkit.util.BlockStateListPopulator;

public class FaweBlockStateListPopulator
extends BlockStateListPopulator {
    private final Long2ObjectOpenHashMap<PaperweightChunkAccessProxy> chunkProxies = new Long2ObjectOpenHashMap();
    private final ServerLevel world;

    public FaweBlockStateListPopulator(ServerLevel world) {
        super((LevelAccessor)world);
        this.world = world;
    }

    public long getSeed() {
        return this.world.getSeed();
    }

    @Nonnull
    public ServerLevel getLevel() {
        return this.world.getLevel();
    }

    @Nonnull
    public DifficultyInstance getCurrentDifficultyAt(BlockPos pos) {
        return this.world.getCurrentDifficultyAt(pos);
    }

    public MinecraftServer getServer() {
        return this.world.getServer();
    }

    @Nonnull
    public ChunkSource getChunkSource() {
        return this.world.getChunkSource();
    }

    @Nonnull
    public RandomSource getRandom() {
        return this.world.getRandom();
    }

    public ChunkAccess getChunk(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        ChunkAccess worldChunk = this.world.getChunk(chunkX, chunkZ, leastStatus, create);
        PaperweightChunkAccessProxy proxy = (PaperweightChunkAccessProxy)((Object)this.chunkProxies.compute(MathMan.pairInt(chunkX, chunkZ), (k, v) -> v == null ? PaperweightChunkAccessProxy.getInstance() : v));
        proxy.parent = worldChunk;
        return proxy;
    }

    @Nonnull
    public BiomeManager getBiomeManager() {
        return this.world.getBiomeManager();
    }

    @Nonnull
    public Holder<Biome> getUncachedNoiseBiome(int biomeX, int biomeY, int biomeZ) {
        return this.world.getUncachedNoiseBiome(biomeX, biomeY, biomeZ);
    }

    public int getSeaLevel() {
        return this.world.getSeaLevel();
    }

    @Nonnull
    public ChunkAccess getChunk(@Nonnull BlockPos pos) {
        ChunkAccess worldChunk = this.world.getChunk(pos);
        PaperweightChunkAccessProxy proxy = (PaperweightChunkAccessProxy)((Object)this.chunkProxies.compute(MathMan.pairInt(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ())), (k, v) -> v == null ? PaperweightChunkAccessProxy.getInstance() : v));
        proxy.parent = worldChunk;
        return proxy;
    }

    @Nonnull
    public ChunkAccess getChunk(int chunkX, int chunkZ) {
        LevelChunk worldChunk = this.world.getChunk(chunkX, chunkZ);
        PaperweightChunkAccessProxy proxy = (PaperweightChunkAccessProxy)((Object)this.chunkProxies.compute(MathMan.pairInt(chunkX, chunkZ), (k, v) -> v == null ? PaperweightChunkAccessProxy.getInstance() : v));
        proxy.parent = worldChunk;
        return proxy;
    }

    @Nonnull
    public ChunkAccess getChunk(int chunkX, int chunkZ, @Nonnull ChunkStatus chunkStatus) {
        ChunkAccess worldChunk = this.world.getChunk(chunkX, chunkZ, chunkStatus);
        PaperweightChunkAccessProxy proxy = (PaperweightChunkAccessProxy)((Object)this.chunkProxies.compute(MathMan.pairInt(chunkX, chunkZ), (k, v) -> v == null ? PaperweightChunkAccessProxy.getInstance() : v));
        proxy.parent = worldChunk;
        return proxy;
    }

    @Nonnull
    public FeatureFlagSet enabledFeatures() {
        return this.world.enabledFeatures();
    }

    public float getShade(Direction direction, boolean shaded) {
        return this.world.getShade(direction, shaded);
    }

    @Nonnull
    public LevelLightEngine getLightEngine() {
        return this.world.getLightEngine();
    }

    @Nullable
    public ChunkAccess getChunkIfLoadedImmediately(int x, int z) {
        return this.world.getChunkIfLoadedImmediately(x, z);
    }

    public BlockState getBlockStateIfLoaded(BlockPos blockposition) {
        return this.world.getBlockStateIfLoaded(blockposition);
    }

    public FluidState getFluidIfLoaded(BlockPos blockposition) {
        return this.world.getFluidIfLoaded(blockposition);
    }

    @Nonnull
    public WorldBorder getWorldBorder() {
        return this.world.getWorldBorder();
    }

    public boolean setBlock(BlockPos pos, BlockState state, int flags, int maxUpdateDepth) {
        return this.world.setBlock(pos, state, flags, maxUpdateDepth);
    }

    public boolean removeBlock(BlockPos pos, boolean move) {
        return this.world.removeBlock(pos, move);
    }

    public boolean destroyBlock(BlockPos pos, boolean drop, Entity breakingEntity, int maxUpdateDepth) {
        return this.world.destroyBlock(pos, drop, breakingEntity, maxUpdateDepth);
    }

    @Nonnull
    public BlockState getBlockState(BlockPos pos) {
        return this.world.getBlockState(pos);
    }

    public boolean setBlock(BlockPos pos, BlockState state, int flags) {
        return this.world.setBlock(pos, state, flags);
    }
}

