/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.fastasyncworldedit.core.configuration.Caption;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.command.util.annotation.Confirm;
import com.sk89q.worldedit.command.util.annotation.SynchronousSettingExpected;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class HistoryCommands {
    private final WorldEdit worldEdit;

    public HistoryCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(name="undo", aliases={"/undo"}, desc="Undoes the last action (from history)")
    @CommandPermissions(value={"worldedit.history.undo", "worldedit.history.undo.self"})
    @SynchronousSettingExpected
    public void undo(Actor actor, LocalSession session, @Confirm(value=Confirm.Processor.LIMIT) @Arg(desc="Number of undoes to perform", def={"1"}) int times, @Arg(name="player", desc="Undo this player's operations", def={""}) String playerName) throws WorldEditException {
        BlockBag blockBag;
        EditSession undone;
        times = Math.max(1, times);
        LocalSession undoSession = session;
        if (session.hasFastMode()) {
            actor.print(Caption.of("fawe.worldedit.history.command.undo.disabled", new Object[0]));
            return;
        }
        if (playerName != null) {
            actor.checkPermission("worldedit.history.undo.other");
            undoSession = this.worldEdit.getSessionManager().findByName(playerName);
            if (undoSession == null) {
                actor.print(Caption.of("worldedit.session.cant-find-session", TextComponent.of(playerName)));
                return;
            }
        }
        int timesUndone = 0;
        for (int i = 0; i < times && (undone = undoSession.undo(blockBag = actor instanceof Player ? undoSession.getBlockBag((Player)actor) : null, actor)) != null; ++i) {
            ++timesUndone;
            this.worldEdit.flushBlockBag(actor, undone);
        }
        if (timesUndone > 0) {
            actor.print(Caption.of("worldedit.undo.undone", TextComponent.of(timesUndone)));
        } else {
            actor.print(Caption.of("worldedit.undo.none", new Object[0]));
        }
    }

    @Command(name="redo", aliases={"/redo"}, desc="Redoes the last action (from history)")
    @CommandPermissions(value={"worldedit.history.redo", "worldedit.history.redo.self"})
    @SynchronousSettingExpected
    public void redo(Actor actor, LocalSession session, @Confirm(value=Confirm.Processor.LIMIT) @Arg(desc="Number of redoes to perform", def={"1"}) int times, @Arg(name="player", desc="Redo this player's operations", def={""}) String playerName) throws WorldEditException {
        BlockBag blockBag;
        EditSession redone;
        times = Math.max(1, times);
        LocalSession redoSession = session;
        if (playerName != null) {
            actor.checkPermission("worldedit.history.redo.other");
            redoSession = this.worldEdit.getSessionManager().findByName(playerName);
            if (redoSession == null) {
                actor.print(Caption.of("worldedit.session.cant-find-session", TextComponent.of(playerName)));
                return;
            }
        }
        int timesRedone = 0;
        for (int i = 0; i < times && (redone = redoSession.redo(blockBag = actor instanceof Player ? redoSession.getBlockBag((Player)actor) : null, actor)) != null; ++i) {
            ++timesRedone;
            this.worldEdit.flushBlockBag(actor, redone);
        }
        if (timesRedone > 0) {
            actor.print(Caption.of("worldedit.redo.redone", TextComponent.of(timesRedone)));
        } else {
            actor.print(Caption.of("worldedit.redo.none", new Object[0]));
        }
    }

    @Command(name="clearhistory", aliases={"/clearhistory"}, desc="Clear your history")
    @CommandPermissions(value={"worldedit.history.clear"})
    public void clearHistory(Actor actor, LocalSession session) {
        session.clearHistory();
        actor.print(Caption.of("worldedit.clearhistory.cleared", new Object[0]));
    }
}

