/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.fastasyncworldedit.core.extent.clipboard.URIClipboardHolder;
import com.fastasyncworldedit.core.internal.io.parallelgzip.ParallelGZIPOutputStream;
import com.fastasyncworldedit.core.util.MainUtil;
import com.fastasyncworldedit.core.util.task.RunnableVal;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Set;

public interface ClipboardFormat {
    public String getName();

    public Set<String> getAliases();

    public ClipboardReader getReader(InputStream var1) throws IOException;

    public ClipboardWriter getWriter(OutputStream var1) throws IOException;

    default public boolean isFormat(File file) {
        boolean bl;
        block8: {
            InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                bl = this.isFormat(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }

    default public boolean isFormat(InputStream inputStream) {
        return false;
    }

    public String getPrimaryFileExtension();

    public Set<String> getFileExtensions();

    public Set<String> getExplicitFileExtensions();

    default public URIClipboardHolder hold(Actor actor, URI uri, InputStream inputStream) throws IOException {
        Preconditions.checkNotNull((Object)actor);
        Preconditions.checkNotNull((Object)uri);
        Preconditions.checkNotNull((Object)inputStream);
        ClipboardReader reader = this.getReader(inputStream);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get(actor);
        session.setClipboard(null);
        Clipboard clipboard = reader.read(actor.getUniqueId());
        URIClipboardHolder holder = new URIClipboardHolder(uri, clipboard);
        session.setClipboard(holder);
        return holder;
    }

    default public Clipboard load(File file) throws IOException {
        return this.load(new FileInputStream(file));
    }

    default public Clipboard load(InputStream stream) throws IOException {
        return this.getReader(stream).read();
    }

    default public URL upload(final Clipboard clipboard) {
        return MainUtil.upload(null, null, this.getPrimaryFileExtension(), new RunnableVal<OutputStream>(){

            @Override
            public void run(OutputStream value) {
                ClipboardFormat.this.write(value, clipboard);
            }
        });
    }

    default public void write(OutputStream value, Clipboard clipboard) {
        try (ParallelGZIPOutputStream gzip = new ParallelGZIPOutputStream(value);
             ClipboardWriter writer = this.getWriter(gzip);){
            writer.write(clipboard);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

