/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.clipboard.LazyClipboardHolder;
import com.fastasyncworldedit.core.extent.clipboard.MultiClipboardHolder;
import com.fastasyncworldedit.core.extent.clipboard.URIClipboardHolder;
import com.fastasyncworldedit.core.internal.io.FastByteArrayOutputStream;
import com.fastasyncworldedit.core.util.MainUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.io.ByteSource;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public class ClipboardFormats {
    private static final Map<String, ClipboardFormat> aliasMap = new HashMap<String, ClipboardFormat>();
    private static final Multimap<String, ClipboardFormat> fileExtensionMap = Multimaps.newMultimap(new HashMap(), LinkedHashSet::new);
    private static final Multimap<String, ClipboardFormat> explicitFileExtensionMap = Multimaps.newMultimap(new HashMap(), LinkedHashSet::new);
    private static final List<ClipboardFormat> registeredFormats = new ArrayList<ClipboardFormat>();
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private static final Set<ClipboardFormat> FAST_SEARCH_BUILTIN_FORMATS = Set.of(BuiltInClipboardFormat.PNG, BuiltInClipboardFormat.MCEDIT_SCHEMATIC, BuiltInClipboardFormat.MINECRAFT_STRUCTURE, BuiltInClipboardFormat.SPONGE_V1_SCHEMATIC, BuiltInClipboardFormat.FAST_V2, BuiltInClipboardFormat.FAST_V3, BuiltInClipboardFormat.SPONGE_V2_SCHEMATIC, BuiltInClipboardFormat.SPONGE_V3_SCHEMATIC, BuiltInClipboardFormat.BROKENENTITY);

    public static void registerClipboardFormat(ClipboardFormat format) {
        String lowExt;
        Preconditions.checkNotNull((Object)format);
        for (String key : format.getAliases()) {
            String lowKey = key.toLowerCase(Locale.ROOT);
            ClipboardFormat old = aliasMap.put(lowKey, format);
            if (old == null) continue;
            aliasMap.put(lowKey, old);
            WorldEdit.logger.warn(format.getClass().getName() + " cannot override existing alias '" + lowKey + "' used by " + old.getClass().getName());
        }
        for (String ext : format.getFileExtensions()) {
            lowExt = ext.toLowerCase(Locale.ROOT);
            fileExtensionMap.put((Object)lowExt, (Object)format);
        }
        for (String ext : format.getExplicitFileExtensions()) {
            lowExt = ext.toLowerCase(Locale.ROOT);
            explicitFileExtensionMap.put((Object)lowExt, (Object)format);
        }
        registeredFormats.add(format);
    }

    @Nullable
    public static ClipboardFormat findByAlias(String alias) {
        Preconditions.checkNotNull((Object)alias);
        return aliasMap.get(alias.toLowerCase(Locale.ROOT).trim());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ClipboardFormat findByFile(File file) {
        Preconditions.checkNotNull((Object)file);
        if (file.getName().toLowerCase().endsWith(".png")) {
            return BuiltInClipboardFormat.PNG;
        }
        try (DataInputStream inputStream2 = new DataInputStream(new GZIPInputStream((InputStream)new FastBufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]))));
             NBTInputStream nbtInputStream = new NBTInputStream(inputStream2);){
            Object name;
            byte type;
            if (inputStream2.readByte() != 10) {
                ClipboardFormat clipboardFormat = ClipboardFormats.findByFileInExternalFormats(file);
                return clipboardFormat;
            }
            int rootNameTagLength = inputStream2.readShort() & 0xFFFF;
            if (rootNameTagLength != 0 && rootNameTagLength != 9) {
                ClipboardFormat clipboardFormat = ClipboardFormats.findByFileInExternalFormats(file);
                return clipboardFormat;
            }
            String rootName = new String(inputStream2.readNBytes(rootNameTagLength), StandardCharsets.UTF_8);
            if (rootName.isEmpty()) {
                while (true) {
                    if ((type = inputStream2.readByte()) == 0) {
                        ClipboardFormat clipboardFormat = ClipboardFormats.findByFileInExternalFormats(file);
                        return clipboardFormat;
                    }
                    name = nbtInputStream.readNamedTagName(type);
                    if (type == 10 && ((String)name).equals("Schematic")) break;
                    if (type == 9 && (((String)name).equals("size") || ((String)name).equals("palette") || ((String)name).equals("blocks") || ((String)name).equals("entities"))) {
                        BuiltInClipboardFormat builtInClipboardFormat = BuiltInClipboardFormat.MINECRAFT_STRUCTURE;
                        return builtInClipboardFormat;
                    }
                    nbtInputStream.readTagPayloadLazy(type, 0);
                }
            }
            while (true) {
                if ((type = inputStream2.readByte()) == 0) {
                    name = ClipboardFormats.findByFileInExternalFormats(file);
                    return name;
                }
                name = nbtInputStream.readNamedTagName(type);
                if (type == 7 && ((String)name).equals("Blocks") || type == 8 && ((String)name).equals("Materials")) {
                    BuiltInClipboardFormat builtInClipboardFormat = BuiltInClipboardFormat.MCEDIT_SCHEMATIC;
                    return builtInClipboardFormat;
                }
                if (type == 3 && ((String)name).equals("Version")) {
                    int version = inputStream2.readInt();
                    ClipboardFormat clipboardFormat = switch (version) {
                        case 1 -> BuiltInClipboardFormat.SPONGE_V1_SCHEMATIC;
                        case 2 -> BuiltInClipboardFormat.FAST_V2;
                        case 3 -> BuiltInClipboardFormat.FAST_V3;
                        default -> ClipboardFormats.findByFileInExternalFormats(file);
                    };
                    return clipboardFormat;
                }
                nbtInputStream.readTagPayloadLazy(type, 0);
            }
        }
        catch (EOFException | ZipException inputStream2) {
            return ClipboardFormats.findByFileInExternalFormats(file);
        }
        catch (IOException e) {
            LOGGER.error("Failed determining clipboard format for file {}", (Object)file.getAbsolutePath(), (Object)e);
            return null;
        }
    }

    private static ClipboardFormat findByFileInExternalFormats(File file) {
        if (registeredFormats.size() == FAST_SEARCH_BUILTIN_FORMATS.size()) {
            return null;
        }
        for (ClipboardFormat format : registeredFormats) {
            if (FAST_SEARCH_BUILTIN_FORMATS.contains(format) || !format.isFormat(file)) continue;
            return format;
        }
        return null;
    }

    public static Multimap<String, ClipboardFormat> getFileExtensionMap() {
        return Multimaps.unmodifiableMultimap(fileExtensionMap);
    }

    public static Collection<ClipboardFormat> getAll() {
        return Collections.unmodifiableCollection(registeredFormats);
    }

    public static String[] getFileExtensionArray() {
        return fileExtensionMap.keySet().toArray(new String[fileExtensionMap.keySet().size()]);
    }

    public static Multimap<String, ClipboardFormat> getExplicitFileExtensionMap() {
        return Multimaps.unmodifiableMultimap(explicitFileExtensionMap);
    }

    private ClipboardFormats() {
    }

    @Nullable
    @Deprecated(forRemoval=true, since="2.11.1")
    public static ClipboardFormat findByExtension(String extension) {
        Preconditions.checkNotNull((Object)extension);
        Collection entries = ClipboardFormats.getFileExtensionMap().entries();
        for (Map.Entry entry : entries) {
            if (!((String)entry.getKey()).equalsIgnoreCase(extension)) continue;
            return (ClipboardFormat)entry.getValue();
        }
        return null;
    }

    @Nullable
    public static ClipboardFormat findByExplicitExtension(String extension) {
        Preconditions.checkNotNull((Object)extension);
        Collection entries = ClipboardFormats.getExplicitFileExtensionMap().entries();
        for (Map.Entry entry : entries) {
            if (!((String)entry.getKey()).equalsIgnoreCase(extension)) continue;
            return (ClipboardFormat)entry.getValue();
        }
        return null;
    }

    public static MultiClipboardHolder loadAllFromInput(Actor player, String input, ClipboardFormat format, boolean message) throws IOException {
        File f;
        File dir;
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)input);
        WorldEdit worldEdit = WorldEdit.getInstance();
        LocalConfiguration config = worldEdit.getConfiguration();
        if (input.startsWith("url:")) {
            if (!player.hasPermission("worldedit.schematic.load.web")) {
                if (message) {
                    player.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.load.web"));
                }
                return null;
            }
            URL base = new URL(Settings.settings().WEB.URL);
            input = new URL(base, "uploads/" + input.substring(4) + "." + format.getPrimaryFileExtension()).toString();
        }
        if (input.startsWith("http")) {
            return null;
        }
        if (Settings.settings().PATHS.PER_PLAYER_SCHEMATICS && Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}").matcher(input).find() && !player.hasPermission("worldedit.schematic.load.other")) {
            player.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.load.other"));
            return null;
        }
        File working = worldEdit.getWorkingDirectoryPath(config.saveDir).toFile();
        File file = dir = Settings.settings().PATHS.PER_PLAYER_SCHEMATICS ? new File(working, player.getUniqueId().toString()) : working;
        if (input.startsWith("#")) {
            String[] extensions = format != null ? format.getFileExtensions().toArray(new String[0]) : ClipboardFormats.getFileExtensionArray();
            f = player.openFileOpenDialog(extensions);
            if (f == null || !f.exists()) {
                if (message) {
                    player.print(Caption.of("worldedit.schematic.load.does-not-exist", TextComponent.of(input)));
                }
                return null;
            }
        } else {
            if (Settings.settings().PATHS.PER_PLAYER_SCHEMATICS && Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}").matcher(input).find() && !player.hasPermission("worldedit.schematic.load.other")) {
                if (message) {
                    player.print(Caption.of("fawe.error.no-perm", "worldedit.schematic.load.other"));
                }
                return null;
            }
            if (format == null && input.matches(".*\\.[\\w].*")) {
                String extension = input.substring(input.lastIndexOf(46) + 1);
                format = ClipboardFormats.findByExplicitExtension(extension);
            }
            f = MainUtil.resolve(dir, input, format, true);
        }
        if (!(f != null && f.exists() || input.contains("../"))) {
            f = MainUtil.resolve(dir, input, null, true);
        }
        if (f == null || !f.exists() || !MainUtil.isInSubDirectory(working, f)) {
            if (message) {
                player.printError("Schematic " + input + " does not exist! (" + (f != null && f.exists()) + "|" + String.valueOf(f) + "|" + (f != null && !MainUtil.isInSubDirectory(working, f)) + ")");
            }
            return null;
        }
        if (format == null && f.isFile() && (format = ClipboardFormats.findByFile(f)) == null) {
            player.print(Caption.of("fawe.worldedit.clipboard.clipboard.invalid.format", f.getName()));
            return null;
        }
        if (!f.exists()) {
            if (message) {
                player.print(Caption.of("fawe.error.schematic.not.found", input));
            }
            return null;
        }
        if (!f.isDirectory()) {
            ByteSource source = com.google.common.io.Files.asByteSource((File)f);
            URI uri = f.toURI();
            return new MultiClipboardHolder(uri, new LazyClipboardHolder(f.toURI(), source, format, null));
        }
        URIClipboardHolder[] clipboards = ClipboardFormats.loadAllFromDirectory(f);
        if (clipboards.length < 1) {
            if (message) {
                player.print(Caption.of("fawe.error.schematic.not.found", input));
            }
            return null;
        }
        return new MultiClipboardHolder(f.toURI(), clipboards);
    }

    public static URIClipboardHolder[] loadAllFromDirectory(File dir) {
        HashSet<String> extensions = new HashSet<String>(Arrays.asList(ClipboardFormats.getFileExtensionArray()));
        File[] files = dir.listFiles(pathname -> {
            String input = pathname.getName();
            String extension = input.substring(input.lastIndexOf(46) + 1);
            return extensions.contains(extension.toLowerCase(Locale.ENGLISH));
        });
        URIClipboardHolder[] clipboards = new LazyClipboardHolder[files.length];
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            ByteSource source = com.google.common.io.Files.asByteSource((File)file);
            ClipboardFormat format = ClipboardFormats.findByFile(file);
            clipboards[i] = new LazyClipboardHolder(file.toURI(), source, format, null);
        }
        return clipboards;
    }

    public static MultiClipboardHolder loadAllFromUrl(URL url) throws IOException {
        ArrayList<LazyClipboardHolder> clipboards = new ArrayList<LazyClipboardHolder>();
        try (ReadableByteChannel rbc = Channels.newChannel(url.openStream());
             InputStream in = Channels.newInputStream(rbc);){
            try (ZipInputStream zip = new ZipInputStream(in);){
                ZipEntry entry;
                byte[] buffer = new byte[8192];
                while ((entry = zip.getNextEntry()) != null) {
                    int len;
                    String filename = entry.getName();
                    ClipboardFormat format = ClipboardFormats.findByExtension(filename);
                    if (format == null) continue;
                    FastByteArrayOutputStream out = new FastByteArrayOutputStream();
                    while ((len = zip.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    byte[] array = out.toByteArray();
                    ByteSource source = ByteSource.wrap((byte[])array);
                    LazyClipboardHolder clipboard = new LazyClipboardHolder(url.toURI(), source, format, null);
                    clipboards.add(clipboard);
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        LazyClipboardHolder[] arr = clipboards.toArray(new LazyClipboardHolder[0]);
        try {
            MultiClipboardHolder multi = new MultiClipboardHolder(url.toURI());
            for (LazyClipboardHolder h : arr) {
                multi.add(h);
            }
            return multi;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        for (BuiltInClipboardFormat format : BuiltInClipboardFormat.values()) {
            ClipboardFormats.registerClipboardFormat(format);
        }
    }
}

