/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.entity;

import com.fastasyncworldedit.core.util.TaskManager;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.EntityFunction;
import com.sk89q.worldedit.internal.helper.MCDirections;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.world.entity.EntityTypes;
import java.util.UUID;
import org.enginehub.linbus.tree.LinByteTag;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinFloatTag;
import org.enginehub.linbus.tree.LinIntArrayTag;
import org.enginehub.linbus.tree.LinListTag;
import org.enginehub.linbus.tree.LinNumberTag;
import org.enginehub.linbus.tree.LinStringTag;
import org.enginehub.linbus.tree.LinTag;
import org.enginehub.linbus.tree.LinTagType;

public class ExtentEntityCopy
implements EntityFunction {
    private final Extent source;
    private final Extent destination;
    private final Vector3 from;
    private final Vector3 to;
    private final Transform transform;
    private boolean removing;

    @Deprecated
    public ExtentEntityCopy(Vector3 from, Extent destination, Vector3 to, Transform transform) {
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)destination);
        Preconditions.checkNotNull((Object)to);
        Preconditions.checkNotNull((Object)transform);
        this.source = null;
        this.destination = destination;
        this.from = from;
        this.to = to;
        this.transform = transform;
    }

    public ExtentEntityCopy(Extent source, Vector3 from, Extent destination, Vector3 to, Transform transform) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)destination);
        Preconditions.checkNotNull((Object)to);
        Preconditions.checkNotNull((Object)transform);
        this.source = source;
        this.destination = destination;
        this.from = from;
        this.to = to;
        this.transform = transform;
    }

    public boolean isRemoving() {
        return this.removing;
    }

    public void setRemoving(boolean removing) {
        this.removing = removing;
    }

    @Override
    public boolean apply(Entity entity) throws WorldEditException {
        BaseEntity state = entity.getState();
        if (state != null && state.getType() != EntityTypes.PLAYER) {
            UUID uuid;
            boolean success;
            Location location = entity.getLocation();
            LinCompoundTag tag = state.getNbt();
            boolean hasTilePosition = false;
            if (tag != null) {
                LinIntArrayTag blockPos;
                Object v = tag.value().get("block_pos");
                if (v instanceof LinIntArrayTag && (blockPos = (LinIntArrayTag)v).value().length == 3) {
                    location = location.setPosition(Vector3.at(blockPos.value()[0], blockPos.value()[1], blockPos.value()[2]).add(0.5, 0.5, 0.5));
                    hasTilePosition = true;
                } else {
                    v = tag.value().get("TileX");
                    if (v instanceof LinNumberTag) {
                        LinNumberTag tagX = (LinNumberTag)v;
                        v = tag.value().get("TileY");
                        if (v instanceof LinNumberTag) {
                            LinNumberTag tagY = (LinNumberTag)v;
                            v = tag.value().get("TileZ");
                            if (v instanceof LinNumberTag) {
                                LinNumberTag tagZ = (LinNumberTag)v;
                                location = location.setPosition(Vector3.at(((Number)tagX.value()).intValue(), ((Number)tagY.value()).intValue(), ((Number)tagZ.value()).intValue()).add(0.5, 0.5, 0.5));
                                hasTilePosition = true;
                            }
                        }
                    }
                }
            }
            Vector3 pivot = this.from.round().add(0.5, 0.5, 0.5);
            Vector3 newPosition = this.transform.apply(location.toVector().subtract(pivot));
            if (hasTilePosition) {
                newPosition = newPosition.subtract(0.5, 0.5, 0.5);
            }
            Vector3 newDirection = this.transform.isIdentity() ? entity.getLocation().getDirection() : this.transform.apply(location.getDirection()).subtract(this.transform.apply(Vector3.ZERO)).normalize();
            Location newLocation = new Location(this.destination, newPosition.add(this.to.round().add(0.5, 0.5, 0.5)), newDirection);
            state = this.transformNbtData(state);
            boolean bl = success = this.destination.createEntity(newLocation, state) != null;
            if (this.isRemoving() && success && (uuid = entity.getState().getUUID()) != null) {
                if (this.source != null) {
                    this.source.removeEntity(entity.getLocation().getBlockX(), entity.getLocation().getBlockY(), entity.getLocation().getBlockZ(), uuid);
                } else {
                    TaskManager.taskManager().sync(entity::remove);
                }
            }
            return success;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseEntity transformNbtData(BaseEntity state) {
        block16: {
            LinTag rotation;
            LinCompoundTag tag;
            block17: {
                LinCompoundTag.Builder builder;
                block18: {
                    Object object;
                    Object v;
                    tag = state.getNbt();
                    if (tag == null) break block16;
                    LinCompoundTag leashCompound = tag.findTag("Leash", LinTagType.compoundTag());
                    if (leashCompound != null && (v = tag.value().get("X")) instanceof LinNumberTag) {
                        LinNumberTag tagX = (LinNumberTag)v;
                        v = tag.value().get("Y");
                        if (v instanceof LinNumberTag) {
                            LinNumberTag tagY = (LinNumberTag)v;
                            v = tag.value().get("Z");
                            if (v instanceof LinNumberTag) {
                                LinNumberTag tagZ = (LinNumberTag)v;
                                Vector3 tilePosition = Vector3.at(((Number)tagX.value()).intValue(), ((Number)tagY.value()).intValue(), ((Number)tagZ.value()).intValue());
                                BlockVector3 newLeash = this.transform.apply(tilePosition.subtract(this.from)).add(this.to).toBlockPoint();
                                return new BaseEntity(state.getType(), LazyReference.computed(tag.toBuilder().put("Leash", leashCompound.toBuilder().putInt("X", newLeash.x()).putInt("Y", newLeash.y()).putInt("Z", newLeash.z()).build()).build()));
                            }
                        }
                    }
                    boolean hasTilePosition = tag.value().containsKey("TileX") && tag.value().containsKey("TileY") && tag.value().containsKey("TileZ");
                    rotation = (LinTag)tag.value().get("Rotation");
                    Vector3 tilePosition = null;
                    Object newLeash = tag.value().get("block_pos");
                    if (newLeash instanceof LinIntArrayTag) {
                        LinIntArrayTag blockPos = (LinIntArrayTag)newLeash;
                        tilePosition = Vector3.at(blockPos.value()[0], blockPos.value()[1], blockPos.value()[2]);
                    }
                    if ((object = tag.value().get("TileX")) instanceof LinNumberTag) {
                        LinNumberTag tagX = (LinNumberTag)object;
                        object = tag.value().get("TileY");
                        if (object instanceof LinNumberTag) {
                            LinNumberTag tagY = (LinNumberTag)object;
                            object = tag.value().get("TileZ");
                            if (object instanceof LinNumberTag) {
                                LinNumberTag tagZ = (LinNumberTag)object;
                                tilePosition = Vector3.at(((Number)tagX.value()).intValue(), ((Number)tagY.value()).intValue(), ((Number)tagZ.value()).intValue());
                            }
                        }
                    }
                    if (tilePosition == null) break block17;
                    BlockVector3 newTilePosition = this.transform.apply(tilePosition.subtract(this.from)).add(this.to).toBlockPoint();
                    builder = tag.toBuilder();
                    if (WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).getDataVersion() < 4325) {
                        builder.putInt("TileX", newTilePosition.x()).putInt("TileY", newTilePosition.y()).putInt("TileZ", newTilePosition.z());
                    } else {
                        builder.putIntArray("block_pos", new int[]{newTilePosition.x(), newTilePosition.y(), newTilePosition.z()});
                    }
                    FacingTagData facingTagData = ExtentEntityCopy.tryGetFacingData(tag);
                    if (facingTagData instanceof FacingTagData) {
                        Object v2;
                        Object tagFacing;
                        String facingKey;
                        block15: {
                            object = facingTagData;
                            try {
                                Object object2 = ((FacingTagData)object).facingKey();
                                facingKey = object2;
                                tagFacing = object2 = ((FacingTagData)object).tagFacing();
                                if (state.getType() != EntityTypes.PAINTING) break block15;
                            }
                            catch (Throwable throwable) {
                                throw new MatchException(throwable.toString(), throwable);
                            }
                            Direction direction = MCDirections.fromHorizontalHanging(((Number)((LinTag)tagFacing).value()).intValue());
                            Vector3 vector = this.transform.apply(direction.toVector()).subtract(this.transform.apply(Vector3.ZERO)).normalize();
                            Direction newDirection = Direction.findClosest(vector, Direction.Flag.CARDINAL);
                            byte facingValue = (byte)MCDirections.toHorizontalHanging(newDirection);
                            builder.putByte(facingKey, facingValue);
                            break block18;
                        }
                        Direction facingDirection = MCDirections.fromHanging(((Number)((LinTag)tagFacing).value()).intValue());
                        Vector3 facingVector = this.transform.apply(facingDirection.toVector()).subtract(this.transform.apply(Vector3.ZERO)).normalize();
                        Direction newFacingDirection = Direction.findClosest(facingVector, Direction.Flag.CARDINAL | Direction.Flag.UPRIGHT);
                        byte facingValue = (byte)MCDirections.toHanging(newFacingDirection);
                        builder.putByte(facingKey, facingValue);
                        String itemRotationKey = "ItemRotation";
                        if (!this.transform.isIdentity() && (v2 = tag.value().get(itemRotationKey)) instanceof LinByteTag) {
                            LinByteTag tagItemRotation = (LinByteTag)v2;
                            String itemId = this.getItemInItemFrame(tag);
                            int availableRotations = itemId != null && itemId.equals("minecraft:filled_map") ? 4 : 8;
                            Direction rotationBaseDirection = facingDirection == Direction.UP || facingDirection == Direction.DOWN ? Direction.NORTH : Direction.UP;
                            int itemRotation = tagItemRotation.value().intValue();
                            Vector3 rotationVector = this.getItemRotationVector(rotationBaseDirection, facingDirection.toVector(), itemRotation, availableRotations);
                            Vector3 newRotationVector = this.transform.apply(rotationVector);
                            Direction newRotationBaseDirection = newFacingDirection == Direction.UP || newFacingDirection == Direction.DOWN ? Direction.NORTH : Direction.UP;
                            byte newItemRotation = (byte)this.getItemRotationSteps(newRotationBaseDirection, newFacingDirection, newRotationVector, availableRotations);
                            builder.putByte(itemRotationKey, newItemRotation);
                        }
                    }
                }
                if (rotation instanceof LinListTag) {
                    LinListTag rotationTag = (LinListTag)rotation;
                    LinListTag<LinFloatTag> orgrot = rotationTag.asTypeChecked(LinTagType.floatTag());
                    Vector3 orgDirection = new Location(this.destination, 0.0, 0.0, 0.0, orgrot.get(0).valueAsFloat(), orgrot.get(1).valueAsFloat()).getDirection();
                    Vector3 newDirection = this.transform.apply(orgDirection).subtract(this.transform.apply(Vector3.ZERO)).normalize();
                    builder.put("Rotation", LinListTag.builder(LinTagType.floatTag()).add(LinFloatTag.of((float)newDirection.toYaw())).add(LinFloatTag.of((float)newDirection.toPitch())).build());
                }
                return new BaseEntity(state.getType(), LazyReference.computed(builder.build()));
            }
            if (rotation instanceof LinListTag) {
                LinListTag rotationTag = (LinListTag)rotation;
                LinCompoundTag.Builder builder = tag.toBuilder();
                LinListTag<LinFloatTag> orgrot = rotationTag.asTypeChecked(LinTagType.floatTag());
                Vector3 orgDirection = new Location(this.destination, 0.0, 0.0, 0.0, orgrot.get(0).valueAsFloat(), orgrot.get(1).valueAsFloat()).getDirection();
                Vector3 newDirection = this.transform.apply(orgDirection).subtract(this.transform.apply(Vector3.ZERO)).normalize();
                builder.put("Rotation", LinListTag.builder(LinTagType.floatTag()).add(LinFloatTag.of((float)newDirection.toYaw())).add(LinFloatTag.of((float)newDirection.toPitch())).build());
                return new BaseEntity(state.getType(), LazyReference.computed(builder.build()));
            }
        }
        return state;
    }

    private Vector3 getItemRotationVector(Direction baseDirection, Vector3 facingVector, int itemRotation, int rotations) {
        Vector3 baseVec = baseDirection.toVector().normalize();
        double angle = Math.toRadians((float)itemRotation * (360.0f / (float)rotations));
        Vector3 rotated = this.rotateAroundAxis(baseVec, facingVector, -angle);
        return rotated.normalize();
    }

    private Vector3 rotateAroundAxis(Vector3 vec, Vector3 axis, double angle) {
        axis = axis.normalize();
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        return vec.multiply(cos).add(axis.cross(vec).multiply(sin)).add(axis.multiply(axis.dot(vec) * (1.0 - cos)));
    }

    private int getItemRotationSteps(Direction baseDirection, Direction facingDirection, Vector3 targetVector, int rotations) {
        double dot;
        Vector3 baseVec = baseDirection.toVector();
        double det = facingDirection.toVector().dot(baseVec.cross(targetVector));
        double signedAngle = Math.atan2(det, dot = baseVec.dot(targetVector));
        double stepsDouble = -signedAngle / (Math.PI / (double)((float)rotations / 2.0f));
        int steps = (int)Math.round(stepsDouble) % rotations;
        if (steps < 0) {
            steps += rotations;
        }
        if (facingDirection == Direction.DOWN) {
            steps = (steps + rotations / 2) % rotations;
        }
        return steps;
    }

    private String getItemInItemFrame(LinCompoundTag tag) {
        LinCompoundTag tagItem;
        Object v;
        Object v2 = tag.value().get("Item");
        if (v2 instanceof LinCompoundTag && (v = (tagItem = (LinCompoundTag)v2).value().get("id")) instanceof LinStringTag) {
            LinStringTag tagId = (LinStringTag)v;
            return tagId.value();
        }
        return null;
    }

    private static FacingTagData tryGetFacingData(LinCompoundTag tag) {
        Object v = tag.value().get("Facing");
        if (v instanceof LinNumberTag) {
            LinNumberTag tagFacingCapital = (LinNumberTag)v;
            return new FacingTagData("Facing", tagFacingCapital);
        }
        v = tag.value().get("facing");
        if (v instanceof LinNumberTag) {
            LinNumberTag tagFacingLower = (LinNumberTag)v;
            return new FacingTagData("facing", tagFacingLower);
        }
        return null;
    }

    private record FacingTagData(String facingKey, LinNumberTag<?> tagFacing) {
    }
}

