/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.pattern;

import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.AbstractExtentPattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StateApplyingPattern
extends AbstractExtentPattern {
    private final Map<String, String> states;
    private final Map<BlockType, PropertyApplication[]> cache = new ConcurrentHashMap<BlockType, PropertyApplication[]>();

    public StateApplyingPattern(Extent extent, Map<String, String> statesToSet) {
        super(extent);
        this.states = statesToSet;
    }

    @Override
    public BaseBlock applyBlock(BlockVector3 position) {
        BlockStateHolder<BlockState> block = position.getBlock(this.getExtent());
        BlockType blockType = block.getBlockType();
        PropertyApplication[] applications = this.cache.get(blockType);
        if (applications == null) {
            applications = this.resolvePropertiesFor(blockType);
            this.cache.put(blockType, applications);
        }
        for (PropertyApplication entry : applications) {
            if (!blockType.hasProperty(entry.property().getKey())) continue;
            block = block.with(entry.property(), entry.value());
        }
        return block.toBaseBlock();
    }

    private PropertyApplication[] resolvePropertiesFor(BlockType blockType) {
        Map<Property<Object>, Object> map = Blocks.resolveProperties(this.states, blockType);
        PropertyApplication[] applications = new PropertyApplication[map.size()];
        int i = 0;
        for (Map.Entry<Property<Object>, Object> entry : map.entrySet()) {
            Property<Object> property = entry.getKey();
            Object o = entry.getValue();
            applications[i++] = new PropertyApplication(property, o);
        }
        return applications;
    }

    private record PropertyApplication(Property<Object> property, Object value) {
    }
}

