/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.visitor;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.queue.implementation.ParallelQueueExtent;
import com.fastasyncworldedit.core.queue.implementation.SingleThreadQueueExtent;
import com.fastasyncworldedit.core.util.ExtentTraverser;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.FlatRegionFunction;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;

public class FlatRegionVisitor
implements Operation {
    private final SingleThreadQueueExtent singleQueue;
    private final FlatRegion flatRegion;
    private final FlatRegionFunction function;
    private int affected = 0;

    public FlatRegionVisitor(FlatRegion flatRegion, FlatRegionFunction function) {
        this(flatRegion, function, null);
    }

    public FlatRegionVisitor(FlatRegion flatRegion, FlatRegionFunction function, Extent extent) {
        ExtentTraverser<ParallelQueueExtent> queueTraverser;
        Preconditions.checkNotNull((Object)flatRegion);
        Preconditions.checkNotNull((Object)function);
        this.function = function;
        this.flatRegion = flatRegion;
        this.singleQueue = extent != null ? ((queueTraverser = new ExtentTraverser<Extent>(extent).find(ParallelQueueExtent.class)) != null ? (SingleThreadQueueExtent)queueTraverser.get().getExtent() : null) : null;
    }

    public int getAffected() {
        return this.affected;
    }

    @Override
    public Operation resume(RunContext run) throws WorldEditException {
        if (this.singleQueue != null) {
            this.singleQueue.preload(this.flatRegion);
        }
        for (BlockVector2 pt : this.flatRegion.asFlatRegion()) {
            if (!this.function.apply(pt)) continue;
            ++this.affected;
        }
        return null;
    }

    @Override
    public void cancel() {
    }

    @Override
    public Iterable<Component> getStatusMessages() {
        return ImmutableList.of((Object)Caption.of("worldedit.operation.affected.column", TextComponent.of(this.getAffected())));
    }
}

