/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.registry;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.extension.factory.parser.AliasedParser;
import com.fastasyncworldedit.core.extension.factory.parser.FaweParser;
import com.google.common.base.Preconditions;
import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.NoMatchException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.internal.registry.InputParser;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractFactory<E> {
    protected final WorldEdit worldEdit;
    protected final List<InputParser<E>> parsers = new ArrayList<InputParser<E>>();
    private final FaweParser<E> richParser;

    protected AbstractFactory(WorldEdit worldEdit, InputParser<E> defaultParser) {
        this(worldEdit, defaultParser, null);
    }

    protected AbstractFactory(WorldEdit worldEdit, InputParser<E> defaultParser, FaweParser<E> richParser) {
        Preconditions.checkNotNull((Object)worldEdit);
        Preconditions.checkNotNull(defaultParser);
        this.worldEdit = worldEdit;
        this.parsers.add(defaultParser);
        this.richParser = richParser;
    }

    public List<InputParser<E>> getParsers() {
        return Collections.unmodifiableList(this.parsers);
    }

    public E parseFromInput(String input, ParserContext context) throws InputParseException {
        ArrayList parsed = new ArrayList();
        for (String component : StringUtil.split(input, ' ', '[', ']')) {
            Object match;
            if (component.isEmpty()) continue;
            if (this.richParser != null && (match = this.richParser.parseFromInput(component, context)) != null) {
                parsed.add(match);
                continue;
            }
            this.parseFromParsers(context, parsed, component);
        }
        return this.getParsed(input, parsed);
    }

    @Deprecated
    public List<String> getSuggestions(String input) {
        return this.getSuggestions(input, new ParserContext());
    }

    public List<String> getSuggestions(String input, ParserContext context) {
        return this.parsers.stream().flatMap(p -> p.getSuggestions(input, context)).collect(Collectors.toList());
    }

    public void register(InputParser<E> inputParser) {
        Preconditions.checkNotNull(inputParser);
        this.parsers.add(this.parsers.size() - 1, inputParser);
    }

    public boolean containsAlias(String alias) {
        return this.parsers.stream().anyMatch(p -> {
            if (!(p instanceof AliasedParser)) {
                return false;
            }
            return ((AliasedParser)((Object)p)).getMatchedAliases().contains(alias);
        });
    }

    protected void parseFromParsers(ParserContext context, List<E> parsed, String component) {
        InputParser<E> parser;
        Object match = null;
        Iterator<InputParser<E>> iterator = this.getParsers().iterator();
        while (iterator.hasNext() && (match = (Object)(parser = iterator.next()).parseFromInput(component, context)) == null) {
        }
        if (match == null) {
            throw new NoMatchException(Caption.of("worldedit.error.no-match", TextComponent.of(component)));
        }
        parsed.add(match);
    }

    public E parseWithoutRich(String input, ParserContext context) throws InputParseException {
        ArrayList parsed = new ArrayList();
        for (String component : StringUtil.split(input, ' ', '[', ']')) {
            if (component.isEmpty()) continue;
            this.parseFromParsers(context, parsed, component);
        }
        return this.getParsed(input, parsed);
    }

    protected E getParsed(String input, List<E> parsed) {
        return parsed.isEmpty() ? null : (E)parsed.get(0);
    }
}

