/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.registry.state;

import com.fastasyncworldedit.core.util.StringMan;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class IntegerProperty
extends AbstractProperty<Integer> {
    private final int[] map;

    public IntegerProperty(String name, List<Integer> values) {
        this(name, values, 0);
    }

    private IntegerProperty(String name, List<Integer> values, int bitOffset) {
        super(name, values, bitOffset);
        int max = Collections.max(values);
        this.map = new int[max + 1];
        for (int i = 0; i < values.size(); ++i) {
            this.map[values.get((int)i).intValue()] = i;
        }
    }

    @Override
    public IntegerProperty withOffset(int bitOffset) {
        return new IntegerProperty(this.getName(), this.getValues(), bitOffset);
    }

    @Override
    public int getIndex(Integer value) {
        try {
            return this.map[value];
        }
        catch (IndexOutOfBoundsException ignored) {
            return -1;
        }
    }

    @Override
    public int getIndexFor(CharSequence string) throws IllegalArgumentException {
        return this.map[StringMan.parseInt(string)];
    }

    @Override
    @Nullable
    public Integer getValueFor(String string) {
        try {
            int val = Integer.parseInt(string);
            if (val > 0 && val >= this.map.length) {
                throw new IllegalArgumentException("Invalid int value: " + string + ". Must be in " + this.getValues().toString());
            }
            return val;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid int value: " + string + ". Not an int.");
        }
    }
}

