/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.regions.plotsquared;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.FaweAPI;
import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.extent.clipboard.io.FastSchematicReaderV2;
import com.fastasyncworldedit.core.extent.clipboard.io.FastSchematicWriterV2;
import com.fastasyncworldedit.core.internal.io.parallelgzip.ParallelGZIPOutputStream;
import com.fastasyncworldedit.core.jnbt.CompressedCompoundTag;
import com.fastasyncworldedit.core.jnbt.CompressedSchematicTag;
import com.fastasyncworldedit.core.util.IOUtil;
import com.fastasyncworldedit.core.util.TaskManager;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.generator.ClassicPlotWorld;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.schematic.Schematic;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.SchematicHandler;
import com.plotsquared.core.util.task.RunnableVal;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.MCEditSchematicReader;
import com.sk89q.worldedit.extent.clipboard.io.sponge.SpongeSchematicV3Reader;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.apache.logging.log4j.Logger;
import org.enginehub.linbus.stream.LinBinaryIO;

public class FaweDelegateSchematicHandler {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private static final AtomicBoolean exportingAll = new AtomicBoolean();

    @Deprecated
    public void paste(Schematic schematic, Plot plot, int xOffset, int yOffset, int zOffset, boolean autoHeight, RunnableVal<Boolean> whenDone) {
        this.paste(schematic, plot, xOffset, yOffset, zOffset, autoHeight, null, whenDone);
    }

    public void paste(Schematic schematic, Plot plot, int xOffset, int yOffset, int zOffset, boolean autoHeight, PlotPlayer<?> actor, RunnableVal<Boolean> whenDone) {
        Runnable r = () -> {
            boolean sizeMismatch;
            if (whenDone != null) {
                whenDone.value = false;
            }
            if (schematic == null) {
                if (whenDone != null) {
                    com.plotsquared.core.util.task.TaskManager.runTask((Runnable)whenDone);
                }
                return;
            }
            BlockVector3 dimension = schematic.getClipboard().getDimensions();
            int WIDTH = dimension.x();
            int LENGTH = dimension.z();
            int HEIGHT = dimension.y();
            int worldHeight = plot.getArea().getMaxGenHeight() - plot.getArea().getMinGenHeight() + 1;
            CuboidRegion region = plot.getLargestRegion();
            boolean bl = sizeMismatch = region.getMaximumPoint().x() - region.getMinimumPoint().x() + xOffset + 1 < WIDTH || region.getMaximumPoint().z() - region.getMinimumPoint().z() + zOffset + 1 < LENGTH || HEIGHT > worldHeight;
            if (!Settings.Schematics.PASTE_MISMATCHES && sizeMismatch) {
                if (actor != null) {
                    actor.sendMessage((Caption)TranslatableCaption.of((String)"schematics.schematic_size_mismatch"), new TagResolver[0]);
                }
                com.plotsquared.core.util.task.TaskManager.runTask((Runnable)whenDone);
                return;
            }
            if (region.getMaximumPoint().x() - region.getMinimumPoint().x() + xOffset + 1 < WIDTH || region.getMaximumPoint().z() - region.getMinimumPoint().z() + zOffset + 1 < LENGTH || HEIGHT > worldHeight) {
                if (whenDone != null) {
                    com.plotsquared.core.util.task.TaskManager.runTask((Runnable)whenDone);
                }
                return;
            }
            try (EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world(FaweAPI.getWorld(plot.getWorldName())).checkMemory(false).fastMode(true).limitUnlimited().changeSetNull().build();){
                PlotArea pw;
                int y_offset_actual = autoHeight ? (HEIGHT >= worldHeight ? yOffset : ((pw = plot.getArea()) instanceof ClassicPlotWorld ? yOffset + pw.getMinBuildHeight() + ((ClassicPlotWorld)pw).PLOT_HEIGHT : yOffset + pw.getMinBuildHeight() + editSession.getHighestTerrainBlock(region.getMinimumPoint().x() + 1, region.getMinimumPoint().z() + 1, pw.getMinGenHeight(), pw.getMaxGenHeight()))) : yOffset;
                BlockVector3 to = BlockVector3.at(region.getMinimumPoint().x() + xOffset, y_offset_actual, region.getMinimumPoint().z() + zOffset);
                Clipboard clipboard = schematic.getClipboard();
                clipboard.setOrigin(clipboard.getRegion().getMinimumPoint());
                clipboard.paste(editSession, to, true, false, true);
                if (whenDone != null) {
                    whenDone.value = true;
                    com.plotsquared.core.util.task.TaskManager.runTask((Runnable)whenDone);
                }
            }
        };
        if (Fawe.isMainThread()) {
            TaskManager.taskManager().async(r);
        } else {
            r.run();
        }
    }

    public boolean save(CompoundTag tag, String path) {
        block36: {
            if (tag == null) {
                LOGGER.warn("Cannot save empty tag");
                return false;
            }
            try {
                File tmp = FileUtils.getFile((File)PlotSquared.platform().getDirectory(), (String)path);
                tmp.getParentFile().mkdirs();
                if (tag instanceof CompressedCompoundTag) {
                    CompressedCompoundTag cTag = (CompressedCompoundTag)tag;
                    if (cTag instanceof CompressedSchematicTag) {
                        Clipboard clipboard = (Clipboard)cTag.getSource();
                        try (FileOutputStream stream = new FileOutputStream(tmp);
                             NBTOutputStream output = new NBTOutputStream(new BufferedOutputStream(new ParallelGZIPOutputStream(stream)));){
                            new FastSchematicWriterV2(output).write(clipboard);
                            break block36;
                        }
                    }
                    try (FileOutputStream stream = new FileOutputStream(tmp);
                         BufferedOutputStream output = new BufferedOutputStream(new ParallelGZIPOutputStream(stream));){
                        LZ4BlockInputStream is = cTag.adapt(cTag.getSource());
                        IOUtil.copy((InputStream)is, output);
                        break block36;
                    }
                }
                try (FileOutputStream stream = new FileOutputStream(tmp);
                     NBTOutputStream output = new NBTOutputStream(new ParallelGZIPOutputStream(stream));){
                    Object map = tag.getValue();
                    output.writeNamedTag("Schematic", map.getOrDefault("Schematic", tag));
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void upload(CompoundTag tag, UUID uuid, String file, RunnableVal<URL> whenDone) {
        if (tag == null) {
            LOGGER.warn("Cannot save empty tag");
            if (whenDone != null) {
                com.plotsquared.core.util.task.TaskManager.runTask(whenDone);
            }
            return;
        }
        final CompoundTag weTag = (CompoundTag)FaweCache.INSTANCE.asTag((Object)tag);
        SchematicHandler.upload((UUID)uuid, (String)file, (String)"schem", (RunnableVal)new RunnableVal<OutputStream>(this){

            public void run(OutputStream output) {
                if (weTag instanceof CompressedSchematicTag) {
                    Clipboard clipboard = (Clipboard)((CompressedSchematicTag)weTag).getSource();
                    BuiltInClipboardFormat.FAST.write(output, clipboard);
                }
                try (ParallelGZIPOutputStream gzip = new ParallelGZIPOutputStream(output);
                     NBTOutputStream nos = new NBTOutputStream(gzip);){
                    Object map = weTag.getValue();
                    nos.writeNamedTag("Schematic", map.getOrDefault("Schematic", weTag));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, whenDone);
    }

    public Schematic getSchematic(@Nonnull InputStream is) {
        try {
            FastSchematicReaderV2 schematicReader = new FastSchematicReaderV2(new NBTInputStream(new BufferedInputStream(new GZIPInputStream(new BufferedInputStream(is)))));
            Clipboard clip = schematicReader.read();
            return new Schematic(clip);
        }
        catch (IOException e) {
            if (e instanceof EOFException) {
                e.printStackTrace();
                return null;
            }
            try {
                SpongeSchematicV3Reader schematicReader = new SpongeSchematicV3Reader(LinBinaryIO.read(new DataInputStream(new GZIPInputStream(is))));
                Clipboard clip = schematicReader.read();
                return new Schematic(clip);
            }
            catch (IOException e2) {
                if (e2 instanceof EOFException) {
                    e.printStackTrace();
                    return null;
                }
                try {
                    MCEditSchematicReader schematicReader = new MCEditSchematicReader(new NBTInputStream(new GZIPInputStream(is)));
                    Clipboard clip = schematicReader.read();
                    return new Schematic(clip);
                }
                catch (IOException e3) {
                    LOGGER.warn("{} | {} : {}", (Object)is, (Object)is.getClass().getCanonicalName(), (Object)e.getMessage());
                    e.printStackTrace();
                    return null;
                }
            }
        }
    }
}

