/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent.clipboard.io;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.function.visitor.Order;
import com.fastasyncworldedit.core.internal.io.FaweOutputStream;
import com.fastasyncworldedit.core.jnbt.streamer.IntValueReader;
import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.fastasyncworldedit.core.util.IOUtil;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;

public class FastSchematicWriterV2
implements ClipboardWriter {
    public static final int CURRENT_VERSION = 2;
    private static final int MAX_SIZE = 65535;
    private final NBTOutputStream outputStream;
    private boolean brokenEntities = false;

    public FastSchematicWriterV2(NBTOutputStream outputStream) {
        Preconditions.checkNotNull((Object)outputStream);
        this.outputStream = outputStream;
    }

    public void setBrokenEntities(boolean brokenEntities) {
        this.brokenEntities = brokenEntities;
    }

    @Override
    public void write(Clipboard clipboard) throws IOException {
        clipboard.flush();
        this.write2(clipboard);
    }

    private void write2(Clipboard clipboard) throws IOException {
        Region region = clipboard.getRegion();
        BlockVector3 origin = clipboard.getOrigin();
        BlockVector3 min = region.getMinimumPoint();
        BlockVector3 offset = min.subtract(origin);
        int width = region.getWidth();
        int height = region.getHeight();
        int length = region.getLength();
        if (width > 65535) {
            throw new IllegalArgumentException("Width of region too large for a .schematic");
        }
        if (height > 65535) {
            throw new IllegalArgumentException("Height of region too large for a .schematic");
        }
        if (length > 65535) {
            throw new IllegalArgumentException("Length of region too large for a .schematic");
        }
        DataOutput rawStream = this.outputStream.getOutputStream();
        this.outputStream.writeLazyCompoundTag("Schematic", out -> {
            out.writeNamedTag("Version", 2);
            out.writeNamedTag("DataVersion", WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).getDataVersion());
            out.writeNamedTag("Width", (short)width);
            out.writeNamedTag("Height", (short)height);
            out.writeNamedTag("Length", (short)length);
            out.writeNamedTag("Offset", new int[]{min.x(), min.y(), min.z()});
            out.writeLazyCompoundTag("Metadata", out1 -> {
                out1.writeNamedTag("WEOffsetX", offset.x());
                out1.writeNamedTag("WEOffsetY", offset.y());
                out1.writeNamedTag("WEOffsetZ", offset.z());
                out1.writeNamedTag("FAWEVersion", Fawe.instance().getVersion().build);
            });
            ByteArrayOutputStream blocksCompressed = new ByteArrayOutputStream();
            FaweOutputStream blocksOut = new FaweOutputStream(new DataOutputStream(new LZ4BlockOutputStream(blocksCompressed)));
            ByteArrayOutputStream tilesCompressed = new ByteArrayOutputStream();
            NBTOutputStream tilesOut = new NBTOutputStream(new LZ4BlockOutputStream(tilesCompressed));
            ArrayList<Integer> paletteList = new ArrayList<Integer>();
            char[] palette = new char[BlockTypesCache.states.length];
            Arrays.fill(palette, '\uffff');
            int paletteMax = 0;
            int numTiles = 0;
            Clipboard finalClipboard = clipboard instanceof BlockArrayClipboard ? ((BlockArrayClipboard)clipboard).getParent() : clipboard;
            Iterator<BlockVector3> iterator = finalClipboard.iterator(Order.YZX);
            while (iterator.hasNext()) {
                char value;
                int ordinal;
                BlockVector3 pos = iterator.next();
                BaseBlock block = pos.getFullBlock(finalClipboard);
                CompoundTag compoundTag = block.getNbtData();
                if (compoundTag != null) {
                    HashMap values = new HashMap((Map<String, Tag<?, ?>>)compoundTag.getValue());
                    values.remove("x");
                    values.remove("y");
                    values.remove("z");
                    values.put("Id", new StringTag(block.getNbtId()));
                    values.remove("id");
                    values.put("Pos", new IntArrayTag(new int[]{pos.x(), pos.y(), pos.z()}));
                    ++numTiles;
                    tilesOut.writeTagPayload(new CompoundTag(values));
                }
                if ((ordinal = block.getOrdinal()) == 0) {
                    ordinal = 1;
                }
                if ((value = palette[ordinal]) == '\uffff') {
                    int size = paletteMax++;
                    palette[ordinal] = value = (char)size;
                    paletteList.add(ordinal);
                }
                blocksOut.writeVarInt(value);
            }
            tilesOut.close();
            blocksOut.close();
            out.writeNamedTag("PaletteMax", paletteMax);
            out.writeLazyCompoundTag("Palette", out12 -> {
                for (int i = 0; i < paletteList.size(); ++i) {
                    int stateOrdinal = (Integer)paletteList.get(i);
                    BlockState state = BlockTypesCache.states[stateOrdinal];
                    out12.writeNamedTag(state.getAsString(), i);
                }
            });
            out.writeNamedTagName("BlockData", 7);
            rawStream.writeInt(blocksOut.size());
            try (LZ4BlockInputStream in = new LZ4BlockInputStream(new ByteArrayInputStream(blocksCompressed.toByteArray()));){
                IOUtil.copy((InputStream)in, rawStream);
            }
            if (numTiles != 0) {
                out.writeNamedTagName("BlockEntities", 9);
                rawStream.write(10);
                rawStream.writeInt(numTiles);
                in = new LZ4BlockInputStream(new ByteArrayInputStream(tilesCompressed.toByteArray()));
                try {
                    IOUtil.copy((InputStream)in, rawStream);
                }
                finally {
                    in.close();
                }
            } else {
                out.writeNamedEmptyList("BlockEntities");
            }
            if (finalClipboard.hasBiomes()) {
                this.writeBiomes(finalClipboard, out);
            }
            ArrayList<CompoundTag> entities = new ArrayList<CompoundTag>();
            for (Entity entity : finalClipboard.getEntities()) {
                BaseEntity state = entity.getState();
                if (state == null) continue;
                HashMap values = new HashMap();
                CompoundTag rawTag = state.getNbtData();
                if (rawTag != null) {
                    values.putAll((Map<String, Tag<?, ?>>)rawTag.getValue());
                }
                values.remove("id");
                Location loc = entity.getLocation();
                if (!this.brokenEntities) {
                    loc = loc.setPosition(loc.add(min.toVector3()));
                }
                values.put("Id", new StringTag(state.getType().id()));
                values.put("Pos", this.writeVector(loc));
                values.put("Rotation", this.writeRotation(entity.getLocation()));
                CompoundTag entityTag = new CompoundTag(values);
                entities.add(entityTag);
            }
            if (entities.isEmpty()) {
                out.writeNamedEmptyList("Entities");
            } else {
                out.writeNamedTag("Entities", new ListTag(CompoundTag.class, entities));
            }
        });
    }

    private void writeBiomes(Clipboard clipboard, NBTOutputStream out) throws IOException {
        ByteArrayOutputStream biomesCompressed = new ByteArrayOutputStream();
        final DataOutputStream biomesOut = new DataOutputStream(new LZ4BlockOutputStream(biomesCompressed));
        final ArrayList paletteList = new ArrayList();
        final int[] palette = new int[BiomeTypes.getMaxId() + 1];
        Arrays.fill(palette, Integer.MAX_VALUE);
        final int[] paletteMax = new int[]{0};
        IntValueReader task = new IntValueReader(){

            @Override
            public void applyInt(int index, int ordinal) {
                try {
                    int value = palette[ordinal];
                    if (value == Integer.MAX_VALUE) {
                        int size;
                        int n = paletteMax[0];
                        paletteMax[0] = n + 1;
                        palette[ordinal] = value = (size = n);
                        paletteList.add(ordinal);
                    }
                    IOUtil.writeVarInt(biomesOut, value);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        BlockVector3 min = clipboard.getMinimumPoint();
        int width = clipboard.getRegion().getWidth();
        int length = clipboard.getRegion().getLength();
        MutableBlockVector3 mutable = new MutableBlockVector3();
        int i = 0;
        for (int z = 0; z < length; ++z) {
            int z0 = min.z() + z;
            int x = 0;
            while (x < width) {
                int x0 = min.x() + x;
                BiomeType biome = clipboard.getBiome(mutable.setComponents(x0, min.y(), z0));
                task.applyInt(i, biome.getInternalId());
                ++x;
                ++i;
            }
        }
        biomesOut.close();
        out.writeNamedTag("BiomePaletteMax", paletteMax[0]);
        out.writeLazyCompoundTag("BiomePalette", out12 -> {
            for (int i = 0; i < paletteList.size(); ++i) {
                int ordinal = (Integer)paletteList.get(i);
                BiomeType state = BiomeTypes.get(ordinal);
                out12.writeNamedTag(state.id(), i);
            }
        });
        out.writeNamedTagName("BiomeData", 7);
        out.writeInt(biomesOut.size());
        try (LZ4BlockInputStream in = new LZ4BlockInputStream(new ByteArrayInputStream(biomesCompressed.toByteArray()));){
            IOUtil.copy((InputStream)in, out);
        }
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

