/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.function.mask;

import com.fastasyncworldedit.core.function.mask.CachedMask;
import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.AbstractMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.math.BlockVector3;

public class AdjacentAny2DMask
extends AbstractMask {
    private final Mask mask;
    private final MutableBlockVector3 mutable;

    public AdjacentAny2DMask(Mask mask) {
        this(mask, true);
    }

    public AdjacentAny2DMask(Mask mask, boolean cache) {
        this.mask = cache ? CachedMask.cache(mask) : mask;
        this.mutable = new MutableBlockVector3();
    }

    @Override
    public boolean test(BlockVector3 v) {
        int z;
        int y;
        int x = v.x();
        if (this.mask.test(this.mutable.setComponents(x + 1, y = v.y(), z = v.z()))) {
            return true;
        }
        if (this.mask.test(this.mutable.setComponents(x - 1, y, z))) {
            return true;
        }
        if (this.mask.test(this.mutable.setComponents(x, y, z + 1))) {
            return true;
        }
        return this.mask.test(this.mutable.setComponents(x, y, z - 1));
    }

    public boolean test(Extent extent, BlockVector3 position) {
        Mask mask = this.mask;
        if (!(mask instanceof AbstractExtentMask)) {
            throw new UnsupportedOperationException("Adjacency mask must inherit from AbstractExtentMask");
        }
        AbstractExtentMask extentMask = (AbstractExtentMask)mask;
        int x = position.x();
        int y = position.y();
        int z = position.z();
        if (extentMask.test(extent, this.mutable.setComponents(x + 1, y, z))) {
            return true;
        }
        if (extentMask.test(extent, this.mutable.setComponents(x - 1, y, z))) {
            return true;
        }
        if (extentMask.test(extent, this.mutable.setComponents(x, y, z + 1))) {
            return true;
        }
        return extentMask.test(extent, this.mutable.setComponents(x, y, z - 1));
    }

    @Override
    public Mask copy() {
        return new AdjacentAny2DMask(this.mask.copy(), false);
    }
}

