/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.math.heightmap;

import com.fastasyncworldedit.core.math.heightmap.ScalableHeightMap;

public class ArrayHeightMap
extends ScalableHeightMap {
    private final char[][] height;
    private final int width;
    private final int length;
    private final double scale;
    private double rx;
    private double rz;

    public ArrayHeightMap(char[][] height, double scale) {
        this.setSize(5);
        this.height = height;
        this.width = height.length;
        this.length = height[0].length;
        this.scale = scale;
    }

    @Override
    public void setSize(int size) {
        super.setSize(size);
        this.rx = (double)this.width / (double)(size << 1);
        this.rz = (double)this.length / (double)(size << 1);
    }

    @Override
    public double getHeight(int x, int z) {
        x = (int)Math.max(0.0, Math.min((double)(this.width - 1), (double)(x + this.size) * this.rx));
        z = (int)Math.max(0.0, Math.min((double)(this.length - 1), (double)(z + this.size) * this.rz));
        return (double)(this.height[x][z] * this.size) / this.scale;
    }
}

