/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util;

import com.fastasyncworldedit.core.function.mask.ResettableMask;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.AbstractMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import java.lang.reflect.Field;
import java.util.Collection;

public class MaskTraverser {
    private final Mask mask;

    public MaskTraverser(Mask start) {
        this.mask = start;
    }

    public void reset(Extent newExtent) {
        this.reset(this.mask, newExtent);
    }

    private void reset(Mask mask, Extent newExtent) {
        if (mask == null) {
            return;
        }
        if (mask instanceof ResettableMask) {
            ((ResettableMask)((Object)mask)).reset();
        }
        Class<?> current = mask.getClass();
        while (current.getSuperclass() != null) {
            Field field2;
            AbstractMask mask1;
            if (mask instanceof AbstractExtentMask) {
                mask1 = (AbstractExtentMask)mask;
                ((AbstractExtentMask)mask1).setExtent(newExtent);
            } else {
                try {
                    field2 = current.getDeclaredField("extent");
                    field2.setAccessible(true);
                    field2.set(mask, newExtent);
                }
                catch (IllegalAccessException | NoSuchFieldException field2) {
                    // empty catch block
                }
            }
            if (mask instanceof MaskIntersection) {
                mask1 = (MaskIntersection)mask;
                try {
                    Field field3 = mask1.getClass().getDeclaredField("masks");
                    field3.setAccessible(true);
                    Collection masks = (Collection)field3.get(mask);
                    for (Mask next : masks) {
                        this.reset(next, newExtent);
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException field3) {
                    // empty catch block
                }
            }
            try {
                field2 = current.getDeclaredField("mask");
                field2.setAccessible(true);
                Mask next = (Mask)field2.get(mask);
                this.reset(next, newExtent);
            }
            catch (IllegalAccessException | NoSuchFieldException field4) {
                // empty catch block
            }
            try {
                field2 = current.getDeclaredField("masks");
                field2.setAccessible(true);
                Collection masks = (Collection)field2.get(mask);
                for (Mask next : masks) {
                    this.reset(next, newExtent);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            current = current.getSuperclass();
        }
    }

    public void setNewExtent(Extent newExtent) {
        this.setNewExtent(this.mask, newExtent);
    }

    private void setNewExtent(Mask mask, Extent newExtent) {
        if (mask == null) {
            return;
        }
        Class<?> current = mask.getClass();
        while (current.getSuperclass() != null) {
            Field field2;
            AbstractMask mask1;
            if (mask instanceof AbstractExtentMask) {
                mask1 = (AbstractExtentMask)mask;
                ((AbstractExtentMask)mask1).setExtent(newExtent);
            } else {
                try {
                    field2 = current.getDeclaredField("extent");
                    field2.setAccessible(true);
                    field2.set(mask, newExtent);
                }
                catch (IllegalAccessException | NoSuchFieldException field2) {
                    // empty catch block
                }
            }
            if (mask instanceof MaskIntersection) {
                mask1 = (MaskIntersection)mask;
                try {
                    Field field3 = mask1.getClass().getDeclaredField("masks");
                    field3.setAccessible(true);
                    Collection masks = (Collection)field3.get(mask);
                    for (Mask next : masks) {
                        this.setNewExtent(next, newExtent);
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException field3) {
                    // empty catch block
                }
            }
            try {
                field2 = current.getDeclaredField("mask");
                field2.setAccessible(true);
                Mask next = (Mask)field2.get(mask);
                this.setNewExtent(next, newExtent);
            }
            catch (IllegalAccessException | NoSuchFieldException field4) {
                // empty catch block
            }
            try {
                field2 = current.getDeclaredField("masks");
                field2.setAccessible(true);
                Collection masks = (Collection)field2.get(mask);
                for (Mask next : masks) {
                    this.setNewExtent(next, newExtent);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            current = current.getSuperclass();
        }
    }
}

