/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.io.IOException;
import java.lang.reflect.Type;
import org.enginehub.linbus.format.snbt.LinStringIO;
import org.enginehub.linbus.tree.LinCompoundTag;

public final class BaseItemAdapter
implements JsonDeserializer<BaseItem>,
JsonSerializer<BaseItem> {
    public BaseItem deserialize(JsonElement json, Type type, JsonDeserializationContext cont) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement id = jsonObject.get("id");
        if (id != null) {
            ItemType itemType = ItemTypes.get(id.getAsString());
            if (itemType == null) {
                throw new JsonParseException("Could not parse item type `" + String.valueOf(id) + "`");
            }
            return new BaseItem(itemType);
        }
        ItemType itemType = (ItemType)cont.deserialize((JsonElement)jsonObject.get("itemType").getAsJsonObject(), ItemType.class);
        JsonElement nbt = jsonObject.get("nbt");
        if (nbt == null) {
            return new BaseItem(itemType);
        }
        try {
            return new BaseItem(itemType, LazyReference.computed(LinCompoundTag.readFrom(LinStringIO.readFromString(nbt.getAsString()))));
        }
        catch (IOException e) {
            throw new JsonParseException("Could not deserialize BaseItem", (Throwable)e);
        }
    }

    public JsonElement serialize(BaseItem baseItem, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject obj = new JsonObject();
        obj.add("itemType", jsonSerializationContext.serialize((Object)baseItem.getType()));
        obj.add("nbt", (JsonElement)(baseItem.getNbt() == null ? null : new JsonPrimitive(LinStringIO.writeToString(baseItem.getNbt()))));
        return obj;
    }
}

