/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jnbt;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongArrayTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.enginehub.linbus.common.LinTagId;
import org.enginehub.linbus.tree.LinByteArrayTag;
import org.enginehub.linbus.tree.LinByteTag;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinDoubleTag;
import org.enginehub.linbus.tree.LinFloatTag;
import org.enginehub.linbus.tree.LinIntArrayTag;
import org.enginehub.linbus.tree.LinIntTag;
import org.enginehub.linbus.tree.LinListTag;
import org.enginehub.linbus.tree.LinLongArrayTag;
import org.enginehub.linbus.tree.LinLongTag;
import org.enginehub.linbus.tree.LinShortTag;
import org.enginehub.linbus.tree.LinStringTag;
import org.enginehub.linbus.tree.LinTag;
import org.enginehub.linbus.tree.LinTagType;

@Deprecated(forRemoval=true)
public class LinBusConverter {
    private static final BiMap<Class<? extends Tag>, LinTagType<?>> TAG_TYPES = new ImmutableBiMap.Builder().put(ByteArrayTag.class, LinTagType.byteArrayTag()).put(ByteTag.class, LinTagType.byteTag()).put(CompoundTag.class, LinTagType.compoundTag()).put(DoubleTag.class, LinTagType.doubleTag()).put(EndTag.class, LinTagType.endTag()).put(FloatTag.class, LinTagType.floatTag()).put(IntArrayTag.class, LinTagType.intArrayTag()).put(IntTag.class, LinTagType.intTag()).put(ListTag.class, LinTagType.listTag()).put(LongArrayTag.class, LinTagType.longArrayTag()).put(LongTag.class, LinTagType.longTag()).put(ShortTag.class, LinTagType.shortTag()).put(StringTag.class, LinTagType.stringTag()).build();
    private static final Map<LinTagType<?>, Function<LinTag, Tag>> CONVERSION;

    public static LinTagType<?> getAdventureType(Class<? extends Tag> type) {
        return Objects.requireNonNull((LinTagType)TAG_TYPES.get(type), () -> "Missing entry for " + String.valueOf(type));
    }

    public static Class<? extends Tag> getJNBTType(LinTagType<?> type) {
        return Objects.requireNonNull((Class)TAG_TYPES.inverse().get(type), () -> "Missing entry for " + String.valueOf(type));
    }

    public static <V, LT extends LinTag<? extends V>> Tag<V, LT> toJnbtTag(LT tag) {
        return switch (tag.type().id()) {
            default -> throw new MatchException(null, null);
            case LinTagId.BYTE_ARRAY -> new ByteArrayTag((LinByteArrayTag)tag);
            case LinTagId.BYTE -> new ByteTag((LinByteTag)tag);
            case LinTagId.COMPOUND -> new CompoundTag((LinCompoundTag)tag);
            case LinTagId.DOUBLE -> new DoubleTag((LinDoubleTag)tag);
            case LinTagId.END -> new EndTag();
            case LinTagId.FLOAT -> new FloatTag((LinFloatTag)tag);
            case LinTagId.INT_ARRAY -> new IntArrayTag((LinIntArrayTag)tag);
            case LinTagId.INT -> new IntTag((LinIntTag)tag);
            case LinTagId.LIST -> new ListTag((LinListTag)tag);
            case LinTagId.LONG_ARRAY -> new LongArrayTag((LinLongArrayTag)tag);
            case LinTagId.LONG -> new LongTag((LinLongTag)tag);
            case LinTagId.SHORT -> new ShortTag((LinShortTag)tag);
            case LinTagId.STRING -> new StringTag((LinStringTag)tag);
        };
    }

    private LinBusConverter() {
    }

    public static Tag fromLinBus(LinTag other) {
        if (other == null) {
            return null;
        }
        Function<LinTag, Tag> conversion = CONVERSION.get(other.type());
        if (conversion == null) {
            throw new IllegalArgumentException("Can't convert other of type " + other.getClass().getCanonicalName());
        }
        return conversion.apply(other);
    }

    static {
        ImmutableMap.Builder conversion = ImmutableMap.builder();
        block0: for (Map.Entry tag : TAG_TYPES.entrySet()) {
            Constructor<?>[] constructors;
            for (Constructor<?> c : constructors = ((Class)tag.getKey()).getConstructors()) {
                if (c.getParameterCount() != 1 || !LinTag.class.isAssignableFrom(c.getParameterTypes()[0])) continue;
                conversion.put((Object)((LinTagType)tag.getValue()), linTag -> {
                    try {
                        return (Tag)c.newInstance(linTag);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw (RuntimeException)e.getCause();
                    }
                });
                continue block0;
            }
        }
        CONVERSION = conversion.build();
    }
}

