/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.FaweRegionExtent;
import com.fastasyncworldedit.core.extent.PassthroughExtent;
import com.fastasyncworldedit.core.extent.ProcessedWEExtent;
import com.fastasyncworldedit.core.extent.ResettableExtent;
import com.fastasyncworldedit.core.extent.SingleRegionExtent;
import com.fastasyncworldedit.core.extent.SourceMaskExtent;
import com.fastasyncworldedit.core.extent.clipboard.WorldCopyClipboard;
import com.fastasyncworldedit.core.extent.processor.ExtentBatchProcessorHolder;
import com.fastasyncworldedit.core.extent.processor.lighting.NullRelighter;
import com.fastasyncworldedit.core.extent.processor.lighting.Relighter;
import com.fastasyncworldedit.core.function.SurfaceRegionFunction;
import com.fastasyncworldedit.core.function.generator.GenBase;
import com.fastasyncworldedit.core.function.generator.OreGen;
import com.fastasyncworldedit.core.function.generator.SchemGen;
import com.fastasyncworldedit.core.function.mask.BlockMaskBuilder;
import com.fastasyncworldedit.core.function.mask.ResettableMask;
import com.fastasyncworldedit.core.function.mask.SingleBlockTypeMask;
import com.fastasyncworldedit.core.function.mask.WallMakeMask;
import com.fastasyncworldedit.core.function.pattern.ExistingPattern;
import com.fastasyncworldedit.core.function.visitor.DirectionalVisitor;
import com.fastasyncworldedit.core.history.changeset.AbstractChangeSet;
import com.fastasyncworldedit.core.history.changeset.BlockBagChangeSet;
import com.fastasyncworldedit.core.limit.FaweLimit;
import com.fastasyncworldedit.core.math.LocalBlockVectorSet;
import com.fastasyncworldedit.core.math.MutableBlockVector2;
import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.fastasyncworldedit.core.math.MutableVector3;
import com.fastasyncworldedit.core.math.random.SimplexNoise;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.implementation.preloader.Preloader;
import com.fastasyncworldedit.core.util.ExtentTraverser;
import com.fastasyncworldedit.core.util.MaskTraverser;
import com.fastasyncworldedit.core.util.MathMan;
import com.fastasyncworldedit.core.util.ProcessorTraverser;
import com.fastasyncworldedit.core.util.TaskManager;
import com.fastasyncworldedit.core.util.collection.BlockVector3Set;
import com.fastasyncworldedit.core.util.task.RunnableVal;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSessionBuilder;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.MaskingExtent;
import com.sk89q.worldedit.extent.TracingExtent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.extent.inventory.BlockBagExtent;
import com.sk89q.worldedit.extent.world.SurvivalModeExtent;
import com.sk89q.worldedit.extent.world.WatchdogTickingExtent;
import com.sk89q.worldedit.function.GroundFunction;
import com.sk89q.worldedit.function.block.BlockReplace;
import com.sk89q.worldedit.function.block.Naturalizer;
import com.sk89q.worldedit.function.block.SnowSimulator;
import com.sk89q.worldedit.function.generator.ForestGenerator;
import com.sk89q.worldedit.function.generator.GardenPatchGenerator;
import com.sk89q.worldedit.function.mask.AbstractMask;
import com.sk89q.worldedit.function.mask.BlockStateMask;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.function.mask.BoundedHeightMask;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.function.mask.MaskUnion;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.function.mask.NoiseFilter2D;
import com.sk89q.worldedit.function.mask.RegionMask;
import com.sk89q.worldedit.function.operation.ChangeSetExecutor;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.pattern.WaterloggedRemover;
import com.sk89q.worldedit.function.util.RegionOffset;
import com.sk89q.worldedit.function.visitor.DownwardVisitor;
import com.sk89q.worldedit.function.visitor.FlatRegionVisitor;
import com.sk89q.worldedit.function.visitor.LayerVisitor;
import com.sk89q.worldedit.function.visitor.NonRisingVisitor;
import com.sk89q.worldedit.function.visitor.RecursiveVisitor;
import com.sk89q.worldedit.function.visitor.RegionVisitor;
import com.sk89q.worldedit.history.UndoContext;
import com.sk89q.worldedit.history.changeset.ChangeSet;
import com.sk89q.worldedit.internal.expression.EvaluationException;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.internal.expression.ExpressionTimeoutException;
import com.sk89q.worldedit.internal.expression.LocalSlot;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MathUtils;
import com.sk89q.worldedit.math.Vector2;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.interpolation.KochanekBartelsInterpolation;
import com.sk89q.worldedit.math.interpolation.Node;
import com.sk89q.worldedit.math.noise.RandomNoise;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.CylinderRegion;
import com.sk89q.worldedit.regions.EllipsoidRegion;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.regions.NullRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionIntersection;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.regions.Regions;
import com.sk89q.worldedit.regions.shape.ArbitraryBiomeShape;
import com.sk89q.worldedit.regions.shape.ArbitraryShape;
import com.sk89q.worldedit.regions.shape.RegionShape;
import com.sk89q.worldedit.regions.shape.WorldEditExpressionEnvironment;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.util.Countable;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.collection.BlockMap;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.generation.ConfiguredFeatureType;
import com.sk89q.worldedit.world.generation.StructureType;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public class EditSession
extends PassthroughExtent
implements AutoCloseable {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    protected final World world;
    @Nullable
    private final Actor actor;
    private final FaweLimit originalLimit;
    private final FaweLimit limit;
    private AbstractChangeSet changeSet;
    private boolean history;
    private final MutableBlockVector3 mutableBlockVector3 = new MutableBlockVector3();
    private int changes = 0;
    private final BlockBag blockBag;
    private final Extent bypassHistory;
    private final Extent bypassAll;
    private final int minY;
    private final int maxY;
    private final List<WatchdogTickingExtent> watchdogExtents = new ArrayList<WatchdogTickingExtent>(2);
    @Nullable
    private final List<TracingExtent> tracingExtents;
    private final Relighter relighter;
    private final boolean wnaMode;
    @Nullable
    private final Region[] allowedRegions;
    private static final BlockVector3[] recurseDirections = new BlockVector3[]{Direction.NORTH.toBlockVector(), Direction.EAST.toBlockVector(), Direction.SOUTH.toBlockVector(), Direction.WEST.toBlockVector(), Direction.UP.toBlockVector(), Direction.DOWN.toBlockVector()};

    EditSession(EditSessionBuilder builder) {
        super(builder.compile().getExtent());
        this.world = builder.getWorld();
        this.bypassHistory = builder.getBypassHistory();
        this.bypassAll = builder.getBypassAll();
        this.originalLimit = builder.getLimit();
        this.limit = builder.getLimit().copy();
        this.actor = builder.getActor();
        this.changeSet = builder.getChangeTask();
        this.minY = this.world != null ? this.world.getMinY() : WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).versionMinY();
        this.maxY = this.world != null ? this.world.getMaxY() : WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).versionMaxY();
        this.blockBag = builder.getBlockBag();
        this.history = this.changeSet != null;
        this.relighter = builder.getRelighter();
        this.wnaMode = builder.isWNAMode();
        if (builder.isTracing()) {
            this.tracingExtents = new ArrayList<TracingExtent>();
            Preconditions.checkNotNull((Object)this.actor, (Object)"A player is required while tracing");
        } else {
            this.tracingExtents = null;
        }
        this.allowedRegions = builder.getAllowedRegions() != null ? (Region[])builder.getAllowedRegions().clone() : null;
    }

    public FaweLimit getLimit() {
        return this.originalLimit;
    }

    public void resetLimit() {
        this.limit.set(this.originalLimit);
        ExtentTraverser<ProcessedWEExtent> find = new ExtentTraverser<Extent>(this.getExtent()).find(ProcessedWEExtent.class);
        if (find != null && find.get() != null) {
            find.get().setLimit(this.limit);
        }
    }

    public FaweLimit getLimitUsed() {
        return this.originalLimit.getLimitUsed(this.limit);
    }

    public FaweLimit getLimitLeft() {
        return this.limit;
    }

    public FaweRegionExtent getRegionExtent() {
        ExtentTraverser<FaweRegionExtent> traverser = new ExtentTraverser<Extent>(this.getExtent()).find(FaweRegionExtent.class);
        return traverser == null ? null : traverser.get();
    }

    public Extent getBypassAll() {
        return this.bypassAll;
    }

    public Extent getBypassHistory() {
        return this.bypassHistory;
    }

    public void setExtent(AbstractDelegateExtent extent) {
        new ExtentTraverser<EditSession>(this).setNext((EditSession)extent);
    }

    @Nullable
    public Actor getActor() {
        return this.actor;
    }

    private Extent traceIfNeeded(Extent input) {
        Extent output = input;
        if (this.tracingExtents != null) {
            TracingExtent newExtent = new TracingExtent(input);
            output = newExtent;
            this.tracingExtents.add(newExtent);
        }
        return output;
    }

    private boolean commitRequired() {
        return false;
    }

    private List<TracingExtent> getActiveTracingExtents() {
        if (this.tracingExtents == null) {
            return List.of();
        }
        return this.tracingExtents.stream().filter(TracingExtent::isActive).collect(Collectors.toList());
    }

    public void enableStandardMode() {
        this.setBatchingChunks(true);
    }

    @Deprecated
    public void setReorderMode(ReorderMode reorderMode) {
        switch (reorderMode.ordinal()) {
            case 0: {
                this.enableQueue();
                break;
            }
            case 1: 
            case 2: {
                this.disableQueue();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not implemented: " + String.valueOf((Object)reorderMode));
            }
        }
    }

    @Deprecated
    public ReorderMode getReorderMode() {
        if (this.isQueueEnabled()) {
            return ReorderMode.MULTI_STAGE;
        }
        return ReorderMode.FAST;
    }

    public World getWorld() {
        return this.world;
    }

    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    public void setRawChangeSet(@Nullable AbstractChangeSet set) {
        this.changeSet = set;
        ++this.changes;
    }

    @Deprecated
    public long getBlockChangeLimit() {
        return this.originalLimit.MAX_CHANGES.get();
    }

    public void setBlockChangeLimit(long limit) {
        this.limit.MAX_CHANGES.set(limit);
    }

    @Override
    @Deprecated
    public boolean isQueueEnabled() {
        return true;
    }

    @Override
    @Deprecated
    public void enableQueue() {
        super.enableQueue();
    }

    @Override
    @Deprecated
    public void disableQueue() {
        super.disableQueue();
    }

    public Mask getMask() {
        ExtentBatchProcessorHolder processorExtent;
        MaskingExtent maskingExtent = new ExtentTraverser<Extent>(this.getExtent()).findAndGet(MaskingExtent.class);
        if (maskingExtent == null && (processorExtent = new ExtentTraverser<Extent>(this.getExtent()).findAndGet(ExtentBatchProcessorHolder.class)) != null) {
            maskingExtent = new ProcessorTraverser<IBatchProcessor>(processorExtent.getProcessor()).find(MaskingExtent.class);
        }
        return maskingExtent != null ? maskingExtent.getMask() : null;
    }

    public Mask getSourceMask() {
        ExtentTraverser<SourceMaskExtent> maskingExtent = new ExtentTraverser<Extent>(this.getExtent()).find(SourceMaskExtent.class);
        return maskingExtent != null ? maskingExtent.get().getMask() : null;
    }

    @Nullable
    public Region[] getAllowedRegions() {
        return this.allowedRegions;
    }

    public void addTransform(ResettableExtent transform) {
        Preconditions.checkNotNull((Object)transform);
        transform.setExtent(this.getExtent());
        new ExtentTraverser<EditSession>(this).setNext((EditSession)((Object)transform));
    }

    @Nullable
    public ResettableExtent getTransform() {
        ExtentTraverser<ResettableExtent> traverser = new ExtentTraverser<Extent>(this.getExtent()).find(ResettableExtent.class);
        if (traverser != null) {
            return traverser.get();
        }
        return null;
    }

    public void setSourceMask(Mask mask) {
        if (mask == null) {
            mask = Masks.alwaysTrue();
        } else {
            new MaskTraverser(mask).reset(this);
        }
        ExtentTraverser<SourceMaskExtent> maskingExtent = new ExtentTraverser<Extent>(this.getExtent()).find(SourceMaskExtent.class);
        if (maskingExtent != null && maskingExtent.get() != null) {
            Mask oldMask = maskingExtent.get().getMask();
            if (oldMask instanceof ResettableMask) {
                ((ResettableMask)((Object)oldMask)).reset();
            }
            maskingExtent.get().setMask(mask);
        } else if (mask != Masks.alwaysTrue()) {
            SourceMaskExtent next = new SourceMaskExtent(this.getExtent(), mask);
            new ExtentTraverser<EditSession>(this).setNext((EditSession)((Object)next));
        }
    }

    public void addSourceMask(Mask mask) {
        Preconditions.checkNotNull((Object)mask);
        Mask existing = this.getSourceMask();
        if (existing != null) {
            if (existing instanceof MaskIntersection) {
                HashSet<Mask> masks = new HashSet<Mask>(((MaskIntersection)existing).getMasks());
                masks.add(mask);
                mask = new MaskIntersection(masks);
            } else {
                mask = new MaskIntersection(existing, mask);
            }
            mask = mask.optimize();
        }
        this.setSourceMask(mask);
    }

    public void setMask(@Nullable Mask mask) {
        ExtentBatchProcessorHolder processorExtent;
        if (mask == null) {
            mask = Masks.alwaysTrue();
        } else {
            new MaskTraverser(mask).reset(this);
        }
        MaskingExtent maskingExtent = new ExtentTraverser<Extent>(this.getExtent()).findAndGet(MaskingExtent.class);
        if (maskingExtent == null && mask != Masks.alwaysTrue() && (processorExtent = new ExtentTraverser<Extent>(this.getExtent()).findAndGet(ExtentBatchProcessorHolder.class)) != null) {
            maskingExtent = new ProcessorTraverser<IBatchProcessor>(processorExtent.getProcessor()).find(MaskingExtent.class);
        }
        if (maskingExtent != null) {
            Mask oldMask = maskingExtent.getMask();
            if (oldMask instanceof ResettableMask) {
                ((ResettableMask)((Object)oldMask)).reset();
            }
            maskingExtent.setMask(mask);
        } else if (mask != Masks.alwaysTrue()) {
            this.addProcessor(new MaskingExtent(this.getExtent(), mask));
        }
    }

    public SurvivalModeExtent getSurvivalExtent() {
        ExtentTraverser<SurvivalModeExtent> survivalExtent = new ExtentTraverser<Extent>(this.getExtent()).find(SurvivalModeExtent.class);
        if (survivalExtent != null) {
            return survivalExtent.get();
        }
        SurvivalModeExtent survival = new SurvivalModeExtent(this.getExtent(), this.getWorld());
        this.setExtent(survival);
        return survival;
    }

    @Deprecated
    public void setFastMode(boolean enabled) {
        this.disableHistory(enabled);
    }

    public void setSideEffectApplier(SideEffectSet sideEffectSet) {
    }

    public SideEffectSet getSideEffectApplier() {
        return SideEffectSet.defaults();
    }

    @Deprecated
    public void disableHistory(boolean disableHistory) {
        if (disableHistory) {
            if (this.history) {
                this.disableHistory();
                this.history = false;
            }
        } else if (this.history) {
            if (this.changeSet == null) {
                throw new IllegalArgumentException("History was never provided, cannot enable");
            }
            this.enableHistory(this.changeSet);
        }
    }

    @Deprecated
    public boolean hasFastMode() {
        return this.getChangeSet() == null;
    }

    public BlockBag getBlockBag() {
        return this.blockBag;
    }

    public void setBlockBag(BlockBag blockBag) {
        throw new UnsupportedOperationException("TODO - this is never called anyway");
    }

    @Override
    public String toString() {
        return super.toString() + ":" + String.valueOf(this.getExtent());
    }

    public Map<BlockType, Integer> popMissingBlocks() {
        BlockBag bag = this.getBlockBag();
        if (bag != null) {
            ExtentTraverser<BlockBagExtent> find;
            bag.flushChanges();
            ChangeSet changeSet = this.getChangeSet();
            Map<BlockType, Integer> missingBlocks = changeSet instanceof BlockBagChangeSet ? ((BlockBagChangeSet)changeSet).popMissing() : ((find = new ExtentTraverser<Extent>(this.getExtent()).find(BlockBagExtent.class)) != null && find.get() != null ? find.get().popMissing() : null);
            if (missingBlocks != null && !missingBlocks.isEmpty()) {
                StringBuilder str = new StringBuilder();
                int size = missingBlocks.size();
                int i = 0;
                for (Map.Entry<BlockType, Integer> entry : missingBlocks.entrySet()) {
                    BlockType type = entry.getKey();
                    int amount = entry.getValue();
                    str.append(type.getName()).append((String)(amount != 1 ? "x" + amount : ""));
                    if (++i == size) continue;
                    str.append(", ");
                }
                this.actor.print(Caption.of("fawe.error.worldedit.some.fails.blockbag", str.toString()));
            }
        }
        return Collections.emptyMap();
    }

    public boolean isBatchingChunks() {
        return false;
    }

    public void setBatchingChunks(boolean batchingChunks) {
        if (batchingChunks) {
            this.enableQueue();
        } else {
            this.disableQueue();
        }
    }

    public boolean isBufferingEnabled() {
        return this.isBatchingChunks();
    }

    public void disableBuffering() {
        this.disableQueue();
    }

    public boolean isTickingWatchdog() {
        return this.watchdogExtents.stream().anyMatch(WatchdogTickingExtent::isEnabled);
    }

    public void setTickingWatchdog(boolean active) {
        for (WatchdogTickingExtent extent : this.watchdogExtents) {
            extent.setEnabled(active);
        }
    }

    public int getBlockChangeCount() {
        return this.changes;
    }

    @Override
    public boolean fullySupports3DBiomes() {
        return this.getExtent().fullySupports3DBiomes();
    }

    @Override
    public BiomeType getBiome(BlockVector3 position) {
        return this.getExtent().getBiome(position);
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        if (position.y() < this.minY || position.y() > this.maxY) {
            return false;
        }
        ++this.changes;
        return this.getExtent().setBiome(position, biome);
    }

    @Override
    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        if (y < this.minY || y > this.maxY) {
            return false;
        }
        ++this.changes;
        return this.getExtent().setBiome(x, y, z, biome);
    }

    @Override
    public int getHighestTerrainBlock(int x, int z, int minY, int maxY) {
        for (int y = maxY; y >= minY; --y) {
            if (!this.getBlock(x, y, z).getBlockType().getMaterial().isMovementBlocker()) continue;
            return y;
        }
        return minY;
    }

    @Override
    public int getHighestTerrainBlock(int x, int z, int minY, int maxY, Mask filter) {
        for (int y = maxY; y >= minY; --y) {
            if (!filter.test(this.mutableBlockVector3.setComponents(x, y, z))) continue;
            return y;
        }
        return minY;
    }

    public BlockType getBlockType(int x, int y, int z) {
        return this.getBlock(x, y, z).getBlockType();
    }

    @Deprecated
    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block, Stage stage) throws WorldEditException {
        if (position.y() < this.minY || position.y() > this.maxY) {
            return false;
        }
        ++this.changes;
        switch (stage.ordinal()) {
            case 0: {
                return this.getExtent().setBlock(position, block);
            }
            case 2: {
                return this.bypassHistory.setBlock(position, block);
            }
            case 1: {
                return this.bypassAll.setBlock(position, block);
            }
        }
        throw new RuntimeException("New enum entry added that is unhandled here");
    }

    @Deprecated
    public <B extends BlockStateHolder<B>> boolean rawSetBlock(BlockVector3 position, B block) {
        if (position.y() < this.minY || position.y() > this.maxY) {
            return false;
        }
        ++this.changes;
        try {
            return this.bypassAll.setBlock(position, block);
        }
        catch (WorldEditException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public <B extends BlockStateHolder<B>> boolean smartSetBlock(BlockVector3 position, B block) {
        if (position.y() < this.minY || position.y() > this.maxY) {
            return false;
        }
        ++this.changes;
        try {
            return this.setBlock(position, block, Stage.BEFORE_REORDER);
        }
        catch (WorldEditException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    @Deprecated
    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block) throws MaxChangedBlocksException {
        if (position.y() < this.minY || position.y() > this.maxY) {
            return false;
        }
        ++this.changes;
        try {
            return this.getExtent().setBlock(position, block);
        }
        catch (MaxChangedBlocksException e) {
            throw e;
        }
        catch (WorldEditException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(int x, int y, int z, B block) {
        if (y < this.minY || y > this.maxY) {
            return false;
        }
        ++this.changes;
        try {
            return this.getExtent().setBlock(x, y, z, block);
        }
        catch (WorldEditException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public boolean setBlock(int x, int y, int z, Pattern pattern) {
        if (y < this.minY || y > this.maxY) {
            return false;
        }
        ++this.changes;
        try {
            MutableBlockVector3 bv = this.mutableBlockVector3.setComponents(x, y, z);
            return pattern.apply(this.getExtent(), bv, bv);
        }
        catch (WorldEditException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public boolean setBlock(BlockVector3 position, Pattern pattern) throws MaxChangedBlocksException {
        if (position.y() < this.minY || position.y() > this.maxY) {
            return false;
        }
        ++this.changes;
        try {
            return pattern.apply(this.getExtent(), position, position);
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <B extends BlockStateHolder<B>> int setBlocks(Region region, B block) throws MaxChangedBlocksException {
        this.changes = super.setBlocks(region, block);
        return this.changes;
    }

    @Override
    public int setBlocks(Region region, Pattern pattern) throws MaxChangedBlocksException {
        this.changes = super.setBlocks(region, pattern);
        return this.changes;
    }

    @Override
    public int setBlocks(Set<BlockVector3> vset, Pattern pattern) {
        this.changes = super.setBlocks(vset, pattern);
        return this.changes;
    }

    public void undo(EditSession editSession) {
        UndoContext context = new UndoContext();
        context.setExtent(editSession.bypassAll);
        ChangeSet changeSet = this.getChangeSet();
        this.setChangeSet(null);
        Operations.completeBlindly(ChangeSetExecutor.create(changeSet, context, ChangeSetExecutor.Type.UNDO, editSession.getBlockBag(), editSession.getLimit().INVENTORY_MODE));
        this.flushQueue();
        editSession.changes = 1;
    }

    public void setBlocks(ChangeSet changeSet, ChangeSetExecutor.Type type) {
        UndoContext context = new UndoContext();
        context.setExtent(this.bypassAll);
        Operations.completeBlindly(ChangeSetExecutor.create(changeSet, context, type, this.getBlockBag(), this.getLimit().INVENTORY_MODE));
        this.flushQueue();
        this.changes = 1;
    }

    public void redo(EditSession editSession) {
        UndoContext context = new UndoContext();
        context.setExtent(editSession.bypassAll);
        ChangeSet changeSet = this.getChangeSet();
        this.setChangeSet(null);
        Operations.completeBlindly(ChangeSetExecutor.create(changeSet, context, ChangeSetExecutor.Type.REDO, editSession.getBlockBag(), editSession.getLimit().INVENTORY_MODE));
        this.flushQueue();
        editSession.changes = 1;
    }

    public boolean isTrackingHistory() {
        return this.history;
    }

    public void setTrackingHistory(boolean trackHistory) {
        if (trackHistory) {
            if (this.history) {
                if (this.changeSet == null) {
                    throw new IllegalStateException("No ChangeSetExtent is available");
                }
                this.enableHistory(this.changeSet);
            }
        } else if (this.history) {
            this.disableHistory();
            this.history = false;
        }
    }

    public int size() {
        return this.getBlockChangeCount();
    }

    @Override
    public BlockVector3 getMinimumPoint() {
        return this.getWorld().getMinimumPoint();
    }

    @Override
    public BlockVector3 getMaximumPoint() {
        return this.getWorld().getMaximumPoint();
    }

    public void setSize(int size) {
        this.changes = size;
    }

    @Override
    public void close() {
        this.flushQueue();
        this.dumpTracingInformation();
    }

    private void dumpTracingInformation() {
        if (this.tracingExtents == null) {
            return;
        }
        List<TracingExtent> tracingExtents = this.getActiveTracingExtents();
        assert (this.actor != null);
        if (tracingExtents.isEmpty()) {
            this.actor.print(TextComponent.of("worldedit.trace.no-tracing-extents"));
            return;
        }
        LinkedHashSet stacks = new LinkedHashSet();
        HashMap<List, BlockVector3> stackToPosition = new HashMap<List, BlockVector3>();
        Set<BlockVector3> touchedLocations = Collections.newSetFromMap(BlockMap.create());
        for (TracingExtent tracingExtent : tracingExtents) {
            touchedLocations.addAll(tracingExtent.getTouchedLocations());
        }
        for (BlockVector3 loc : touchedLocations) {
            List stack2 = tracingExtents.stream().filter(it -> it.getTouchedLocations().contains(loc)).collect(Collectors.toList());
            boolean anyFailed = stack2.stream().anyMatch(it -> it.getFailedActions().containsKey((Object)loc));
            if (!anyFailed || !stacks.add(stack2)) continue;
            stackToPosition.put(stack2, loc);
        }
        stackToPosition.forEach((stack, position) -> {
            TracingExtent failure = (TracingExtent)stack.get(0);
            this.actor.printDebug(Caption.of("worldedit.trace.action-failed", failure.getFailedActions().get(position).toString(), position.toString(), failure.getExtent().getClass().getName()));
        });
    }

    @Deprecated
    public void flushSession() {
        this.flushQueue();
    }

    public void flushQueue() {
        Preloader preloader;
        block19: {
            Operations.completeBlindly(this.commit());
            FaweLimit used = this.getLimitUsed();
            if (used.MAX_FAILS.get() > 0) {
                if (used.MAX_CHANGES.get() > 0L || used.MAX_ENTITIES.get() > 0) {
                    this.actor.print(Caption.of("fawe.error.worldedit.some.fails", used.MAX_FAILS));
                } else if (new ExtentTraverser<Extent>(this.getExtent()).findAndGet(FaweRegionExtent.class) != null) {
                    this.actor.print(Caption.of("fawe.cancel.reason.outside.region", new Object[0]));
                } else {
                    this.actor.print(Caption.of("fawe.cancel.reason.outside.level", new Object[0]));
                }
            }
            if (this.wnaMode) {
                this.getWorld().flush();
            }
            this.limit.set(this.originalLimit);
            try {
                if (this.relighter == null || this.relighter instanceof NullRelighter || this.relighter.isFinished() || !this.relighter.getLock().tryLock()) break block19;
                try {
                    if (Settings.settings().LIGHTING.REMOVE_FIRST) {
                        this.relighter.removeAndRelight(true);
                    } else {
                        this.relighter.fixLightingSafe(true);
                    }
                }
                finally {
                    this.relighter.getLock().unlock();
                }
            }
            catch (Throwable e) {
                this.actor.print(Caption.of("fawe.error.lighting", new Object[0]));
                e.printStackTrace();
            }
        }
        if (this.getActor() instanceof Player && (preloader = Fawe.platform().getPreloader(false)) != null) {
            preloader.cancel(this.getActor());
        }
        if (this.getChangeSet() != null) {
            if (Settings.settings().HISTORY.COMBINE_STAGES) {
                ((AbstractChangeSet)this.getChangeSet()).closeAsync();
            } else {
                try {
                    this.getChangeSet().close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public <B extends BlockStateHolder<B>> int fall(Region region, boolean fullHeight, B replace) {
        FlatRegion flat = Regions.asFlatRegion(region);
        int startPerformY = region.getMinimumPoint().y();
        int startCheckY = fullHeight ? this.getMinY() : startPerformY;
        int endY = region.getMaximumPoint().y();
        RegionVisitor visitor = new RegionVisitor(flat, pos -> {
            int x = pos.x();
            int z = pos.z();
            int freeSpot = startCheckY;
            for (int y = startCheckY; y <= endY; ++y) {
                if (y < startPerformY) {
                    if (this.getBlockType(x, y, z).getMaterial().isAir()) continue;
                    freeSpot = y + 1;
                    continue;
                }
                BlockType block = this.getBlockType(x, y, z);
                if (block.getMaterial().isAir()) continue;
                if (freeSpot != y) {
                    this.setBlock(x, freeSpot, z, block);
                    this.setBlock(x, y, z, (B)replace);
                }
                ++freeSpot;
            }
            return true;
        }, this);
        Operations.completeBlindly(visitor);
        return this.changes;
    }

    @Override
    public <B extends BlockStateHolder<B>> int replaceBlocks(Region region, Set<BaseBlock> filter, B replacement) throws MaxChangedBlocksException {
        this.changes = super.replaceBlocks(region, filter, replacement);
        return this.changes;
    }

    @Override
    public int replaceBlocks(Region region, Set<BaseBlock> filter, Pattern pattern) throws MaxChangedBlocksException {
        this.changes = super.replaceBlocks(region, filter, pattern);
        return this.changes;
    }

    @Override
    public int replaceBlocks(Region region, Mask mask, Pattern pattern) throws MaxChangedBlocksException {
        this.changes = super.replaceBlocks(region, mask, pattern);
        return this.changes;
    }

    public int fillDirection(BlockVector3 origin, Pattern pattern, double radius, int depth, BlockVector3 direction) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)origin);
        Preconditions.checkNotNull((Object)pattern);
        Preconditions.checkArgument((radius >= 0.0 ? 1 : 0) != 0, (Object)"radius >= 0");
        Preconditions.checkArgument((depth >= 1 ? 1 : 0) != 0, (Object)"depth >= 1");
        if (direction.equals(BlockVector3.UNIT_MINUS_Y)) {
            return this.fillXZ(origin, pattern, radius, depth, false);
        }
        MaskIntersection mask = new MaskIntersection(new RegionMask(new EllipsoidRegion(null, origin, Vector3.at(radius, radius, radius))), Masks.negate(new ExistingBlockMask(this)));
        BlockReplace replace = new BlockReplace(this, pattern);
        DirectionalVisitor visitor = new DirectionalVisitor(mask, replace, origin, direction, (int)(radius * 2.0 + 1.0), this.minY, this.maxY);
        visitor.visit(origin);
        Operations.completeBlindly(visitor);
        this.changes = visitor.getAffected();
        return this.changes;
    }

    public <B extends BlockStateHolder<B>> int fillXZ(BlockVector3 origin, B block, double radius, int depth, boolean recursive) throws MaxChangedBlocksException {
        return this.fillXZ(origin, (Pattern)block, radius, depth, recursive);
    }

    public int fillXZ(BlockVector3 origin, Pattern pattern, double radius, int depth, boolean recursive) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)origin);
        Preconditions.checkNotNull((Object)pattern);
        Preconditions.checkArgument((radius >= 0.0 ? 1 : 0) != 0, (Object)"radius >= 0");
        Preconditions.checkArgument((depth >= 1 ? 1 : 0) != 0, (Object)"depth >= 1");
        int lowerBound = origin.y() - depth + 1;
        if (lowerBound > origin.y()) {
            lowerBound = Integer.MIN_VALUE;
        }
        MaskIntersection mask = new MaskIntersection(new RegionMask(new EllipsoidRegion(null, origin, Vector3.at(radius, radius, radius))), new BoundedHeightMask(Math.max(lowerBound, this.minY), Math.min(this.maxY, origin.y())), Masks.negate(new ExistingBlockMask(this)));
        BlockReplace replace = new BlockReplace(this, pattern);
        RecursiveVisitor visitor = recursive ? new RecursiveVisitor(mask, replace, (int)(radius * 2.0 + 1.0), this.minY, this.maxY, this) : new DownwardVisitor(mask, replace, origin.y(), (int)(radius * 2.0 + 1.0), this.minY, this.maxY, this);
        visitor.visit(origin);
        Operations.completeLegacy(visitor);
        this.changes = visitor.getAffected();
        return this.changes;
    }

    public int removeAbove(BlockVector3 position, int apothem, int height) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkArgument((apothem >= 1 ? 1 : 0) != 0, (Object)"apothem >= 1");
        Preconditions.checkArgument((height >= 1 ? 1 : 0) != 0, (Object)"height >= 1");
        CuboidRegion region = new CuboidRegion(this.getWorld(), position.add(-apothem + 1, 0, -apothem + 1), position.add(apothem - 1, height - 1, apothem - 1));
        return this.setBlocks((Region)region, (BlockStateHolder)BlockTypes.AIR.getDefaultState());
    }

    public int removeBelow(BlockVector3 position, int apothem, int height) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkArgument((apothem >= 1 ? 1 : 0) != 0, (Object)"apothem >= 1");
        Preconditions.checkArgument((height >= 1 ? 1 : 0) != 0, (Object)"height >= 1");
        CuboidRegion region = new CuboidRegion(this.getWorld(), position.add(-apothem + 1, 0, -apothem + 1), position.add(apothem - 1, -height + 1, apothem - 1));
        return this.setBlocks((Region)region, (BlockStateHolder)BlockTypes.AIR.getDefaultState());
    }

    public int removeNear(BlockVector3 position, Mask mask, int apothem) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkArgument((apothem >= 1 ? 1 : 0) != 0, (Object)"apothem >= 1");
        BlockVector3 adjustment = BlockVector3.ONE.multiply(apothem - 1);
        CuboidRegion region = new CuboidRegion(this.getWorld(), position.add(adjustment.multiply(-1)), position.add(adjustment));
        return this.replaceBlocks((Region)region, mask, (Pattern)BlockTypes.AIR.getDefaultState());
    }

    @Override
    public int center(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)pattern);
        Vector3 center = region.getCenter();
        CuboidRegion centerRegion = new CuboidRegion(this.getWorld(), BlockVector3.at((int)center.x(), (int)center.y(), (int)center.z()), BlockVector3.at(MathUtils.roundHalfUp(center.x()), MathUtils.roundHalfUp(center.y()), MathUtils.roundHalfUp(center.z())));
        return this.setBlocks((Region)centerRegion, pattern);
    }

    @Deprecated
    public <B extends BlockStateHolder<B>> int makeCuboidFaces(Region region, B block) throws MaxChangedBlocksException {
        return this.makeCuboidFaces(region, (Pattern)block);
    }

    public int makeCuboidFaces(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)pattern);
        CuboidRegion cuboid = CuboidRegion.makeCuboid(region);
        Region faces = cuboid.getFaces();
        return this.setBlocks(faces, pattern);
    }

    public int makeFaces(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)pattern);
        if (region instanceof CuboidRegion) {
            return this.makeCuboidFaces(region, pattern);
        }
        return new RegionShape(region).generate(this, pattern, true);
    }

    public <B extends BlockStateHolder<B>> int makeCuboidWalls(Region region, B block) throws MaxChangedBlocksException {
        return this.makeCuboidWalls(region, (Pattern)block);
    }

    public int makeCuboidWalls(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)pattern);
        CuboidRegion cuboid = CuboidRegion.makeCuboid(region);
        Region faces = cuboid.getWalls();
        return this.setBlocks((Set)((Object)faces), pattern);
    }

    public int makeWalls(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)pattern);
        if (region instanceof CuboidRegion) {
            return this.makeCuboidWalls(region, pattern);
        }
        this.replaceBlocks(region, new WallMakeMask(region), pattern);
        return this.changes;
    }

    @Deprecated
    public <B extends BlockStateHolder<B>> int overlayCuboidBlocks(Region region, B block) throws MaxChangedBlocksException {
        Preconditions.checkNotNull(block);
        return this.overlayCuboidBlocks(region, (Pattern)block);
    }

    public int overlayCuboidBlocks(Region region, Pattern pattern) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)pattern);
        BlockReplace replace = new BlockReplace(this, pattern);
        RegionOffset offset = new RegionOffset(BlockVector3.UNIT_Y, replace);
        int minY = region.getMinimumPoint().y();
        int maxY = Math.min(this.getMaximumPoint().y(), region.getMaximumPoint().y() + 1);
        SurfaceRegionFunction surface = new SurfaceRegionFunction(this, offset, minY, maxY);
        FlatRegionVisitor visitor = new FlatRegionVisitor(Regions.asFlatRegion(region), surface, this);
        Operations.completeBlindly(visitor);
        this.changes = visitor.getAffected();
        return this.changes;
    }

    public int naturalizeCuboidBlocks(Region region) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)region);
        Naturalizer naturalizer = new Naturalizer(this);
        FlatRegion flatRegion = Regions.asFlatRegion(region);
        LayerVisitor visitor = new LayerVisitor(flatRegion, Regions.minimumBlockY(region), Regions.maximumBlockY(region), naturalizer, this);
        Operations.completeBlindly(visitor);
        this.changes = naturalizer.getAffected();
        return this.changes;
    }

    public int stackCuboidRegion(Region region, BlockVector3 dir, int count, boolean copyAir) throws MaxChangedBlocksException {
        return this.stackCuboidRegion(region, dir, count, true, false, copyAir ? null : new ExistingBlockMask(this));
    }

    public int stackCuboidRegion(Region region, BlockVector3 offset, int count, boolean copyEntities, boolean copyBiomes, Mask mask) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)offset);
        BlockVector3 size = region.getMaximumPoint().subtract(region.getMinimumPoint()).add(1, 1, 1);
        try {
            return this.stackRegionBlockUnits(region, offset.multiply(size), count, copyEntities, copyBiomes, mask);
        }
        catch (RegionOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int stackRegionBlockUnits(Region region, BlockVector3 offset, int count, boolean copyEntities, boolean copyBiomes, Mask mask) throws MaxChangedBlocksException, RegionOperationException {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)offset);
        Preconditions.checkArgument((count >= 1 ? 1 : 0) != 0, (Object)"count >= 1 required");
        BlockVector3 size = region.getMaximumPoint().subtract(region.getMinimumPoint()).add(1, 1, 1);
        BlockVector3 offsetAbs = offset.abs();
        if (offsetAbs.x() < size.x() && offsetAbs.y() < size.y() && offsetAbs.z() < size.z()) {
            throw new RegionOperationException(Caption.of("worldedit.stack.intersecting-region", new Object[0]));
        }
        BlockVector3 to = region.getMinimumPoint();
        ForwardExtentCopy copy = new ForwardExtentCopy(this, region, this, to);
        copy.setRepetitions(count);
        copy.setTransform(new AffineTransform().translate(offset));
        copy.setCopyingEntities(copyEntities);
        copy.setCopyingBiomes(copyBiomes);
        Region allowedRegion = this.allowedRegions == null || this.allowedRegions.length == 0 ? new NullRegion() : new RegionIntersection(this.allowedRegions);
        mask = MaskIntersection.of(this.getSourceMask(), mask, new RegionMask(allowedRegion)).optimize();
        if (mask != Masks.alwaysTrue()) {
            this.setSourceMask(null);
            copy.setSourceMask(mask);
        }
        Operations.completeLegacy(copy);
        this.changes = copy.getAffected();
        return this.changes;
    }

    public int moveRegion(Region region, BlockVector3 offset, int multiplier, boolean copyAir, boolean moveEntities, boolean copyBiomes, Pattern replacement) throws MaxChangedBlocksException {
        ExistingBlockMask mask = null;
        if (!copyAir) {
            mask = new ExistingBlockMask(this);
        }
        return this.moveRegion(region, offset, multiplier, moveEntities, copyBiomes, mask, replacement);
    }

    public int moveRegion(Region region, BlockVector3 offset, int multiplier, boolean moveEntities, boolean copyBiomes, Mask mask, Pattern replacement) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)offset);
        Preconditions.checkArgument((multiplier >= 1 ? 1 : 0) != 0, (Object)"distance >= 1 required");
        Preconditions.checkArgument((!copyBiomes || region instanceof FlatRegion ? 1 : 0) != 0, (Object)"can't copy biomes from non-flat region");
        BlockVector3 to = region.getMinimumPoint().add(offset.multiply(multiplier));
        BlockVector3 displace = offset.multiply(multiplier);
        BlockVector3 size = region.getMaximumPoint().subtract(region.getMinimumPoint()).add(1, 1, 1);
        BlockVector3 disAbs = displace.abs();
        if (disAbs.x() < size.x() && disAbs.y() < size.y() && disAbs.z() < size.z()) {
            this.enableQueue();
        }
        ForwardExtentCopy copy = new ForwardExtentCopy(this, region, this, to);
        if (replacement == null) {
            replacement = BlockTypes.AIR.getDefaultState();
        }
        BlockReplace remove = replacement instanceof ExistingPattern ? null : new BlockReplace(this, replacement);
        copy.setSourceFunction(remove);
        copy.setCopyingEntities(moveEntities);
        copy.setRemovingEntities(moveEntities);
        copy.setCopyingBiomes(copyBiomes);
        copy.setRepetitions(1);
        Region allowedRegion = this.allowedRegions == null || this.allowedRegions.length == 0 ? new NullRegion() : new RegionIntersection(this.allowedRegions);
        Mask sourceMask = this.getSourceMask();
        mask = MaskIntersection.of(sourceMask, mask, new RegionMask(allowedRegion)).optimize();
        if (mask != Masks.alwaysTrue()) {
            copy.setSourceMask(mask);
            if (sourceMask != null && sourceMask.equals(mask)) {
                this.setSourceMask(null);
            }
        }
        Operations.completeBlindly(copy);
        this.changes = copy.getAffected();
        return this.changes;
    }

    public int moveCuboidRegion(Region region, BlockVector3 dir, int distance, boolean copyAir, Pattern replacement) throws MaxChangedBlocksException {
        return this.moveRegion(region, dir, distance, copyAir, true, false, replacement);
    }

    public int drainArea(BlockVector3 origin, double radius) throws MaxChangedBlocksException {
        return this.drainArea(origin, radius, false);
    }

    public int drainArea(BlockVector3 origin, double radius, boolean waterlogged) throws MaxChangedBlocksException {
        return this.drainArea(origin, radius, waterlogged, false);
    }

    public int drainArea(BlockVector3 origin, double radius, boolean waterlogged, boolean plants) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)origin);
        Preconditions.checkArgument((radius >= 0.0 ? 1 : 0) != 0, (Object)"radius >= 0 required");
        AbstractMask liquidMask = plants ? new BlockTypeMask((Extent)this, BlockTypes.LAVA, BlockTypes.WATER, BlockTypes.BUBBLE_COLUMN, BlockTypes.KELP_PLANT, BlockTypes.KELP, BlockTypes.SEAGRASS, BlockTypes.TALL_SEAGRASS) : new BlockMaskBuilder().addTypes(BlockTypes.WATER, BlockTypes.LAVA, BlockTypes.BUBBLE_COLUMN).build(this);
        if (waterlogged) {
            HashMap<String, String> stateMap = new HashMap<String, String>();
            stateMap.put("waterlogged", "true");
            liquidMask = new MaskUnion(liquidMask, new BlockStateMask(this, stateMap, true));
        }
        MaskIntersection mask = new MaskIntersection(new BoundedHeightMask(this.minY, this.maxY), new RegionMask(new EllipsoidRegion(null, origin, Vector3.at(radius, radius, radius))), liquidMask);
        BlockReplace replace = waterlogged ? new BlockReplace(this, new WaterloggedRemover(this)) : new BlockReplace(this, BlockTypes.AIR.getDefaultState());
        RecursiveVisitor visitor = new RecursiveVisitor(mask, replace, (int)(radius * 2.0 + 1.0), this.minY, this.maxY, this);
        for (BlockVector3 position : CuboidRegion.fromCenter(origin, 1)) {
            if (!mask.test(position)) continue;
            visitor.visit(position);
        }
        Operations.completeLegacy(visitor);
        this.changes = visitor.getAffected();
        return this.changes;
    }

    public int fixLiquid(BlockVector3 origin, double radius, BlockType fluid) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)origin);
        Preconditions.checkArgument((radius >= 0.0 ? 1 : 0) != 0, (Object)"radius >= 0 required");
        SingleBlockTypeMask liquidMask = new SingleBlockTypeMask(this, fluid);
        MaskUnion blockMask = new MaskUnion(liquidMask, Masks.negate(new ExistingBlockMask(this)));
        MaskIntersection mask = new MaskIntersection(new BoundedHeightMask(this.minY, Math.min(origin.y(), this.maxY)), new RegionMask(new EllipsoidRegion(null, origin, Vector3.at(radius, radius, radius))), blockMask);
        BlockReplace replace = new BlockReplace(this, fluid.getDefaultState());
        NonRisingVisitor visitor = new NonRisingVisitor(mask, replace, Integer.MAX_VALUE, this.minY, this.maxY, this);
        for (BlockVector3 position : CuboidRegion.fromCenter(origin, 1)) {
            if (!liquidMask.test(position)) continue;
            visitor.visit(position);
        }
        Operations.completeLegacy(visitor);
        return visitor.getAffected();
    }

    public int makeCylinder(BlockVector3 pos, Pattern block, double radius, int height, boolean filled) throws MaxChangedBlocksException {
        return this.makeCylinder(pos, block, radius, radius, height, filled);
    }

    public int makeCylinder(BlockVector3 pos, Pattern block, double radiusX, double radiusZ, int height, boolean filled) throws MaxChangedBlocksException {
        return this.makeCylinder(pos, block, radiusX, radiusZ, height, 0.0, filled);
    }

    public int makeHollowCylinder(BlockVector3 pos, Pattern block, double radiusX, double radiusZ, int height, double thickness) throws MaxChangedBlocksException {
        return this.makeCylinder(pos, block, radiusX, radiusZ, height, thickness, false);
    }

    public int makeCylinder(BlockVector3 pos, Pattern block, double radiusX, double radiusZ, int height, double thickness, boolean filled) throws MaxChangedBlocksException {
        block15: {
            radiusX += 0.5;
            radiusZ += 0.5;
            MutableBlockVector3 mutableBlockVector3 = new MutableBlockVector3(pos);
            if (height == 0) {
                return 0;
            }
            if (height < 0) {
                height = -height;
                mutableBlockVector3.mutY(mutableBlockVector3.y() - height);
            }
            if (mutableBlockVector3.y() < this.getWorld().getMinY()) {
                mutableBlockVector3.mutY(this.world.getMinY());
            } else if (mutableBlockVector3.y() + height - 1 > this.maxY) {
                height = this.maxY - mutableBlockVector3.y() + 1;
            }
            double invRadiusX = 1.0 / radiusX;
            double invRadiusZ = 1.0 / radiusZ;
            int px = mutableBlockVector3.x();
            int py = mutableBlockVector3.y();
            int pz = mutableBlockVector3.z();
            int ceilRadiusX = (int)Math.ceil(radiusX);
            int ceilRadiusZ = (int)Math.ceil(radiusZ);
            double nextXn = 0.0;
            if (thickness != 0.0) {
                double nextMinXn = 0.0;
                double minInvRadiusX = 1.0 / (radiusX - thickness);
                double minInvRadiusZ = 1.0 / (radiusZ - thickness);
                block0: for (int x = 0; x <= ceilRadiusX; ++x) {
                    double xn = nextXn;
                    double dx2 = nextMinXn * nextMinXn;
                    nextXn = (double)(x + 1) * invRadiusX;
                    nextMinXn = (double)(x + 1) * minInvRadiusX;
                    double nextZn = 0.0;
                    double nextMinZn = 0.0;
                    double xSqr = xn * xn;
                    int xx = px + x;
                    int x_x = px - x;
                    for (int z = 0; z <= ceilRadiusZ; ++z) {
                        double zn = nextZn;
                        double zSqr = zn * zn;
                        double distanceSq = xSqr + zSqr;
                        if (distanceSq > 1.0) {
                            if (z != 0) continue block0;
                            break block15;
                        }
                        double dz2 = nextMinZn * nextMinZn;
                        nextZn = (double)(z + 1) * invRadiusZ;
                        nextMinZn = (double)(z + 1) * minInvRadiusZ;
                        if (dz2 + nextMinXn * nextMinXn <= 1.0 && nextMinZn * nextMinZn + dx2 <= 1.0) continue;
                        int zz = pz + z;
                        int z_z = pz - z;
                        for (int y = 0; y < height; ++y) {
                            int yy = py + y;
                            this.setBlock(xx, yy, zz, block);
                            this.setBlock(x_x, yy, zz, block);
                            this.setBlock(xx, yy, z_z, block);
                            this.setBlock(x_x, yy, z_z, block);
                        }
                    }
                }
            } else {
                block3: for (int x = 0; x <= ceilRadiusX; ++x) {
                    double xn = nextXn;
                    nextXn = (double)(x + 1) * invRadiusX;
                    double nextZn = 0.0;
                    double xSqr = xn * xn;
                    int xx = px + x;
                    int x_x = px - x;
                    for (int z = 0; z <= ceilRadiusZ; ++z) {
                        double zn = nextZn;
                        double zSqr = zn * zn;
                        double distanceSq = xSqr + zSqr;
                        if (distanceSq > 1.0) {
                            if (z != 0) continue block3;
                            break block15;
                        }
                        nextZn = (double)(z + 1) * invRadiusZ;
                        if (!filled && zSqr + nextXn * nextXn <= 1.0 && nextZn * nextZn + xSqr <= 1.0) continue;
                        int zz = pz + z;
                        int z_z = pz - z;
                        for (int y = 0; y < height; ++y) {
                            int yy = py + y;
                            this.setBlock(xx, yy, zz, block);
                            this.setBlock(x_x, yy, zz, block);
                            this.setBlock(xx, yy, z_z, block);
                            this.setBlock(x_x, yy, z_z, block);
                        }
                    }
                }
            }
        }
        return this.changes;
    }

    public int makeCone(BlockVector3 pos, Pattern block, double radiusX, double radiusZ, int height, boolean filled, double thickness) throws MaxChangedBlocksException {
        int affected = 0;
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double rx2 = Math.pow(radiusX, 2.0);
        double ry2 = Math.pow(radiusZ, 2.0);
        double rz2 = Math.pow(height, 2.0);
        int layers = Math.abs(height);
        int cx = pos.x();
        int cy = pos.y();
        int cz = pos.z();
        block0: for (int y = 0; y < layers; ++y) {
            double ySquaredMinusHeightOverHeightSquared = Math.pow(y - layers, 2.0) / ry2;
            int yy = height < 0 ? cy - y : cy + y;
            block1: for (int x = 0; x <= ceilRadiusX; ++x) {
                double xSquaredOverRadiusX = Math.pow(x, 2.0) / rx2;
                int xx = cx + x;
                for (int z = 0; z <= ceilRadiusZ; ++z) {
                    int zz = cz + z;
                    double zSquaredOverRadiusZ = Math.pow(z, 2.0) / rz2;
                    double distanceFromOriginMinusHeightSquared = xSquaredOverRadiusX + zSquaredOverRadiusZ - ySquaredMinusHeightOverHeightSquared;
                    if (distanceFromOriginMinusHeightSquared > 1.0) {
                        if (z != 0) continue block1;
                        continue block0;
                    }
                    if (!filled) {
                        double xNext = Math.pow((double)x + thickness, 2.0) / rx2 + zSquaredOverRadiusZ - ySquaredMinusHeightOverHeightSquared;
                        double yNext = xSquaredOverRadiusX + zSquaredOverRadiusZ - Math.pow((double)y + thickness - (double)height, 2.0) / ry2;
                        double zNext = xSquaredOverRadiusX + Math.pow((double)z + thickness, 2.0) / rz2 - ySquaredMinusHeightOverHeightSquared;
                        if (xNext <= 0.0 && zNext <= 0.0 && yNext <= 0.0 && (double)y + thickness != (double)layers) continue;
                    }
                    if (!(distanceFromOriginMinusHeightSquared <= 0.0)) continue;
                    if (this.setBlock(xx, yy, zz, block)) {
                        ++affected;
                    }
                    if (this.setBlock(xx, yy, zz, block)) {
                        ++affected;
                    }
                    if (this.setBlock(xx, yy, zz, block)) {
                        ++affected;
                    }
                    if (!this.setBlock(xx, yy, zz, block)) continue;
                    ++affected;
                }
            }
        }
        return affected;
    }

    public int moveRegion(Region region, BlockVector3 dir, int distance, boolean copyAir, Pattern replacement) throws MaxChangedBlocksException {
        return this.moveRegion(region, dir, distance, true, false, copyAir ? new ExistingBlockMask(this) : null, replacement);
    }

    public int makeCircle(BlockVector3 pos, Pattern block, double radiusX, double radiusY, double radiusZ, boolean filled, Vector3 normal) throws MaxChangedBlocksException {
        radiusX += 0.5;
        radiusY += 0.5;
        radiusZ += 0.5;
        normal = normal.normalize();
        double nx = normal.x();
        double ny = normal.y();
        double nz = normal.z();
        double invRadiusX = 1.0 / radiusX;
        double invRadiusY = 1.0 / radiusY;
        double invRadiusZ = 1.0 / radiusZ;
        int px = pos.x();
        int py = pos.y();
        int pz = pos.z();
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double threshold = 0.5;
        double nextXn = 0.0;
        block0: for (int x = 0; x <= ceilRadiusX; ++x) {
            double xn = nextXn;
            double dx = xn * xn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextXnSq = nextXn * nextXn;
            double nextYn = 0.0;
            int xx = px + x;
            int x_x = px - x;
            double xnx = (double)x * nx;
            block1: for (int y = 0; y <= ceilRadiusY; ++y) {
                double yn = nextYn;
                double dy = yn * yn;
                double dxy = dx + dy;
                nextYn = (double)(y + 1) * invRadiusY;
                double nextYnSq = nextYn * nextYn;
                double nextZn = 0.0;
                int yy = py + y;
                int y_y = py - y;
                double yny = (double)y * ny;
                for (int z = 0; z <= ceilRadiusZ; ++z) {
                    double zn = nextZn;
                    double dz = zn * zn;
                    double dxyz = dxy + dz;
                    double dxz = dx + dz;
                    double dyz = dy + dz;
                    nextZn = (double)(z + 1) * invRadiusZ;
                    double nextZnSq = nextZn * nextZn;
                    if (dxyz > 1.0) {
                        if (z != 0) continue block1;
                        if (y != 0) continue block0;
                        break block0;
                    }
                    if (!filled && nextXnSq + dyz <= 1.0 && nextYnSq + dxz <= 1.0 && nextZnSq + dxy <= 1.0) continue;
                    int zz = pz + z;
                    int z_z = pz - z;
                    double znz = (double)z * nz;
                    if (Math.abs(xnx + yny + znz) < threshold) {
                        this.setBlock(xx, yy, zz, block);
                    }
                    if (Math.abs(-xnx + yny + znz) < threshold) {
                        this.setBlock(x_x, yy, zz, block);
                    }
                    if (Math.abs(xnx - yny + znz) < threshold) {
                        this.setBlock(xx, y_y, zz, block);
                    }
                    if (Math.abs(xnx + yny - znz) < threshold) {
                        this.setBlock(xx, yy, z_z, block);
                    }
                    if (Math.abs(-xnx - yny + znz) < threshold) {
                        this.setBlock(x_x, y_y, zz, block);
                    }
                    if (Math.abs(xnx - yny - znz) < threshold) {
                        this.setBlock(xx, y_y, z_z, block);
                    }
                    if (Math.abs(-xnx + yny - znz) < threshold) {
                        this.setBlock(x_x, yy, z_z, block);
                    }
                    if (!(Math.abs(-xnx - yny - znz) < threshold)) continue;
                    this.setBlock(x_x, y_y, z_z, block);
                }
            }
        }
        return this.changes;
    }

    public int makeSphere(BlockVector3 pos, Pattern block, double radius, boolean filled) throws MaxChangedBlocksException {
        return this.makeSphere(pos, block, radius, radius, radius, filled);
    }

    public int makeSphere(BlockVector3 pos, Pattern block, double radiusX, double radiusY, double radiusZ, boolean filled) throws MaxChangedBlocksException {
        double invRadiusX = 1.0 / (radiusX += 0.5);
        double invRadiusY = 1.0 / (radiusY += 0.5);
        double invRadiusZ = 1.0 / (radiusZ += 0.5);
        int px = pos.x();
        int py = pos.y();
        int pz = pos.z();
        int ceilRadiusX = (int)Math.ceil(radiusX);
        int ceilRadiusY = (int)Math.ceil(radiusY);
        int ceilRadiusZ = (int)Math.ceil(radiusZ);
        double nextXn = 0.0;
        block0: for (int x = 0; x <= ceilRadiusX; ++x) {
            double xn = nextXn;
            double dx = xn * xn;
            nextXn = (double)(x + 1) * invRadiusX;
            double nextXnSq = nextXn * nextXn;
            int xx = px + x;
            int x_x = px - x;
            double nextZn = 0.0;
            block1: for (int z = 0; z <= ceilRadiusZ; ++z) {
                double zn = nextZn;
                double dz = zn * zn;
                double dxz = dx + dz;
                nextZn = (double)(z + 1) * invRadiusZ;
                double nextZnSq = nextZn * nextZn;
                int zz = pz + z;
                int z_z = pz - z;
                double nextYn = 0.0;
                for (int y = 0; y <= ceilRadiusY; ++y) {
                    double yn = nextYn;
                    double dy = yn * yn;
                    double dxyz = dxz + dy;
                    nextYn = (double)(y + 1) * invRadiusY;
                    if (dxyz > 1.0) {
                        if (y != 0) continue block1;
                        if (z != 0) continue block0;
                        break block0;
                    }
                    double nextYnSq = nextYn * nextYn;
                    double dxy = dx + dy;
                    double dyz = dy + dz;
                    if (!filled && nextXnSq + dyz <= 1.0 && nextYnSq + dxz <= 1.0 && nextZnSq + dxy <= 1.0) continue;
                    int yy = py + y;
                    if (yy <= this.maxY) {
                        this.setBlock(xx, yy, zz, block);
                        if (x != 0) {
                            this.setBlock(x_x, yy, zz, block);
                        }
                        if (z != 0) {
                            this.setBlock(xx, yy, z_z, block);
                            if (x != 0) {
                                this.setBlock(x_x, yy, z_z, block);
                            }
                        }
                    }
                    if (y == 0 || (yy = py - y) < this.minY) continue;
                    this.setBlock(xx, yy, zz, block);
                    if (x != 0) {
                        this.setBlock(x_x, yy, zz, block);
                    }
                    if (z == 0) continue;
                    this.setBlock(xx, yy, z_z, block);
                    if (x == 0) continue;
                    this.setBlock(x_x, yy, z_z, block);
                }
            }
        }
        return this.changes;
    }

    public int makePyramid(BlockVector3 position, Pattern block, int size, boolean filled) throws MaxChangedBlocksException {
        int bx = position.x();
        int by = position.y();
        int bz = position.z();
        int height = size;
        for (int y = 0; y <= height; ++y) {
            --size;
            int yy = y + by;
            for (int x = 0; x <= size; ++x) {
                int xx = bx + x;
                int x_x = bx - x;
                for (int z = 0; z <= size; ++z) {
                    int zz = bz + z;
                    int z_z = bz - z;
                    if ((!filled || z > size || x > size) && z != size && x != size) continue;
                    this.setBlock(xx, yy, zz, block);
                    this.setBlock(x_x, yy, zz, block);
                    this.setBlock(xx, yy, z_z, block);
                    this.setBlock(x_x, yy, z_z, block);
                }
            }
        }
        return this.changes;
    }

    @Deprecated
    public int thaw(BlockVector3 position, double radius) throws MaxChangedBlocksException {
        return this.thaw(position, radius, WorldEdit.getInstance().getConfiguration().defaultVerticalHeight);
    }

    public int thaw(BlockVector3 position, double radius, int height) throws MaxChangedBlocksException {
        int affected = 0;
        double radiusSq = radius * radius;
        int ox = position.x();
        int oy = position.y();
        int oz = position.z();
        BlockState air = BlockTypes.AIR.getDefaultState();
        BlockState water = BlockTypes.WATER.getDefaultState();
        int centerY = Math.max(this.minY, Math.min(this.maxY, oy));
        int minY = Math.max(this.minY, centerY - height);
        int maxY = Math.min(this.maxY, centerY + height);
        MutableBlockVector3 mutable = new MutableBlockVector3();
        MutableBlockVector3 mutable2 = new MutableBlockVector3();
        int ceilRadius = (int)Math.ceil(radius);
        for (int x = ox - ceilRadius; x <= ox + ceilRadius; ++x) {
            block1: for (int z = oz - ceilRadius; z <= oz + ceilRadius; ++z) {
                if ((double)mutable.setComponents(x, oy, z).distanceSq(position) > radiusSq) continue;
                for (int y = maxY; y > minY; --y) {
                    mutable.setComponents(x, y, z);
                    mutable2.setComponents(x, y - 1, z);
                    BlockType id = this.getBlock(mutable).getBlockType();
                    if (id == BlockTypes.ICE) {
                        if (!this.setBlock((BlockVector3)mutable, (B)water)) continue block1;
                        ++affected;
                        continue block1;
                    }
                    if (id == BlockTypes.SNOW) {
                        BlockState block;
                        if (!this.setBlock((BlockVector3)mutable, (B)air)) continue block1;
                        if (y > this.getMinY() && (block = this.getBlock(mutable2)).getBlockType().hasProperty(SnowSimulator.SNOWY) && this.setBlock((BlockVector3)mutable2, (B)block.with((Property)SnowSimulator.SNOWY, (Object)false))) {
                            ++affected;
                        }
                        ++affected;
                        continue block1;
                    }
                    if (!id.getMaterial().isAir()) continue block1;
                }
            }
        }
        return affected;
    }

    @Deprecated
    public int simulateSnow(BlockVector3 position, double radius) throws MaxChangedBlocksException {
        return this.simulateSnow(position, radius, WorldEdit.getInstance().getConfiguration().defaultVerticalHeight);
    }

    public int simulateSnow(BlockVector3 position, double radius, int height) throws MaxChangedBlocksException {
        return this.simulateSnow(new CylinderRegion(position, Vector2.at(radius, radius), position.y(), height), false);
    }

    public int simulateSnow(FlatRegion region, boolean stack) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)region);
        SnowSimulator snowSimulator = new SnowSimulator(this, stack);
        LayerVisitor layerVisitor = new LayerVisitor(region, region.getMinimumY(), region.getMaximumY(), snowSimulator, this);
        Operations.completeLegacy(layerVisitor);
        return snowSimulator.getAffected();
    }

    @Deprecated
    public int green(BlockVector3 position, double radius, boolean onlyNormalDirt) throws MaxChangedBlocksException {
        return this.green(position, radius, WorldEdit.getInstance().getConfiguration().defaultVerticalHeight, onlyNormalDirt);
    }

    public int green(BlockVector3 position, double radius, int height, boolean onlyNormalDirt) throws MaxChangedBlocksException {
        int affected = 0;
        double radiusSq = radius * radius;
        int ox = position.x();
        int oy = position.y();
        int oz = position.z();
        BlockState grass = BlockTypes.GRASS_BLOCK.getDefaultState();
        int centerY = Math.max(this.minY, Math.min(this.maxY, oy));
        int minY = Math.max(this.minY, centerY - height);
        int maxY = Math.min(this.maxY, centerY + height);
        MutableBlockVector3 mutable = new MutableBlockVector3();
        int ceilRadius = (int)Math.ceil(radius);
        for (int x = ox - ceilRadius; x <= ox + ceilRadius; ++x) {
            block1: for (int z = oz - ceilRadius; z <= oz + ceilRadius; ++z) {
                if ((double)mutable.setComponents(x, oy, z).distanceSq(position) > radiusSq) continue;
                for (int y = maxY; y > minY; --y) {
                    BlockState block = this.getBlock(mutable.mutY(y));
                    if (block.getBlockType() == BlockTypes.DIRT || !onlyNormalDirt && block.getBlockType() == BlockTypes.COARSE_DIRT) {
                        if (!this.setBlock((BlockVector3)mutable.mutY(y), (B)grass)) continue block1;
                        ++affected;
                        continue block1;
                    }
                    if (block.getBlockType() == BlockTypes.WATER || block.getBlockType() == BlockTypes.LAVA || block.getBlockType().getMaterial().isMovementBlocker()) continue block1;
                }
            }
        }
        return affected;
    }

    public int makePumpkinPatches(BlockVector3 position, int apothem) throws MaxChangedBlocksException {
        return this.makePumpkinPatches(position, apothem, 0.02);
    }

    public int makePumpkinPatches(BlockVector3 position, int apothem, double density) throws MaxChangedBlocksException {
        GardenPatchGenerator generator = new GardenPatchGenerator(this);
        generator.setPlant(GardenPatchGenerator.getPumpkinPattern());
        CuboidRegion region = new CuboidRegion(this.getWorld(), position.add(-apothem, -5, -apothem), position.add(apothem, 10, apothem));
        GroundFunction ground = new GroundFunction(new ExistingBlockMask(this), generator);
        LayerVisitor visitor = new LayerVisitor(region, Regions.minimumBlockY(region), Regions.maximumBlockY(region), ground, this);
        visitor.setMask(new NoiseFilter2D(new RandomNoise(), density));
        Operations.completeLegacy(visitor);
        this.changes = ground.getAffected();
        return this.changes;
    }

    public int makeForest(BlockVector3 basePosition, int size, double density, TreeGenerator.TreeType treeType) throws MaxChangedBlocksException {
        return this.makeForest(CuboidRegion.fromCenter(basePosition, size), density, treeType);
    }

    public int makeForest(Region region, double density, TreeGenerator.TreeType treeType) throws MaxChangedBlocksException {
        ForestGenerator generator = new ForestGenerator(this, treeType);
        GroundFunction ground = new GroundFunction(new ExistingBlockMask(this), generator);
        LayerVisitor visitor = new LayerVisitor(Regions.asFlatRegion(region), Regions.minimumBlockY(region), Regions.maximumBlockY(region), ground, this);
        visitor.setMask(new NoiseFilter2D(new RandomNoise(), density));
        Operations.completeLegacy(visitor);
        return ground.getAffected();
    }

    public List<Countable<BlockState>> getBlockDistribution(Region region, boolean separateStates) {
        if (separateStates) {
            List<Countable<BlockState>> distr = this.getBlockDistributionWithData(region);
            Collections.reverse(distr);
            return distr;
        }
        List<Countable<BlockType>> normalDistr = this.getBlockDistribution(region);
        ArrayList<Countable<BlockState>> distribution = new ArrayList<Countable<BlockState>>();
        for (Countable<BlockType> count : normalDistr) {
            distribution.add(new Countable<BlockState>(count.getID().getDefaultState(), count.getAmount()));
        }
        Collections.reverse(distribution);
        return distribution;
    }

    public int makeShape(Region region, Vector3 zero, Vector3 unit, Pattern pattern, String expressionString, boolean hollow) throws ExpressionException, MaxChangedBlocksException {
        return this.makeShape(region, zero, unit, pattern, expressionString, hollow, WorldEdit.getInstance().getConfiguration().calculationTimeout);
    }

    public int makeShape(Region region, final Vector3 zero, final Vector3 unit, Pattern pattern, String expressionString, boolean hollow, final int timeout) throws ExpressionException, MaxChangedBlocksException {
        final Expression expression = Expression.compile(expressionString, "x", "y", "z", "type", "data");
        expression.optimize();
        final LocalSlot.Variable typeVariable = expression.getSlots().getVariable("type").orElseThrow(IllegalStateException::new);
        final LocalSlot.Variable dataVariable = expression.getSlots().getVariable("data").orElseThrow(IllegalStateException::new);
        final WorldEditExpressionEnvironment environment = new WorldEditExpressionEnvironment(this, unit, zero);
        expression.setEnvironment(environment);
        final int[] timedOut = new int[]{0};
        ArbitraryShape shape = new ArbitraryShape(this, region){

            @Override
            protected BaseBlock getMaterial(int x, int y, int z, BaseBlock defaultMaterial) {
                Vector3 current = Vector3.at(x, y, z);
                environment.setCurrentBlock(current);
                Vector3 scaled = current.subtract(zero).divide(unit);
                try {
                    int[] legacy = LegacyMapper.getInstance().getLegacyFromBlock(defaultMaterial.toImmutableState());
                    int typeVar = 0;
                    int dataVar = 0;
                    if (legacy != null) {
                        typeVar = legacy[0];
                        if (legacy.length > 1) {
                            dataVar = legacy[1];
                        }
                    }
                    double[] dArray = new double[]{scaled.x(), scaled.y(), scaled.z(), typeVar, dataVar};
                    if (expression.evaluate(dArray, timeout) <= 0.0) {
                        return null;
                    }
                    int newType = (int)typeVariable.value();
                    int newData = (int)dataVariable.value();
                    if (newType != typeVar || newData != dataVar) {
                        BlockState state = LegacyMapper.getInstance().getBlockFromLegacy(newType, newData);
                        return state == null ? defaultMaterial : state.toBaseBlock();
                    }
                    return defaultMaterial;
                }
                catch (ExpressionTimeoutException e) {
                    timedOut[0] = timedOut[0] + 1;
                    return null;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        int changed = shape.generate(this, pattern, hollow);
        if (timedOut[0] > 0) {
            throw new ExpressionTimeoutException(String.format("%d blocks changed. %d blocks took too long to evaluate (increase with //timeout).", changed, timedOut[0]));
        }
        return changed;
    }

    public int deformRegion(Region region, Vector3 zero, Vector3 unit, String expressionString) throws ExpressionException, MaxChangedBlocksException {
        return this.deformRegion(region, zero, unit, expressionString, WorldEdit.getInstance().getConfiguration().calculationTimeout);
    }

    public int deformRegion(Region region, Vector3 zero, Vector3 unit, String expressionString, int timeout) throws ExpressionException, MaxChangedBlocksException {
        Expression expression = Expression.compile(expressionString, "x", "y", "z");
        expression.optimize();
        return this.deformRegion(region, zero, unit, expression, timeout);
    }

    public int deformRegion(Region region, Vector3 zero, Vector3 unit, Expression expression, int timeout) throws ExpressionException, MaxChangedBlocksException {
        LocalSlot.Variable x = expression.getSlots().getVariable("x").orElseThrow(IllegalStateException::new);
        LocalSlot.Variable y = expression.getSlots().getVariable("y").orElseThrow(IllegalStateException::new);
        LocalSlot.Variable z = expression.getSlots().getVariable("z").orElseThrow(IllegalStateException::new);
        WorldEditExpressionEnvironment environment = new WorldEditExpressionEnvironment(this, unit, zero);
        expression.setEnvironment(environment);
        Vector3 zero2 = zero.add(0.5, 0.5, 0.5);
        RegionVisitor visitor = new RegionVisitor(region, position -> {
            try {
                Vector3 scaled = position.toVector3().subtract(zero).divide(unit);
                expression.evaluate(new double[]{scaled.x(), scaled.y(), scaled.z()}, timeout);
                int xv = (int)Math.floor(x.value() * unit.x() + zero2.x());
                int yv = (int)Math.floor(y.value() * unit.y() + zero2.y());
                int zv = (int)Math.floor(z.value() * unit.z() + zero2.z());
                BlockState get = yv >= this.minY && yv <= this.maxY ? this.getBlock(xv, yv, zv) : BlockTypes.AIR.getDefaultState();
                return this.setBlock(position, (B)get);
            }
            catch (EvaluationException e) {
                throw new RuntimeException(e);
            }
        }, this);
        Operations.completeBlindly(visitor);
        this.changes += visitor.getAffected();
        return this.changes;
    }

    public int hollowOutRegion(Region region, int thickness, Pattern pattern, Mask mask) {
        try {
            BlockVector3Set outside = BlockVector3Set.getAppropriateVectorSet(region);
            BlockVector3 min = region.getMinimumPoint();
            BlockVector3 max = region.getMaximumPoint();
            int minX = min.x();
            int minY = min.y();
            int minZ = min.z();
            int maxX = max.x();
            int maxY = max.y();
            int maxZ = max.z();
            MutableBlockVector3 mutable = new MutableBlockVector3();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    this.recurseHollow(region, mutable.setComponents(x, y, minZ), outside, mask);
                    this.recurseHollow(region, mutable.setComponents(x, y, maxZ), outside, mask);
                }
            }
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.recurseHollow(region, mutable.setComponents(minX, y, z), outside, mask);
                    this.recurseHollow(region, mutable.setComponents(maxX, y, z), outside, mask);
                }
            }
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    this.recurseHollow(region, mutable.setComponents(x, minY, z), outside, mask);
                    this.recurseHollow(region, mutable.setComponents(x, maxY, z), outside, mask);
                }
            }
            for (int i = 1; i < thickness; ++i) {
                BlockVector3Set newOutside = BlockVector3Set.getAppropriateVectorSet(region);
                block9: for (BlockVector3 position : region) {
                    for (BlockVector3 recurseDirection : recurseDirections) {
                        MutableBlockVector3 neighbor = mutable.setComponents(position).add(recurseDirection);
                        if (!outside.contains(neighbor)) continue;
                        newOutside.add(position);
                        continue block9;
                    }
                }
                outside.addAll(newOutside);
            }
            block11: for (BlockVector3 position : region) {
                for (BlockVector3 recurseDirection : recurseDirections) {
                    MutableBlockVector3 neighbor = mutable.setComponents(position).add(recurseDirection);
                    if (outside.contains(neighbor)) continue block11;
                }
                ++this.changes;
                pattern.apply(this.getExtent(), position, position);
            }
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
        return this.changes;
    }

    public int drawLine(Pattern pattern, BlockVector3 pos1, BlockVector3 pos2, double radius, boolean filled) throws MaxChangedBlocksException {
        return this.drawLine(pattern, pos1, pos2, radius, filled, false);
    }

    public int drawLine(Pattern pattern, BlockVector3 pos1, BlockVector3 pos2, double radius, boolean filled, boolean flat) throws MaxChangedBlocksException {
        Set<BlockVector3> newVset;
        int dMax;
        int x1 = pos1.x();
        int y1 = pos1.y();
        int z1 = pos1.z();
        int x2 = pos2.x();
        int y2 = pos2.y();
        int z2 = pos2.z();
        int tipx = x1;
        int tipy = y1;
        int tipz = z1;
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dz = Math.abs(z2 - z1);
        BlockVector3Set vset = BlockVector3Set.getAppropriateVectorSet(new CuboidRegion(pos1, pos2));
        boolean notdrawn = true;
        if (dx + dy + dz == 0) {
            vset.add(tipx, tipy, tipz);
            notdrawn = false;
        }
        if ((dMax = Math.max(Math.max(dx, dy), dz)) == dx && notdrawn) {
            for (domstep = 0; domstep <= dx; ++domstep) {
                tipx = x1 + domstep * (x2 - x1 > 0 ? 1 : -1);
                tipy = (int)Math.round((double)y1 + (double)domstep * (double)dy / (double)dx * (double)(y2 - y1 > 0 ? 1 : -1));
                tipz = (int)Math.round((double)z1 + (double)domstep * (double)dz / (double)dx * (double)(z2 - z1 > 0 ? 1 : -1));
                vset.add(tipx, tipy, tipz);
            }
        } else if (dMax == dy && notdrawn) {
            for (domstep = 0; domstep <= dy; ++domstep) {
                tipy = y1 + domstep * (y2 - y1 > 0 ? 1 : -1);
                tipx = (int)Math.round((double)x1 + (double)domstep * (double)dx / (double)dy * (double)(x2 - x1 > 0 ? 1 : -1));
                tipz = (int)Math.round((double)z1 + (double)domstep * (double)dz / (double)dy * (double)(z2 - z1 > 0 ? 1 : -1));
                vset.add(tipx, tipy, tipz);
            }
        } else if (dMax == dz && notdrawn) {
            for (domstep = 0; domstep <= dz; ++domstep) {
                tipz = z1 + domstep * (z2 - z1 > 0 ? 1 : -1);
                tipy = (int)Math.round((double)y1 + (double)domstep * (double)dy / (double)dz * (double)(y2 - y1 > 0 ? 1 : -1));
                tipx = (int)Math.round((double)x1 + (double)domstep * (double)dx / (double)dz * (double)(x2 - x1 > 0 ? 1 : -1));
                vset.add(tipx, tipy, tipz);
            }
        }
        if (flat) {
            newVset = EditSession.getStretched(vset, radius);
            if (!filled) {
                newVset = this.getOutline(newVset);
            }
        } else {
            newVset = EditSession.getBallooned(vset, radius);
            if (!filled) {
                newVset = this.getHollowed(newVset);
            }
        }
        return this.changes += this.setBlocks(newVset, pattern);
    }

    public int drawLine(Pattern pattern, List<BlockVector3> vectors, double radius, boolean filled) throws MaxChangedBlocksException {
        Set<BlockVector3> vset = new HashSet<BlockVector3>();
        for (int i = 0; vectors.size() != 0 && i < vectors.size() - 1; ++i) {
            int domstep;
            int dz;
            int dy;
            BlockVector3 pos1 = vectors.get(i);
            BlockVector3 pos2 = vectors.get(i + 1);
            int x1 = pos1.x();
            int y1 = pos1.y();
            int z1 = pos1.z();
            int x2 = pos2.x();
            int y2 = pos2.y();
            int z2 = pos2.z();
            int tipx = x1;
            int tipy = y1;
            int tipz = z1;
            int dx = Math.abs(x2 - x1);
            if (dx + (dy = Math.abs(y2 - y1)) + (dz = Math.abs(z2 - z1)) == 0) {
                vset.add(BlockVector3.at(tipx, tipy, tipz));
                continue;
            }
            int dMax = Math.max(Math.max(dx, dy), dz);
            if (dMax == dx) {
                for (domstep = 0; domstep <= dx; ++domstep) {
                    tipx = x1 + domstep * (x2 - x1 > 0 ? 1 : -1);
                    tipy = (int)Math.round((double)y1 + (double)domstep * (double)dy / (double)dx * (double)(y2 - y1 > 0 ? 1 : -1));
                    tipz = (int)Math.round((double)z1 + (double)domstep * (double)dz / (double)dx * (double)(z2 - z1 > 0 ? 1 : -1));
                    vset.add(BlockVector3.at(tipx, tipy, tipz));
                }
                continue;
            }
            if (dMax == dy) {
                for (domstep = 0; domstep <= dy; ++domstep) {
                    tipy = y1 + domstep * (y2 - y1 > 0 ? 1 : -1);
                    tipx = (int)Math.round((double)x1 + (double)domstep * (double)dx / (double)dy * (double)(x2 - x1 > 0 ? 1 : -1));
                    tipz = (int)Math.round((double)z1 + (double)domstep * (double)dz / (double)dy * (double)(z2 - z1 > 0 ? 1 : -1));
                    vset.add(BlockVector3.at(tipx, tipy, tipz));
                }
                continue;
            }
            for (domstep = 0; domstep <= dz; ++domstep) {
                tipz = z1 + domstep * (z2 - z1 > 0 ? 1 : -1);
                tipy = (int)Math.round((double)y1 + (double)domstep * (double)dy / (double)dz * (double)(y2 - y1 > 0 ? 1 : -1));
                tipx = (int)Math.round((double)x1 + (double)domstep * (double)dx / (double)dz * (double)(x2 - x1 > 0 ? 1 : -1));
                vset.add(BlockVector3.at(tipx, tipy, tipz));
            }
        }
        vset = EditSession.getBallooned(vset, radius);
        if (!filled) {
            vset = this.getHollowed(vset);
        }
        return this.changes += this.setBlocks(vset, pattern);
    }

    public int drawSpline(Pattern pattern, List<BlockVector3> nodevectors, double tension, double bias, double continuity, double quality, double radius, boolean filled) throws MaxChangedBlocksException {
        BlockVector3Set vset = LocalBlockVectorSet.wrapped();
        ArrayList<Node> nodes = new ArrayList<Node>(nodevectors.size());
        KochanekBartelsInterpolation interpol = new KochanekBartelsInterpolation();
        for (BlockVector3 nodevector : nodevectors) {
            Node n = new Node(nodevector.toVector3());
            n.setTension(tension);
            n.setBias(bias);
            n.setContinuity(continuity);
            nodes.add(n);
        }
        interpol.setNodes(nodes);
        double splinelength = interpol.arcLength(0.0, 1.0);
        for (double loop = 0.0; loop <= 1.0; loop += 1.0 / splinelength / quality) {
            BlockVector3 tipv = interpol.getPosition(loop).toBlockPoint();
            if (radius == 0.0) {
                pattern.apply(this, tipv, tipv);
                ++this.changes;
                continue;
            }
            vset.add(tipv);
        }
        if (radius != 0.0) {
            Set<BlockVector3> newVset = EditSession.getBallooned(vset, radius);
            if (!filled) {
                newVset = this.getHollowed(newVset);
            }
            return this.changes += this.setBlocks(newVset, pattern);
        }
        return this.changes;
    }

    private static Set<BlockVector3> getBallooned(Set<BlockVector3> vset, double radius) {
        if (radius < 1.0) {
            return vset;
        }
        BlockVector3Set returnset = LocalBlockVectorSet.wrapped();
        int ceilrad = (int)Math.ceil(radius);
        for (BlockVector3 v : vset) {
            int tipx = v.x();
            int tipy = v.y();
            int tipz = v.z();
            for (int loopx = tipx - ceilrad; loopx <= tipx + ceilrad; ++loopx) {
                for (int loopy = tipy - ceilrad; loopy <= tipy + ceilrad; ++loopy) {
                    for (int loopz = tipz - ceilrad; loopz <= tipz + ceilrad; ++loopz) {
                        double[] dArray = new double[]{loopx - tipx, loopy - tipy, loopz - tipz};
                        if (!(MathMan.hypot(dArray) <= radius)) continue;
                        returnset.add(loopx, loopy, loopz);
                    }
                }
            }
        }
        return returnset;
    }

    public static Set<BlockVector3> getStretched(Set<BlockVector3> vset, double radius) {
        if (radius < 1.0) {
            return vset;
        }
        BlockVector3Set returnset = LocalBlockVectorSet.wrapped();
        int ceilrad = (int)Math.ceil(radius);
        for (BlockVector3 v : vset) {
            int tipx = v.x();
            int tipy = v.y();
            int tipz = v.z();
            for (int loopx = tipx - ceilrad; loopx <= tipx + ceilrad; ++loopx) {
                for (int loopz = tipz - ceilrad; loopz <= tipz + ceilrad; ++loopz) {
                    double[] dArray = new double[]{loopx - tipx, 0.0, loopz - tipz};
                    if (!(MathMan.hypot(dArray) <= radius)) continue;
                    returnset.add(loopx, v.y(), loopz);
                }
            }
        }
        return returnset;
    }

    public Set<BlockVector3> getOutline(Set<BlockVector3> vset) {
        BlockVector3Set returnset = LocalBlockVectorSet.wrapped();
        BlockVector3Set newset = LocalBlockVectorSet.wrapped();
        newset.addAll(vset);
        for (BlockVector3 v : newset) {
            int z;
            int y;
            int x = v.x();
            if (newset.contains(x + 1, y = v.y(), z = v.z()) && newset.contains(x - 1, y, z) && newset.contains(x, y, z + 1) && newset.contains(x, y, z - 1)) continue;
            returnset.add(v);
        }
        return returnset;
    }

    public Set<BlockVector3> getHollowed(Set<BlockVector3> vset) {
        BlockVector3Set returnset = LocalBlockVectorSet.wrapped();
        BlockVector3Set newset = LocalBlockVectorSet.wrapped();
        newset.addAll(vset);
        for (BlockVector3 v : newset) {
            int z;
            int y;
            int x = v.x();
            if (newset.contains(x + 1, y = v.y(), z = v.z()) && newset.contains(x - 1, y, z) && newset.contains(x, y + 1, z) && newset.contains(x, y - 1, z) && newset.contains(x, y, z + 1) && newset.contains(x, y, z - 1)) continue;
            returnset.add(v);
        }
        return returnset;
    }

    private void recurseHollow(Region region, BlockVector3 origin, Set<BlockVector3> outside, Mask mask) {
        BlockVector3Set queue = BlockVector3Set.getAppropriateVectorSet(region);
        queue.add(origin);
        MutableBlockVector3 mutable = new MutableBlockVector3();
        while (!queue.isEmpty()) {
            Iterator iter = queue.iterator();
            while (iter.hasNext()) {
                BlockVector3 current = (BlockVector3)iter.next();
                iter.remove();
                if (mask.test(current) || !outside.add(current) || !region.contains(current)) continue;
                for (BlockVector3 recurseDirection : recurseDirections) {
                    queue.add(mutable.setComponents(current).add(recurseDirection));
                }
            }
        }
    }

    public int makeBiomeShape(Region region, Vector3 zero, Vector3 unit, BiomeType biomeType, String expressionString, boolean hollow) throws ExpressionException {
        return this.makeBiomeShape(region, zero, unit, biomeType, expressionString, hollow, WorldEdit.getInstance().getConfiguration().calculationTimeout);
    }

    public int makeBiomeShape(Region region, final Vector3 zero, final Vector3 unit, BiomeType biomeType, String expressionString, boolean hollow, final int timeout) throws ExpressionException {
        final Expression expression = Expression.compile(expressionString, "x", "y", "z");
        expression.optimize();
        EditSession editSession = this;
        final WorldEditExpressionEnvironment environment = new WorldEditExpressionEnvironment(editSession, unit, zero);
        expression.setEnvironment(environment);
        final AtomicInteger timedOut = new AtomicInteger();
        ArbitraryBiomeShape shape = new ArbitraryBiomeShape(this, region){

            @Override
            protected BiomeType getBiome(int x, int y, int z, BiomeType defaultBiomeType) {
                environment.setCurrentBlock(x, y, z);
                double scaledX = ((double)x - zero.x()) / unit.x();
                double scaledY = ((double)y - zero.y()) / unit.y();
                double scaledZ = ((double)z - zero.z()) / unit.z();
                try {
                    double[] dArray = new double[]{scaledX, scaledY, scaledZ};
                    if (expression.evaluate(dArray, timeout) <= 0.0) {
                        return null;
                    }
                    return defaultBiomeType;
                }
                catch (ExpressionTimeoutException e) {
                    timedOut.getAndIncrement();
                    return null;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to create shape", (Throwable)e);
                    return null;
                }
            }
        };
        int changed = shape.generate(this, biomeType, hollow);
        if (timedOut.get() > 0) {
            throw new ExpressionTimeoutException(String.format("%d biomes changed. %d biomes took too long to evaluate (increase time with //timeout)", changed, timedOut.get()));
        }
        return changed;
    }

    public int morph(BlockVector3 position, double brushSize, int minErodeFaces, int numErodeIterations, int minDilateFaces, int numDilateIterations) throws MaxChangedBlocksException {
        BlockState[][][] tmp;
        int newFreq;
        BlockState adj;
        BlockState highestState;
        int highestFreq;
        BlockState blockState;
        int zsqr;
        int realZ;
        int z;
        int ysqr;
        int realY;
        int y;
        int xsqr;
        int realX;
        int x;
        int i;
        int ceilBrushSize = (int)Math.ceil(brushSize);
        int bufferSize = ceilBrushSize * 2 + 3;
        BlockState[][][] currentBuffer = new BlockState[bufferSize][bufferSize][bufferSize];
        BlockState[][][] nextBuffer = new BlockState[bufferSize][bufferSize][bufferSize];
        for (int x2 = 0; x2 < bufferSize; ++x2) {
            for (int y2 = 0; y2 < bufferSize; ++y2) {
                for (int z2 = 0; z2 < bufferSize; ++z2) {
                    BlockState blockState2;
                    currentBuffer[x2][y2][z2] = blockState2 = this.getBlock(position.add(x2 - ceilBrushSize - 1, y2 - ceilBrushSize - 1, z2 - ceilBrushSize - 1));
                    nextBuffer[x2][y2][z2] = blockState2;
                }
            }
        }
        double brushSizeSq = brushSize * brushSize;
        HashMap<BlockState, Integer> blockStateFrequency = new HashMap<BlockState, Integer>();
        for (i = 0; i < numErodeIterations; ++i) {
            for (x = 0; x <= ceilBrushSize * 2; ++x) {
                realX = x - ceilBrushSize;
                xsqr = realX * realX;
                for (y = 0; y <= ceilBrushSize * 2; ++y) {
                    realY = y - ceilBrushSize;
                    ysqr = realY * realY;
                    for (z = 0; z <= ceilBrushSize * 2; ++z) {
                        realZ = z - ceilBrushSize;
                        zsqr = realZ * realZ;
                        if ((double)(xsqr + ysqr + zsqr) > brushSizeSq) continue;
                        nextBuffer[x + 1][y + 1][z + 1] = currentBuffer[x + 1][y + 1][z + 1];
                        blockState = currentBuffer[x + 1][y + 1][z + 1];
                        if (blockState.getBlockType().getMaterial().isLiquid() || blockState.getBlockType().getMaterial().isAir()) continue;
                        blockStateFrequency.clear();
                        int totalFaces = 0;
                        highestFreq = 0;
                        highestState = blockState;
                        for (BlockVector3 vec3 : recurseDirections) {
                            adj = currentBuffer[x + 1 + vec3.x()][y + 1 + vec3.y()][z + 1 + vec3.z()];
                            if (!adj.getBlockType().getMaterial().isLiquid() && !adj.getBlockType().getMaterial().isAir()) continue;
                            ++totalFaces;
                            newFreq = blockStateFrequency.getOrDefault(adj, 0) + 1;
                            blockStateFrequency.put(adj, newFreq);
                            if (newFreq <= highestFreq) continue;
                            highestFreq = newFreq;
                            highestState = adj;
                        }
                        if (totalFaces < minErodeFaces) continue;
                        nextBuffer[x + 1][y + 1][z + 1] = highestState;
                    }
                }
            }
            tmp = currentBuffer;
            currentBuffer = nextBuffer;
            nextBuffer = tmp;
        }
        for (i = 0; i < numDilateIterations; ++i) {
            for (x = 0; x <= ceilBrushSize * 2; ++x) {
                realX = x - ceilBrushSize;
                xsqr = realX * realX;
                for (y = 0; y <= ceilBrushSize * 2; ++y) {
                    realY = y - ceilBrushSize;
                    ysqr = realY * realY;
                    for (z = 0; z <= ceilBrushSize * 2; ++z) {
                        realZ = z - ceilBrushSize;
                        zsqr = realZ * realZ;
                        if ((double)(xsqr + ysqr + zsqr) > brushSizeSq) continue;
                        nextBuffer[x + 1][y + 1][z + 1] = currentBuffer[x + 1][y + 1][z + 1];
                        blockState = currentBuffer[x + 1][y + 1][z + 1];
                        if (!blockState.getBlockType().getMaterial().isLiquid() && !blockState.getBlockType().getMaterial().isAir()) continue;
                        blockStateFrequency.clear();
                        int totalFaces = 0;
                        highestFreq = 0;
                        highestState = blockState;
                        for (BlockVector3 vec3 : recurseDirections) {
                            adj = currentBuffer[x + 1 + vec3.x()][y + 1 + vec3.y()][z + 1 + vec3.z()];
                            if (adj.getBlockType().getMaterial().isLiquid() || adj.getBlockType().getMaterial().isAir()) continue;
                            ++totalFaces;
                            newFreq = blockStateFrequency.getOrDefault(adj, 0) + 1;
                            blockStateFrequency.put(adj, newFreq);
                            if (newFreq <= highestFreq) continue;
                            highestFreq = newFreq;
                            highestState = adj;
                        }
                        if (totalFaces < minDilateFaces) continue;
                        nextBuffer[x + 1][y + 1][z + 1] = highestState;
                    }
                }
            }
            tmp = currentBuffer;
            currentBuffer = nextBuffer;
            nextBuffer = tmp;
        }
        int changed = 0;
        for (x = 0; x < bufferSize; ++x) {
            for (int y3 = 0; y3 < bufferSize; ++y3) {
                for (int z3 = 0; z3 < bufferSize; ++z3) {
                    if (!this.setBlock(position.add(x - ceilBrushSize - 1, y3 - ceilBrushSize - 1, z3 - ceilBrushSize - 1), (B)currentBuffer[x][y3][z3])) continue;
                    ++changed;
                }
            }
        }
        return changed;
    }

    public boolean regenerate(Region region) {
        return this.regenerate(region, this);
    }

    public boolean regenerate(Region region, EditSession session) {
        return session.regenerate(region, null, null);
    }

    private void setExistingBlocks(BlockVector3 pos1, BlockVector3 pos2) {
        for (int x = pos1.x(); x <= pos2.x(); ++x) {
            for (int z = pos1.z(); z <= pos2.z(); ++z) {
                for (int y = pos1.y(); y <= pos2.y(); ++y) {
                    this.setBlock(x, y, z, (B)this.getFullBlock(x, y, z));
                }
            }
        }
    }

    public boolean regenerate(Region region, final BiomeType biome, final Long seed) {
        AbstractChangeSet fcs = (AbstractChangeSet)this.getChangeSet();
        this.setChangeSet(null);
        FaweRegionExtent fe = this.getRegionExtent();
        boolean cuboid = region instanceof CuboidRegion;
        if (fe != null && cuboid) {
            BlockVector3 max = region.getMaximumPoint();
            BlockVector3 min = region.getMinimumPoint();
            if (!fe.contains(max.x(), max.y(), max.z()) && !fe.contains(min.x(), min.y(), min.z())) {
                throw FaweCache.OUTSIDE_REGION;
            }
        }
        Set<BlockVector2> chunks = region.getChunks();
        MutableBlockVector3 mutable = new MutableBlockVector3();
        MutableBlockVector3 mutable2 = new MutableBlockVector3();
        MutableBlockVector2 mutable2D = new MutableBlockVector2();
        for (BlockVector2 chunk : chunks) {
            final int cx = chunk.x();
            final int cz = chunk.z();
            int bx = cx << 4;
            int bz = cz << 4;
            BlockVector3 cmin = BlockVector3.at(bx, 0, bz);
            BlockVector3 cmax = cmin.add(15, this.maxY, 15);
            boolean containsBot1 = fe == null || fe.contains(cmin.x(), cmin.y(), cmin.z());
            boolean containsBot2 = region.contains(cmin);
            boolean containsTop1 = fe == null || fe.contains(cmax.x(), cmax.y(), cmax.z());
            boolean containsTop2 = region.contains(cmax);
            if (containsBot2 && containsTop2 && !containsBot1 && !containsTop1) continue;
            boolean conNextX = chunks.contains(mutable2D.setComponents(cx + 1, cz));
            boolean conNextZ = chunks.contains(mutable2D.setComponents(cx, cz + 1));
            boolean containsAny = false;
            if (cuboid && containsBot1 && containsBot2 && containsTop1 && containsTop2 && conNextX && conNextZ) {
                containsAny = true;
                if (fcs != null) {
                    for (x = 0; x < 16; ++x) {
                        xx = x + bx;
                        for (z = 0; z < 16; ++z) {
                            zz = z + bz;
                            for (y = this.minY; y < this.maxY + 1; ++y) {
                                BaseBlock block = this.getFullBlock(mutable.setComponents(xx, y, zz));
                                fcs.add(mutable, block, BlockTypes.AIR.getDefaultState().toBaseBlock());
                            }
                        }
                    }
                }
            } else {
                if (!conNextX) {
                    this.setExistingBlocks(mutable.setComponents(bx + 16, 0, bz), mutable2.setComponents(bx + 31, this.maxY, bz + 15));
                }
                if (!conNextZ) {
                    this.setExistingBlocks(mutable.setComponents(bx, 0, bz + 16), mutable2.setComponents(bx + 15, this.maxY, bz + 31));
                }
                if (!(chunks.contains(mutable2D.setComponents(cx + 1, cz + 1)) || conNextX || conNextZ)) {
                    this.setExistingBlocks(mutable.setComponents(bx + 16, 0, bz + 16), mutable2.setComponents(bx + 31, this.maxY, bz + 31));
                }
                for (x = 0; x < 16; ++x) {
                    xx = x + bx;
                    mutable.mutX(xx);
                    for (z = 0; z < 16; ++z) {
                        zz = z + bz;
                        mutable.mutZ(zz);
                        for (y = this.minY; y < this.maxY + 1; ++y) {
                            BaseBlock block;
                            boolean contains;
                            mutable.mutY(y);
                            boolean bl = contains = (fe == null || fe.contains(xx, y, zz)) && region.contains(mutable);
                            if (contains) {
                                containsAny = true;
                                if (fcs == null) continue;
                                block = this.getFullBlock(mutable);
                                fcs.add(mutable, block, BlockTypes.AIR.getDefaultState().toBaseBlock());
                                continue;
                            }
                            block = this.getFullBlock(mutable);
                            try {
                                this.setBlock((BlockVector3)mutable, (B)block);
                                continue;
                            }
                            catch (MaxChangedBlocksException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                }
            }
            if (!containsAny) continue;
            ++this.changes;
            TaskManager.taskManager().sync(new RunnableVal<Object>(){

                @Override
                public void run(Object value) {
                    EditSession.this.regenerateChunk(cx, cz, biome, seed);
                }
            });
        }
        if (this.changes != 0) {
            this.flushQueue();
            return true;
        }
        return false;
    }

    @Override
    public List<? extends Entity> getEntities() {
        return this.world.getEntities();
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        return this.world.getEntities(region);
    }

    @Override
    public Entity createEntity(Location location, BaseEntity entity) {
        try {
            return this.getExtent().createEntity(location, entity);
        }
        catch (WorldEditException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    @Override
    public Entity createEntity(Location location, BaseEntity entity, UUID uuid) {
        try {
            return this.getExtent().createEntity(location, entity, uuid);
        }
        catch (WorldEditException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    @Override
    public void removeEntity(int x, int y, int z, UUID uuid) {
        try {
            this.getExtent().removeEntity(x, y, z, uuid);
        }
        catch (WorldEditException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    @Override
    public void generate(Region region, GenBase gen) throws WorldEditException {
        for (BlockVector2 chunkPos : region.getChunks()) {
            gen.generate(chunkPos, new SingleRegionExtent(this, this.getLimit(), region));
        }
    }

    @Override
    public void addSchems(Region region, Mask mask, List<ClipboardHolder> clipboards, int rarity, boolean rotate) throws WorldEditException {
        this.spawnResource(region, new SchemGen(mask, this, clipboards, rotate, region), rarity, 1);
    }

    @Override
    public void addOre(Region region, Mask mask, Pattern material, int size, int frequency, int rarity, int minY, int maxY) throws WorldEditException {
        this.spawnResource(region, new OreGen(this, mask, material, size, minY, maxY), rarity, frequency);
    }

    @Override
    public Clipboard lazyCopy(Region region) {
        WorldCopyClipboard faweClipboard = WorldCopyClipboard.of(this, region);
        faweClipboard.setOrigin(region.getMinimumPoint());
        return faweClipboard;
    }

    public int makeBlob(BlockVector3 position, Pattern pattern, double size, double frequency, double amplitude, Vector3 radius, double sphericity) {
        double seedX = ThreadLocalRandom.current().nextDouble();
        double seedY = ThreadLocalRandom.current().nextDouble();
        double seedZ = ThreadLocalRandom.current().nextDouble();
        int px = position.x();
        int py = position.y();
        int pz = position.z();
        double distort = frequency / size;
        double modX = 1.0 / radius.x();
        double modY = 1.0 / radius.y();
        double modZ = 1.0 / radius.z();
        int r = (int)size;
        int radiusSqr = (int)(size * size);
        int sizeInt = (int)size * 2;
        if (sphericity == 1.0) {
            for (int x = -sizeInt; x <= sizeInt; ++x) {
                double nx = seedX + (double)x * distort;
                double d1 = (double)(x * x) * modX;
                int xx = px + x;
                for (int y = -sizeInt; y <= sizeInt; ++y) {
                    double d2 = d1 + (double)(y * y) * modY;
                    double ny = seedY + (double)y * distort;
                    int yy = py + y;
                    for (int z = -sizeInt; z <= sizeInt; ++z) {
                        double nz = seedZ + (double)z * distort;
                        double distance = d2 + (double)(z * z) * modZ;
                        int zz = pz + z;
                        double noise = amplitude * SimplexNoise.noise(nx, ny, nz);
                        if (!(distance + distance * noise < (double)radiusSqr)) continue;
                        this.setBlock(xx, yy, zz, pattern);
                    }
                }
            }
        } else {
            AffineTransform transform = new AffineTransform().rotateX(ThreadLocalRandom.current().nextInt(360)).rotateY(ThreadLocalRandom.current().nextInt(360)).rotateZ(ThreadLocalRandom.current().nextInt(360));
            double manScaleX = 1.25 + seedX * 0.5;
            double manScaleY = 1.25 + seedY * 0.5;
            double manScaleZ = 1.25 + seedZ * 0.5;
            MutableVector3 mutable = new MutableVector3();
            double roughness = 1.0 - sphericity;
            for (int xr = -sizeInt; xr <= sizeInt; ++xr) {
                int xx = px + xr;
                for (int yr = -sizeInt; yr <= sizeInt; ++yr) {
                    int yy = py + yr;
                    for (int zr = -sizeInt; zr <= sizeInt; ++zr) {
                        int zz = pz + zr;
                        mutable.setComponents(xr, yr, zr);
                        Vector3 pt = transform.apply(mutable);
                        int x = MathMan.roundInt(pt.x());
                        int y = MathMan.roundInt(pt.y());
                        int z = MathMan.roundInt(pt.z());
                        double xScaled = (double)Math.abs(x) * modX;
                        double yScaled = (double)Math.abs(y) * modY;
                        double zScaled = (double)Math.abs(z) * modZ;
                        double manDist = xScaled + yScaled + zScaled;
                        double distSqr = (double)(x * x) * modX + (double)(z * z) * modZ + (double)(y * y) * modY;
                        double distance = Math.sqrt(distSqr) * sphericity + MathMan.max(manDist, xScaled * manScaleX, yScaled * manScaleY, zScaled * manScaleZ) * roughness;
                        double noise = amplitude * SimplexNoise.noise(seedX + (double)x * distort, seedZ + (double)z * distort, seedZ + (double)z * distort);
                        if (!(distance + distance * noise < (double)r)) continue;
                        this.setBlock(xx, yy, zz, pattern);
                    }
                }
            }
        }
        return this.changes;
    }

    public int generateFeature(ConfiguredFeatureType feature, BlockVector3 position) {
        feature.place(this, position);
        return this.changes;
    }

    public int generateStructure(StructureType structure, BlockVector3 position) {
        structure.place(this, position);
        return this.changes;
    }

    @Deprecated
    public static enum ReorderMode {
        MULTI_STAGE("multi"),
        FAST("fast"),
        NONE("none");

        private final String displayName;

        private ReorderMode(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static enum Stage {
        BEFORE_HISTORY,
        BEFORE_REORDER,
        BEFORE_CHANGE;

    }
}

