/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.ext.fawe.v1_20_R4;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.bukkit.adapter.ext.fawe.v1_20_R4.PaperweightAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import org.enginehub.linbus.tree.LinTag;
import org.jetbrains.annotations.Nullable;

public class PaperweightServerLevelDelegateProxy
implements InvocationHandler {
    private final EditSession editSession;
    private final WorldServer serverLevel;
    private final PaperweightAdapter adapter;

    private PaperweightServerLevelDelegateProxy(EditSession editSession, WorldServer serverLevel, PaperweightAdapter adapter) {
        this.editSession = editSession;
        this.serverLevel = serverLevel;
        this.adapter = adapter;
    }

    public static GeneratorAccessSeed newInstance(EditSession editSession, WorldServer serverLevel, PaperweightAdapter adapter) {
        return (GeneratorAccessSeed)Proxy.newProxyInstance(serverLevel.getClass().getClassLoader(), serverLevel.getClass().getInterfaces(), (InvocationHandler)new PaperweightServerLevelDelegateProxy(editSession, serverLevel, adapter));
    }

    @Nullable
    private TileEntity getBlockEntity(BlockPosition blockPos) {
        TileEntity tileEntity = this.serverLevel.m(blockPos).c_(blockPos);
        if (tileEntity == null) {
            return null;
        }
        tileEntity.c((NBTTagCompound)this.adapter.fromNativeLin((LinTag)this.editSession.getFullBlock(blockPos.u(), blockPos.v(), blockPos.w()).getNbtReference().getValue()), (HolderLookup.a)this.serverLevel.H_());
        return tileEntity;
    }

    private IBlockData getBlockState(BlockPosition blockPos) {
        return this.adapter.adapt(this.editSession.getBlock(BlockVector3.at(blockPos.u(), blockPos.v(), blockPos.w())));
    }

    private boolean setBlock(BlockPosition blockPos, IBlockData blockState) {
        try {
            return this.editSession.setBlock(BlockVector3.at(blockPos.u(), blockPos.v(), blockPos.w()), this.adapter.adapt(blockState));
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean removeBlock(BlockPosition blockPos, boolean bl) {
        try {
            return this.editSession.setBlock(BlockVector3.at(blockPos.u(), blockPos.v(), blockPos.w()), BlockTypes.AIR.getDefaultState());
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "a_": 
            case "getBlockState": {
                Object object;
                if (args.length != 1 || !((object = args[0]) instanceof BlockPosition)) break;
                BlockPosition blockPos = (BlockPosition)object;
                return this.getBlockState(blockPos);
            }
            case "c_": 
            case "getBlockEntity": {
                Object object;
                if (args.length != 1 || !((object = args[0]) instanceof BlockPosition)) break;
                BlockPosition blockPos = (BlockPosition)object;
                return this.getBlockEntity(blockPos);
            }
            case "a": 
            case "setBlock": 
            case "removeBlock": 
            case "destroyBlock": {
                Object object;
                if (args.length >= 2 && (object = args[0]) instanceof BlockPosition) {
                    BlockPosition blockPos = (BlockPosition)object;
                    object = args[1];
                    if (object instanceof IBlockData) {
                        IBlockData blockState = (IBlockData)object;
                        return this.setBlock(blockPos, blockState);
                    }
                }
                if (args.length < 2 || !((object = args[0]) instanceof BlockPosition)) break;
                BlockPosition blockPos = (BlockPosition)object;
                object = args[1];
                if (!(object instanceof Boolean)) break;
                Boolean bl = (Boolean)object;
                return this.removeBlock(blockPos, bl);
            }
        }
        return method.invoke((Object)this.serverLevel, args);
    }
}

