/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R4.regen;

import com.fastasyncworldedit.bukkit.adapter.Regenerator;
import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.queue.IChunkCache;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.implementation.chunk.ChunkCache;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Lifecycle;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.Refraction;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.io.file.SafeFiles;
import com.sk89q.worldedit.world.RegenOptions;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.function.BooleanSupplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaperweightRegen
extends Regenerator {
    private static final Field serverWorldsField;
    private static final Field paperConfigField;
    private static final Field generatorSettingBaseSupplierField;
    private WorldServer originalServerWorld;
    private WorldServer freshWorld;
    private Convertable.ConversionSession session;
    private Path tempDir;

    public PaperweightRegen(org.bukkit.World originalBukkitWorld, Region region, Extent target, RegenOptions options) {
        super(originalBukkitWorld, region, target, options);
    }

    @Override
    protected void runTasks(BooleanSupplier shouldKeepTicking) {
        while (shouldKeepTicking.getAsBoolean()) {
            if (this.freshWorld.l().d()) continue;
            return;
        }
    }

    @Override
    protected boolean prepare() {
        this.originalServerWorld = ((CraftWorld)this.originalBukkitWorld).getHandle();
        this.seed = this.options.getSeed().orElse(this.originalServerWorld.C());
        return true;
    }

    @Override
    protected boolean initNewWorld() throws Exception {
        this.tempDir = Files.createTempDirectory("FastAsyncWorldEditWorldGen", new FileAttribute[0]);
        World.Environment environment = this.originalBukkitWorld.getEnvironment();
        ChunkGenerator generator = this.originalBukkitWorld.getGenerator();
        Convertable levelStorageSource = Convertable.b((Path)this.tempDir);
        ResourceKey<WorldDimension> levelStemResourceKey = this.getWorldDimKey(environment);
        this.session = levelStorageSource.createAccess("faweregentempworld", levelStemResourceKey);
        WorldDataServer originalWorldData = this.originalServerWorld.K;
        DedicatedServer server = this.originalServerWorld.getCraftServer().getServer();
        WorldOptions originalOpts = originalWorldData.y();
        WorldOptions newOpts = this.options.getSeed().isPresent() ? originalOpts.a(OptionalLong.of(this.seed)) : originalOpts;
        WorldSettings newWorldSettings = new WorldSettings("faweregentempworld", originalWorldData.g.b(), originalWorldData.g.c(), originalWorldData.g.d(), originalWorldData.g.e(), originalWorldData.g.f(), originalWorldData.g.g());
        WorldDataServer.a specialWorldProperty = originalWorldData.z() ? WorldDataServer.a.b : (originalWorldData.A() ? WorldDataServer.a.c : WorldDataServer.a.a);
        WorldDataServer newWorldData = new WorldDataServer(newWorldSettings, newOpts, specialWorldProperty, Lifecycle.stable());
        BiomeProvider biomeProvider = this.getBiomeProvider();
        this.freshWorld = Fawe.instance().getQueueHandler().sync(() -> this.lambda$initNewWorld$0((MinecraftServer)server, newWorldData, environment, generator, biomeProvider)).get();
        this.freshWorld.e = true;
        this.removeWorldFromWorldsMap();
        newWorldData.checkName(this.originalServerWorld.K.e());
        if (paperConfigField != null) {
            paperConfigField.set(this.freshWorld, this.originalServerWorld.paperConfig());
        }
        return true;
    }

    @Override
    protected void cleanup() {
        try {
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Fawe.instance().getQueueHandler().sync(() -> {
                try {
                    this.freshWorld.l().k().b.clear();
                    this.freshWorld.l().close(false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Fawe.instance().getQueueHandler().sync(this::removeWorldFromWorldsMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SafeFiles.tryHardToDeleteDir(this.tempDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected IChunkCache<IChunkGet> initSourceQueueCache() {
        return new ChunkCache<IChunkGet>(BukkitAdapter.adapt((org.bukkit.World)this.freshWorld.getWorld()));
    }

    private void removeWorldFromWorldsMap() {
        try {
            Map map = (Map)serverWorldsField.get(Bukkit.getServer());
            map.remove("faweregentempworld");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private ResourceKey<WorldDimension> getWorldDimKey(World.Environment env) {
        return switch (env) {
            case World.Environment.NETHER -> WorldDimension.c;
            case World.Environment.THE_END -> WorldDimension.d;
            default -> WorldDimension.b;
        };
    }

    private /* synthetic */ WorldServer lambda$initNewWorld$0(MinecraftServer server, WorldDataServer newWorldData, World.Environment environment, ChunkGenerator generator, BiomeProvider biomeProvider) {
        return new WorldServer(server, server.ax, this.session, newWorldData, this.originalServerWorld.af(), new WorldDimension(this.originalServerWorld.ae(), this.originalServerWorld.l().g()), new RegenNoOpWorldLoadListener(), this.originalServerWorld.ai(), this.seed, (List)ImmutableList.of(), false, this.originalServerWorld.L(), environment, generator, biomeProvider){
            private final Holder<BiomeBase> singleBiome;
            {
                this.singleBiome = PaperweightRegen.this.options.hasBiomeType() ? (Holder)DedicatedServer.getServer().bc().d(Registries.az).t().b(WorldEditPlugin.getInstance().getBukkitImplAdapter().getInternalBiomeId(PaperweightRegen.this.options.getBiomeType())) : null;
            }

            @NotNull
            public Holder<BiomeBase> a(int biomeX, int biomeY, int biomeZ) {
                if (PaperweightRegen.this.options.hasBiomeType()) {
                    return this.singleBiome;
                }
                return super.a(biomeX, biomeY, biomeZ);
            }

            public void a(@Nullable IProgressUpdate progressListener, boolean flush, boolean savingDisabled) {
            }

            public void save(@Nullable IProgressUpdate progressListener, boolean flush, boolean savingDisabled, boolean close) {
            }
        };
    }

    static {
        try {
            Field tmpPaperConfigField;
            serverWorldsField = CraftServer.class.getDeclaredField("worlds");
            serverWorldsField.setAccessible(true);
            try {
                tmpPaperConfigField = World.class.getDeclaredField("paperConfig");
                tmpPaperConfigField.setAccessible(true);
            }
            catch (Exception e) {
                tmpPaperConfigField = null;
            }
            paperConfigField = tmpPaperConfigField;
            generatorSettingBaseSupplierField = ChunkGeneratorAbstract.class.getDeclaredField(Refraction.pickName("settings", "e"));
            generatorSettingBaseSupplierField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class RegenNoOpWorldLoadListener
    implements WorldLoadListener {
        private RegenNoOpWorldLoadListener() {
        }

        public void a(@NotNull ChunkCoordIntPair spawnPos) {
        }

        public void a(@NotNull ChunkCoordIntPair pos, @Nullable ChunkStatus status) {
        }

        public void a() {
        }

        public void b() {
        }

        public void setChunkRadius(int radius) {
        }
    }
}

