/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_6;

import com.fastasyncworldedit.core.util.ReflectionUtils;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_6.PaperweightFaweAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_6.PaperweightPlacementStateProcessor;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_6.PaperweightPlatformAdapter;
import com.sk89q.worldedit.world.block.BlockState;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.ValueInput;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinTag;
import sun.misc.Unsafe;

public class PaperweightLevelProxy
extends WorldServer {
    protected WorldServer serverLevel;
    private PaperweightPlacementStateProcessor processor;
    private PaperweightFaweAdapter adapter;

    private PaperweightLevelProxy() {
        super(null, null, null, null, null, null, null, true, 0L, null, true, null, null, null, null);
        throw new IllegalStateException("Cannot be instantiated");
    }

    public static PaperweightLevelProxy getInstance(WorldServer serverLevel, PaperweightPlacementStateProcessor processor) {
        PaperweightLevelProxy newLevel;
        Unsafe unsafe = ReflectionUtils.getUnsafe();
        try {
            newLevel = (PaperweightLevelProxy)((Object)unsafe.allocateInstance(PaperweightLevelProxy.class));
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        newLevel.processor = processor;
        newLevel.adapter = (PaperweightFaweAdapter)WorldEditPlugin.getInstance().getBukkitImplAdapter();
        newLevel.serverLevel = serverLevel;
        return newLevel;
    }

    @Nullable
    public TileEntity c_(@Nonnull BlockPosition blockPos) {
        if (blockPos.u() == Integer.MAX_VALUE) {
            return null;
        }
        LinCompoundTag tag = this.processor.getTileAt(blockPos.u(), blockPos.v(), blockPos.w());
        if (tag == null) {
            return null;
        }
        IBlockData state = this.adapter.adapt(this.processor.getBlockStateAt(blockPos.u(), blockPos.v(), blockPos.w()));
        Block block = state.b();
        if (!(block instanceof ITileEntity)) {
            return null;
        }
        ITileEntity entityBlock = (ITileEntity)block;
        TileEntity tileEntity = entityBlock.a(blockPos, state);
        ValueInput input = PaperweightPlatformAdapter.createInput((NBTTagCompound)this.adapter.fromNativeLin((LinTag)tag));
        tileEntity.b(input);
        return tileEntity;
    }

    @Nonnull
    public IBlockData a_(@Nonnull BlockPosition blockPos) {
        if (blockPos.u() == Integer.MAX_VALUE) {
            return Blocks.a.m();
        }
        BlockState state = this.processor.getBlockStateAt(blockPos.u(), blockPos.v(), blockPos.w());
        return this.adapter.adapt(state);
    }

    @Nonnull
    public Fluid b_(@Nonnull BlockPosition pos) {
        if (pos.u() == Integer.MAX_VALUE) {
            return FluidTypes.a.g();
        }
        return this.a_(pos).y();
    }

    public boolean B(@Nonnull BlockPosition pos) {
        if (pos.u() == Integer.MAX_VALUE) {
            return false;
        }
        return this.a_(pos).y().a(TagsFluid.a);
    }

    public int M_() {
        return this.serverLevel.M_();
    }

    public int L_() {
        return this.serverLevel.L_();
    }

    public int ao() {
        return this.serverLevel.ao();
    }

    public boolean d(int blockY) {
        return this.serverLevel.d(blockY);
    }

    public boolean u(BlockPosition pos) {
        return this.serverLevel.u(pos);
    }

    public boolean e(int blockY) {
        return this.serverLevel.e(blockY);
    }

    public WorldBorder F_() {
        return this.serverLevel.F_();
    }
}

